/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.formplugin.dc.tree;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.filter.FilterContainer;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.TreeView;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.isc.iscb.formplugin.dc.tree.AbstractTemplateTreePlugin;
import kd.isc.iscb.util.dt.D;

public class IntegrationSchemaTreePlugin
extends AbstractTemplateTreePlugin {
    private static final String NODE = "node";
    private static final String CATEGORY = "category";
    private static final String SCHEMA_CATEGORY_EDIT = "schema_category_edit";
    private static final String SCHEMA_CATEGORY_ADD = "schema_category_add";
    private static final String ISC_SCHEMA_CATEGORY = "isc_schema_category";
    private static final String ISC_DATA_SOURCE = "isc_data_source";

    public void initialize() {
        super.initialize();
        FilterContainer fc = (FilterContainer)this.getControl("filtercontainerap");
        fc.setBillFormId("isc_data_copy");
        fc.setTitle(new LocaleString(ResManager.loadKDString((String)"\u96c6\u6210\u65b9\u6848\u5217\u8868", (String)"IntegrationSchemaTreePlugin_0", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0])));
    }

    @Override
    protected void filterBillList(BillList billList, String nodeId) {
        if (nodeId != null && !nodeId.equals("root")) {
            QFilter filter = new QFilter("data_source", "=", (Object)D.l((Object)nodeId));
            this.setFilter(filter);
            billList.addSetFilterListener(event -> event.getQFilters().add(filter));
        }
    }

    @Override
    void filterBillList(BillList billList, String nodeId, String category) {
        QFilter filter = null;
        if (nodeId != null && !nodeId.equals("root")) {
            long lid = D.l((Object)nodeId);
            if (category.equalsIgnoreCase("srcsystem")) {
                filter = new QFilter("data_source", "=", (Object)lid);
            } else if (category.equalsIgnoreCase("tarsystem")) {
                filter = new QFilter("data_target", "=", (Object)lid);
            } else {
                List<Object> ids = this.getSchemaCategoryId(lid);
                filter = new QFilter("schema_category", "in", ids);
            }
        } else {
            filter = new QFilter("data_source", ">=", (Object)0);
        }
        QFilter f = filter;
        this.setFilter(f);
        billList.addSetFilterListener(event -> event.getQFilters().add(f));
    }

    private List<Object> getSchemaCategoryId(long nodeId) {
        ArrayList<Object> ids = new ArrayList<Object>(12);
        ids.add(nodeId);
        return this.getSchemaCategoryId(ids, nodeId);
    }

    private List<Object> getSchemaCategoryId(List<Object> ids, long nodeId) {
        DynamicObject[] load;
        QFilter qFilter = new QFilter("parent", "=", (Object)nodeId);
        for (DynamicObject dy : load = BusinessDataServiceHelper.load((String)ISC_SCHEMA_CATEGORY, (String)"id", (QFilter[])new QFilter[]{qFilter})) {
            long id = D.l((Object)dy.get("id"));
            ids.add(id);
            this.getSchemaCategoryId(ids, id);
        }
        return ids;
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        OperationResult operationResult = args.getOperationResult();
        TreeView treeView = (TreeView)this.getView().getControl("treeviewap");
        Map focusNode = treeView.getTreeState().getFocusNode();
        String category = D.s((Object)this.getModel().getValue("classification"));
        if (operationResult != null && operationResult.isSuccess()) {
            if ("refresh".equals(operateKey) || "delete".equals(operateKey)) {
                BillList billList = (BillList)this.getControl("billlistap");
                String nodeId = focusNode == null ? "root" : D.s(focusNode.get("id"));
                this.filterBillList(billList, nodeId, category);
                billList.refresh();
                billList.clearSelection();
            } else if (SCHEMA_CATEGORY_ADD.equals(operateKey)) {
                this.addCateGory(focusNode, category);
            } else if (SCHEMA_CATEGORY_EDIT.equals(operateKey)) {
                this.editCategory(focusNode, category);
            } else if ("schema_category_delete".equals(operateKey)) {
                this.getPageCache().put(NODE, focusNode.get("id").toString());
                this.getPageCache().put(CATEGORY, category);
                ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("deleteCategory", (IFormPlugin)this);
                this.getView().showConfirm(ResManager.loadKDString((String)"\u786e\u5b9a\u5220\u9664\u5206\u7c7b\uff1f", (String)"IntegrationSchemaTreePlugin_1", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, confirmCallBacks);
            }
        }
    }

    private void delCateGoryByType(Object categorgId, String entityName) {
        OperationResult result = OperationServiceHelper.executeOperate((String)"delete", (String)entityName, (Object[])new Object[]{categorgId}, (OperateOption)OperateOption.create());
        if (result.isSuccess()) {
            String s = D.s((Object)this.getModel().getValue("classification"));
            String entityTypeName = this.getEntityTypeName();
            super.initTree(null, s, entityTypeName);
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f\u3002", (String)"IntegrationSchemaTreePlugin_2", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6570\u636e\u5b58\u5728\u5f15\u7528\u4e0d\u80fd\u88ab\u5220\u9664\u3002", (String)"IntegrationSchemaTreePlugin_3", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
        }
    }

    private void editCategory(Map<String, Object> focusNode, String category) {
        Object categorgId = focusNode.get("id");
        if ("root".equals(D.s((Object)categorgId))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u5141\u8bb8\u7f16\u8f91\u6839\u8282\u70b9", (String)"IntegrationSchemaTreePlugin_4", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
        } else if (category.equals("srcsystem") || category.equals("tarsystem")) {
            this.editCateGoryByType(categorgId, ISC_DATA_SOURCE, ResManager.loadKDString((String)"\u4fee\u6539\u6570\u636e\u6e90", (String)"IntegrationSchemaTreePlugin_5", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
        } else if (category.equals("customsystem")) {
            this.editCateGoryByType(categorgId, ISC_SCHEMA_CATEGORY, ResManager.loadKDString((String)"\u4fee\u6539\u5206\u7c7b", (String)"IntegrationSchemaTreePlugin_6", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
        }
    }

    private void editCateGoryByType(Object categorgId, String entityName, String type) {
        BillShowParameter param = new BillShowParameter();
        param.setFormId(entityName);
        param.setPkId(categorgId);
        param.getOpenStyle().setShowType(ShowType.Modal);
        param.setStatus(OperationStatus.EDIT);
        param.setCaption(type);
        param.setCloseCallBack(new CloseCallBack((IFormPlugin)this, SCHEMA_CATEGORY_EDIT));
        this.getView().showForm((FormShowParameter)param);
    }

    private void addByType(Map<String, Object> focusNode, String entityName, String type) {
        BillShowParameter param = new BillShowParameter();
        param.setFormId(entityName);
        param.getOpenStyle().setShowType(ShowType.Modal);
        param.setStatus(OperationStatus.ADDNEW);
        param.setCaption(type);
        param.setCustomParams(this.getParams(focusNode));
        param.setCloseCallBack(new CloseCallBack((IFormPlugin)this, SCHEMA_CATEGORY_ADD));
        this.getView().showForm((FormShowParameter)param);
    }

    private void addCateGory(Map<String, Object> focusNode, String category) {
        if (category.equals("srcsystem") || category.equals("tarsystem")) {
            this.addByType(focusNode, ISC_DATA_SOURCE, ResManager.loadKDString((String)"\u6dfb\u52a0\u6570\u636e\u6e90", (String)"IntegrationSchemaTreePlugin_7", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
        } else {
            this.addByType(focusNode, ISC_SCHEMA_CATEGORY, ResManager.loadKDString((String)"\u6dfb\u52a0\u5206\u7c7b", (String)"IntegrationSchemaTreePlugin_8", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
        }
    }

    private Map<String, Object> getParams(Map<String, Object> focusNode) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (!ObjectUtils.isEmpty(focusNode)) {
            String id = D.s((Object)focusNode.get("id"));
            map.put("schema_category_id", id == null || id.equals("root") ? 0L : D.l((Object)id));
        }
        return map;
    }

    private void delCateGory(Object categorgId, String category) {
        if ("root".equals(D.s((Object)categorgId))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u5141\u8bb8\u5220\u9664\u6839\u8282\u70b9\u3002", (String)"IntegrationSchemaTreePlugin_9", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
        } else if (category.equals("srcsystem") || category.equals("tarsystem")) {
            this.delCateGoryByType(categorgId, ISC_DATA_SOURCE);
        } else if (category.equals("customsystem")) {
            this.delCateGoryByType(categorgId, ISC_SCHEMA_CATEGORY);
        }
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        if (StringUtils.equals((CharSequence)evt.getActionId(), (CharSequence)SCHEMA_CATEGORY_ADD) || StringUtils.equals((CharSequence)evt.getActionId(), (CharSequence)SCHEMA_CATEGORY_EDIT)) {
            String s = D.s((Object)this.getModel().getValue("classification"));
            super.initTree(null, s, this.getEntityTypeName());
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent evt) {
        super.confirmCallBack(evt);
        if (MessageBoxResult.Yes == evt.getResult() && StringUtils.equals((CharSequence)evt.getCallBackId(), (CharSequence)"deleteCategory")) {
            this.delCateGory(this.getPageCache().get(NODE), this.getPageCache().get(CATEGORY));
        }
        this.getPageCache().remove(NODE);
        this.getPageCache().remove(CATEGORY);
    }

    private String getEntityTypeName() {
        MainEntityType dataEntityType = this.getView().getModel().getDataEntityType();
        return dataEntityType.getName();
    }
}

