/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.formplugin.dc.tree;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.report.CellStyle;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Search;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.isc.iscb.platform.core.license.IscLicenseUtil;
import kd.isc.iscb.platform.core.license.n.AccountInfo;
import kd.isc.iscb.platform.core.license.n.ConnectionInfo;
import kd.isc.iscb.platform.core.license.n.GroupCategory;
import kd.isc.iscb.platform.core.license.n.GroupInfo;
import kd.isc.iscb.platform.core.license.n.TenantInfo;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.misc.StringUtil;

public class LicenseSchemaTreePlugin
extends AbstractFormPlugin
implements TreeNodeClickListener,
SearchEnterListener {
    private static final String LICENSE_STATUS = "license_status";
    private static final String ENTRY_ENTITY = "entryentity";
    private static final String FIXME_LICENSE_CATAGORY = "licenseCatagory";
    private static final String LICENSE_CATAGORY = "license_catagory";
    private static final String ACCOUNT_ID = "accountId";
    private static final String KEY_TREEVIEW = "treeviewap";
    private static final String KEY_SEARCH = "searchap";
    private static final String EXPIRE_DATE = "expire_date";
    private static int counter = 0;

    public void registerListener(EventObject e) {
        super.registerListener(e);
        TreeView treeView = (TreeView)this.getControl(KEY_TREEVIEW);
        treeView.addTreeNodeClickListener((TreeNodeClickListener)this);
        Search search = (Search)this.getControl(KEY_SEARCH);
        search.addEnterListener((SearchEnterListener)this);
    }

    public void initialize() {
        super.initialize();
        Map params = this.getView().getFormShowParameter().getCustomParams();
        String accountId = D.s(params.get(ACCOUNT_ID));
        String licenseCatagory = D.s(params.get(LICENSE_CATAGORY));
        String acId = D.s(params.get("acId"));
        String catagory = D.s(params.get(FIXME_LICENSE_CATAGORY));
        this.getPageCache().put(ACCOUNT_ID, accountId);
        this.getPageCache().put(LICENSE_CATAGORY, licenseCatagory);
        this.getPageCache().put("acId", acId);
        this.getPageCache().put(FIXME_LICENSE_CATAGORY, catagory);
    }

    public void search(SearchEnterEvent event) {
        String searchText = event.getText();
        String accountId = this.getPageCache().get(ACCOUNT_ID);
        Map focusNode = ((TreeView)this.getView().getControl(KEY_TREEVIEW)).getTreeState().getFocusNode();
        String licenseCatagory = D.s(focusNode.get("id")).split(",")[0];
        String isParent = D.s(focusNode.get("isParent"));
        String parentid = D.s(focusNode.get("parentid"));
        if ("true".equals(isParent)) {
            licenseCatagory = this.getPageCache().get(LICENSE_CATAGORY);
        }
        String id = StringUtil.isEmpty((String)parentid) ? accountId : ("root".equals(parentid) ? D.s(focusNode.get("id")) : parentid);
        this.showLicenseList(id, licenseCatagory, searchText);
    }

    public void treeNodeClick(TreeNodeEvent evt) {
        Map focusNode = ((TreeView)this.getView().getControl(KEY_TREEVIEW)).getTreeState().getFocusNode();
        String licenseCatagory = D.s(focusNode.get("id")).split(",")[0];
        String isParent = D.s(focusNode.get("isParent"));
        String parentid = D.s(focusNode.get("parentid"));
        Control source = (Control)evt.getSource();
        String nodeId = D.s((Object)evt.getNodeId());
        String accountId = this.getPageCache().get(ACCOUNT_ID);
        this.getPageCache().put("focusNodeId", nodeId);
        if (StringUtils.equals((CharSequence)source.getKey(), (CharSequence)KEY_TREEVIEW)) {
            if ("true".equals(isParent)) {
                String catagory = this.getPageCache().get(LICENSE_CATAGORY);
                this.showLicenseList("root".equals(nodeId) ? accountId : nodeId, catagory, null);
            } else {
                this.showLicenseList(parentid, licenseCatagory, null);
            }
        }
    }

    private void putIfAbsent() {
        if (this.getPageCache().get(EXPIRE_DATE) == null) {
            this.getPageCache().put(EXPIRE_DATE, IscLicenseUtil.getTenantLicenseInfo().getExpiredDate());
        }
    }

    private String getCatagoryName(String catagory) {
        switch (catagory) {
            case "MQ_SERVER": {
                catagory = ResManager.loadKDString((String)"\u6d88\u606f\u670d\u52a1", (String)"LicenseSchemaTreePlugin_0", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]);
                break;
            }
            case "BIZ_WEBAPI": {
                catagory = ResManager.loadKDString((String)"WebAPI\u8fde\u63a5", (String)"LicenseSchemaTreePlugin_1", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]);
                break;
            }
            case "BIZ_DEDICATED": {
                catagory = ResManager.loadKDString((String)"\u4e13\u7528\u8fde\u63a5", (String)"LicenseSchemaTreePlugin_2", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]);
                break;
            }
            default: {
                catagory = ResManager.loadKDString((String)"\u5176\u4ed6", (String)"LicenseSchemaTreePlugin_3", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]);
            }
        }
        return catagory;
    }

    private String getString(String category) {
        if ("TOTAL".equals(category)) {
            return "";
        }
        return GroupCategory.valueOf((String)category).name();
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.putIfAbsent();
        String accountId = this.getPageCache().get(ACCOUNT_ID);
        if (StringUtil.isEmpty((String)accountId)) {
            return;
        }
        String licenseCatagory = this.getPageCache().get(LICENSE_CATAGORY);
        String licenseCatagory2 = this.getPageCache().get(FIXME_LICENSE_CATAGORY);
        String acId = this.getPageCache().get("acId");
        licenseCatagory2 = StringUtil.isEmpty((String)licenseCatagory2) ? licenseCatagory : this.getString(licenseCatagory2);
        this.initTree(accountId, licenseCatagory, licenseCatagory2, acId);
    }

    private void initTree(String accountId, String licenseCatagory, String focusCatagory, String acId) {
        TreeView tree = (TreeView)this.getControl(KEY_TREEVIEW);
        TenantInfo tenantLicenseInfo = IscLicenseUtil.getTenantLicenseInfo();
        Map licenseInfoMap = tenantLicenseInfo.getAccounts();
        TreeNode rootNode = new TreeNode("", "root", ResManager.loadKDString((String)"\u6570\u636e\u4e2d\u5fc3", (String)"LicenseSchemaTreePlugin_4", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
        tree.addNode(rootNode);
        TreeNode currentNode = rootNode;
        TreeNode tmp = null;
        String[] accountIds = accountId.split(",");
        ArrayList<String> treeNodeFilterList = new ArrayList<String>(accountIds.length);
        for (AccountInfo licenseInfo : licenseInfoMap.values()) {
            String tmpId = licenseInfo.getAccountId();
            if (treeNodeFilterList.contains(tmpId)) continue;
            treeNodeFilterList.add(tmpId);
            for (String id : accountIds) {
                TreeNode node = null;
                if (id.equals(tmpId)) {
                    String[] catagorys;
                    node = new TreeNode(rootNode.getId(), tmpId, licenseInfo.getAccountName());
                    for (String catagory : catagorys = licenseCatagory.split(",")) {
                        TreeNode childNode = new TreeNode(node.getId(), D.s((Object)(catagory + ',' + LicenseSchemaTreePlugin.newId())), this.getCatagoryName(catagory));
                        node.addChild(childNode);
                        if (!id.equals(acId) || !focusCatagory.equals(catagory)) continue;
                        tmp = childNode;
                    }
                }
                rootNode.addChild(node);
                currentNode = this.getCurrentNode(id, currentNode, StringUtil.isEmpty((String)acId) ? tmpId : acId, node);
            }
        }
        if (tmp != null) {
            currentNode = tmp;
        }
        if (StringUtil.isEmpty((String)acId)) {
            currentNode = rootNode;
        }
        tree.focusNode(currentNode);
        this.expandTree(tree, rootNode, acId);
        if (StringUtil.isEmpty((String)acId)) {
            acId = accountId;
        }
        this.showLicenseList(acId, focusCatagory, null);
    }

    private void expandTree(TreeView tree, TreeNode currentNode, String acId) {
        if (StringUtil.isEmpty((String)acId)) {
            return;
        }
        tree.expand(currentNode.getId());
        List children = currentNode.getChildren();
        if (children == null) {
            return;
        }
        for (TreeNode child : children) {
            if (!child.getId().equals(acId) && !child.getParentid().equals(acId)) continue;
            this.expandTree(tree, child, acId);
        }
    }

    private static synchronized long newId() {
        return ++counter;
    }

    private TreeNode getCurrentNode(String accountId, TreeNode currentNode, String accountId1, TreeNode node) {
        if (node == null) {
            return currentNode;
        }
        if (accountId1.equals(accountId)) {
            currentNode = node;
        }
        return currentNode;
    }

    private void showLicenseList(String accountId, String licenseCatagory, String searchTxt) {
        String[] accountIds;
        DynamicObjectCollection entries = this.getModel().getDataEntity(true).getDynamicObjectCollection(ENTRY_ENTITY);
        entries.clear();
        TenantInfo tenantLicenseInfo = IscLicenseUtil.getTenantLicenseInfo();
        for (String nodeId : accountIds = accountId.split(",")) {
            Map groups = tenantLicenseInfo.getAccount(nodeId).getGroups();
            ArrayList<ConnectionInfo> list = new ArrayList<ConnectionInfo>();
            for (Map.Entry groupInfoEntry : groups.entrySet()) {
                GroupCategory key = (GroupCategory)groupInfoEntry.getKey();
                if (!licenseCatagory.contains(key.name())) continue;
                GroupInfo groupInfo = (GroupInfo)groupInfoEntry.getValue();
                list.addAll(groupInfo.getConnections().values());
            }
            this.initEntry(searchTxt, entries, list);
        }
        entries.sort((Comparator)new Comparator<DynamicObject>(){

            @Override
            public int compare(DynamicObject o1, DynamicObject o2) {
                long l1 = D.l((Object)o1.get("create_time"));
                long l2 = D.l((Object)o2.get("create_time"));
                return Long.compare(l2, l1);
            }
        });
        this.setFontColor(entries);
        this.getView().updateView(ENTRY_ENTITY);
    }

    private void initEntry(String searchText, DynamicObjectCollection entries, Collection<ConnectionInfo> values) {
        Collection<Object> newValues = new ArrayList<ConnectionInfo>(values);
        if (!StringUtil.isEmpty((String)searchText)) {
            newValues = values.stream().filter(cn -> this.matches((ConnectionInfo)cn, searchText)).collect(Collectors.toList());
        }
        for (ConnectionInfo info : newValues) {
            DynamicObject row = entries.addNew();
            this.setEntryValues(info, row);
        }
    }

    private boolean matches(ConnectionInfo cnInfo, String text) {
        return cnInfo.getName() != null && cnInfo.getName().contains(text) || cnInfo.getNumber() != null && cnInfo.getNumber().contains(text);
    }

    private void setEntryValues(ConnectionInfo connectionLicenseInfo, DynamicObject row) {
        int licenseSN = connectionLicenseInfo.getLicenseSN();
        String state = connectionLicenseInfo.getStateString();
        Date createTime = connectionLicenseInfo.getCreateTime();
        row.set("type", (Object)connectionLicenseInfo.getType());
        row.set("name", (Object)connectionLicenseInfo.getName());
        row.set("number", (Object)connectionLicenseInfo.getNumber());
        row.set("create_time", (Object)D.t((Object)createTime));
        row.set(LICENSE_STATUS, (Object)state);
        if (licenseSN != 0) {
            row.set("license_sn", (Object)licenseSN);
        }
        row.set("failure_time", (Object)this.getPageCache().get(EXPIRE_DATE));
    }

    private void setFontColor(DynamicObjectCollection entries) {
        ArrayList<CellStyle> styles = new ArrayList<CellStyle>(entries.size());
        for (int i = 0; i < entries.size(); ++i) {
            DynamicObject entry = (DynamicObject)entries.get(i);
            CellStyle cellStyle = new CellStyle();
            cellStyle.setRow(i);
            cellStyle.setFieldKey(LICENSE_STATUS);
            Object license_status = entry.get(LICENSE_STATUS);
            if (license_status.equals("expired")) {
                cellStyle.setForeColor("rgb(128,0,0)");
            } else if (license_status.equals("no")) {
                cellStyle.setForeColor("rgb(255,0,0)");
            } else if (license_status.equals("yes")) {
                // empty if block
            }
            styles.add(cellStyle);
        }
        EntryGrid grid = (EntryGrid)this.getView().getControl(ENTRY_ENTITY);
        grid.setCellStyle(styles);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        ComboEdit comboEdit = (ComboEdit)this.getControl("type");
        DynamicObject[] connectionTypeArray = BusinessDataServiceHelper.load((String)"isc_connection_type", (String)"number, name", null);
        ArrayList<ComboItem> comboItemdata = new ArrayList<ComboItem>(connectionTypeArray.length);
        for (DynamicObject connectionType : connectionTypeArray) {
            comboItemdata.add(new ComboItem(new LocaleString(connectionType.getString("name")), connectionType.getString("number")));
        }
        comboItemdata.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u5185\u90e8RabbitMQ", (String)"LicenseSchemaTreePlugin_6", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0])), "InternalRabbit"));
        comboItemdata.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u5916\u90e8RabbitMQ", (String)"LicenseSchemaTreePlugin_7", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0])), "ExternalRabbit"));
        comboItemdata.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u5916\u90e8Kafka", (String)"LicenseSchemaTreePlugin_8", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0])), "ExternalKafka"));
        comboItemdata.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u5916\u90e8RocketMQ", (String)"LicenseSchemaTreePlugin_9", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0])), "ExternalRocket"));
        comboItemdata.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u534e\u4e3aMQS", (String)"LicenseSchemaTreePlugin_10", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0])), "ExternalMqs"));
        comboItemdata.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u5916\u90e8ActiveMQ", (String)"LicenseSchemaTreePlugin_11", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0])), "ExternalActive"));
        comboItemdata.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u5916\u90e8MSMQ", (String)"LicenseSchemaTreePlugin_12", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0])), "ExternalMsmq"));
        comboEdit.setComboItems(comboItemdata);
    }
}

