/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.formplugin.dc.trigger;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Search;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.lang.Lang;
import kd.isc.iscb.util.db.DataRow;
import kd.isc.iscb.util.db.DbUtil;
import kd.isc.iscb.util.except.IscBizException;
import kd.isc.iscb.util.io.ObjectReader;

public class DataCopyTriggerF7FormPlugin
extends AbstractFormPlugin
implements RowClickEventListener,
SearchEnterListener {
    private static final String ENTRY_ENTITY = "entryentity";
    private static final Map<String, String> fieldsMap = new HashMap<String, String>();

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.getModel().deleteEntryData(ENTRY_ENTITY);
        StringBuilder sBuilder = this.generateFileds();
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Map filters = (Map)formShowParameter.getCustomParam("params");
        int size = 3;
        if (filters == null) {
            filters = Collections.emptyMap();
        }
        sBuilder.append(" WHERE ");
        ArrayList<Object> values = new ArrayList<Object>(size += filters.size());
        ArrayList<Integer> types = new ArrayList<Integer>(size);
        this.filterMultiLang(sBuilder, values, types);
        for (Map.Entry field : filters.entrySet()) {
            sBuilder.append(" AND ").append(fieldsMap.get(field.getKey())).append(" like ? ");
            values.add("%" + field.getValue() + "%");
            types.add(12);
        }
        this.executeQuery(sBuilder, values, types);
    }

    public void search(SearchEnterEvent event) {
        String searchText = event.getText();
        this.getModel().deleteEntryData(ENTRY_ENTITY);
        this.innerSearch(searchText);
    }

    private void innerSearch(String searchText) {
        StringBuilder sBuilder = this.generateFileds();
        sBuilder.append(" WHERE ");
        ArrayList<Object> values = new ArrayList<Object>();
        ArrayList<Integer> types = new ArrayList<Integer>();
        this.filterMultiLang(sBuilder, values, types);
        if (searchText != null && searchText.trim().length() > 0) {
            values.addAll(Arrays.asList("%" + searchText + "%", "%" + searchText + "%", "%" + searchText + "%", "%" + searchText + "%", "%" + searchText + "%"));
            types.addAll(Arrays.asList(12, 12, 12, 12, 12));
            sBuilder.append(" and ( ");
            sBuilder.append(" T_ISC_DATA_COPY_TRIGGER.fnumber like ? ");
            sBuilder.append(" or T_ISC_DATA_COPY_TRIGGER_L.fname like ? ");
            sBuilder.append(" or T_DS_SRCSYS.fnumber like ? ");
            sBuilder.append(" or T_DS_SRCSYS_L.fname LIKE ? ");
            sBuilder.append(" or T_DS_SRCSYSTYPE.fnumber like ? ");
            sBuilder.append(" ) ");
        }
        this.executeQuery(sBuilder, values, types);
    }

    public void executeQuery(StringBuilder sBuilder, List<Object> values, List<Integer> types) {
        Connection cn = null;
        ObjectReader rows = null;
        try {
            cn = TX.getConnection((String)"ISCB", (boolean)true, (String[])new String[0]);
            rows = DbUtil.executeQuery((Connection)cn, (String)sBuilder.toString(), values, types);
            this.setEntryData((ObjectReader<DataRow>)rows);
        }
        catch (Exception e) {
            try {
                throw new IscBizException((Throwable)e);
            }
            catch (Throwable throwable) {
                DbUtil.close(rows);
                DbUtil.close((Connection)cn, (boolean)false);
                throw throwable;
            }
        }
        DbUtil.close((ObjectReader)rows);
        DbUtil.close((Connection)cn, (boolean)false);
    }

    private void filterMultiLang(StringBuilder sBuilder, List<Object> values, List<Integer> types) {
        values.addAll(Arrays.asList(Lang.get().toString(), Lang.get().toString(), Lang.get().toString()));
        types.addAll(Arrays.asList(12, 12, 12));
        sBuilder.append(" T_ISC_DATA_COPY_TRIGGER_L.FLOCALEID = ? ");
        sBuilder.append(" AND T_DS_SRCSYS_L.FLOCALEID = ? ");
        sBuilder.append(" AND T_DS_SRCSYSTYPE_L.FLOCALEID = ? ");
    }

    private void setEntryData(ObjectReader<DataRow> rows) {
        IDataModel model = this.getModel();
        int i = 0;
        DataRow item = (DataRow)rows.read();
        while (item != null) {
            model.insertEntryRow(ENTRY_ENTITY, i);
            for (String field : fieldsMap.keySet()) {
                model.setValue(field, item.getValue("f" + field), i);
            }
            ++i;
            item = (DataRow)rows.read();
        }
    }

    private StringBuilder generateFileds() {
        StringBuilder sBuilder = new StringBuilder();
        sBuilder.append(" SELECT ");
        sBuilder.append(" DISTINCT T_ISC_DATA_COPY_TRIGGER.FID, ");
        sBuilder.append(" T_ISC_DATA_COPY_TRIGGER.FNUMBER, ");
        sBuilder.append(" T_ISC_DATA_COPY_TRIGGER_L.FNAME, ");
        sBuilder.append(" T_ISC_DATA_COPY_TRIGGER.FCREATORID, ");
        sBuilder.append(" T_ISC_DATA_COPY_TRIGGER.FMODIFIERID, ");
        sBuilder.append(" T_ISC_DATA_COPY_TRIGGER.FSTATUS, ");
        sBuilder.append(" T_ISC_DATA_COPY_TRIGGER.FENABLE, ");
        sBuilder.append(" T_ISC_DATA_COPY_TRIGGER.FCREATETIME, ");
        sBuilder.append(" T_ISC_DATA_COPY_TRIGGER.FMODIFYTIME, ");
        sBuilder.append(" T_ISC_DATA_COPY_TRIGGER.FMASTERID, ");
        sBuilder.append(" T_ISC_DATA_COPY_TRIGGER.FTRIGGED_TIME, ");
        sBuilder.append(" T_ISC_DATA_COPY_TRIGGER.FTOTAL_COUNT, ");
        sBuilder.append(" T_ISC_DATA_COPY_TRIGGER.FTRIGGER_TYPE, ");
        sBuilder.append(" T_ISC_DATA_COPY_TRIGGER.FDATA_COPY AS FDATA_COPY_ID, ");
        sBuilder.append(" T_ISC_DATASOURCE.FID AS FDATA_SOURCE_ID, ");
        sBuilder.append(" T_ISC_DATASOURCE.FNUMBER AS FDATA_SOURCE_NUMBER, ");
        sBuilder.append(" T_ISC_DATABASE_LINK.FNUMBER AS FDBLINK_NUMBER, ");
        sBuilder.append(" T_DS_SRCSYS.FNUMBER AS FDS_SRCSYS_NUMBER, ");
        sBuilder.append(" T_DS_SRCSYS_L.FNAME AS FDS_SRCSYS_NAME, ");
        sBuilder.append(" T_DS_SRCSYSTYPE.FNUMBER AS FDS_SRCSYS_TYPE_NUMBER, ");
        sBuilder.append(" T_DS_SRCSYSTYPE_L.FNAME AS FDS_SRCSYS_TYPE_NAME ");
        sBuilder.append(" FROM ");
        sBuilder.append(" T_ISC_DATA_COPY_TRIGGER ");
        sBuilder.append(" LEFT JOIN  T_ISC_DATA_COPY_TRIGGER_L ON T_ISC_DATA_COPY_TRIGGER.FID = T_ISC_DATA_COPY_TRIGGER_L.FID ");
        sBuilder.append(" LEFT JOIN T_ISCB_DATA_COPY ON T_ISC_DATA_COPY_TRIGGER.FDATA_COPY = T_ISCB_DATA_COPY.FID ");
        sBuilder.append(" LEFT JOIN T_ISC_DATASOURCE ON T_ISCB_DATA_COPY.FDATA_SOURCE = T_ISC_DATASOURCE.FID ");
        sBuilder.append(" LEFT JOIN T_ISC_DATABASE_LINK ON T_ISC_DATASOURCE.FDBLINK = T_ISC_DATABASE_LINK.FID ");
        sBuilder.append(" LEFT JOIN T_DS_SRCSYS ON T_ISC_DATABASE_LINK.FSOURCE_SYSTEM = T_DS_SRCSYS.FID ");
        sBuilder.append(" LEFT JOIN T_DS_SRCSYS_L ON T_DS_SRCSYS_L.FID = T_DS_SRCSYS.FID ");
        sBuilder.append(" LEFT JOIN T_DS_SRCSYSTYPE ON T_DS_SRCSYS.FSRCSYSTYPE = T_DS_SRCSYSTYPE.FID ");
        sBuilder.append(" LEFT JOIN T_DS_SRCSYSTYPE_L ON T_DS_SRCSYSTYPE.FID = T_DS_SRCSYSTYPE_L.FID ");
        return sBuilder;
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btn_confirm", "btn_cancel"});
        this.addClickListeners(new String[]{ENTRY_ENTITY});
        EntryGrid entry = (EntryGrid)this.getView().getControl(ENTRY_ENTITY);
        entry.addRowClickListener((RowClickEventListener)this);
        Search search = (Search)this.getControl("searchap");
        search.addEnterListener((SearchEnterListener)this);
    }

    public void click(EventObject evt) {
        String key = ((Control)evt.getSource()).getKey();
        if ("btn_confirm".equals(key)) {
            EntryGrid entry = (EntryGrid)this.getControl(ENTRY_ENTITY);
            int[] rows = entry.getSelectRows();
            if (rows.length == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u81f3\u5c11\u9009\u62e9 1 \u6761\u8bb0\u5f55!", (String)"DataCopyTriggerF7FormPlugin_0", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
                return;
            }
            this.getView().returnDataToParent(this.getSelectedRowData(rows));
            this.getView().close();
        } else if ("btn_cancel".equals(key)) {
            this.getView().close();
        }
    }

    private List<Map<String, Object>> getSelectedRowData(int[] rows) {
        IDataModel model = this.getModel();
        ArrayList<Map<String, Object>> dataRows = new ArrayList<Map<String, Object>>(rows.length);
        for (int index : rows) {
            HashMap<String, Object> data = new HashMap<String, Object>(fieldsMap.size());
            for (String field : fieldsMap.keySet()) {
                data.put(field, model.getValue(field, index));
            }
            dataRows.add(data);
        }
        return dataRows;
    }

    static {
        fieldsMap.put("id", "T_ISC_DATA_COPY_TRIGGER.FID");
        fieldsMap.put("number", "T_ISC_DATA_COPY_TRIGGER.FNUMBER");
        fieldsMap.put("name", "T_ISC_DATA_COPY_TRIGGER.FNAME");
        fieldsMap.put("trigged_time", "T_ISC_DATA_COPY_TRIGGER.FTRIGGED_TIME");
        fieldsMap.put("total_count", "T_ISC_DATA_COPY_TRIGGER.FTOTAL_COUNT");
        fieldsMap.put("trigger_type", "T_ISC_DATA_COPY_TRIGGER.FTRIGGER_TYPE");
        fieldsMap.put("dblink_number", "T_ISC_DATABASE_LINK.FNUMBER");
        fieldsMap.put("ds_srcsys_number", "T_DS_SRCSYS.FNUMBER");
        fieldsMap.put("ds_srcsys_type_number", "T_DS_SRCSYSTYPE.FNUMBER");
        fieldsMap.put("ds_srcsys_type_name", "T_DS_SRCSYSTYPE_L.FNAME");
    }
}

