/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.formplugin.dc.trigger;

import java.sql.Timestamp;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.OperateOptionPrivate;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.Donothing;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.isc.iscb.formplugin.common.topology.TopologyFormUtil;
import kd.isc.iscb.formplugin.dc.trigger.TriggerPluginUtil;
import kd.isc.iscb.formplugin.tools.ScriptDebuggerFormPlugin;
import kd.isc.iscb.formplugin.util.EventLogUtil;
import kd.isc.iscb.formplugin.util.ExportUtil;
import kd.isc.iscb.formplugin.util.FormOpener;
import kd.isc.iscb.formplugin.util.MetaTypeChecker;
import kd.isc.iscb.platform.core.cache.data.DataCopySchema;
import kd.isc.iscb.platform.core.cache.data.MetaDataSchema;
import kd.isc.iscb.platform.core.connector.eas.Util;
import kd.isc.iscb.platform.core.dc.DataCopyTask;
import kd.isc.iscb.platform.core.dc.DataCopyTaskStage;
import kd.isc.iscb.platform.core.dc.DataCopyTaskUtil;
import kd.isc.iscb.platform.core.dc.e.DataCopyDebugger;
import kd.isc.iscb.platform.core.dc.e.DataCopyParam;
import kd.isc.iscb.platform.core.dc.mq.TriggerRouter;
import kd.isc.iscb.platform.core.task.Task;
import kd.isc.iscb.platform.core.task.TaskManager;
import kd.isc.iscb.platform.core.trace.Caller;
import kd.isc.iscb.platform.core.trace.TraceStack;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.trace.TraceTask;

public class DataCopyTriggerListPlugin
extends AbstractListPlugin {
    private static final String TYPE_EVENT = "event";
    private static final String TRIGGER_ID = "triggerId";
    private static final String TRIGGER_TYPE = "trigger_type";
    private static final String ISC_DATA_COPY_TASKSTAGE = "isc_data_copy_taskstage";
    private static final String ISC_DATA_COPY_EXECUTION = "isc_data_copy_execution";
    private static final String ISC_DATA_COPY_TRIGGER = "isc_data_copy_trigger";

    public void beforeDoOperation(BeforeDoOperationEventArgs evt) {
        ListSelectedRowCollection dataCollection = evt.getListSelectedData();
        if (evt.getSource() instanceof AbstractOperate && dataCollection.size() > 0) {
            AbstractOperate operate = (AbstractOperate)evt.getSource();
            String operateKey = operate.getOperateKey();
            try {
                if (!"exportzip".equals(operate.getOperateKey()) && !"exportschema".equals(operate.getOperateKey()) || dataCollection.size() <= 100) {
                    if (operateKey.equals("enable")) {
                        Object[] primaryKeyValues = dataCollection.getPrimaryKeyValues();
                        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)ISC_DATA_COPY_TRIGGER);
                        DynamicObject[] triggers = BusinessDataServiceHelper.load((Object[])primaryKeyValues, (DynamicObjectType)dataEntityType);
                        DataCopyTriggerListPlugin.submit(triggers);
                        TriggerPluginUtil.enableSubscriberQueue((AbstractFormPlugin)this, triggers);
                    } else if (operateKey.equals("disable")) {
                        Object[] primaryKeyValues = dataCollection.getPrimaryKeyValues();
                        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)ISC_DATA_COPY_TRIGGER);
                        DynamicObject[] triggers = BusinessDataServiceHelper.load((Object[])primaryKeyValues, (DynamicObjectType)dataEntityType);
                        DataCopyTriggerListPlugin.cancel(triggers);
                    } else if ("delete".equals(operateKey) && dataCollection.size() > 1) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u8981\u9009\u62e9\u591a\u884c!", (String)"DataCopyTriggerListPlugin_1", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), Integer.valueOf(1500));
                        evt.setCancel(true);
                    } else if ("modify".equals(operateKey)) {
                        if (dataCollection.size() > 1) {
                            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u8981\u9009\u62e9\u591a\u884c!", (String)"DataCopyTriggerListPlugin_1", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), Integer.valueOf(1500));
                            evt.setCancel(true);
                        } else if (dataCollection.size() == 1) {
                            Object[] ids = dataCollection.getPrimaryKeyValues();
                            this.checkEnable(ids[0]);
                            evt.setCancel(true);
                        }
                    }
                }
            }
            catch (Exception e) {
                evt.setCancel(true);
                FormOpener.showErrorMessage(this.getView(), e);
            }
        }
        this.openDataCopyFormByFilter(evt);
    }

    private void openDataCopyFormByFilter(BeforeDoOperationEventArgs evt) {
        if (evt.getSource() instanceof AbstractOperate) {
            AbstractOperate operate = (AbstractOperate)evt.getSource();
            String operateKey = operate.getOperateKey();
            try {
                QFilter qFilter;
                ListShowParameter listShowParameter;
                List qFilters;
                if ("new".equalsIgnoreCase(operateKey) && !(qFilters = (listShowParameter = (ListShowParameter)this.getView().getFormShowParameter()).getListFilterParameter().getQFilters()).isEmpty() && (qFilter = (QFilter)qFilters.get(0)) != null && "data_copy".equals(qFilter.getProperty()) && "=".equals(qFilter.getCP())) {
                    long id = D.l((Object)qFilter.getValue());
                    HashMap<String, Object> params = new HashMap<String, Object>();
                    params.put("data_copy_id", id);
                    FormOpener.showTabBill((AbstractFormPlugin)this, ISC_DATA_COPY_TRIGGER, null, params, null);
                    evt.setCancel(true);
                }
            }
            catch (Exception e) {
                evt.setCancel(true);
                FormOpener.showErrorMessage(this.getView(), e);
            }
        }
    }

    private void checkEnable(Object id) {
        if (id != null && Long.parseLong(id.toString()) != 0L) {
            DynamicObject trigger = BusinessDataServiceHelper.loadSingle((Object)id, (String)ISC_DATA_COPY_TRIGGER, (String)"enable");
            if (trigger.getInt("enable") == 1) {
                ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("disable_trigger", (IFormPlugin)this);
                this.getView().showConfirm(ResManager.loadKDString((String)"\u542f\u52a8\u65b9\u6848\u7981\u7528\u540e\u624d\u80fd\u4fee\u6539\uff0c\u662f\u5426\u7981\u7528\uff1f", (String)"DataCopyTriggerListPlugin_2", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, confirmCallBacks);
            } else {
                FormOpener.showTabEdit((AbstractFormPlugin)this, ISC_DATA_COPY_TRIGGER, trigger.getPkValue());
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent evt) {
        super.confirmCallBack(evt);
        if (evt.getResult() != MessageBoxResult.Yes) {
            return;
        }
        String callback = evt.getCallBackId();
        ListSelectedRowCollection selectedRows = this.getSelectedRows();
        Object[] pk = selectedRows.getPrimaryKeyValues();
        if (pk.length == 1 && "disable_trigger".equals(callback)) {
            try {
                DynamicObject trigger = BusinessDataServiceHelper.loadSingle((Object)pk[0], (String)ISC_DATA_COPY_TRIGGER);
                DataCopyTriggerListPlugin.cancel(new DynamicObject[]{trigger});
                trigger.set("enable", (Object)"0");
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{trigger});
                FormOpener.showTabEdit((AbstractFormPlugin)this, ISC_DATA_COPY_TRIGGER, trigger.getPkValue());
            }
            catch (Exception e) {
                FormOpener.showErrorMessage(this.getView(), e);
            }
        } else if ("enable_subscriber_queue".equals(callback)) {
            TriggerPluginUtil.confirmEnableQueue((AbstractFormPlugin)this);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs evt) {
        super.afterDoOperation(evt);
        try {
            if (evt.getOperationResult() == null || !evt.getOperationResult().isSuccess()) {
                return;
            }
            String operationKey = evt.getOperateKey();
            if (operationKey.equalsIgnoreCase("execute")) {
                Object pk = FormOpener.getSelectedId((AbstractFormPlugin)this, evt);
                if (pk != null) {
                    OperateOption option = ((Donothing)evt.getSource()).getOption();
                    boolean debug = D.x((Object)option.getVariableValue("#DEBUG", ""));
                    this.copy(BusinessDataServiceHelper.loadSingle((Object)pk, (String)ISC_DATA_COPY_TRIGGER), debug);
                }
            } else if (operationKey.equals("show_logs")) {
                FormOpener.showList((AbstractFormPlugin)this, "isc_data_copy_exec_log", "data_copy_trigger", evt);
            } else if (operationKey.equals("show_executions")) {
                FormOpener.showList((AbstractFormPlugin)this, ISC_DATA_COPY_EXECUTION, "data_copy_trigger", evt);
            } else if (operationKey.equals("show_taskstage")) {
                FormOpener.showList((AbstractFormPlugin)this, ISC_DATA_COPY_TASKSTAGE, "data_trigger", evt);
            } else if (operationKey.equals("exportschema")) {
                List pkIds = evt.getOperationResult().getSuccessPkIds();
                ExportUtil.exportDts((AbstractFormPlugin)this, pkIds, ISC_DATA_COPY_TRIGGER);
            } else if (operationKey.equals("exportzip")) {
                ExportUtil.exportZip((AbstractFormPlugin)this, evt, ISC_DATA_COPY_TRIGGER);
            } else if (operationKey.equals("importschema")) {
                FormOpener.openImportForm((IFormPlugin)this, this.getView(), ISC_DATA_COPY_TRIGGER);
            } else if (operationKey.equals("view_evt_que")) {
                EventLogUtil.showEventLogList((AbstractFormPlugin)this, "D", FormOpener.getSelectedId((AbstractFormPlugin)this, evt));
            } else if (operationKey.equals("enable") || operationKey.equals("disable")) {
                TriggerRouter.clearCache();
            } else if (operationKey.equals("attach_logs")) {
                FormOpener.showList((AbstractFormPlugin)this, "isc_attachment_log", "trigger", evt);
            } else if ("relation_query".equalsIgnoreCase(operationKey)) {
                TriggerPluginUtil.showUpstreamTrigger((AbstractFormPlugin)this, FormOpener.getSelectedId((AbstractFormPlugin)this, evt));
            } else if ("topology".equals(operationKey)) {
                this.showTopologyView(evt);
            } else if ("downstream_relation_query".equalsIgnoreCase(operationKey)) {
                TriggerPluginUtil.showDownstreamTrigger((AbstractFormPlugin)this, FormOpener.getSelectedId((AbstractFormPlugin)this, evt));
            } else if ("view_trigger_imp".equals(operationKey)) {
                QFilter filter = new QFilter("res_type", "like", (Object)"%(isc_data_copy_trigger)");
                FormOpener.openBillList((AbstractFormPlugin)this, "isc_dts_imp", Collections.singletonList(filter), ResManager.loadKDString((String)"\u8d44\u6e90\u5bfc\u5165\u8bb0\u5f55", (String)"DataCopyListPlugin_11", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
            }
        }
        catch (Exception e) {
            FormOpener.showErrorMessage(this.getView(), e);
        }
    }

    private void showTopologyView(AfterDoOperationEventArgs args) {
        long id = D.l((Object)FormOpener.getSelectedId((AbstractFormPlugin)this, args));
        if (id > 0L) {
            HashMap<String, Object> params = new HashMap<String, Object>(2);
            params.put("type", ISC_DATA_COPY_TRIGGER);
            params.put("id", id);
            FormOpener.showTabForm((AbstractFormPlugin)this, "isc_topology_view", TopologyFormUtil.getName("isc_data_copy_trigger," + id), params, "");
        }
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        super.closedCallBack(evt);
        if (StringUtils.equals((CharSequence)evt.getActionId(), (CharSequence)"importschema")) {
            this.getView().invokeOperation("refresh");
        } else if (StringUtils.equals((CharSequence)evt.getActionId(), (CharSequence)"close_event_param")) {
            Map map;
            Object returnData = evt.getReturnData();
            if (returnData instanceof Map && !D.x((map = (Map)returnData).get("#DEBUG"))) {
                Object id = map.get("id");
                FormOpener.showStatusBill((AbstractFormPlugin)this, ISC_DATA_COPY_EXECUTION, id, null, OperationStatus.VIEW, ShowType.MainNewTabPage);
            }
        } else if (StringUtils.equals((CharSequence)evt.getActionId(), (CharSequence)"iscExportTaskCloseCallBack")) {
            ExportUtil.iscExportTaskCallBack((AbstractFormPlugin)this, evt.getReturnData());
        }
    }

    private void copy(DynamicObject trigger, boolean debug) {
        int taskSize = trigger.getInt("taskSize");
        if (taskSize == 0) {
            this.doCopy(trigger, debug);
        } else if (taskSize > 0 && this.isSupportsBatch(trigger, taskSize)) {
            this.doBatch(trigger);
        }
    }

    private boolean isSupportsBatch(DynamicObject trigger, int taskSize) {
        if (taskSize < 1 || taskSize > 100000) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6e90\u5355\u6279\u91cf\u5927\u5c0f\u8d85\u51fa[0,100000]\u8303\u56f4", (String)"DataCopyTriggerListPlugin_4", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
            return false;
        }
        DynamicObject schema = BusinessDataServiceHelper.loadSingle((Object)trigger.getLong("data_copy_id"), (String)"isc_data_copy");
        DataCopyParam param = new DataCopyParam(schema);
        String trigger_type = trigger.getString(TRIGGER_TYPE);
        if (!trigger_type.equalsIgnoreCase("manual")) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4efb\u52a1\u5206\u6279\u53ea\u652f\u6301\u4eba\u5de5\u542f\u52a8", (String)"DataCopyTriggerListPlugin_5", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
            return false;
        }
        if (!(param.sourceIsTable() || param.sourceIsView() || param.sourceIsEntity())) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4efb\u52a1\u5206\u6279\u53ea\u652f\u6301\u8868\uff0c\u89c6\u56fe\u3001\u5b9e\u4f53\u6570\u636e", (String)"DataCopyTriggerListPlugin_6", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
            return false;
        }
        if (param.isRollbackOnError() || param.getTargetParentField() != null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5355\u4e8b\u7269\u548c\u5c42\u7ea7\u5173\u7cfb\u6570\u636e\u4e0d\u652f\u6301\u4efb\u52a1\u5206\u6279", (String)"DataCopyTriggerListPlugin_7", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private void doBatch(final DynamicObject trigger) {
        if (trigger.getDynamicObjectCollection("params_entryentity").isEmpty()) {
            TraceStack.trace((Caller)Caller.Front, (TraceTask)new TraceTask(){

                public void run() {
                    DynamicObject batchObject = DataCopyTaskStage.create((DynamicObject)trigger);
                    DataCopyTriggerListPlugin.this.refreshTaskStageR(batchObject);
                    Object batchId = batchObject.getPkValue();
                    TaskManager.submit((Task)new DataCopyTaskStage.taskStageThread(batchId));
                    FormOpener.showView((AbstractFormPlugin)DataCopyTriggerListPlugin.this, DataCopyTriggerListPlugin.ISC_DATA_COPY_TASKSTAGE, batchId);
                }
            });
        } else {
            HashMap<String, Object> params = new HashMap<String, Object>(1);
            params.put(TRIGGER_ID, trigger.getPkValue());
            FormOpener.showAddNew((AbstractFormPlugin)this, ISC_DATA_COPY_TASKSTAGE, params);
        }
    }

    private void refreshTaskStageR(DynamicObject batchObject) {
        batchObject.set("state", (Object)"R");
        batchObject.set("modifytime", (Object)new Timestamp(System.currentTimeMillis()));
        Util.save((DynamicObject)batchObject);
    }

    private void doCopy(DynamicObject trigger, boolean debug) {
        if (TYPE_EVENT.equals(trigger.getString(TRIGGER_TYPE))) {
            this.eventTrigger(trigger, debug);
        } else {
            this.manualTrigger(trigger, debug);
        }
    }

    private void eventTrigger(DynamicObject trigger, boolean debug) {
        DynamicObject meta = this.getSrcSchema(trigger);
        MetaTypeChecker.checkMetaType(meta);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put(TRIGGER_ID, trigger.getPkValue());
        params.put("#DEBUG", debug);
        FormOpener.showForm((AbstractFormPlugin)this, "isc_event_trigger_param", ResManager.loadKDString((String)"\u4e8b\u4ef6\u542f\u52a8\u65b9\u6848\u8fc7\u6ee4\u914d\u7f6e", (String)"DataCopyTriggerListPlugin_8", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), params, "close_event_param");
    }

    private DynamicObject getSrcSchema(DynamicObject trigger) {
        long schemaId = D.l((Object)trigger.getLong("data_copy_id"));
        if (schemaId > 0L) {
            DynamicObject schema = DataCopySchema.get((long)schemaId);
            return MetaDataSchema.get((long)schema.getLong("source_schema_id"));
        }
        return null;
    }

    private void manualTrigger(final DynamicObject trigger, final boolean debug) {
        if (trigger.getDynamicObjectCollection("params_entryentity").isEmpty()) {
            TraceStack.trace((Caller)Caller.Front, (TraceTask)new TraceTask(){

                public void run() {
                    DataCopyDebugger.setDebug((boolean)debug);
                    try {
                        DynamicObject execution = DataCopyTask.create((DynamicObject)trigger, null, (DataCopyTask.InitType)DataCopyTask.InitType.MANUAL);
                        if (execution == null) {
                            DataCopyTriggerListPlugin.this.getView().showTipNotification(ResManager.loadKDString((String)"\u672c\u542f\u52a8\u65b9\u6848\u6b63\u5728\u6267\u884c\uff0c\u5fc5\u987b\u7ed3\u675f\u540e\u624d\u80fd\u518d\u6b21\u6267\u884c\uff01", (String)"DataCopyTriggerListPlugin_9", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
                        } else {
                            DataCopyTask.start((DynamicObject)execution);
                            FormOpener.showStatusBill((AbstractFormPlugin)DataCopyTriggerListPlugin.this, DataCopyTriggerListPlugin.ISC_DATA_COPY_EXECUTION, execution.getPkValue(), null, OperationStatus.VIEW, ShowType.MainNewTabPage);
                        }
                    }
                    finally {
                        DataCopyDebugger.unsetDebug();
                    }
                }
            });
        } else {
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put(TRIGGER_ID, trigger.getPkValue());
            params.put("#DEBUG", debug);
            FormOpener.showStatusBill((AbstractFormPlugin)this, ISC_DATA_COPY_EXECUTION, null, params, OperationStatus.ADDNEW, ShowType.MainNewTabPage);
        }
    }

    public static void submit(DynamicObject[] triggers) {
        for (DynamicObject trigger : triggers) {
            if ("auto".equals(trigger.get(TRIGGER_TYPE))) {
                DataCopyTaskUtil.createJobSchedule((DynamicObject)trigger);
                continue;
            }
            if (!TYPE_EVENT.equals(trigger.get(TRIGGER_TYPE))) continue;
            DataCopyTaskUtil.attachEvents((DynamicObject)trigger);
        }
    }

    public static void cancel(DynamicObject[] triggers) {
        for (DynamicObject trigger : triggers) {
            if ("auto".equals(trigger.get(TRIGGER_TYPE))) {
                DataCopyTaskUtil.disableJobSchedule((DynamicObject)trigger);
                continue;
            }
            if (!TYPE_EVENT.equals(trigger.get(TRIGGER_TYPE))) continue;
            DataCopyTaskUtil.detachEvents((DynamicObject)trigger);
        }
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        args.setCancel(true);
        Object selectedId = ((BillList)args.getHyperLinkClickEvent().getSource()).getCurrentSelectedRowInfo().getPrimaryKeyValue();
        FormOpener.showTabViewIfNotExist((AbstractFormPlugin)this, ISC_DATA_COPY_TRIGGER, selectedId);
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        if ("data_copy_debug".equals(evt.getItemKey()) && ScriptDebuggerFormPlugin.enableDebug((AbstractFormPlugin)this)) {
            FormOpener.showAppIdTabForm((AbstractFormPlugin)this, "isc_script_debugger", ResManager.loadKDString((String)"\u6570\u636e\u96c6\u6210\u8c03\u8bd5", (String)"DataCopyTriggerListPlugin_17", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), new HashMap<String, Object>());
            OperateOptionPrivate option = new OperateOptionPrivate();
            option.setVariableValue("#DEBUG", "true");
            this.getView().invokeOperation("execute", (OperateOption)option);
        }
    }
}

