/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.formplugin.export;

import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.cache.CacheFactory;
import kd.bos.dataentity.resource.ResManager;
import kd.isc.iscb.formplugin.export.ExcelFileExport;
import kd.isc.iscb.util.connector.s.QueryList;
import kd.isc.iscb.util.db.DbUtil;
import kd.isc.iscb.util.except.IscBizException;
import kd.isc.iscb.util.misc.StringUtil;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddress;

public class DownloadUtil {
    public static final int MAX_LENGTH = 30000;

    public static void createHead(Sheet sheet, CellStyle style, List<ExcelFileExport.ExcelColumnInfo> excelInfos) {
        Row row = sheet.createRow(0);
        int excelInfosSize = excelInfos.size();
        for (int i = 0; i < excelInfosSize; ++i) {
            ExcelFileExport.ExcelColumnInfo info = excelInfos.get(i);
            Cell cell = row.createCell(i);
            cell.setCellValue(info.getColumnName());
            cell.setCellStyle(style);
            sheet.setColumnWidth(i, info.getWidth());
        }
        sheet.setAutoFilter(CellRangeAddress.valueOf((String)"A1:I1"));
    }

    public static CellStyle createContentStyle(Workbook workbook) {
        CellStyle style = workbook.createCellStyle();
        Font font = workbook.createFont();
        style.setFont(font);
        return style;
    }

    public static CellStyle createHeadStyle(Workbook workbook) {
        CellStyle style = workbook.createCellStyle();
        Font font = workbook.createFont();
        font.setBold(true);
        style.setFont(font);
        return style;
    }

    public static int calLength(String inputString, String outputString, String otherString) {
        int i = inputString == null ? 0 : inputString.length();
        int j = outputString == null ? 0 : outputString.length();
        int k = otherString == null ? 0 : otherString.length();
        int max = Math.max(Math.max(i, j), k);
        if (max <= 30000) {
            return 0;
        }
        return max % 30000 == 0 ? max / 30000 - 1 : max / 30000;
    }

    public static int calListLength(List<String> strings) {
        int max = -1;
        for (String string : strings) {
            int length = StringUtil.isEmpty((String)string) ? 0 : string.length();
            max = Math.max(length, max);
        }
        if (max <= 30000) {
            return 0;
        }
        return max % 30000 == 0 ? max / 30000 - 1 : max / 30000;
    }

    public static void setMultiCells(Row row, CellStyle contentStyle, String stringVar, int i, int k) {
        if (stringVar == null) {
            return;
        }
        if (stringVar.length() >= (i + 1) * 30000) {
            DownloadUtil.setCellValue(row, contentStyle, stringVar.substring(i * 30000, (i + 1) * 30000), k);
        } else if (stringVar.length() > i * 30000) {
            DownloadUtil.setCellValue(row, contentStyle, stringVar.substring(i * 30000), k);
        }
    }

    private static void setCellValue(Row row, CellStyle contentStyle, String inputString, int k) {
        Cell c = row.createCell(k);
        c.setCellStyle(contentStyle);
        c.setCellValue(inputString);
    }

    public static String getZipUrl(InputStream input, String name) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd_HHmmss");
        String format = sdf.format(new Date());
        return CacheFactory.getCommonCacheFactory().getTempFileCache().saveAsUrl(name + '_' + format + ".zip", input, 600);
    }

    public static int checkMaxLimit(int max_limit, Map<String, Object> log) {
        int maxSize = QueryList.getResultSetMaxSize();
        if ((max_limit = (int)((long)max_limit + DbUtil.getObjectSize(log))) >= maxSize) {
            throw new IscBizException(String.format(ResManager.loadKDString((String)"\u5bfc\u51fa\u6587\u4ef6\u7684\u603b\u5b57\u8282\u6570\u5df2\u7ecf\u8d85\u8fc7\u53ef\u663e\u793a\u7684\u6700\u5927\u503c%s\u4e2a\u5b57\u8282\uff0c\u5efa\u8bae\u89e3\u51b3\u529e\u6cd5\uff1a\u8c03\u6574\u5bfc\u51fa\u6587\u4ef6\u6570\u91cf\uff1b\u6216\u8054\u7cfb\u7ba1\u7406\u5458\u8c03\u6574JVM\u7cfb\u7edf\u53c2\u6570 ISC_QUERY_MAX_SIZE \u589e\u52a0\u4e0a\u9650\u3002", (String)"DownloadUtil_3", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), maxSize));
        }
        return max_limit;
    }

    public static String getXlsFileName(String filename) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd_HHmmss");
        String format = sdf.format(new Date());
        return filename + format + ".xlsx";
    }
}

