/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.formplugin.ext;

import java.sql.Connection;
import java.util.Collections;
import java.util.EventObject;
import java.util.Map;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.isc.iscb.formplugin.util.FormOpener;
import kd.isc.iscb.platform.core.cache.data.ConnectionConfig;
import kd.isc.iscb.platform.core.connector.ConnectionManager;
import kd.isc.iscb.platform.core.connector.self.ExecutionData;
import kd.isc.iscb.platform.core.ext.InterfaceCenterUtil;
import kd.isc.iscb.util.db.DataRow;
import kd.isc.iscb.util.db.DbUtil;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.except.IscBizException;

public class ExternalCnConfigFormPlugin
extends AbstractFormPlugin {
    private static final String ENABLE = "enable";
    private static final String DISABLE = "disable";
    private static final String SAVE = "save";
    private static final String MODIFY = "modify";
    private static final String TEST = "test";
    private static final String NUMBER = "number";
    private static final String NAME = "name";
    private static final String ID = "id";
    private static final String SECRET_NEW = "appsecret_new";
    private static final String NEW_CIPHER = "newpwd";
    private static final String STATE = "state";
    private static final String HTTP_PROTOCOL = "http_protocal";
    private static final String SERVER_PORT = "server_port";
    private static final String DATABASE_TYPE = "database_type";
    private static final String DATA_CENTER = "data_center";
    private static final String ISC_CN_CONFIG = "isc_cn_config";
    private static final String ISC_CONNECTION_TYPE = "isc_connection_type_x";
    private static final String SERVER_IP = "server_ip";
    private static final String APPID = "appid";
    private static final String ACCOUNT = "account";
    private static final String TENANT = "tenant";
    private static final String USER = "user";
    private static final String FIELD_NEW = "newpwd";
    private static final String SQL_DATABASE = "sql_database";
    private static final String ORACLE_SERVICE = "oracle_service";
    private static final String CHARSET = "charset";
    private static final String EAS_SERVICE = "eas_service";
    private static final String WEB_APP = "web_app";
    private static final String IERP_PROXY_USER = "ierp_proxy_user";
    private static final String ICID = "icid";
    private static final String MAX_TPS = "max_tps";
    private static final String BAR_MODIFY = "bar_modify";
    private static final String BAR_DISABLE = "bar_disable";

    public void initialize() {
        String appid;
        super.initialize();
        if ("admin".equals(System.getProperty("interface_center.user.type"))) {
            this.getView().setEnable(Boolean.TRUE, new String[]{NUMBER, NAME, DATABASE_TYPE});
            this.getView().setEnable(Boolean.TRUE, new String[]{SERVER_IP, SERVER_PORT, APPID, SECRET_NEW, ACCOUNT, TENANT, USER, "newpwd", SQL_DATABASE, ORACLE_SERVICE, CHARSET, DATA_CENTER, EAS_SERVICE, WEB_APP, IERP_PROXY_USER, HTTP_PROTOCOL, ICID, MAX_TPS});
        } else {
            this.getView().setEnable(Boolean.FALSE, new String[]{NUMBER, NAME, DATABASE_TYPE});
        }
        IFormView parentView = this.getView().getParentView();
        if (parentView != null && "iscb".equals(appid = D.s((Object)parentView.getFormShowParameter().getAppId()))) {
            this.getView().setVisible(Boolean.FALSE, new String[]{BAR_MODIFY, BAR_DISABLE});
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{DATA_CENTER});
    }

    public void click(EventObject evt) {
        super.click(evt);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate operate = (AbstractOperate)args.getSource();
        String operationKey = operate.getOperateKey();
        if (SAVE.equals(operationKey)) {
            this.executeSave(args);
        } else if (MODIFY.equals(operationKey)) {
            this.checkEnable(args);
        }
    }

    private void executeSave(BeforeDoOperationEventArgs args) {
        this.checkEnable(args);
        String viewNumber = D.s((Object)this.getModel().getValue(NUMBER));
        String id = D.s((Object)this.getModel().getValue(ID));
        if (InterfaceCenterUtil.checkDuplicateNumber((String)"t_isc_database_link", (String)id, (String)viewNumber)) {
            args.setCancel(true);
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u4fdd\u5b58%s,\u7f16\u7801\u5728\u3010\u96c6\u6210\u7ba1\u7406\u3011->\u3010\u8fde\u63a5\u7ba1\u7406\u3011->\u3010\u8fde\u63a5\u914d\u7f6e\u3011\u4e2d\u5df2\u5b58\u5728\u3002", (String)"ExternalCnConfigFormPlugin_16", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), viewNumber));
            return;
        }
        if (InterfaceCenterUtil.checkDuplicateNumber((String)"t_isc_datasource", (String)id, (String)viewNumber)) {
            args.setCancel(true);
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u4fdd\u5b58%s,\u7f16\u7801\u5728\u3010\u96c6\u6210\u7ba1\u7406\u3011->\u3010\u8fde\u63a5\u7ba1\u7406\u3011->\u3010\u6570\u636e\u6e90\u7ba1\u7406\u3011\u4e2d\u5df2\u5b58\u5728\u3002", (String)"ExternalCnConfigFormPlugin_17", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), viewNumber));
            return;
        }
        if (!args.isCancel()) {
            this.getModel().setValue(STATE, null);
        }
    }

    private void checkEnable(BeforeDoOperationEventArgs evt) {
        DynamicObject cn_config;
        Object cnId = this.getModel().getValue(ID);
        if (cnId != null && Long.parseLong(cnId.toString()) != 0L && (cn_config = BusinessDataServiceHelper.loadSingle((Object)cnId, (String)ISC_CN_CONFIG, (String)ENABLE)).getBoolean(ENABLE)) {
            evt.setCancel(true);
            ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("disable_cn_config", (IFormPlugin)this);
            String tips = OperationStatus.VIEW.equals((Object)this.getView().getFormShowParameter().getStatus()) ? ResManager.loadKDString((String)"\u8fde\u63a5\u914d\u7f6e\u7981\u7528\u540e\u624d\u80fd\u4fee\u6539\uff0c\u662f\u5426\u7981\u7528\uff1f", (String)"ExternalCnConfigFormPlugin_3", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u8fde\u63a5\u914d\u7f6e\u7981\u7528\u540e\u624d\u80fd\u4fdd\u5b58\uff0c\u662f\u5426\u7981\u7528\uff1f", (String)"ExternalCnConfigFormPlugin_4", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]);
            this.getView().showConfirm(tips, MessageBoxOptions.YesNo, confirmCallBacks);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        if (this.isSuccess(args)) {
            try {
                String operateKey = args.getOperateKey();
                if (TEST.equals(operateKey)) {
                    this.testConnection();
                } else if (SAVE.equals(operateKey)) {
                    this.openDetailForm();
                    this.getView().setStatus(OperationStatus.VIEW);
                    this.getView().setVisible(Boolean.TRUE, new String[]{BAR_DISABLE});
                } else if (MODIFY.equals(operateKey)) {
                    this.getView().setStatus(OperationStatus.EDIT);
                    this.getView().setVisible(Boolean.FALSE, new String[]{BAR_DISABLE});
                } else if (ENABLE.equals(operateKey)) {
                    this.getView().setStatus(OperationStatus.VIEW);
                } else if (DISABLE.equals(operateKey)) {
                    this.getView().setStatus(OperationStatus.VIEW);
                }
            }
            catch (Throwable e) {
                FormOpener.showErrorMessage(this.getView(), e);
            }
        }
    }

    private boolean isSuccess(AfterDoOperationEventArgs args) {
        return args.getOperationResult() != null && args.getOperationResult().isSuccess();
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        super.closedCallBack(evt);
    }

    private void openDetailForm() {
        String formId = this.getView().getFormShowParameter().getFormId();
        if (ISC_CN_CONFIG.equals(formId)) {
            BillShowParameter param = new BillShowParameter();
            DynamicObject cnType = (DynamicObject)this.getModel().getValue(DATABASE_TYPE);
            param.setFormId(this.getCnConfigForm(cnType));
            param.setPkId(this.getModel().getValue(ID));
            param.getOpenStyle().setShowType(ShowType.InCurrentForm);
            param.setParentPageId(this.getView().getParentView().getPageId());
            this.getView().showForm((FormShowParameter)param);
        }
    }

    private String getCnConfigForm(DynamicObject cnType) {
        Object cnTypeId = cnType.getPkValue();
        DynamicObject[] types = BusinessDataServiceHelper.load((String)ISC_CONNECTION_TYPE, (String)"config_form", (QFilter[])new QFilter[]{new QFilter(ID, "=", cnTypeId)});
        int typeSize = types.length;
        if (typeSize < 1) {
            throw new IscBizException(String.format(ResManager.loadKDString((String)"\u6839\u636e\u6761\u4ef6\uff1aid = %1$s,\u67e5\u8be2\u5355\u636e\uff1a%2$s,\u83b7\u53d6\u6570\u636e\u6761\u6570\uff1a%3$s\u6761\u3002", (String)"ExternalCnConfigFormPlugin_18", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), cnTypeId, ISC_CONNECTION_TYPE, typeSize));
        }
        return types[0].getString("config_form");
    }

    private void testConnection() {
        boolean enable = D.x((Object)this.getView().getModel().getValue(ENABLE));
        if (!enable) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u542f\u7528\u5916\u90e8\u7cfb\u7edf\u914d\u7f6e\uff0c\u518d\u6267\u884c\u6d4b\u8bd5\u3002", (String)"ExternalCnConfigFormPlugin_9", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
            return;
        }
        DynamicObject dataEntity = this.getModel().getDataEntity();
        if (D.l((Object)dataEntity.getPkValue()) == 0L || this.hasPageModified(dataEntity.getPkValue())) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u4fdd\u5b58\u6570\u636e\u3002", (String)"ExternalCnConfigFormPlugin_10", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
        } else {
            this.test(dataEntity);
        }
    }

    private void test(DynamicObject dataEntity) {
        if (!InterfaceCenterUtil.connectionTypeIsEnabled((DynamicObject)dataEntity)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5728\u5f00\u653e\u5e73\u53f0->\u7b2c\u4e09\u65b9\u63a5\u53e3->\u5916\u90e8\u7cfb\u7edf->\u7cfb\u7edf\u7c7b\u578b\uff0c\u6267\u884c\u542f\u7528/\u7981\u7528\u64cd\u4f5c\uff0c\u5c06\u8fde\u63a5\u7c7b\u578b\u53d1\u5e03\u5230\u96c6\u6210\u7ba1\u7406\uff0c\u518d\u6267\u884c\u6d4b\u8bd5\u3002", (String)"ExternalCnConfigFormPlugin_11", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
            return;
        }
        try {
            ConnectionManager.test((long)D.l((Object)dataEntity.getPkValue()));
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u6d4b\u8bd5\u6210\u529f\uff01", (String)"ExternalCnConfigFormPlugin_12", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
            dataEntity.set(STATE, (Object)"S");
        }
        catch (Throwable e) {
            dataEntity.set(STATE, (Object)"F");
            FormOpener.showErrorMessage(this.getView(), e);
        }
        SaveServiceHelper.update((DynamicObject)dataEntity);
    }

    private boolean hasPageModified(Object pkValue) {
        DynamicObject dbLink = BusinessDataServiceHelper.loadSingle((Object)pkValue, (String)ISC_CN_CONFIG);
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)ISC_CN_CONFIG);
        for (Map.Entry entry : entityType.getAllFields().entrySet()) {
            String field = (String)entry.getKey();
            Object modelValue = this.getModel().getValue(field);
            Object dbValue = dbLink.get(field);
            if (field.equals("modifytime") || field.equals(NAME) || field.equals("license_info") || "license_sn".equals(field) || this.isPwdField(field) && this.isEmpty((String)modelValue, (String)dbValue) || modelValue == null || modelValue.equals(dbValue)) continue;
            return true;
        }
        return false;
    }

    private boolean isEmpty(String modelValue, String dbValue) {
        return ConnectionConfig.isEmptyPassword((String)modelValue) && ConnectionConfig.isEmptyPassword((String)dbValue);
    }

    private boolean isPwdField(String field) {
        return field.equals("newpwd") || field.equals(SECRET_NEW);
    }

    public void confirmCallBack(MessageBoxClosedEvent evt) {
        super.confirmCallBack(evt);
        if (evt.getResult() != MessageBoxResult.Yes) {
            return;
        }
        String callback = evt.getCallBackId();
        if ("disable_cn_config".equals(callback)) {
            Object id = this.getModel().getValue(ID);
            DynamicObject cn_config = BusinessDataServiceHelper.loadSingle((Object)id, (String)ISC_CN_CONFIG);
            ExecutionData.execute((DynamicObject)cn_config, (String)DISABLE);
            if (this.getView().getFormShowParameter() != null && OperationStatus.VIEW.equals((Object)this.getView().getFormShowParameter().getStatus())) {
                this.getView().updateView();
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u7981\u7528\u6210\u529f\u3002", (String)"ExternalCnConfigFormPlugin_13", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
            } else {
                this.getView().showMessage(ResManager.loadKDString((String)"\u8fde\u63a5\u914d\u7f6e\u5df2\u7981\u7528\uff0c\u8bf7\u518d\u6b21\u5c1d\u8bd5\u4fdd\u5b58\u3002", (String)"ExternalCnConfigFormPlugin_14", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
            }
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        if (!this.isEnabled()) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"test_connection"});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isEnabled() {
        long cnId = D.l((Object)this.getView().getModel().getValue(ID));
        if (cnId != 0L) {
            Connection cn = TX.getConnection((String)"ISCB", (boolean)true, (String[])new String[0]);
            try {
                String sql = "SELECT fenable FROM t_isc_cn_config WHERE FID = ?";
                DataRow dataRow = DbUtil.executeRow((Connection)cn, (String)sql, Collections.singletonList(cnId), Collections.singletonList(-5));
                boolean bl = D.x((Object)dataRow.get((Object)"fenable"));
                return bl;
            }
            finally {
                DbUtil.close((Connection)cn);
            }
        }
        return true;
    }

    public void beforeClosed(BeforeClosedEvent e) {
        e.setCheckDataChange(false);
        super.beforeClosed(e);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String prop = e.getProperty().getName();
        if (SERVER_PORT.equals(prop)) {
            Object newValue = e.getChangeSet()[0].getNewValue();
            int port = D.i((Object)newValue);
            if (port == 443) {
                this.getModel().setValue(HTTP_PROTOCOL, (Object)"https");
            } else if (port == 80) {
                this.getModel().setValue(HTTP_PROTOCOL, (Object)"http");
            }
        } else if (HTTP_PROTOCOL.equals(prop) && "http".equals(this.getModel().getValue(HTTP_PROTOCOL))) {
            this.getView().showMessage(ResManager.loadKDString((String)"http\u662f\u4e0d\u5b89\u5168\u534f\u8bae\uff0c\u4f7f\u7528\u8be5\u534f\u8bae\u5728\u7f51\u7edc\u4e0a\u4f20\u8f93\u6570\u636e\u65f6\u53ef\u80fd\u53d1\u751f\u4fe1\u606f\u6cc4\u9732\uff0c\u8bf7\u614e\u91cd\u8bc4\u4f30\u76f8\u5173\u98ce\u9669\u3002", (String)"ExternalCnConfigFormPlugin_15", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
        }
    }

    public void beforeBindData(EventObject e) {
        this.setModelValue();
    }

    private void setModelValue() {
        IDataModel model;
        boolean enable;
        String appid;
        IFormView parentView = this.getView().getParentView();
        if (parentView != null && "iscb".equals(appid = D.s((Object)parentView.getFormShowParameter().getAppId())) && !(enable = D.x((Object)(model = this.getView().getModel()).getValue(ENABLE)))) {
            long id = D.l((Object)model.getValue(ID));
            DynamicObject link = BusinessDataServiceHelper.loadSingle((Object)id, (String)"isc_database_link", (String)"name,server_ip");
            this.getModel().setValue(NAME, (Object)link.getString(NAME));
            this.getModel().setValue(SERVER_IP, (Object)link.getString(SERVER_IP));
        }
    }
}

