/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.formplugin.ext;

import java.sql.Connection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.TextEdit;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.isc.iscb.formplugin.util.FormOpener;
import kd.isc.iscb.formplugin.util.InitBindDataUtil;
import kd.isc.iscb.platform.core.connector.ConnectionFactory;
import kd.isc.iscb.platform.core.connector.DatabaseType;
import kd.isc.iscb.platform.core.connector.ExtensibleConnectionFactory;
import kd.isc.iscb.platform.core.dc.mq.MessageQueueServerFactory;
import kd.isc.iscb.platform.core.ext.InterfaceCenterUtil;
import kd.isc.iscb.platform.core.factory.FactoryManager;
import kd.isc.iscb.util.db.DbUtil;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.except.IscBizException;
import kd.isc.iscb.util.misc.ReflectionUtil;
import kd.isc.iscb.util.misc.StringUtil;

public class ExternalConnectionTypeFormPlugin
extends AbstractFormPlugin {
    private static final String SCRIPT_EXTENSION = "script_extension";
    private static final String CONFIG_FORM = "config_form";
    private static final String FACTORY_CLASS = "factory_class";
    private static final String GET_REFRESH_SCRIPT = "get_refresh_script";
    private static final String REFRESH_SCRIPT_TAG = "refresh_script_tag";
    private static final String REFRESH_SCRIPT = "refresh_script";
    private static final String GET_TEST_SCRIPT = "get_test_script";
    private static final String TEST_SCRIPT_TAG = "test_script_tag";
    private static final String TEST_SCRIPT = "test_script";
    private static final String GET_LOGIN_SCRIPT = "get_login_script";
    private static final String ISC_SCRIPT_EDITOR = "isc_script_editor";
    private static final String LOGIN_SCRIPT_TAG = "login_script_tag";
    private static final String LOGIN_SCRIPT = "login_script";
    private static final String FIELD = "field";
    private static final String SCRIPT = "script";
    private static final String REMARK = "remark";
    private static final String REFRESH_SCRIPT_EDITOR = "refresh_script_editor";
    private static final String TEST_SCRIPT_EDITOR = "test_script_editor";
    private static final String LOGIN_SCRIPT_EDITOR = "login_script_editor";
    private static final String REFRESH_ENV = "refresh_env";
    private static final String ISCB_CONNECTION_TABLE = "t_iscb_connection_type";

    public void initialize() {
        super.initialize();
        if ("admin".equals(System.getProperty("interface_center.user.type"))) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"bar_modify", "bar_save"});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"bar_modify", "bar_save"});
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{REFRESH_ENV});
        this.addClickListeners(new String[]{LOGIN_SCRIPT_EDITOR, TEST_SCRIPT_EDITOR, REFRESH_SCRIPT_EDITOR});
    }

    public void click(EventObject evt) {
        super.click(evt);
        Object src = evt.getSource();
        if (src instanceof TextEdit) {
            TextEdit edit = (TextEdit)src;
            HashMap<String, Object> params = new HashMap<String, Object>();
            String key = edit.getKey();
            if (LOGIN_SCRIPT_EDITOR.equals(key)) {
                params.put(REMARK, this.getModel().getValue(LOGIN_SCRIPT));
                params.put(SCRIPT, this.getModel().getValue(LOGIN_SCRIPT_TAG));
                params.put(FIELD, LOGIN_SCRIPT);
                FormOpener.showForm(this, ISC_SCRIPT_EDITOR, ResManager.loadKDString((String)"\u767b\u5f55\u811a\u672c\u7f16\u8f91", (String)"ExternalConnectionTypeFormPlugin_0", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), params, GET_LOGIN_SCRIPT);
            } else if (TEST_SCRIPT_EDITOR.equals(key)) {
                params.put(REMARK, this.getModel().getValue(TEST_SCRIPT));
                params.put(SCRIPT, this.getModel().getValue(TEST_SCRIPT_TAG));
                params.put(FIELD, TEST_SCRIPT);
                FormOpener.showForm(this, ISC_SCRIPT_EDITOR, ResManager.loadKDString((String)"\u6d4b\u8bd5\u811a\u672c\u7f16\u8f91", (String)"ExternalConnectionTypeFormPlugin_1", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), params, GET_TEST_SCRIPT);
            } else if (REFRESH_SCRIPT_EDITOR.equals(key)) {
                params.put(REMARK, this.getModel().getValue(REFRESH_SCRIPT));
                params.put(SCRIPT, this.getModel().getValue(REFRESH_SCRIPT_TAG));
                params.put(FIELD, REFRESH_SCRIPT);
                FormOpener.showForm(this, ISC_SCRIPT_EDITOR, ResManager.loadKDString((String)"\u4f1a\u8bdd\u5237\u65b0\u811a\u672c\u7f16\u8f91", (String)"ExternalConnectionTypeFormPlugin_2", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), params, GET_REFRESH_SCRIPT);
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate source = (AbstractOperate)args.getSource();
        String operateKey = source.getOperateKey();
        if ("save".equals(operateKey)) {
            this.executeSave(args, operateKey);
        } else if ("modify".equals(operateKey)) {
            this.checkEnable(args, operateKey);
        }
    }

    private void executeSave(BeforeDoOperationEventArgs args, String operateKey) {
        String viewNumber;
        this.checkEnable(args, operateKey);
        String factoryClass = D.s((Object)this.getModel().getValue(FACTORY_CLASS));
        if (!this.checkConnectorFactoryClassValid(factoryClass)) {
            args.setCancel(true);
            return;
        }
        String id = D.s((Object)this.getView().getModel().getValue("id"));
        if (InterfaceCenterUtil.checkDuplicateNumber((String)ISCB_CONNECTION_TABLE, (String)id, (String)(viewNumber = D.s((Object)this.getModel().getValue("number"))))) {
            args.setCancel(true);
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u4fdd\u5b58%s,\u7f16\u7801\u5728\u3010\u96c6\u6210\u7ba1\u7406\u3011->\u3010\u8fde\u63a5\u7ba1\u7406\u3011->\u3010\u8fde\u63a5\u7c7b\u578b\u3011\u4e2d\u5df2\u5b58\u5728\u3002", (String)"ExternalConnectionTypeFormPlugin_21", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), viewNumber));
            return;
        }
        long index = D.l((Object)this.getModel().getValue("index"));
        if (InterfaceCenterUtil.checkDuplicateIndex((String)ISCB_CONNECTION_TABLE, (String)id, (long)index)) {
            args.setCancel(true);
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u4fdd\u5b58%1$s,\u987a\u5e8f\u53f7(%2$s)\u5728\u3010\u96c6\u6210\u7ba1\u7406\u3011->\u3010\u8fde\u63a5\u7ba1\u7406\u3011->\u3010\u8fde\u63a5\u7c7b\u578b\u3011\u4e2d\u5df2\u5b58\u5728\u3002", (String)"ExternalConnectionTypeFormPlugin_22", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), viewNumber, index));
            return;
        }
        if (!this.checkExitConfigForm()) {
            args.setCancel(true);
            return;
        }
        if (this.checkScript()) {
            args.setCancel(true);
            return;
        }
        this.checkExtensionScript(args);
        this.getModel().setValue("index", (Object)index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkExitConfigForm() {
        String config_form = D.s((Object)this.getModel().getValue(CONFIG_FORM));
        if (null == config_form) {
            throw new IscBizException(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u914d\u7f6e\u8868\u5355.", (String)"ExternalConnectionTypeFormPlugin_7", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
        }
        Connection cn = TX.getConnection((String)"sys.meta", (boolean)true, (String[])new String[0]);
        try {
            String sql = "SELECT top 1 fid FROM t_meta_formdesign WHERE fnumber = ? and FPARENTID = (select top 1 fid from t_meta_formdesign where FNUMBER = 'isc_cn_config')";
            List metas = DbUtil.executeList((Connection)cn, (String)sql, Collections.singletonList(config_form), Collections.singletonList(12));
            if (metas.size() < 1) {
                this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u7b2c\u4e09\u65b9\u63a5\u53e3\uff1a\u4e0d\u5b58\u5728\u6807\u8bc6\u4e3a%s\u7684\u8fde\u63a5\u914d\u7f6e\u3002", (String)"ExternalConnectionTypeFormPlugin_23", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), config_form));
                boolean bl = false;
                return bl;
            }
        }
        finally {
            DbUtil.close((Connection)cn);
        }
        return true;
    }

    private void checkExtensionScript(BeforeDoOperationEventArgs args) {
        String scriptExtension;
        String configForm;
        String factoryClass;
        IFormView view = this.getView();
        String number = D.s((Object)this.getModel().getValue("number"));
        FactoryManager.Item item = new FactoryManager.Item(number, factoryClass = D.s((Object)this.getModel().getValue(FACTORY_CLASS)), configForm = D.s((Object)this.getModel().getValue(CONFIG_FORM)), scriptExtension = D.s((Object)this.getModel().getValue(SCRIPT_EXTENSION)));
        Object factory = item.getFactory();
        if (factory instanceof Exception) {
            view.showTipNotification(String.format(ResManager.loadKDString((String)"\u7c7b\u578b\u4e3a\uff1a%1$s\u7684\u8fde\u63a5\u7c7b\u578b\u4fdd\u5b58\u5931\u8d25\uff0c\u539f\u56e0\uff1a%2$s", (String)"ExternalConnectionTypeFormPlugin_24", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), number, D.s((Object)factory)));
            args.setCancel(true);
        }
    }

    private boolean checkScript() {
        try {
            Class clazz = ReflectionUtil.getClass((String)D.s((Object)this.getModel().getValue(FACTORY_CLASS)));
            if (ExtensibleConnectionFactory.class.isAssignableFrom(clazz)) {
                StringBuilder msg = new StringBuilder();
                if (StringUtil.isEmpty((String)D.s((Object)this.getModel().getValue(TEST_SCRIPT_TAG)))) {
                    if (msg.length() > 0) {
                        msg.append(", ");
                    }
                    msg.append(ResManager.loadKDString((String)"\u670d\u52a1\u5668\u72b6\u6001\u6d4b\u8bd5\u811a\u672c\u4e3a\u7a7a", (String)"ExternalConnectionTypeFormPlugin_12", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
                }
                if (msg.length() > 0) {
                    msg.append('\u3002');
                    this.getView().showMessage(msg.toString());
                }
            }
        }
        catch (Exception e) {
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u6839\u636e\u8fde\u63a5\u5668\u5de5\u5382\u7c7b\u8def\u5f84\u672a\u627e\u5230\u8be5\u7c7b\uff0c\u9519\u8bef\u4fe1\u606f\uff1a%s", (String)"ExternalConnectionTypeFormPlugin_25", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), e.getMessage()));
            return true;
        }
        return false;
    }

    private void checkEnable(BeforeDoOperationEventArgs args, String operateKey) {
        if (D.l((Object)this.getModel().getValue("enable")) == 1L) {
            this.getView().showConfirm("save".equals(operateKey) ? ResManager.loadKDString((String)"\u8fde\u63a5\u7c7b\u578b\u7981\u7528\u540e\u624d\u80fd\u4fdd\u5b58\uff0c\u662f\u5426\u7981\u7528\uff1f", (String)"ExternalConnectionTypeFormPlugin_14", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u8fde\u63a5\u7c7b\u578b\u7981\u7528\u540e\u624d\u80fd\u4fee\u6539\uff0c\u662f\u5426\u7981\u7528\uff1f", (String)"ExternalConnectionTypeFormPlugin_15", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, new ConfirmCallBackListener("disable", (IFormPlugin)this));
            args.setCancel(true);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        if (args.getOperationResult() == null || !args.getOperationResult().isSuccess()) {
            return;
        }
        if (REFRESH_ENV.equals(operateKey)) {
            DatabaseType.resetEnvironment();
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5237\u65b0\u73af\u5883\u6210\u529f\u3002", (String)"ExternalConnectionTypeFormPlugin_16", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
        } else if ("save".equals(operateKey) || "modify".equals(operateKey)) {
            this.getView().setStatus(OperationStatus.EDIT);
        } else if ("enable".equals(operateKey)) {
            DatabaseType.resetEnvironment();
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        String actionId = e.getActionId();
        Map params = (Map)e.getReturnData();
        if (params == null || params.isEmpty()) {
            return;
        }
        if (GET_LOGIN_SCRIPT.equals(actionId)) {
            this.getModel().setValue(LOGIN_SCRIPT, params.get(REMARK));
            this.getModel().setValue(LOGIN_SCRIPT_TAG, params.get(SCRIPT));
            this.getModel().setValue(LOGIN_SCRIPT_EDITOR, params.get(REMARK));
        } else if (GET_TEST_SCRIPT.equals(actionId)) {
            this.getModel().setValue(TEST_SCRIPT, params.get(REMARK));
            this.getModel().setValue(TEST_SCRIPT_TAG, params.get(SCRIPT));
            this.getModel().setValue(TEST_SCRIPT_EDITOR, params.get(REMARK));
        } else if (GET_REFRESH_SCRIPT.equals(actionId)) {
            this.getModel().setValue(REFRESH_SCRIPT, params.get(REMARK));
            this.getModel().setValue(REFRESH_SCRIPT_TAG, params.get(SCRIPT));
            this.getModel().setValue(REFRESH_SCRIPT_EDITOR, params.get(REMARK));
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String form;
        String name = e.getProperty().getName();
        if (FACTORY_CLASS.equals(name)) {
            this.checkConnectorFactoryClassValid(D.s((Object)e.getChangeSet()[0].getNewValue()));
        } else if (CONFIG_FORM.equals(name) && !"isc_cn_config".equals(InterfaceCenterUtil.getParentForm((String)(form = D.s((Object)this.getModel().getValue(CONFIG_FORM)))))) {
            this.getModel().setValue(CONFIG_FORM, (Object)"");
            this.getView().showMessage(ResManager.loadKDString((String)"\u914d\u7f6e\u8868\u5355\u9519\u8bef\uff0c\u53ea\u80fd\u4f7f\u7528\u7ee7\u627f\u4e86[isc_cn_config]\u6a21\u677f\u7684\u8868\u5355\u754c\u9762", (String)"ExternalConnectionTypeFormPlugin_17", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
        }
    }

    public void beforeBindData(EventObject e) {
        String appid;
        super.beforeBindData(e);
        this.getModel().setValue(LOGIN_SCRIPT_EDITOR, this.getModel().getValue(LOGIN_SCRIPT));
        this.getModel().setValue(TEST_SCRIPT_EDITOR, this.getModel().getValue(TEST_SCRIPT));
        this.getModel().setValue(REFRESH_SCRIPT_EDITOR, this.getModel().getValue(REFRESH_SCRIPT));
        this.getModel().setDataChanged(false);
        this.getModel().setValue(FACTORY_CLASS, (Object)"kd.isc.iscb.platform.core.connector.webapi.WebApiConnectionFactory");
        IFormView parentView = this.getView().getParentView();
        if (parentView != null && "iscb".equals(appid = D.s((Object)parentView.getFormShowParameter().getAppId()))) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"bar_modify"});
        }
    }

    public void afterBindData(EventObject e) {
        this.checkConnectorFactoryClassValid(D.s((Object)this.getModel().getValue(FACTORY_CLASS)));
    }

    private boolean checkConnectorFactoryClassValid(String className) {
        if (StringUtil.isEmpty((String)className)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{LOGIN_SCRIPT_EDITOR, TEST_SCRIPT_EDITOR, REFRESH_SCRIPT_EDITOR, SCRIPT_EXTENSION});
            return false;
        }
        try {
            String number;
            Class factoryClazz = ReflectionUtil.getClass((String)className);
            Class<ConnectionFactory> c1 = ConnectionFactory.class;
            Class<MessageQueueServerFactory> c2 = MessageQueueServerFactory.class;
            if (!c1.isAssignableFrom(factoryClazz) && !c2.isAssignableFrom(factoryClazz)) {
                String text = String.format(ResManager.loadKDString((String)"\u8fde\u63a5\u5668\u5de5\u5382\u7c7b\u5fc5\u987b\u5b9e\u73b0\u4e1a\u52a1\u7cfb\u7edf\u63a5\u53e3\uff08%1$s\uff09\u6216\u6d88\u606f\u670d\u52a1\u5668\u63a5\u53e3\uff08%2$s\uff09", (String)"ExternalConnectionTypeFormPlugin_26", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), c1.getName(), c2.getName());
                this.getView().showErrorNotification(text);
                return false;
            }
            if (c2.isAssignableFrom(factoryClazz) && this.existMqNumber(number = D.s((Object)this.getModel().getValue("number")))) {
                this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"%s: \u201c\u7f16\u7801\u201d\u5df2\u5b58\u5728\uff0c\u8bf7\u4fee\u6539\u3002", (String)"ExternalConnectionTypeFormPlugin_27", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), number));
                return false;
            }
            this.getView().setVisible(Boolean.valueOf(ExtensibleConnectionFactory.class.isAssignableFrom(factoryClazz)), new String[]{LOGIN_SCRIPT_EDITOR, TEST_SCRIPT_EDITOR, REFRESH_SCRIPT_EDITOR, SCRIPT_EXTENSION, LOGIN_SCRIPT, TEST_SCRIPT, REFRESH_SCRIPT, SCRIPT_EXTENSION});
        }
        catch (Exception e1) {
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u6839\u636e\u8fde\u63a5\u5668\u5de5\u5382\u7c7b\u8def\u5f84\u672a\u627e\u5230\u8be5\u7c7b\uff0c\u9519\u8bef\u4fe1\u606f\uff1a%s", (String)"ExternalConnectionTypeFormPlugin_25", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), e1.getMessage()));
            return false;
        }
        return true;
    }

    private boolean existMqNumber(String number) {
        for (ComboItem comboItem : InitBindDataUtil.getDefaultMq()) {
            if (!comboItem.getValue().equals(number)) continue;
            return true;
        }
        return false;
    }

    public void confirmCallBack(MessageBoxClosedEvent evt) {
        super.confirmCallBack(evt);
        if ("disable".equals(evt.getCallBackId()) && evt.getResult() == MessageBoxResult.Yes) {
            this.getView().invokeOperation("disable");
            this.getView().setStatus(OperationStatus.EDIT);
        }
    }
}

