/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.formplugin.ext;

import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.CodeEdit;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.AfterF7SelectEvent;
import kd.bos.form.field.events.AfterF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.mvc.bill.BillView;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.isc.iscb.formplugin.apic.AbstractApiFormPlugin;
import kd.isc.iscb.formplugin.sf.ServiceFlowFormPlugin;
import kd.isc.iscb.platform.core.apic.IscApicUtil;
import kd.isc.iscb.platform.core.apic.ScriptApiMeta;
import kd.isc.iscb.platform.core.connector.DatabaseType;
import kd.isc.iscb.platform.core.connector.apic.doc.external.CommonApiDocBuilder;
import kd.isc.iscb.platform.core.ext.InterfaceCenterUtil;
import kd.isc.iscb.platform.core.util.CommonUtil;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.misc.StringUtil;

public class ExternalScriptApiFormPlugin
extends AbstractApiFormPlugin
implements AfterF7SelectListener {
    private static final String NUMBER = "number";
    private static final String NAME = "name";
    private static final String GROUP = "group";
    private static final String DESCRIPTION = "description";
    private static final String SCRIPT = "script";
    private static final String EXPORT_BTN = "export_btn";
    private static final String INPUTS_EDIT = "inputs_edit";
    private static final String OUTPUTS_EDIT = "outputs_edit";
    private static final String SCRIPT_EDIT = "script_editor";
    private static final String AP = "advconbaritemap";
    private static final String AP1 = "advconbaritemap1";
    private static final String AP2 = "advconbaritemap2";
    private static final String AP4 = "advconbaritemap4";
    private static final String AP6 = "advconbaritemap6";
    private static final String AP7 = "advconbaritemap7";
    private static final String AP8 = "advconbaritemap8";
    private static final String AP9 = "advconbaritemap9";
    private static final String AP10 = "advconbaritemap10";
    private static final String INPUTS = "inputs";
    private static final String OUTPUTS = "outputs";
    private static final String RESOURCES = "resources";
    private static final String RECORD_LOG = "record_log";
    private static final String IN_DIGEST = "in_digest";
    private static final String OUT_DIGEST = "out_digest";
    private static final String BAR_MODIFY = "bar_modify";
    private static final String BAR_DISABLE = "bar_disable";
    private static final String DO_TEST = "do_test";
    private static String USER_TYPE = null;

    public void initialize() {
        super.initialize();
        USER_TYPE = System.getProperty("interface_center.user.type");
        if ("admin".equals(USER_TYPE)) {
            this.getView().setEnable(Boolean.TRUE, new String[]{NUMBER, NAME, GROUP, DESCRIPTION, SCRIPT, EXPORT_BTN});
            this.getView().setEnable(Boolean.TRUE, new String[]{INPUTS_EDIT, AP4, AP6, AP});
            this.getView().setEnable(Boolean.TRUE, new String[]{OUTPUTS_EDIT, AP7, AP8, AP1});
            this.getView().setEnable(Boolean.TRUE, new String[]{AP9, AP10, AP2});
            this.getView().setEnable(Boolean.TRUE, new String[]{SCRIPT_EDIT, INPUTS, OUTPUTS, RESOURCES});
            this.getView().setEnable(Boolean.TRUE, new String[]{RECORD_LOG, IN_DIGEST, OUT_DIGEST});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{BAR_MODIFY});
            this.getView().setEnable(Boolean.FALSE, new String[]{NUMBER, NAME, GROUP, DESCRIPTION, SCRIPT, EXPORT_BTN});
            this.getView().setEnable(Boolean.FALSE, new String[]{INPUTS_EDIT, AP4, AP6, AP});
            this.getView().setEnable(Boolean.FALSE, new String[]{OUTPUTS_EDIT, AP7, AP8, AP1});
            this.getView().setEnable(Boolean.FALSE, new String[]{AP9, AP10, AP2});
            this.getView().setEnable(Boolean.FALSE, new String[]{SCRIPT_EDIT, INPUTS, OUTPUTS, RESOURCES});
            this.getView().setEnable(Boolean.FALSE, new String[]{RECORD_LOG, IN_DIGEST, OUT_DIGEST});
        }
    }

    @Override
    public void registerListener(EventObject e) {
        BasedataEdit res_ref = (BasedataEdit)this.getControl("res_ref");
        IFormView view = this.getView();
        res_ref.addBeforeF7ViewDetailListener(evt -> {
            evt.setCancel(true);
            BillShowParameter param = new BillShowParameter();
            DynamicObject cn_config = BusinessDataServiceHelper.loadSingle((Object)evt.getPkId(), (String)"isc_cn_config", (String)"database_type");
            param.setFormId(DatabaseType.getForm((String)cn_config.getDynamicObject("database_type").getString(NUMBER)));
            param.setPkId(evt.getPkId());
            param.getOpenStyle().setShowType(ShowType.Modal);
            param.setStatus(OperationStatus.VIEW);
            view.showForm((FormShowParameter)param);
        });
        res_ref.addAfterF7SelectListener((AfterF7SelectListener)this);
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        if (!"admin".equals(USER_TYPE)) {
            return;
        }
        if (e.getSource() instanceof BillView) {
            BillView source = (BillView)e.getSource();
            BillShowParameter formShowParameter = (BillShowParameter)source.getFormShowParameter();
            BillOperationStatus billStatus = formShowParameter.getBillStatus();
            if (billStatus == BillOperationStatus.VIEW) {
                this.getView().setVisible(Boolean.TRUE, new String[]{BAR_MODIFY, BAR_DISABLE, DO_TEST});
            } else {
                this.getView().setVisible(Boolean.FALSE, new String[]{BAR_MODIFY, BAR_DISABLE, DO_TEST});
            }
        }
    }

    @Override
    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.initScript();
        long id = D.l((Object)this.getModel().getValue("id"));
        if (id == 0L) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"btn_show_history"});
        }
    }

    @Override
    public void afterDoOperation(AfterDoOperationEventArgs evt) {
        String operateKey;
        super.afterDoOperation(evt);
        if (this.isSuccess(evt) && "save".equals(operateKey = evt.getOperateKey())) {
            this.initScript();
        }
        this.afterDoOperationExt(evt);
    }

    private void initScript() {
        CodeEdit editor = (CodeEdit)this.getView().getControl(SCRIPT_EDIT);
        String script = (String)this.getModel().getValue("script_tag");
        editor.setText(script);
    }

    @Override
    public void confirmCallBack(MessageBoxClosedEvent evt) {
        super.confirmCallBack(evt);
        this.confirmCallBackExt(evt);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String prop = e.getProperty().getName();
        ChangeData[] changeSet = e.getChangeSet();
        if (changeSet.length == 1 && "res_ref".equals(prop)) {
            int rowIndex = changeSet[0].getRowIndex();
            DynamicObject rowEntity = this.getModel().getEntryRowEntity(RESOURCES, rowIndex);
            if (rowEntity.get("res_ref") != null && StringUtil.isEmpty((String)D.s((Object)rowEntity.get("res_alias")))) {
                rowEntity.set("res_alias", (Object)ServiceFlowFormPlugin.getRandVarName());
            }
            this.getView().updateView(RESOURCES);
        }
    }

    @Override
    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        super.beforeDoOperation(e);
        AbstractOperate operate = (AbstractOperate)e.getSource();
        String operateKey = operate.getOperateKey();
        if ("save".equals(operateKey)) {
            this.executeSave(e);
        }
    }

    private void executeSave(BeforeDoOperationEventArgs e) {
        DynamicObject tmp;
        String viewNumber = D.s((Object)this.getModel().getValue(NUMBER));
        String id = D.s((Object)this.getModel().getValue("id"));
        if (InterfaceCenterUtil.checkDuplicateNumber((String)"t_iscb_apic_script", (String)id, (String)viewNumber)) {
            e.setCancel(true);
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u4fdd\u5b58%s,\u7f16\u7801\u5728\u3010\u96c6\u6210\u7ba1\u7406\u3011->\u3010\u81ea\u5b9a\u4e49API\u3011\u4e2d\u5df2\u5b58\u5728\u3002", (String)"ExternalScriptApiFormPlugin_7", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), viewNumber));
            return;
        }
        DynamicObjectCollection resources = this.getModel().getEntryEntity(RESOURCES);
        for (int i = 0; i < resources.size(); ++i) {
            DynamicObject resource = (DynamicObject)resources.get(i);
            String res_alias = resource.getString("res_alias");
            if (!CommonUtil.isIllegalString((String)res_alias)) continue;
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u4f9d\u8d56\u8d44\u6e90\u5206\u5f55\u7b2c %1$s \u884c\u522b\u540d\u547d\u540d\u4e0d\u89c4\u8303\uff0c\u53ea\u5141\u8bb8\u4ee5\u5b57\u6bcd\u3001\u6570\u5b57\u6216\u4e0b\u5212\u7ebf\u4f5c\u4e3a\u5143\u7d20, \u4e0d\u5141\u8bb8\u4ee5\u6570\u5b57\u5f00\u5934\uff0c\u66f4\u4e0d\u5141\u8bb8\u4f7f\u7528\u5176\u4ed6\u7279\u6b8a\u5b57\u7b26'%2$s'", (String)"ExternalScriptApiFormPlugin_8", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), i + 1, res_alias));
            e.setCancel(true);
            return;
        }
        try {
            tmp = BusinessDataServiceHelper.newDynamicObject((String)"isc_apic_for_external_api");
            tmp.set(INPUTS, (Object)this.getModel().getEntryEntity(INPUTS));
            IscApicUtil.getInputSchema((DynamicObject)this.getModel().getDataEntity());
        }
        catch (Exception err) {
            this.getView().showMessage(String.format(ResManager.loadKDString((String)"\u8f93\u5165\u5206\u5f55\u6821\u9a8c\u9519\u8bef\uff1a%s", (String)"ExternalScriptApiFormPlugin_9", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), err.getMessage()));
            e.setCancel(true);
            return;
        }
        try {
            tmp = BusinessDataServiceHelper.newDynamicObject((String)"isc_apic_for_external_api");
            tmp.set(OUTPUTS, (Object)this.getModel().getEntryEntity(OUTPUTS));
            IscApicUtil.getOutputSchema((DynamicObject)this.getModel().getDataEntity());
        }
        catch (Exception err) {
            this.getView().showMessage(String.format(ResManager.loadKDString((String)"\u8f93\u51fa\u5206\u5f55\u6821\u9a8c\u9519\u8bef\uff1a%s", (String)"ExternalScriptApiFormPlugin_10", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), err.getMessage()));
            e.setCancel(true);
            return;
        }
        CodeEdit editor = (CodeEdit)this.getView().getControl(SCRIPT_EDIT);
        String script = editor.getText();
        if (script != null) {
            this.getModel().setValue("script_tag", (Object)script);
        }
    }

    @Override
    protected Map<String, Object> getTestInputParams(DynamicObject api) {
        ScriptApiMeta meta = ScriptApiMeta.get((long)D.l((Object)api.getPkValue()));
        return CommonApiDocBuilder.getInstance().parseParam(meta.getInputs());
    }

    @Override
    protected void generateXml(List<Object> successPkIds, IFormView view) {
        throw new UnsupportedOperationException(ResManager.loadKDString((String)"\u6682\u4e0d\u652f\u6301\u751f\u6210\u6587\u6863\u3002", (String)"ExternalScriptApiFormPlugin_6", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
    }

    @Override
    protected void generatePdf(List<Object> successPkIds, IFormView view) {
        throw new UnsupportedOperationException(ResManager.loadKDString((String)"\u6682\u4e0d\u652f\u6301\u751f\u6210\u6587\u6863\u3002", (String)"ExternalScriptApiFormPlugin_6", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
    }

    public void afterF7Select(AfterF7SelectEvent afterF7SelectEvent) {
    }
}

