/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.formplugin.guide;

import com.alibaba.fastjson.JSON;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.container.Wizard;
import kd.bos.form.control.ProgressBar;
import kd.bos.form.control.StepsOption;
import kd.bos.form.control.events.StepEvent;
import kd.bos.form.control.events.WizardStepsListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.isc.iscb.formplugin.guide.Const;
import kd.isc.iscb.formplugin.guide.WizardState;
import kd.isc.iscb.formplugin.guide.tasks.GuideTaskEnum;
import kd.isc.iscb.formplugin.guide.tasks.GuideUtil;
import kd.isc.iscb.formplugin.util.FormOpener;
import kd.isc.iscb.platform.core.api.webapi.WebRespBody;
import kd.isc.iscb.util.misc.StringUtil;

public class ConnTypeGuideFormPlugin
extends AbstractFormPlugin
implements WizardStepsListener,
Const {
    public void update(StepEvent e) {
        int index = e.getValue();
        IFormView view = this.getView();
        String task = GuideUtil.getCurrentGuideTasks(view).get(index);
        GuideTaskEnum guideTaskEnum = GuideTaskEnum.valueOf(task);
        guideTaskEnum.openMainPage(view, index);
        this.reSetTasksGuide();
        GuideUtil.refreshWizardByClick(view, WizardState.process);
        this.setProcessBar();
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        IFormView view = this.getView();
        this.initTaskGuide();
        Object apiModelString = this.getView().getFormShowParameter().getCustomParam("apiModelString");
        if (apiModelString == null) {
            this.initView();
            GuideTaskEnum isSelectTask = GuideTaskEnum.is_select_task;
            isSelectTask.beforeInGuideTask(view);
        } else {
            GuideUtil.putPageCache(this.getView(), "guide_tasks", JSON.toJSONString(Arrays.asList("is_create_login", "is_create_refresh", "is_create_link", "is_create_source", "complete")));
            GuideTaskEnum nextGuideTask = GuideUtil.getCurrentTask(view);
            nextGuideTask.beforeInGuideTask(view);
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("apiModelString", apiModelString);
            params.put("guideTask", nextGuideTask.name());
            GuideUtil.showSubPage(view, "isc_script_to_contype", params);
            view.setVisible(Boolean.FALSE, new String[]{"convert", "next_step"});
            view.setVisible(Boolean.TRUE, new String[]{"save_obj", "test"});
        }
        this.reSetTasksGuide();
        GuideUtil.refreshWizardByClick(view, WizardState.process);
        this.setProcessBar();
    }

    private void initView() {
        GuideUtil.putPageCache(this.getView(), "guide_tasks", JSON.toJSONString(Arrays.asList("is_select_task", "is_create_login", "is_create_refresh", "is_create_link", "is_create_source", "complete")));
    }

    public void initTaskGuide() {
        IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        proxy.setFieldProperty("wizardap", "visualStyle", (Object)1);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        Wizard wizard = (Wizard)this.getControl("wizardap");
        wizard.addWizardStepsListener((WizardStepsListener)this);
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        IFormView view = this.getView();
        try {
            if ("next_step".equals(operateKey)) {
                this.doGuideOperate();
            } else if ("convert".equals(operateKey)) {
                boolean isSame = GuideUtil.getCurrentChildObj(view).getBoolean("is_refresh_same_login");
                GuideUtil.convert(view);
                view.setVisible(Boolean.FALSE, new String[]{"convert", "next_step"});
                view.setVisible(Boolean.TRUE, new String[]{"save_obj"});
                view.setVisible(Boolean.valueOf(!isSame), new String[]{"test"});
            } else if ("save_obj".equals(operateKey)) {
                GuideUtil.getCurrentTask(view).save(view);
            } else if ("test".equals(operateKey)) {
                this.testScript();
            }
        }
        catch (Throwable e) {
            FormOpener.showMessage(this, StringUtil.getCascadeMessage((Throwable)e), StringUtil.getCascadeMessage((Throwable)e));
        }
    }

    public void doGuideOperate() {
        IFormView view = this.getView();
        GuideTaskEnum guideTask = GuideUtil.getCurrentTask(view);
        guideTask.doAction(view);
        guideTask.afterDoAction(view);
        GuideTaskEnum nextGuideTask = GuideUtil.getCurrentTask(view);
        this.reSetTasksGuide();
        GuideUtil.refreshWizardByClick(view, WizardState.process);
        nextGuideTask.beforeInGuideTask(view);
        this.setProcessBar();
    }

    public void testScript() {
        IFormView view = this.getView();
        if (GuideUtil.getCurrentTask(view) == GuideTaskEnum.is_create_webapi) {
            if (GuideUtil.getCurrentChildObj(view).getLong("id") > 0L) {
                GuideUtil.getCurrentChildView(view).invokeOperation("test");
                view.sendFormAction(GuideUtil.getCurrentChildView(view));
            } else {
                view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u4fdd\u5b58\u540e\u518d\u6d4b\u8bd5\u3002", (String)"ConnTypeGuideFormPlugin_3", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), Integer.valueOf(5000));
            }
        } else {
            GuideUtil.getCurrentChildView(view).invokeOperation("test");
            DynamicObjectCollection web_resp_body = GuideUtil.getCurrentChildObj(view).getDynamicObjectCollection("web_resp_body");
            if (web_resp_body.size() > 0) {
                view.showSuccessNotification(ResManager.loadKDString((String)"\u811a\u672c\u8fd0\u884c\u6210\u529f\uff0c\u6d4b\u8bd5\u7ed3\u679c\u5df2\u683c\u5f0f\u5316\u5230\u54cd\u5e94\u4f53\u5206\u5f55\u3002", (String)"ConnTypeGuideFormPlugin_1", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), Integer.valueOf(5000));
            } else {
                view.showSuccessNotification(ResManager.loadKDString((String)"\u811a\u672c\u8fd0\u884c\u6210\u529f\uff0c\u6d4b\u8bd5\u7ed3\u679c\u8fd4\u56de\u7684\u6570\u636e\u975eMap\u5bf9\u8c61\u3002", (String)"ConnTypeGuideFormPlugin_2", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), Integer.valueOf(5000));
            }
            view.sendFormAction(GuideUtil.getCurrentChildView(view));
            WebRespBody webRespBody = new WebRespBody(web_resp_body);
            Map exampleParamMap = webRespBody.getExampleParamMap();
            GuideUtil.putPageCache(view, "webRespBodyStr", JSON.toJSONString((Object)exampleParamMap));
        }
    }

    public void setProcessBar() {
        this.getView().setVisible(Boolean.TRUE, new String[]{"progressbarap"});
        ProgressBar bar = (ProgressBar)this.getView().getControl("progressbarap");
        List<String> guideTasks = GuideUtil.getCurrentGuideTasks(this.getView());
        BigDecimal total = new BigDecimal(guideTasks.size());
        BigDecimal complete = new BigDecimal(GuideUtil.getCurrentIndex(this.getView()) + 1);
        int percent = (int)(complete.divide(total, 2, RoundingMode.HALF_DOWN).doubleValue() * 100.0);
        bar.setPercent(percent);
    }

    private void reSetTasksGuide() {
        List<String> tasks = GuideUtil.getCurrentGuideTasks(this.getView());
        ArrayList<StepsOption> stepsOptionList = new ArrayList<StepsOption>(tasks.size());
        int index = GuideUtil.getCurrentIndex(this.getView());
        for (int i = 0; i < tasks.size(); ++i) {
            StepsOption stepsOption = new StepsOption();
            LocaleString title = new LocaleString(GuideTaskEnum.guide_tasks.get(tasks.get(i)));
            stepsOption.setTitle(title);
            stepsOption.setDescription(title);
            if (i < index) {
                stepsOption.setStatus(WizardState.finish.name());
            } else if (i == index) {
                stepsOption.setStatus(WizardState.process.name());
            } else {
                stepsOption.setStatus(WizardState.wait.name());
            }
            stepsOptionList.add(stepsOption);
        }
        this.sendRequestToView(stepsOptionList);
    }

    private void sendRequestToView(List<StepsOption> stepsOptionList) {
        IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        proxy.invokeControlMethod("wizardap", "setWizardStepsOptions", new Object[]{stepsOptionList.stream().map(stepsOption -> {
            HashMap<String, Object> map = new HashMap<String, Object>(2);
            map.put("title", stepsOption.getTitle());
            if (stepsOption.getStatus() != null) {
                map.put("status", stepsOption.getStatus());
            }
            return map;
        }).collect(Collectors.toList())});
    }
}

