/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.formplugin.guide;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.FormShowParameter;
import kd.bos.form.container.Tab;
import kd.bos.form.control.CodeEdit;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.CellClickEvent;
import kd.bos.form.control.events.CellClickListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.isv.ISVService;
import kd.bos.service.operation.OperationServiceImpl;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.isc.iscb.formplugin.apic.webapi.ReqHandler;
import kd.isc.iscb.formplugin.apic.webapi.ReqHeadHandler;
import kd.isc.iscb.formplugin.apic.webapi.RespHandler;
import kd.isc.iscb.formplugin.apic.webapi.UrlParamHandler;
import kd.isc.iscb.formplugin.guide.Const;
import kd.isc.iscb.formplugin.guide.GuideClickFormPlugin;
import kd.isc.iscb.formplugin.guide.tasks.GuideTaskEnum;
import kd.isc.iscb.formplugin.util.FormOpener;
import kd.isc.iscb.platform.core.api.quick.HttpItem;
import kd.isc.iscb.platform.core.api.quick.UrlItem;
import kd.isc.iscb.platform.core.api.webapi.FormatType;
import kd.isc.iscb.platform.core.api.webapi.WebReqBody;
import kd.isc.iscb.platform.core.api.webapi.WebRespBody;
import kd.isc.iscb.platform.core.connector.ConnectorUtil;
import kd.isc.iscb.platform.core.connector.self.MicroServiceInvoker2;
import kd.isc.iscb.platform.core.util.CommonUtil;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.err.CommonError;
import kd.isc.iscb.util.except.IscBizException;
import kd.isc.iscb.util.misc.Json;
import kd.isc.iscb.util.misc.StringUtil;
import kd.isc.iscb.util.script.Script;

public class ConvertScriptFormPlugin
extends GuideClickFormPlugin
implements Const,
CellClickListener {
    private static final String formatStr = "var url = %s ;\nvar httpMethod = \"%s\";\nvar header = %s;\nvar data = %s;\nvar result = HttpAccess(url, httpMethod, %s, \"UTF-8\", null, header).result;\nif(result is Map){ \n  result.$refreshTime = %s ;\n}\nreturn result ;\n";
    private static final String formatJsonStr = "var url = %s ;\nvar httpMethod = \"%s\";\nvar header = %s;\nvar data = %s;\nvar result = String.ParseJson(HttpAccess(url, httpMethod, %s, \"UTF-8\", null, header).result);\nif(result is Map){ \n  result.$refreshTime = %s ;\n}\nreturn result ;\n";

    @Override
    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        if (!this.isFromCache()) {
            this.initData();
            this.bindResp();
        } else {
            this.selectHeaders();
        }
        this.getView().setEnable(Boolean.valueOf(!this.getModel().getDataEntity().getBoolean("is_refresh_same_login")), new String[]{"is_refresh_same_login"});
        this.getView().setVisible(Boolean.valueOf(!this.getModel().getDataEntity().getBoolean("is_refresh_same_login")), new String[]{"method", "http_protocal", "server_ip", "server_port", "url_path"});
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        EntryGrid urlPrams = (EntryGrid)this.getView().getControl("web_url_params");
        urlPrams.addCellClickListener((CellClickListener)this);
        EntryGrid reqHeader = (EntryGrid)this.getView().getControl("web_req_header");
        reqHeader.addCellClickListener((CellClickListener)this);
        EntryGrid reqBody = (EntryGrid)this.getView().getControl("web_req_body");
        reqBody.addCellClickListener((CellClickListener)this);
    }

    private void bindResp() {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Object respResult = customParams.get("webRespBodyStr");
        if (respResult != null) {
            DynamicObject obj = this.getModel().getDataEntity(true);
            obj.set("web_resp_body", (Object)RespHandler.initRespBody(D.s(respResult), obj));
            this.selectResp();
        } else {
            this.selectHeaders();
        }
    }

    private void selectHeaders() {
        Tab tabCtrl = (Tab)this.getView().getControl("tabap");
        tabCtrl.activeTab("headers");
        this.getPageCache().put("tabap", "true");
    }

    private void selectResp() {
        Tab tabCtrl = (Tab)this.getView().getControl("tabap");
        tabCtrl.activeTab("response");
        this.getPageCache().put("tabap", "true");
    }

    public void initData() {
        Object customParam;
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        if (formShowParameter.getCustomParam("conn_id") != null) {
            DynamicObject conn = BusinessDataServiceHelper.loadSingle((Object)formShowParameter.getCustomParam("conn_id"), (String)"isc_connection_type");
            this.getModel().setValue("conn", (Object)conn);
            this.getModel().setValue("number", conn.get("number"));
            this.getModel().setValue("name", conn.get("name"));
        }
        if ((customParam = formShowParameter.getCustomParam("guideTask")) == null) {
            String s = ResManager.loadKDString((String)"\u6b64\u5904\u4e0d\u5e94\u4e3a\u7a7a\u3002", (String)"ConvertScriptFormPlugin_5", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]);
            throw new IscBizException(s);
        }
        this.getModel().setValue("guide_task", customParam);
        this.buildApiModal(formShowParameter);
        this.getModel().setValue("is_refresh_same_login", formShowParameter.getCustomParam("is_refresh_same_login"));
    }

    public void buildApiModal(FormShowParameter formShowParameter) {
        Object operation_data = formShowParameter.getCustomParam("apiModelString");
        if (operation_data != null) {
            DynamicObject obj = this.getModel().getDataEntity(true);
            HttpItem httpItem = (HttpItem)JSON.parseObject((String)D.s((Object)operation_data), (TypeReference)new TypeReference<HttpItem>(){}, (Feature[])new Feature[]{Feature.OrderedField});
            UrlItem urlItem = httpItem.getUrlItem();
            obj.set("url_path", (Object)urlItem.getPath());
            obj.set("http_protocal", (Object)urlItem.getProtocol());
            obj.set("server_ip", (Object)urlItem.getIp());
            obj.set("server_port", (Object)urlItem.getPort());
            obj.set("method", (Object)httpItem.getHttpMethod());
            obj.set("web_url_params", (Object)UrlParamHandler.initParams(urlItem.getQueryParamMap(), obj));
            obj.set("web_req_header", (Object)ReqHeadHandler.initHeaders(httpItem.getHeaders(), obj));
            obj.set("web_req_body", ReqHandler.initReqBody(httpItem, obj));
            formShowParameter.setCustomParam("apiModelString", null);
            String script = this.getCodeEditScript(httpItem.getHttpMethod(), urlItem.getPort(), urlItem.getPath(), false, 900);
            CodeEdit codeEdit = (CodeEdit)this.getControl("login_codeedit");
            codeEdit.setText(script);
        }
    }

    private String buildQueryString() {
        StringBuilder queryStr = new StringBuilder();
        DynamicObjectCollection web_url_params = this.getModel().getDataEntity(true).getDynamicObjectCollection("web_url_params");
        for (DynamicObject web_url_param : web_url_params) {
            if (queryStr.length() > 0) {
                queryStr.append(" + '&'");
            }
            String key = this.encodeWhenNotContainPercent(web_url_param.getString("url_param_name"));
            queryStr.append(" + '").append(key).append("='");
            if (web_url_param.getBoolean("is_param_used_in_link")) {
                queryStr.append(" + ").append("this.u_").append(key);
                continue;
            }
            String url_param_value = web_url_param.getString("url_param_value");
            if (this.isFromSessionOrLink(url_param_value)) {
                queryStr.append(" + ").append(url_param_value);
                continue;
            }
            queryStr.append(" + '").append(this.encodeWhenNotContainPercent(url_param_value)).append('\'');
        }
        return queryStr.toString();
    }

    private boolean isFromSessionOrLink(String value) {
        return D.s((Object)value) != null && (value.startsWith("$session") || value.startsWith("this."));
    }

    private String encodeWhenNotContainPercent(String sourceStr) {
        if (sourceStr.contains("%")) {
            return sourceStr;
        }
        return this.encode(sourceStr);
    }

    private String encode(String value) {
        try {
            return URLEncoder.encode(value, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw CommonError.INVALID_CHARSET.create((Throwable)e, new String[]{"UTF-8"});
        }
    }

    private String getCodeEditScript(String method, int port, String url_path, boolean is_url_path_used, int refreshTime) {
        String urlString = this.getUrlString(port, url_path, is_url_path_used);
        String headerString = this.getHeaderString();
        String bodyString = this.getBodyString();
        String formatBodyString = this.getFormatBodyString(bodyString);
        return this.generateScript(urlString, method, headerString, bodyString, formatBodyString, "L(NOW) + " + refreshTime * 1000);
    }

    private String getFormatBodyString(String bodyString) {
        String contentType = this.getContentType();
        FormatType formatType = this.getFormatType(contentType);
        return formatType.genScript(bodyString);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        this.refreshScript();
    }

    public void refreshScript() {
        if (!this.getModel().getDataEntity(true).getBoolean("is_edit_in_script")) {
            this.refreshInvokeScript();
        }
        if (this.getModel().getDataEntity(true).getBoolean("is_refresh_same_login")) {
            CodeEdit codeEdit = (CodeEdit)this.getControl("login_codeedit");
            codeEdit.setText("Relogin();");
        }
    }

    private void refreshInvokeScript() {
        DynamicObject obj = this.getModel().getDataEntity(true);
        String script = this.getCodeEditScript(obj.getString("method"), obj.getInt("server_port"), obj.getString("url_path"), obj.getBoolean("is_url_used_in_link"), obj.getInt("refresh_seconds"));
        CodeEdit codeEdit = (CodeEdit)this.getControl("login_codeedit");
        codeEdit.setText(script);
    }

    private String buildBodyMapString(DynamicObjectCollection web_req_bodys) {
        StringBuilder ss = new StringBuilder();
        for (DynamicObject web_req_body : web_req_bodys) {
            Object paramValue;
            if (web_req_body.getLong("pid") > 0L) continue;
            if (ss.length() > 0) {
                ss.append(",\n");
            }
            String fieldName = web_req_body.getString("req_b_param_name");
            ss.append("    \"").append(fieldName).append('\"').append(':');
            if (web_req_body.getBoolean("is_body_used_in_link")) {
                ss.append(" this.b_").append(fieldName);
                continue;
            }
            if (this.isFromSessionOrLink(web_req_body.getString("req_b_param_example"))) {
                ss.append(' ').append(web_req_body.getString("req_b_param_example"));
                continue;
            }
            WebReqBody webReqBody = new WebReqBody(web_req_bodys);
            Map exampleParamMap = webReqBody.getExampleParamMap();
            if ("STRUCT".equals(web_req_body.getString("req_b_param_type"))) {
                paramValue = exampleParamMap.get(fieldName);
                ss.append(JSON.toJSONString(paramValue, (boolean)true));
                continue;
            }
            paramValue = web_req_body.getString("req_b_param_example");
            ss.append(JSON.toJSONString(paramValue, (boolean)true));
        }
        return "{\n" + ss + "\n}";
    }

    public String getHeaderString() {
        StringBuilder ss = new StringBuilder();
        DynamicObjectCollection web_req_headers = this.getModel().getDataEntity(true).getDynamicObjectCollection("web_req_header");
        for (DynamicObject web_req_header : web_req_headers) {
            if (ss.length() > 0) {
                ss.append(",\n");
            }
            String fieldName = web_req_header.getString("req_h_param_name");
            ss.append("    \"").append(fieldName).append('\"').append(':');
            if (web_req_header.getBoolean("is_head_used_in_link")) {
                ss.append(" this.h_").append(fieldName);
                continue;
            }
            String paramValue = web_req_header.getString("req_h_param_value");
            if (this.isFromSessionOrLink(paramValue)) {
                ss.append(paramValue);
                continue;
            }
            ss.append(JSON.toJSONString((Object)paramValue));
        }
        return "{\n" + ss + "\n}";
    }

    private String getUrlString(int port, String url_path, boolean is_url_path_used) {
        String url = "this.http_protocal + '://' + this.server_ip ";
        if (D.i((Object)port) > -1) {
            url = url + "+ ':' + this.server_port ";
        }
        url = is_url_path_used ? url + " + this.url_path " : url + " + '" + url_path + "' ";
        String queryString = this.buildQueryString();
        if (queryString.length() > 0) {
            url = url + " + '?' " + queryString;
        }
        return url;
    }

    public String getBodyString() {
        DynamicObjectCollection web_req_bodys = this.getModel().getDataEntity(true).getDynamicObjectCollection("web_req_body");
        return this.buildBodyMapString(web_req_bodys);
    }

    public FormatType getFormatType(String content_type) {
        FormatType formatType = StringUtil.isEmpty((String)content_type) ? FormatType.JSON : FormatType.getFormatTypeByContentType((String)content_type);
        return formatType;
    }

    public String getContentType() {
        DynamicObjectCollection web_req_headers = this.getModel().getDataEntity(true).getDynamicObjectCollection("web_req_header");
        String content_type = "";
        for (DynamicObject object : web_req_headers) {
            if (!"Content-Type".equalsIgnoreCase(object.getString("req_h_param_name"))) continue;
            content_type = object.getString("req_h_param_value");
        }
        return content_type;
    }

    private String generateScript(String url, String httpMethod, String headers, String data, String formatBodyString, String nextTime) {
        if (this.getModel().getDataEntity().getBoolean("need_format_result")) {
            return String.format(formatJsonStr, url, httpMethod, headers, data, formatBodyString, nextTime);
        }
        return String.format(formatStr, url, httpMethod, headers, data, formatBodyString, nextTime);
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        if ("gen_conn".equals(args.getOperateKey())) {
            this.saveConntype();
        } else if ("save_refresh".equals(args.getOperateKey())) {
            this.saveRefresh();
        } else if ("test".equals(args.getOperateKey())) {
            this.test();
        } else if ("gen_resp_model".equals(args.getOperateKey())) {
            FormOpener.showForm(this, "isc_data_content", ResManager.loadKDString((String)"\u5bfc\u5165\u54cd\u5e94\u6a21\u578b\uff08json\u683c\u5f0f\uff09", (String)"WebApiFormPlugin_13", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), new HashMap<String, Object>(), "gen_resp_model");
        }
    }

    public void test() {
        if (!this.getModel().getDataEntity().getBoolean("is_refresh_same_login")) {
            CodeEdit codeEdit = (CodeEdit)this.getControl("login_codeedit");
            Map<String, Object> context = this.buildContext();
            Object eval = Script.compile((String)codeEdit.getText()).eval(context);
            this.setRespData(Json.toString((Object)eval, (boolean)true));
            this.selectResp();
        } else {
            FormOpener.showMessage(this, ResManager.loadKDString((String)"\u5237\u65b0\u811a\u672c\u548c\u767b\u5f55\u811a\u672c\u76f8\u540c\u65f6\u53ea\u9700\u6d4b\u8bd5\u767b\u5f55\u811a\u672c", (String)"ConvertScriptFormPlugin_2", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), "");
        }
    }

    public void saveRefresh() {
        DynamicObject obj = this.getModel().getDataEntity(true);
        DynamicObject conn = BusinessDataServiceHelper.loadSingle((Object)obj.getDynamicObject("conn").getPkValue(), (String)"isc_connection_type");
        if (obj.getBoolean("is_refresh_same_login")) {
            conn.set("refresh_script_tag", (Object)"Relogin();");
            conn.set("refresh_script", (Object)ResManager.loadKDString((String)"\u5237\u65b0\u811a\u672c\u4e0e\u767b\u5f55\u811a\u672c\u76f8\u540c", (String)"ConvertScriptFormPlugin_3", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
        } else {
            CodeEdit codeEdit = (CodeEdit)this.getControl("login_codeedit");
            String text = codeEdit.getText();
            conn.set("refresh_script_tag", (Object)text);
            conn.set("refresh_script", (Object)ResManager.loadKDString((String)"\u5411\u5bfc\u751f\u6210", (String)"ConvertScriptFormPlugin_4", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
        }
        ConnectorUtil.save((DynamicObject)conn);
    }

    private void saveConntype() {
        DynamicObject obj = this.getModel().getDataEntity(true);
        if (obj.get("conn") == null) {
            DynamicObject conn = BusinessDataServiceHelper.newDynamicObject((String)"isc_connection_type");
            conn.set("creator", (Object)RequestContext.get().getCurrUserId());
            conn.set("createtime", (Object)new Timestamp(System.currentTimeMillis()));
            this.saveConn(conn);
            this.getModel().setValue("conn", (Object)conn);
        } else {
            DynamicObject conn = BusinessDataServiceHelper.loadSingle((Object)obj.getDynamicObject("conn").getPkValue(), (String)"isc_connection_type");
            this.saveConn(conn);
        }
    }

    private void saveConn(DynamicObject conn) {
        DynamicObject obj = this.getModel().getDataEntity(true);
        conn.set("number", obj.get("number"));
        conn.set("name", obj.get("name"));
        conn.set("isv", (Object)ISVService.getISVInfo().getName());
        conn.set("iscustom", (Object)Boolean.TRUE);
        conn.set("enable", (Object)"1");
        conn.set("preset", (Object)Boolean.FALSE);
        conn.set("protect_level", (Object)"DEFAULT");
        conn.set("domain", (Object)"F");
        conn.set("permit", (Object)",INSERT,UPDATE,DELETE,");
        conn.set("config_form", (Object)"isc_database_link_common");
        conn.set("factory_class", (Object)"kd.isc.iscb.platform.core.connector.webapi.WebApiConnectionFactory");
        CodeEdit codeEdit = (CodeEdit)this.getControl("login_codeedit");
        String text = codeEdit.getText();
        conn.set("login_script_tag", (Object)text);
        conn.set("login_script", (Object)ResManager.loadKDString((String)"\u5411\u5bfc\u751f\u6210", (String)"ConvertScriptFormPlugin_4", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
        if (obj.getBoolean("is_refresh_same_login")) {
            conn.set("refresh_script_tag", (Object)"Relogin();");
            conn.set("refresh_script", (Object)ResManager.loadKDString((String)"\u5237\u65b0\u811a\u672c\u4e0e\u767b\u5f55\u811a\u672c\u76f8\u540c", (String)"ConvertScriptFormPlugin_3", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
        }
        conn.set("test_script", (Object)ResManager.loadKDString((String)"\u5411\u5bfc\u751f\u6210\u7684\u8fde\u63a5\u7c7b\u578b\u4e0d\u63d0\u4f9b\u6d4b\u8bd5\u811a\u672c\uff0c\u6c38\u8fdc\u8fd4\u56detrue\u3002\u5982\u6709\u9700\u8981\uff0c\u8bf7\u624b\u52a8\u4fee\u6539\u3002", (String)"ConvertScriptFormPlugin_6", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
        conn.set("test_script_tag", (Object)"return true;");
        DynamicObjectCollection collection = conn.getDynamicObjectCollection("entryentity");
        collection.clear();
        DynamicObject ipObj = collection.addNew();
        ipObj.set("params_number", (Object)"server_ip");
        ipObj.set("params_name", (Object)ResManager.loadKDString((String)"\u670d\u52a1\u5668IP\u6216\u57df\u540d", (String)"ConnectionTypeFormPlugin_22", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
        String ip = obj.getString("server_ip");
        if (StringUtil.isEmpty((String)ip)) {
            throw new IscBizException(ResManager.loadKDString((String)"\u4fdd\u5b58 \u8bf7\u586b\u5199 \u201c\u670d\u52a1\u5668IP\u6216\u57df\u540d\u201c", (String)"ConnectionTypeFormPlugin_26", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
        }
        ipObj.set("default_value", (Object)ip);
        ipObj.set("params_type", (Object)"string");
        ipObj.set("params_preset", (Object)Boolean.TRUE);
        ipObj.set("isrequired", (Object)Boolean.TRUE);
        DynamicObject httpObj = collection.addNew();
        httpObj.set("params_number", (Object)"http_protocal");
        httpObj.set("params_name", (Object)ResManager.loadKDString((String)"HTTP\u534f\u8bae", (String)"ConnectionTypeFormPlugin_24", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
        String http_protocal = obj.getString("http_protocal");
        if (StringUtil.isEmpty((String)http_protocal)) {
            throw new IscBizException(ResManager.loadKDString((String)"\u4fdd\u5b58 \u8bf7\u586b\u5199 \u201cHTTP\u534f\u8bae\u201d", (String)"ConnectionTypeFormPlugin_25", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
        }
        httpObj.set("default_value", (Object)http_protocal);
        httpObj.set("params_type", (Object)"string");
        httpObj.set("params_preset", (Object)Boolean.TRUE);
        httpObj.set("isrequired", (Object)Boolean.TRUE);
        int server_port = obj.getInt("server_port");
        if (server_port <= -1) {
            server_port = "HTTPS".equalsIgnoreCase(http_protocal) ? 443 : 80;
        }
        DynamicObject portObj = collection.addNew();
        portObj.set("params_number", (Object)"server_port");
        portObj.set("params_name", (Object)ResManager.loadKDString((String)"\u7aef\u53e3", (String)"ConnectionTypeFormPlugin_23", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
        portObj.set("default_value", (Object)server_port);
        portObj.set("params_type", (Object)"long");
        portObj.set("params_preset", (Object)Boolean.TRUE);
        portObj.set("isrequired", (Object)Boolean.TRUE);
        List<Map<String, Object>> keys = ConvertScriptFormPlugin.getAllKeys(obj, false);
        for (Map<String, Object> key : keys) {
            DynamicObject obje = collection.addNew();
            obje.set("params_number", key.get("params_number"));
            obje.set("params_name", key.get("params_name"));
            obje.set("params_type", key.get("params_type"));
            obje.set("isrequired", key.get("isrequired"));
            obje.set("default_value", key.get("default_value"));
            obje.set("desc", key.get("desc"));
        }
        OperationServiceImpl operationService = new OperationServiceImpl();
        OperationResult result = operationService.localInvokeOperation("save", new DynamicObject[]{conn}, OperateOption.create());
        CommonUtil.check((OperationResult)result);
    }

    private Map<String, Object> buildContext() {
        HashMap<String, Object> this_map = new HashMap<String, Object>();
        DynamicObject obj = this.getModel().getDataEntity(true);
        this_map.put("server_ip", obj.get("server_ip"));
        this_map.put("server_port", obj.get("server_port"));
        this_map.put("http_protocal", obj.get("http_protocal"));
        if (GuideTaskEnum.is_create_login.name().equals(this.getModel().getDataEntity().getString("guide_task"))) {
            List<Map<String, Object>> allKeys = ConvertScriptFormPlugin.getAllKeys(obj, true);
            for (Map<String, Object> key : allKeys) {
                this_map.put(D.s((Object)key.get("params_number")), key.get("default_value"));
            }
            HashMap<String, Object> context = new HashMap<String, Object>();
            context.put("this", this_map);
            context.put("invokeMicroService2", new MicroServiceInvoker2());
            return context;
        }
        DynamicObjectCollection web_resp_body = this.getModel().getDataEntity(true).getDynamicObjectCollection("web_resp_body");
        WebRespBody webRespBody = new WebRespBody(web_resp_body);
        Map exampleParamMap = webRespBody.getExampleParamMap();
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("$session", exampleParamMap);
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        if (customParams.get("conn_params_json_str") != null) {
            this_map.putAll((Map)Json.toObject((String)D.s(customParams.get("conn_params_json_str"))));
        }
        context.put("this", this_map);
        context.put("invokeMicroService2", new MicroServiceInvoker2());
        return context;
    }

    public static List<Map<String, Object>> getAllKeys(DynamicObject obj, boolean needDefault) {
        boolean is_head_used_value;
        String number;
        HashMap<String, Object> dparam;
        String url_param_name;
        DynamicObjectCollection web_url_params = obj.getDynamicObjectCollection("web_url_params");
        DynamicObjectCollection web_req_header = obj.getDynamicObjectCollection("web_req_header");
        DynamicObjectCollection web_req_body = obj.getDynamicObjectCollection("web_req_body");
        ArrayList<Map<String, Object>> keys = new ArrayList<Map<String, Object>>();
        if (obj.getBoolean("is_url_used_in_link")) {
            HashMap<String, String> dparam2 = new HashMap<String, String>();
            String number2 = "url_path";
            dparam2.put("params_number", number2);
            dparam2.put("params_name", number2);
            dparam2.put("default_value", obj.getString(number2));
            dparam2.put("params_type", "string");
            dparam2.put("desc", number2);
            keys.add(dparam2);
        }
        for (DynamicObject web_url_param : web_url_params) {
            boolean is_param_used_in_link = web_url_param.getBoolean("is_param_used_in_link");
            if (!is_param_used_in_link) continue;
            url_param_name = web_url_param.getString("url_param_name");
            dparam = new HashMap<String, Object>();
            number = "u_" + url_param_name;
            dparam.put("params_number", number);
            dparam.put("params_name", number);
            boolean is_param_used_value = web_url_param.getBoolean("is_param_used_value");
            if (needDefault) {
                dparam.put("default_value", web_url_param.get("url_param_value"));
            } else if (is_param_used_value) {
                dparam.put("default_value", web_url_param.get("url_param_value"));
            }
            if (web_url_param.getBoolean("is_param_used_pwd")) {
                dparam.put("params_type", "password");
            } else {
                dparam.put("params_type", "string");
            }
            dparam.put("desc", web_url_param.get("url_param_desc"));
            dparam.put("isrequired", web_url_param.get("is_param_need"));
            keys.add(dparam);
        }
        for (DynamicObject header : web_req_header) {
            boolean is_head_used_in_link = header.getBoolean("is_head_used_in_link");
            if (!is_head_used_in_link) continue;
            url_param_name = header.getString("req_h_param_name");
            dparam = new HashMap();
            number = "h_" + url_param_name;
            dparam.put("params_number", number);
            dparam.put("params_name", number);
            is_head_used_value = header.getBoolean("is_head_used_value");
            if (needDefault) {
                dparam.put("default_value", header.get("req_h_param_value"));
            } else if (is_head_used_value) {
                dparam.put("default_value", header.get("req_h_param_value"));
            }
            if (header.getBoolean("is_head_used_pwd")) {
                dparam.put("params_type", "password");
            } else {
                dparam.put("params_type", "string");
            }
            dparam.put("desc", header.get("req_h_param_desc"));
            dparam.put("isrequired", header.get("is_head_need"));
            keys.add(dparam);
        }
        for (DynamicObject body : web_req_body) {
            boolean is_body_used_in_link = body.getBoolean("is_body_used_in_link");
            if (!is_body_used_in_link) continue;
            String req_b_param_name = body.getString("req_b_param_name");
            dparam = new HashMap();
            number = "b_" + req_b_param_name;
            dparam.put("params_number", number);
            dparam.put("params_name", number);
            is_head_used_value = body.getBoolean("is_body_used_value");
            if (needDefault) {
                dparam.put("default_value", body.get("req_b_param_example"));
            } else if (is_head_used_value) {
                dparam.put("default_value", body.get("req_b_param_example"));
            }
            if (body.getBoolean("is_body_used_pwd")) {
                dparam.put("params_type", "password");
            } else {
                dparam.put("params_type", "string");
            }
            dparam.put("desc", body.get("req_b_param_desc"));
            dparam.put("isrequired", body.get("is_body_need"));
            keys.add(dparam);
        }
        return keys;
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        super.closedCallBack(evt);
        String action = evt.getActionId();
        if (action.equals("gen_resp_model")) {
            this.setRespBody(evt);
        } else if (action.equals("web_url_params")) {
            this.setCell(evt, "web_url_params", "url_param_value");
        } else if (action.equals("web_req_body")) {
            this.setCell(evt, "web_req_body", "req_b_param_example");
        } else if (action.equals("web_req_header")) {
            this.setCell(evt, "web_req_header", "req_h_param_value");
        }
        this.refreshScript();
    }

    private void setRespBody(ClosedCallBackEvent evt) {
        String respData = D.s((Object)evt.getReturnData());
        if (respData != null) {
            this.setRespData(respData);
        }
    }

    private void setRespData(String respData) {
        DynamicObject obj = this.getModel().getDataEntity(true);
        DynamicObjectCollection dynamicObjects = RespHandler.initRespBody(respData, obj);
        obj.set("web_resp_body", (Object)dynamicObjects);
        this.getView().updateView("web_resp_body");
    }

    public void cellClick(CellClickEvent evt) {
    }

    public void cellDoubleClick(CellClickEvent evt) {
        try {
            if (GuideTaskEnum.is_create_refresh.name().equals(this.getModel().getDataEntity().getString("guide_task"))) {
                String fieldKey = evt.getFieldKey();
                if ("url_param_value".equals(fieldKey)) {
                    this.selectParam(evt, "web_url_params", "is_param_used_in_link");
                } else if ("req_h_param_value".equals(fieldKey)) {
                    this.selectParam(evt, "web_req_header", "is_head_used_in_link");
                } else if ("req_b_param_example".equals(fieldKey)) {
                    this.selectParam(evt, "web_req_body", "is_body_used_in_link");
                }
            }
        }
        catch (Throwable e) {
            FormOpener.showMessage(this, StringUtil.getCascadeMessage((Throwable)e), StringUtil.getCascadeMessage((Throwable)e));
        }
    }

    private void selectParam(CellClickEvent cellClickEvent, String entryName, String used) {
        Map param = this.getView().getFormShowParameter().getCustomParams();
        int row = cellClickEvent.getRow();
        param.put("$row", row);
        FormOpener.showFloatForm(this, "isc_guide_conn_variables", ResManager.loadKDString((String)"\u9009\u62e9\u53d8\u91cf", (String)"WebApiFormPlugin_18", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), param, entryName);
    }

    private void setCell(ClosedCallBackEvent evt, String entryName, String varValue) {
        Object returnData = evt.getReturnData();
        if (returnData instanceof Map) {
            Map mapData = (Map)returnData;
            DynamicObject row = this.getModel().getEntryRowEntity(entryName, D.i(mapData.get("$row")));
            row.set(varValue, mapData.get("var_name"));
            this.getView().updateView(entryName);
        }
    }
}

