/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.formplugin.guide;

import java.sql.Timestamp;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicComplexProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicSimpleProperty;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.events.GetEntityTypeEventArgs;
import kd.bos.entity.property.BasedataProp;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.container.Container;
import kd.bos.form.control.Control;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.LoadCustomControlMetasArgs;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.field.FieldEdit;
import kd.bos.isv.ISVService;
import kd.bos.metadata.form.container.FlexPanelAp;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.isc.iscb.formplugin.dc.cntype.DynamicConfigForCnType;
import kd.isc.iscb.formplugin.guide.Const;
import kd.isc.iscb.formplugin.guide.DataLinkF7FormPlugin;
import kd.isc.iscb.platform.core.connector.ConnectorUtil;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.misc.Json;

public class DataBaseLinkGuideFormPlugin
extends DataLinkF7FormPlugin
implements Const {
    public static final String ISC_DATABASE_LINK = "isc_database_link";

    @Override
    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        Map params = this.getView().getFormShowParameter().getCustomParams();
        String conn_id = (String)params.get("conn_id");
        DynamicConfigForCnType config = new DynamicConfigForCnType(conn_id);
        DynamicObject conn = BusinessDataServiceHelper.loadSingle((Object)conn_id, (String)"isc_connection_type");
        this.getModel().setValue("conn", (Object)conn);
        long link_id = D.l(params.get("link_id"));
        if (link_id > 0L) {
            DynamicObject link = BusinessDataServiceHelper.loadSingle((Object)link_id, (String)ISC_DATABASE_LINK);
            this.getModel().setValue("link", (Object)link);
            this.getModel().setValue("number", (Object)link.getString("number"));
            this.getModel().setValue("name", (Object)link.getString("name"));
        }
        FlexPanelAp panelAP = config.getFlexPanelAP();
        List controlList = ((Container)panelAP.buildRuntimeControl()).getItems();
        Container myFldPanel = (Container)this.getView().getControl("params_pane");
        myFldPanel.getItems().addAll(controlList);
        this.getView().createControlIndex(myFldPanel.getItems());
        config.setDefaultFiledInfo(this.getView(), this.getModel());
        Map customParam = this.getView().getFormShowParameter().getCustomParams();
        String pageCaches = D.s(customParam.get("stringFromCache"));
        if (pageCaches != null) {
            Map map = (Map)Json.toObject((String)pageCaches);
            config.setDynamicFieldValues(this.getModel(), map);
        }
    }

    private void registerDynamicProps(MainEntityType newMainType) {
        Map params = this.getView().getFormShowParameter().getCustomParams();
        String conn_id = (String)params.get("conn_id");
        DynamicObject cnType = BusinessDataServiceHelper.loadSingle((Object)conn_id, (String)"isc_connection_type");
        DynamicObjectCollection collection = cnType.getDynamicObjectCollection("entryentity");
        DynamicConfigForCnType config = new DynamicConfigForCnType(collection);
        config.initFieldPropMap();
        for (DynamicObject object : collection) {
            DynamicProperty fieldProp = config.getFieldProp(D.s((Object)object.get("params_number")));
            if (fieldProp == null) continue;
            String params_type = D.s((Object)object.get("params_type"));
            if ("ref".equals(params_type)) {
                newMainType.registerComplexProperty((DynamicComplexProperty)((BasedataProp)fieldProp));
                DynamicProperty prop = config.getFieldProp(D.s((Object)object.get("params_number")) + "_id");
                newMainType.registerSimpleProperty((DynamicSimpleProperty)prop);
                continue;
            }
            newMainType.registerSimpleProperty((DynamicSimpleProperty)fieldProp);
        }
    }

    public void getEntityType(GetEntityTypeEventArgs e) {
        MainEntityType oldMainType = e.getOriginalEntityType();
        MainEntityType newMainType = null;
        try {
            newMainType = (MainEntityType)oldMainType.clone();
        }
        catch (CloneNotSupportedException exp) {
            throw new KDException((Throwable)exp, new ErrorCode("LoadCustomControlMetasSample", exp.getMessage()), new Object[0]);
        }
        this.registerDynamicProps(newMainType);
        e.setNewEntityType(newMainType);
    }

    public void loadCustomControlMetas(LoadCustomControlMetasArgs e) {
        super.loadCustomControlMetas(e);
        Map params = ((FormShowParameter)e.getSource()).getCustomParams();
        String conn_id = (String)params.get("conn_id");
        DynamicConfigForCnType config = new DynamicConfigForCnType(conn_id);
        FlexPanelAp panelAP = config.getFlexPanelAP();
        HashMap<String, String> mapHead = new HashMap<String, String>();
        mapHead.put("id", "params_pane");
        mapHead.put("items", (String)panelAP.createControl().get("items"));
        e.getItems().add(mapHead);
    }

    public void onGetControl(OnGetControlArgs e) {
        Map params;
        String conn_id;
        DynamicConfigForCnType config;
        FieldEdit fieldEdit;
        if (e.getKey().startsWith("config_") && (fieldEdit = (config = new DynamicConfigForCnType(conn_id = (String)(params = ((IFormView)e.getSource()).getFormShowParameter().getCustomParams()).get("conn_id"))).getFieldEditByKey(e.getKey())) != null) {
            fieldEdit.setView(this.getView());
            e.setControl((Control)fieldEdit);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        if ("save_link".equals(operateKey)) {
            this.saveDataLink();
        }
    }

    private void saveDataLink() {
        DynamicObject obj = this.getModel().getDataEntity(true);
        if (obj.get("link") == null) {
            DynamicObject link = BusinessDataServiceHelper.newDynamicObject((String)ISC_DATABASE_LINK);
            link.set("creator", (Object)RequestContext.get().getCurrUserId());
            link.set("createtime", (Object)new Timestamp(System.currentTimeMillis()));
            this.saveLink(link);
            this.getModel().setValue("link", (Object)link);
        } else {
            DynamicObject link = BusinessDataServiceHelper.loadSingle((Object)obj.getDynamicObject("link").getPkValue(), (String)ISC_DATABASE_LINK);
            this.saveLink(link);
        }
    }

    private void saveLink(DynamicObject link) {
        DynamicObject obj = this.getModel().getDataEntity();
        link.set("number", obj.get("number"));
        link.set("name", obj.get("name"));
        DynamicObject conn = obj.getDynamicObject("conn");
        link.set("database_type", conn.get("number"));
        link.set("dum_link", (Object)conn);
        link.set("enable", (Object)1);
        link.set("isv", (Object)ISVService.getISVInfo().getName());
        String http_protocal = obj.getString("http_protocal");
        link.set("http_protocal", (Object)http_protocal);
        link.set("server_ip", obj.get("server_ip"));
        int server_port = obj.getInt("server_port");
        if (server_port > -1) {
            link.set("server_port", (Object)server_port);
        } else if ("HTTPS".equalsIgnoreCase(http_protocal)) {
            link.set("server_port", (Object)443);
        } else {
            link.set("server_port", (Object)80);
        }
        Map params = this.getView().getFormShowParameter().getCustomParams();
        String conn_id = (String)params.get("conn_id");
        DynamicConfigForCnType config = new DynamicConfigForCnType(conn_id);
        Map<String, Object> map = config.collectConfigData(this.getModel());
        String json = Json.toString(map);
        link.set("attr_e1", (Object)json);
        link.set("attr5", (Object)"@#is_custom_page");
        link.set("current_account", (Object)RequestContext.get().getAccountId());
        ConnectorUtil.save((DynamicObject)link);
    }
}

