/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.formplugin.guide;

import java.sql.Timestamp;
import java.util.EventObject;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.isv.ISVService;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.isc.iscb.formplugin.guide.Const;
import kd.isc.iscb.formplugin.guide.GuideClickFormPlugin;
import kd.isc.iscb.platform.core.connector.ConnectorUtil;
import kd.isc.iscb.util.dt.D;

public class DataBaseSourceGuideFormPlugin
extends GuideClickFormPlugin
implements Const {
    @Override
    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        if (!this.isFromCache()) {
            long source_id;
            Map params = this.getView().getFormShowParameter().getCustomParams();
            long link_id = D.l(params.get("link_id"));
            if (link_id > 0L) {
                DynamicObject link = BusinessDataServiceHelper.loadSingle((Object)link_id, (String)"isc_database_link");
                this.getModel().setValue("link", (Object)link);
                this.getModel().setValue("number", (Object)link.getString("number"));
                this.getModel().setValue("name", (Object)link.getString("name"));
            }
            if ((source_id = D.l(params.get("source_id"))) > 0L) {
                DynamicObject source = BusinessDataServiceHelper.loadSingle((Object)source_id, (String)"isc_data_source");
                this.getModel().setValue("source", (Object)source);
                this.getModel().setValue("number", (Object)source.getString("number"));
                this.getModel().setValue("name", (Object)source.getString("name"));
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        if ("save_source".equals(operateKey)) {
            this.saveDataSource();
        }
    }

    private void saveDataSource() {
        DynamicObject obj = this.getModel().getDataEntity(true);
        if (obj.get("source") == null) {
            DynamicObject source = BusinessDataServiceHelper.newDynamicObject((String)"isc_data_source");
            source.set("creator", (Object)RequestContext.get().getCurrUserId());
            source.set("createtime", (Object)new Timestamp(System.currentTimeMillis()));
            this.saveSource(source);
            this.getModel().setValue("source", (Object)source);
        } else {
            DynamicObject source = BusinessDataServiceHelper.loadSingle((Object)obj.getDynamicObject("source").getPkValue(), (String)"isc_data_source");
            this.saveSource(source);
        }
    }

    private void saveSource(DynamicObject source) {
        DynamicObject obj = this.getModel().getDataEntity();
        source.set("number", obj.get("number"));
        source.set("name", obj.get("name"));
        source.set("dblink", (Object)obj.getDynamicObject("link"));
        source.set("isv", (Object)ISVService.getISVInfo().getName());
        source.set("connection_type", (Object)BusinessDataServiceHelper.loadSingle((Object)this.getView().getFormShowParameter().getCustomParam("conn_id"), (String)"isc_connection_type", (String)"number").getString("number"));
        source.set("enable", (Object)1);
        ConnectorUtil.save((DynamicObject)source);
    }
}

