/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.formplugin.guide.tasks;

import com.alibaba.fastjson.JSON;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.container.Wizard;
import kd.bos.form.control.CodeEdit;
import kd.isc.iscb.formplugin.guide.Const;
import kd.isc.iscb.formplugin.guide.WizardState;
import kd.isc.iscb.formplugin.guide.tasks.GuideTaskEnum;
import kd.isc.iscb.platform.core.api.quick.HttpItem;
import kd.isc.iscb.platform.core.api.webapi.Util;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.except.IscBizException;
import kd.isc.iscb.util.misc.StringUtil;

public class GuideUtil
implements Const {
    public static String getCurrentChildPageId(IFormView view) {
        return GuideUtil.getPageCache(view, "current_child_pageid");
    }

    public static IFormView getCurrentChildView(IFormView view) {
        String currentChildPageId = GuideUtil.getCurrentChildPageId(view);
        return view.getView(currentChildPageId);
    }

    public static DynamicObject getCurrentChildObj(IFormView view) {
        IFormView childView = GuideUtil.getCurrentChildView(view);
        return childView.getModel().getDataEntity(true);
    }

    public static List<String> getCurrentGuideTasks(IFormView view) {
        return (List)JSON.parse((String)GuideUtil.getPageCache(view, "guide_tasks"));
    }

    public static int getCurrentIndex(IFormView view) {
        return D.i((Object)GuideUtil.getPageCache(view, "current_index"));
    }

    public static GuideTaskEnum getCurrentTask(IFormView view) {
        List<String> tasks = GuideUtil.getCurrentGuideTasks(view);
        int currentIndex = GuideUtil.getCurrentIndex(view);
        return GuideTaskEnum.valueOf(tasks.get(currentIndex));
    }

    public static void showSubPage(IFormView view, String formId, Map<String, Object> params) {
        String pageId = GuideUtil.showViewInContainer(view, formId, params, "step_flex");
        GuideUtil.putPageCache(view, "current_child_pageid", pageId);
    }

    public static String showViewInContainer(IFormView view, String formId, Map<String, Object> params, String container) {
        FormShowParameter param = new FormShowParameter();
        param.setFormId(formId);
        param.setCustomParams(params);
        param.setParentPageId(view.getPageId());
        param.setStatus(OperationStatus.ADDNEW);
        param.getOpenStyle().setShowType(ShowType.InContainer);
        param.getOpenStyle().setTargetKey(container);
        view.showForm(param);
        return param.getPageId();
    }

    public static HttpItem getHttpItem(IFormView view) {
        HttpItem httpItem;
        IFormView childView = GuideUtil.getCurrentChildView(view);
        DynamicObject childObj = GuideUtil.getCurrentChildObj(view);
        CodeEdit srcCodeEditor = (CodeEdit)childView.getControl("src_code_editor");
        String srcCode = srcCodeEditor.getText();
        if (childObj.getBoolean("is_refresh_same_login") && StringUtil.isEmpty((String)srcCode)) {
            return null;
        }
        String srcCodeType = childObj.getString("src_code_type");
        if ("curl".equals(srcCodeType)) {
            httpItem = new HttpItem(srcCode);
        } else {
            if (StringUtil.isEmpty((String)srcCode)) {
                throw new IscBizException(ResManager.loadKDString((String)"\u4f20\u5165\u7684\u96c6\u6210\u4e91\u811a\u672c\u4e3a\u7a7a", (String)"ConvertCodeFormPlugin_6", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
            }
            httpItem = Util.generateHttpItemFromIscScript((String)srcCode);
        }
        return httpItem;
    }

    public static void refreshWizardByClick(IFormView view, WizardState state) {
        Wizard wizard = (Wizard)view.getControl("wizardap");
        HashMap<String, Object> currentStepMap = new HashMap<String, Object>();
        currentStepMap.put("currentStep", GuideUtil.getCurrentIndex(view));
        currentStepMap.put("currentStatus", state.name());
        wizard.setWizardCurrentStep(currentStepMap);
    }

    public static String getPageCache(IFormView view, String key) {
        return view.getPageCache().get(key);
    }

    public static void putPageCache(IFormView view, String key, String value) {
        view.getPageCache().put(key, value);
    }

    public static void convert(IFormView view) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("apiModelString", GuideUtil.getHttpItem(view) == null ? null : JSON.toJSONString((Object)GuideUtil.getHttpItem(view)));
        GuideTaskEnum currentTask = GuideUtil.getCurrentTask(view);
        params.put("guideTask", currentTask.name());
        params.put("conn_id", GuideUtil.getPageCache(view, "conn_id"));
        if (currentTask == GuideTaskEnum.is_create_refresh) {
            params.put("webRespBodyStr", GuideUtil.getPageCache(view, "webRespBodyStr"));
            params.put("conn_params_json_str", GuideUtil.getPageCache(view, "conn_params_json_str"));
            params.put("is_refresh_same_login", GuideUtil.getCurrentChildObj(view).getBoolean("is_refresh_same_login"));
        }
        if (currentTask == GuideTaskEnum.is_create_webapi) {
            params.put("conn_id", GuideUtil.getPageCache(view, "conn_id"));
            params.put("source_id", GuideUtil.getPageCache(view, "source_id"));
            params.put("webRespBodyStr", GuideUtil.getPageCache(view, "webRespBodyStr"));
            params.put("conn_params_json_str", GuideUtil.getPageCache(view, "conn_params_json_str"));
        }
        if (currentTask == GuideTaskEnum.is_create_refresh || currentTask == GuideTaskEnum.is_create_login) {
            GuideUtil.showSubPage(view, "isc_script_to_contype", params);
        } else {
            GuideUtil.showWebApi(view, params);
        }
    }

    public static void showWebApi(IFormView view, Map<String, Object> params) {
        BillShowParameter p = new BillShowParameter();
        p.setFormId("isc_conn_guide_weiapi");
        p.setCustomParams(params);
        p.getOpenStyle().setShowType(ShowType.InContainer);
        p.setParentPageId(view.getPageId());
        p.setStatus(OperationStatus.ADDNEW);
        p.getOpenStyle().setShowType(ShowType.InContainer);
        p.getOpenStyle().setTargetKey("step_flex");
        p.setStatus(OperationStatus.ADDNEW);
        view.showForm((FormShowParameter)p);
        GuideUtil.putPageCache(view, "current_child_pageid", p.getPageId());
    }
}

