/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.formplugin.help;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.filter.FilterParameter;
import kd.bos.entity.tree.TreeNode;
import kd.bos.ext.form.control.Markdown;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.Search;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.control.events.TreeNodeQueryListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.lang.Lang;
import kd.bos.list.BillList;
import kd.bos.list.events.ListRowClickEvent;
import kd.bos.list.events.ListRowClickListener;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.isc.iscb.formplugin.util.FormOpener;
import kd.isc.iscb.formplugin.util.ScriptScens;
import kd.isc.iscb.formplugin.util.ShowScriptHelpUtil;
import kd.isc.iscb.platform.core.connector.ConnectorUtil;
import kd.isc.iscb.platform.core.imp.JarResourceImportJob;
import kd.isc.iscb.platform.core.job.Job;
import kd.isc.iscb.platform.core.job.JobEngine;
import kd.isc.iscb.platform.core.job.JobInfo;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.misc.Json;
import kd.isc.iscb.util.misc.StringUtil;

public class IscOnlineHelpItemTreePlugin
extends AbstractListPlugin
implements ClickListener,
ListRowClickListener,
TreeNodeClickListener,
SearchEnterListener,
TreeNodeQueryListener {
    private static final String KEY_TREEVIEW = "treeviewap";
    private static final String KEY_BILLLIST = "billlistap";
    private static final String KEY_SEARCH = "searchap";
    private static final String BTNNEW = "btnnew";
    private static final String BTNEDIT = "btnedit";
    private static final String BTNDEL = "btndel";
    private static final String REFRESH = "refresh";

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.initTree();
        this.showItemByTargetScens();
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.getView().setVisible(Boolean.valueOf(Lang.zh_CN != Lang.get()), new String[]{"flex_tips"});
        this.getView().setVisible(Boolean.valueOf(Lang.zh_CN == Lang.get()), new String[]{"toolbarap", "splitcontainerap"});
        if (Lang.zh_CN != Lang.get()) {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u73af\u5883\u8bed\u8a00\u914d\u7f6e\u4e3a\uff1a%s\uff0c\u975e\u4e2d\u6587\u73af\u5883\u4e0b\u8be5\u529f\u80fd\u6682\u4e0d\u652f\u6301\u4f7f\u7528\u3002", (String)"IscOnlineHelpItemTreePlugin_11", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), Lang.get()), Integer.valueOf(6000));
        }
    }

    private void showItemByTargetScens() {
        QFilter filter;
        Map params = this.getView().getFormShowParameter().getCustomParams();
        String plugin_name = D.s(params.get("plugin_name"));
        if (plugin_name == null || "isc_portal_advertising".equals(plugin_name)) {
            return;
        }
        ScriptScens scens = ShowScriptHelpUtil.getScensByPluginName(plugin_name);
        if (ScriptScens.ALL == scens) {
            filter = new QFilter("target_scens", "match", (Object)ScriptScens.ALL.name());
        } else {
            String target_scens = scens.name();
            filter = new QFilter("target_scens", "match", (Object)ScriptScens.ALL.name()).or(new QFilter("target_scens", "match", (Object)target_scens));
        }
        BillList billList = (BillList)this.getControl(KEY_BILLLIST);
        FilterParameter fp = new FilterParameter();
        fp.setFilter(filter);
        billList.setFilterParameter(fp);
        billList.addSetFilterListener(event -> event.getQFilters().add(filter));
        billList.refresh();
        billList.clearSelection();
    }

    private void initTree() {
        TreeView tree = (TreeView)this.getControl(KEY_TREEVIEW);
        tree.deleteAllNodes();
        TreeNode rootNode = new TreeNode("", "0", ResManager.loadKDString((String)"\u5168\u90e8", (String)"IscOnlineHelpItemTreePlugin_0", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
        tree.addNode(rootNode);
        tree.focusNode(rootNode);
        List<TreeNode> nodes = this.getChildNodes("0");
        tree.addNodes(nodes);
        tree.expand("0");
        tree.expand(this.getPageCache().get("scriptNode"));
        this.loadCategories(nodes);
        this.loadItems();
    }

    private void loadItems() {
        DynamicObjectCollection items = QueryServiceHelper.query((String)"isc_help_item", (String)"id,group,number,name", null, (String)"number");
        HashMap<String, String> cache = new HashMap<String, String>();
        for (DynamicObject item : items) {
            long pid = item.getLong("group");
            String parent = String.valueOf(pid);
            String id = String.valueOf(item.get("id"));
            String number = item.getString("number");
            String title = item.getString("name");
            cache.put(id, title + ":" + number + ":" + parent);
        }
        this.getPageCache().put("itemCache", Json.toString(cache));
    }

    private void loadCategories(List<TreeNode> nodes) {
        LinkedHashMap<String, String> cache = new LinkedHashMap<String, String>(nodes.size());
        this.buildCategoriesCache(nodes, cache);
        this.getPageCache().put("categoriesCache", Json.toString(cache));
    }

    private void buildCategoriesCache(List<TreeNode> nodes, Map<String, String> cache) {
        for (TreeNode node : nodes) {
            String parent = node.getParentid();
            String id = node.getId();
            String title = node.getText();
            cache.put(id, title + ":" + parent);
            List child = node.getChildren();
            if (child == null || child.isEmpty()) continue;
            this.buildCategoriesCache(child, cache);
        }
    }

    public void treeNodeClick(TreeNodeEvent evt) {
        Control source = (Control)evt.getSource();
        if (KEY_TREEVIEW.equals(source.getKey())) {
            this.refreshBillList(evt.getNodeId(), 1);
            this.showItemByTargetScens();
        }
    }

    private void refreshBillList(Object nodeId, int i) {
        BillList billList = (BillList)this.getControl(KEY_BILLLIST);
        long id = D.l((Object)nodeId);
        FilterParameter fp = new FilterParameter();
        String group = this.getPageCache().get("group");
        QFilter filter = null;
        if (id == 0L) {
            if (i == 2 && !StringUtil.isEmpty((String)group)) {
                List<Long> asList = this.getIDList(group);
                filter = new QFilter("id", "in", asList);
            }
        } else {
            List<Object> nodes = this.findChildrenNodes(id);
            filter = new QFilter("group", "in", nodes);
            if (i == 2 && !StringUtil.isEmpty((String)group)) {
                List<Long> asList = this.getIDList(group);
                filter.and(new QFilter("id", "in", asList));
            }
        }
        fp.setFilter(filter);
        billList.setFilterParameter(fp);
        QFilter finalFilter1 = filter;
        billList.addSetFilterListener(event -> event.getQFilters().add(finalFilter1));
        billList.refresh();
        billList.clearSelection();
    }

    private List<Long> getIDList(String group) {
        String[] array = group.split(",");
        ArrayList<Long> ids = new ArrayList<Long>(array.length);
        for (String s : array) {
            ids.add(Long.parseLong(s));
        }
        return ids;
    }

    private List<Object> findChildrenNodes(long id) {
        QFilter filter = new QFilter("id", "=", (Object)id);
        DynamicObject object = QueryServiceHelper.queryOne((String)"isc_help_category", (String)"longnumber", (QFilter[])new QFilter[]{filter});
        assert (object != null);
        String longnumber = object.getString("longnumber");
        QFilter qFilter = new QFilter("longnumber", "like", (Object)(longnumber + ".%"));
        qFilter.or(new QFilter("longnumber", "=", (Object)longnumber));
        return QueryServiceHelper.queryPrimaryKeys((String)"isc_help_category", (QFilter[])new QFilter[]{qFilter}, null, (int)1000);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BillList list = (BillList)this.getControl(KEY_BILLLIST);
        list.addListRowClickListener((ListRowClickListener)this);
        TreeView treeView = (TreeView)this.getControl(KEY_TREEVIEW);
        treeView.addTreeNodeClickListener((TreeNodeClickListener)this);
        treeView.addTreeNodeQueryListener((TreeNodeQueryListener)this);
        Search search = (Search)this.getControl(KEY_SEARCH);
        search.addEnterListener((SearchEnterListener)this);
        this.addClickListeners(new String[]{BTNNEW, BTNEDIT, BTNDEL, REFRESH});
    }

    public void click(EventObject evt) {
        Control source = (Control)evt.getSource();
        String key = source.getKey();
        if (REFRESH.equals(key)) {
            Object id = this.getFocusId();
            this.refreshBillList(id, 1);
        } else if (BTNEDIT.equals(key) || BTNDEL.equals(key)) {
            this.updateCategory(key);
        } else if (BTNNEW.equals(key)) {
            FormOpener.showAddNew((AbstractFormPlugin)this, "isc_help_category", Collections.emptyMap(), "add_category");
        }
    }

    private void updateCategory(String action) {
        Object id = this.getFocusId();
        if (id == null || "0".equals(id.toString())) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u4e2a\u6811\u5b50\u8282\u70b9\u3002", (String)"IscOnlineHelpItemTreePlugin_1", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
            return;
        }
        if (BTNEDIT.equals(action)) {
            this.editCategory(id);
        } else {
            this.deleteCategory(id);
        }
    }

    private void deleteCategory(Object id) {
        try {
            long parentId = D.l((Object)id);
            if (QueryServiceHelper.exists((String)"isc_help_category", (QFilter[])new QFilter[]{new QFilter("parent", "=", (Object)parentId)})) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u6811\u8282\u70b9\u5b58\u5728\u5b50\u7ea7\uff0c\u8bf7\u5148\u5220\u9664\u5b50\u7ea7\u3002", (String)"IscOnlineHelpItemTreePlugin_2", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
                return;
            }
            ConnectorUtil.delete((String)"isc_help_category", (Object)parentId);
            this.initTree();
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f\u3002", (String)"IscOnlineHelpItemTreePlugin_3", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
        }
        catch (Exception e) {
            FormOpener.showErrorMessage(this.getView(), e);
        }
    }

    private void editCategory(Object id) {
        BillShowParameter param = new BillShowParameter();
        param.setFormId("isc_help_category");
        param.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "edit_category"));
        param.setPkId(id);
        param.getOpenStyle().setShowType(ShowType.Modal);
        param.setCustomParam("MUTEX_OBJ_ID", (Object)String.valueOf(id));
        param.setStatus(OperationStatus.EDIT);
        this.getView().showForm((FormShowParameter)param);
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        super.closedCallBack(evt);
        String actionId = evt.getActionId();
        Object result = evt.getReturnData();
        if (("add_category".equals(actionId) || "edit_category".equals(actionId)) && "success".equals(result)) {
            this.initTree();
        }
    }

    private Object getFocusId() {
        TreeView tree = (TreeView)this.getControl(KEY_TREEVIEW);
        Map node = tree.getTreeState().getFocusNode();
        return node == null ? null : node.get("id");
    }

    public void listRowClick(ListRowClickEvent evt) {
        BillList list = (BillList)this.getView().getControl(KEY_BILLLIST);
        ListSelectedRow info = list.getCurrentSelectedRowInfo();
        if (info != null) {
            Object pk = info.getPrimaryKeyValue();
            DynamicObject item = BusinessDataServiceHelper.loadSingle((Object)pk, (String)"isc_help_item", (String)"number,target_scens,help_text, help_content_tag");
            Markdown mk = (Markdown)this.getView().getControl("markdownap");
            String content = item.getString("help_content_tag");
            String scens = item.getString("target_scens");
            String number = item.getString("number");
            String[] strings = scens.split(",");
            StringBuilder sbuffer = new StringBuilder(strings.length);
            sbuffer.append(ResManager.loadKDString((String)" \u9002\u7528\u573a\u666f\uff1a", (String)"IscOnlineHelpItemTreePlugin_9", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0])).append('\n');
            for (String string : strings) {
                if (StringUtil.isEmpty((String)string)) continue;
                String name = ScriptScens.getScens(string).getName();
                sbuffer.append("- ").append(name).append('\n');
            }
            sbuffer.append("#### ");
            if (StringUtil.isEmpty((String)content) && StringUtil.isEmpty((String)(content = item.getString("help_text")))) {
                mk.setText(ResManager.loadKDString((String)"\u8be5\u63d2\u4ef6\u6b63\u5728\u5feb\u9a6c\u52a0\u97ad\u7684\u5f00\u53d1\u4e2d......", (String)"IscOnlineHelpItemTreePlugin_5", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
                return;
            }
            if (!content.trim().startsWith("#")) {
                content = "# " + number + "\n" + content;
            }
            int index = content.indexOf("\u57fa\u672c\u7528\u6cd5");
            StringBuilder builder = new StringBuilder();
            if (index != -1) {
                String str = content.substring(0, index);
                builder.append(str).append((CharSequence)sbuffer).append(content.substring(index));
            } else {
                index = content.indexOf(10);
                String str = content.substring(0, index);
                builder.append(str).append("\n#### ").append((CharSequence)sbuffer).append(content.substring(index));
            }
            mk.setText(builder.toString());
        }
    }

    public void search(SearchEnterEvent evt) {
        String searchText = evt.getText();
        if (StringUtils.isNotEmpty((CharSequence)searchText)) {
            String last_search_text = D.s((Object)this.getView().getPageCache().get("last_search_text"));
            if (!searchText.equals(last_search_text)) {
                this.getView().getPageCache().put("group_last_index", null);
            }
            this.getView().getPageCache().put("last_search_text", searchText);
            String s = this.getPageCache().get("categoriesCache");
            Map categoriesCache = (Map)Json.toObject((String)s);
            Iterator<Map.Entry<String, String>> it = this.getEntryIterator(categoriesCache);
            boolean found = this.searchKeywords(searchText, it, 1);
            if (!found) {
                s = this.getPageCache().get("itemCache");
                Map itemCache = (Map)Json.toObject((String)s);
                it = this.getEntryIterator(itemCache);
                found = this.searchKeywords(searchText, it, 2);
                if (!found && this.getView().getPageCache().get("group_last_index") == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f88\u62b1\u6b49\u6ca1\u6709\u627e\u5230\u5339\u914d\u7684\u5e2e\u52a9\u4fe1\u606f\u3002", (String)"IscOnlineHelpItemTreePlugin_7", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
                }
                this.getView().getPageCache().put("group_last_index", null);
                this.showItemByTargetScens();
            }
        }
    }

    private Iterator<Map.Entry<String, String>> getEntryIterator(Map<String, String> cache) {
        return cache.entrySet().iterator();
    }

    private boolean searchKeywords(String text, Iterator<Map.Entry<String, String>> it, int i) {
        String nodeId = this.searchAndShowEntry(it, text, i);
        this.refreshBillList(nodeId, i);
        return !"".equals(nodeId);
    }

    private String searchAndShowEntry(Iterator<Map.Entry<String, String>> it, String text, int i) {
        String[] keywords = text.split("\\s+");
        int flag = 0;
        String nodeId = "0";
        StringBuilder buf = new StringBuilder();
        this.getPageCache().put("group", "");
        int index = 0;
        while (it.hasNext()) {
            Map.Entry<String, String> e = it.next();
            String value = e.getValue();
            ++index;
            if (!this.containsAll(value, keywords)) continue;
            nodeId = e.getKey();
            if (i != 1) {
                String[] split = value.split(":");
                String group = split[split.length - 1];
                buf.append(nodeId).append(',');
                nodeId = group;
                ++flag;
                continue;
            }
            int last_index = D.i((Object)this.getView().getPageCache().get("group_last_index"));
            if (last_index >= index) continue;
            this.getView().getPageCache().put("group_last_index", D.s((Object)index));
            this.showEntry(nodeId);
            return nodeId;
        }
        if (flag == 0) {
            return "";
        }
        if (flag > 1) {
            nodeId = "0";
        }
        String s = buf.toString();
        String substring = s.substring(0, s.length() - 1);
        this.getPageCache().put("group", substring);
        this.showEntry(nodeId);
        return nodeId;
    }

    private boolean containsAll(String topic, String[] keywords) {
        String lowerCase = topic.toLowerCase();
        for (String key : keywords) {
            if (lowerCase.contains(key.toLowerCase())) continue;
            return false;
        }
        return true;
    }

    private void showEntry(String nodeId) {
        TreeView tree = (TreeView)this.getControl(KEY_TREEVIEW);
        tree.showNode(nodeId);
        tree.focusNode(new TreeNode("", nodeId, ""));
    }

    public void queryTreeNodeChildren(TreeNodeEvent evt) {
        TreeView treeView = (TreeView)this.getView().getControl(KEY_TREEVIEW);
        String pNodeId = evt.getNodeId().toString();
        if ("root".equals(pNodeId)) {
            this.refreshBillList(pNodeId, 1);
        } else {
            List<TreeNode> nodes = this.getChildNodes(pNodeId);
            treeView.addNodes(nodes);
        }
    }

    private List<TreeNode> getChildNodes(String pNodeId) {
        DynamicObjectCollection categories = QueryServiceHelper.query((String)"isc_help_category", (String)"id,parent,name", (QFilter[])new QFilter[]{new QFilter("parent", "=", (Object)D.l((Object)pNodeId))});
        ArrayList<TreeNode> nodes = new ArrayList<TreeNode>(categories.size());
        for (DynamicObject category : categories) {
            long pid = category.getLong("parent");
            String id = String.valueOf(category.get("id"));
            String title = category.getString("name");
            TreeNode node = new TreeNode(D.s((Object)pid), id, title);
            if (pid == 0L) {
                this.getPageCache().put("scriptNode", id);
            }
            if (QueryServiceHelper.exists((String)"isc_help_category", (QFilter[])new QFilter[]{new QFilter("parent", "=", (Object)D.l((Object)id))})) {
                node.setChildren(this.getChildNodes(id));
            }
            nodes.add(node);
        }
        return nodes;
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        if ("rebuild".equals(e.getOperateKey())) {
            JarResourceImportJob job = new JarResourceImportJob(ResManager.loadKDString((String)"\u91cd\u5efa\u811a\u672c\u5e2e\u52a9", (String)"IscOnlineHelpItemTreePlugin_8", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), "isc/iscb/help/item");
            List jobs = JobEngine.getJobsWithOwnerId((long)job.getOwnerId());
            if (jobs.isEmpty()) {
                FormOpener.startJob((AbstractFormPlugin)this, (Job)job);
            } else {
                FormOpener.reopenJob((AbstractFormPlugin)this, ((JobInfo)jobs.get(0)).getId(), job.getTitle());
            }
        } else if ("refresh2".equals(e.getOperateKey())) {
            this.getView().getPageCache().put("group_last_index", null);
            this.initTree();
            this.showItemByTargetScens();
        }
    }
}

