/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.formplugin.hub;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.filter.ControlFilters;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.FilterContainerSearchClickArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.isc.iscb.formplugin.util.FormOpener;
import kd.isc.iscb.platform.core.content.DataFlowResourceUtil;
import kd.isc.iscb.platform.core.content.ResourceType;
import kd.isc.iscb.platform.core.content.SearchUtil;
import kd.isc.iscb.platform.core.content.job.ContentSearchJobFactory;
import kd.isc.iscb.platform.core.job.Job;
import kd.isc.iscb.platform.core.job.JobEngine;
import kd.isc.iscb.platform.core.job.JobInfo;
import kd.isc.iscb.platform.core.util.CollectionUtils;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.misc.Json;

public class ContentSearchListPlugin
extends AbstractListPlugin {
    public void afterDoOperation(AfterDoOperationEventArgs args) {
        List successPkIds;
        OperationResult operationResult;
        super.afterDoOperation(args);
        if ("mark_done".equals(args.getOperateKey()) && (operationResult = args.getOperationResult()) != null && !CollectionUtils.isEmpty((Collection)(successPkIds = operationResult.getSuccessPkIds()))) {
            SearchUtil.markDataHandled((List)successPkIds);
            this.getView().invokeOperation("refresh");
        }
    }

    public void setFilter(SetFilterEvent e) {
        long currUserId = RequestContext.get().getCurrUserId();
        e.addCustomQFilter(new QFilter("creator", "=", (Object)currUserId));
    }

    public void filterContainerSearchClick(FilterContainerSearchClickArgs args) {
        super.filterContainerSearchClick(args);
        ControlFilters controlFilters = this.getControlFilters();
        if (controlFilters != null) {
            try {
                this.innerSearch(controlFilters);
            }
            catch (Throwable e) {
                FormOpener.showErrorMessage(this.getView(), e);
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent evt) {
        super.confirmCallBack(evt);
        if ("do_search".equals(evt.getCallBackId()) && evt.getResult() == MessageBoxResult.Yes) {
            this.handleSearchCallback(evt);
        }
        if ("start_job".equals(evt.getCallBackId())) {
            this.handleStartJobCallback(evt);
        }
    }

    private void handleSearchCallback(MessageBoxClosedEvent evt) {
        String keyword = evt.getCustomVaule();
        List jobs = JobEngine.getJobsWithOwnerId((long)this.getUserId());
        if (!jobs.isEmpty()) {
            long jobId = ((JobInfo)jobs.get(0)).getId();
            String tips = ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u6709\u6b63\u5728\u6267\u884c\u4e2d\u7684\u4efb\u52a1\uff0c\u662f\u5426\u9700\u8981\u505c\u6389\u6267\u884c\u4e2d\u7684\u4efb\u52a1\u6267\u884c\u65b0\u7684\u641c\u7d22\u4efb\u52a1\uff1f\u70b9\u51fb\u201c\u786e\u5b9a\u201d\u6309\u94ae\u505c\u6389\u6267\u884c\u4e2d\u7684\u4efb\u52a1\uff0c\u70b9\u51fb\u201c\u53d6\u6d88\u201d\u7ee7\u7eed\u6267\u884c\u6267\u884c\u4e2d\u7684\u4efb\u52a1\u3002", (String)"ContentSearchListPlugin_6", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]);
            this.getView().showConfirm(tips, null, MessageBoxOptions.OKCancel, ConfirmTypes.Default, new ConfirmCallBackListener("start_job"), null, keyword + "#_!" + jobId);
        } else {
            this.startNewSearchJob(keyword);
        }
    }

    private void handleStartJobCallback(MessageBoxClosedEvent evt) {
        String customVaule = evt.getCustomVaule();
        String[] split = customVaule.split("#_!");
        String keyword = split[0];
        long jobId = D.l((Object)split[1]);
        MessageBoxResult result = evt.getResult();
        if (result == MessageBoxResult.Yes || result == MessageBoxResult.OK) {
            JobEngine.cancel((long)jobId);
            QFilter qFilter = new QFilter("id", "=", (Object)jobId);
            DeleteServiceHelper.delete((String)"isc_job_inst", (QFilter[])new QFilter[]{qFilter});
            this.startNewSearchJob(keyword);
        } else if (result == MessageBoxResult.Cancel) {
            String title = ResManager.loadKDString((String)"\u96c6\u6210\u5185\u5bb9\u68c0\u7d22", (String)"ContentSearchListPlugin_2", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]);
            FormOpener.reopenJob((AbstractFormPlugin)this, jobId, title, "job_callback");
        }
    }

    private void startNewSearchJob(String keyword) {
        ControlFilters controlFilters = this.getControlFilters();
        String resourceType = this.getResourceType(controlFilters.getFilter("resource_type"));
        String pageId = this.getPageCache().getPageId();
        String title = ResManager.loadKDString((String)"\u96c6\u6210\u5185\u5bb9\u68c0\u7d22", (String)"ContentSearchListPlugin_2", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]);
        Job job = ContentSearchJobFactory.createJob((long)this.getUserId(), (String)title, (String)pageId, (String)resourceType, (String)keyword);
        FormOpener.startJob((AbstractFormPlugin)this, job, "job_callback");
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        ControlFilters controlFilters;
        super.closedCallBack(evt);
        String actionId = evt.getActionId();
        if ("job_callback".equals(actionId) && (controlFilters = this.getControlFilters()) != null) {
            this.callback(controlFilters);
        }
    }

    private void callback(ControlFilters controlFilters) {
        List keywords = controlFilters.getFastFilter("keyword");
        if (!CollectionUtils.isEmpty((Collection)keywords)) {
            long jobOwnerId = this.getUserId();
            List jobs = JobEngine.getJobsWithOwnerId((long)jobOwnerId);
            if (jobs.isEmpty()) {
                this.getView().invokeOperation("refresh");
            } else {
                String tips = ResManager.loadKDString((String)"\u68c0\u7d22\u4efb\u52a1\u672a\u7ed3\u675f\uff0c\u53ef\u518d\u6b21\u67e5\u8be2\u67e5\u770b\u4efb\u52a1\u8fdb\u5ea6\u3002", (String)"ContentSearchListPlugin_3", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]);
                this.getView().showTipNotification(tips);
            }
        }
    }

    private void innerSearch(ControlFilters controlFilters) {
        List keywords = controlFilters.getFastFilter("keyword");
        if (!CollectionUtils.isEmpty((Collection)keywords)) {
            if (keywords.size() > 1) {
                String msg = ResManager.loadKDString((String)"\u5173\u952e\u8bcd\u5feb\u901f\u8fc7\u6ee4\u53ea\u5141\u8bb8\u8f93\u5165\u5355\u4e2a\u503c", (String)"ContentSearchListPlugin_1", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]);
                this.getView().showTipNotification(msg);
            } else if (keywords.size() == 1) {
                this.startSearchJob(keywords);
            }
        }
    }

    private void startSearchJob(List<Object> keywords) {
        String keyword = D.s((Object)keywords.get(0));
        if (keyword != null) {
            if (keyword.length() > 30) {
                String msg = ResManager.loadKDString((String)"\u5173\u952e\u8bcd\u957f\u5ea6\u9700\u5c0f\u4e8e\u7b49\u4e8e30\u4e2a\u5b57\u7b26", (String)"ContentSearchListPlugin_4", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]);
                this.getView().showTipNotification(msg);
            } else {
                String tips = ResManager.loadKDString((String)"\u641c\u7d22\u4f1a\u6e05\u7a7a\u5f53\u524d\u5217\u8868\u7684\u68c0\u7d22\u8bb0\u5f55\uff0c\u8bf7\u786e\u5b9a\u662f\u5426\u7ee7\u7eed\u3002", (String)"ContentSearchListPlugin_5", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]);
                this.getView().showConfirm(tips, null, MessageBoxOptions.YesNo, ConfirmTypes.Default, new ConfirmCallBackListener("do_search"), null, keyword);
            }
        }
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        super.billListHyperLinkClick(args);
        String fieldName = args.getFieldName();
        if ("resource_number".equals(fieldName)) {
            args.setCancel(true);
            long id = D.l((Object)this.getFocusRowPkId());
            if (id != 0L) {
                this.openDetail(id);
            }
        }
    }

    private long getUserId() {
        RequestContext ctx = RequestContext.get();
        return ctx.getCurrUserId();
    }

    private String getResourceType(List<Object> typeFilters) {
        if (!CollectionUtils.isEmpty(typeFilters)) {
            return D.s((Object)typeFilters.get(0));
        }
        return null;
    }

    private void openDetail(long id) {
        DynamicObject obj = BusinessDataServiceHelper.loadSingle((Object)id, (String)"isc_content_search");
        String resourceType = obj.getString("resource_type");
        if (ResourceType.isc_service_flow.name().equals(resourceType)) {
            this.openServiceFlowDiagram(obj, resourceType);
        } else if (ResourceType.iscx_resource.name().equals(resourceType)) {
            DataFlowResourceUtil.openResourceEditor((long)obj.getLong("resource_id"), (AbstractFormPlugin)this);
        } else if (ResourceType.isc_value_conver_rule.name().equals(resourceType)) {
            long resourceId = obj.getLong("resource_id");
            FormOpener.showView((AbstractFormPlugin)this, resourceType, resourceId);
        } else {
            long resourceId = obj.getLong("resource_id");
            FormOpener.showTabView((AbstractFormPlugin)this, resourceType, resourceId);
        }
    }

    private void openServiceFlowDiagram(DynamicObject obj, String resourceType) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("flow", obj.getLong("resource_id"));
        params.put("ENTITY", resourceType);
        params.put("editable", Boolean.TRUE);
        params.put("$tag", this.getDiagramMetaIds(obj.getString("location_tag")));
        FormOpener.showTabForm((AbstractFormPlugin)this, "isc_service_flow_editor", ResManager.loadKDString((String)"\u6d41\u7a0b\u56fe", (String)"ServiceFlowListPlugin_16", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), params, null);
    }

    private String getDiagramMetaIds(String locationTag) {
        List locations = (List)Json.toObject((String)locationTag);
        StringBuilder metaIds = new StringBuilder();
        for (int i = 0; i < locations.size(); ++i) {
            if (i > 0) {
                metaIds.append(',');
            }
            Map location = (Map)locations.get(i);
            metaIds.append(location.get("id"));
        }
        return metaIds.toString();
    }
}

