/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.formplugin.log;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import kd.bos.cache.CacheFactory;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.report.CellStyle;
import kd.bos.exception.KDBizException;
import kd.bos.form.MessageTypes;
import kd.bos.form.container.Tab;
import kd.bos.form.control.CodeEdit;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.StringUtils;
import kd.isc.iscb.formplugin.log.ConvertRuleExceptionItem;
import kd.isc.iscb.formplugin.log.SchemaEncryptDataUtil;
import kd.isc.iscb.formplugin.util.FormOpener;
import kd.isc.iscb.platform.core.cache.DynamicObjectCacheProxy;
import kd.isc.iscb.platform.core.cache.data.DataCopySchema;
import kd.isc.iscb.platform.core.dc.DataCopyTask;
import kd.isc.iscb.platform.core.util.FileUtil;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.except.IscBizException;
import kd.isc.iscb.util.misc.Json2;
import kd.isc.iscb.util.misc.StringUtil;

public class DataCopyExecLogFormPlugin
extends AbstractFormPlugin
implements HyperLinkClickListener {
    private static final String MAPPING_URL = "https://vip.kingdee.com/article/350577993002859776";
    private static final String SQL_QUERY_FAILURE_URL = "https://vip.kingdee.com/article/350571330452221696";
    private static final String SQL_URL = "https://vip.kingdee.com/article/350392249206627072";
    private static final String AUTO_URL = "https://vip.kingdee.com/article/350591661988795392";
    private static final String SCRIPT_URL = "https://vip.kingdee.com/article/357454534597788160";
    private static final String COMPOSITE_URL = "https://vip.kingdee.com/article/357456803732458240";
    private static final String TLB_URL = "https://vip.kingdee.com/article/356129999214033152";
    private static final String DEFAULT_URL = "https://vip.kingdee.com/article/350300853158206208";
    private static Log logger = LogFactory.getLog(DataCopyTask.class);

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        e.setCheckDataChange(false);
    }

    public void beforeBindData(EventObject e) {
        String message;
        super.beforeBindData(e);
        IDataModel model = this.getView().getModel();
        long logId = D.l((Object)model.getDataEntity().getPkValue());
        Object dataCopySchema = model.getValue("data_copy_schema");
        if (dataCopySchema instanceof DynamicObject) {
            this.showMessage(model, logId, (DynamicObject)dataCopySchema);
        }
        boolean needShowRuleTab = (message = D.s((Object)this.getModel().getValue("message_tag"))) != null && message.contains("\u8f6c\u6362\u89c4\u5219\uff08");
        this.getView().setVisible(Boolean.valueOf(needShowRuleTab), new String[]{"rule_tab"});
        if (needShowRuleTab) {
            try {
                this.showErrorRuleInfo(message);
                Tab tabCtrl = (Tab)this.getView().getControl("tabap");
                tabCtrl.activeTab("rule_tab");
            }
            catch (Exception exception) {
                this.getView().setVisible(Boolean.FALSE, new String[]{"rule_tab"});
                this.getView().showMessage(ResManager.loadKDString((String)"\u65e0\u6cd5\u83b7\u53d6\u503c\u8f6c\u6362\u5f02\u5e38\u8be6\u60c5\u5217\u8868", (String)"DataCopyExecLogFormPlugin_1", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), StringUtil.getCascadeMessage((Throwable)exception), MessageTypes.Default);
            }
        }
    }

    private void showErrorRuleInfo(String message) {
        LinkedList<ConvertRuleExceptionItem> failed_rule = this.getFailedRuleList(message);
        this.setRuleEntity(failed_rule);
    }

    private LinkedList<ConvertRuleExceptionItem> getFailedRuleList(String message) {
        String[] split = message.split("\r\n\r\n");
        LinkedList<ConvertRuleExceptionItem> failed_rule = new LinkedList<ConvertRuleExceptionItem>();
        for (String s : split) {
            if (!s.contains("\u5230\u76ee\u6807\u5355\u5b57\u6bb5\"") || !s.contains("\"\u8f6c\u6362\u5931\u8d25")) continue;
            failed_rule.add(new ConvertRuleExceptionItem(s));
        }
        return failed_rule;
    }

    private void setRuleEntity(LinkedList<ConvertRuleExceptionItem> failed_rule) {
        DynamicObjectCollection ruleEntity = this.getModel().getDataEntity(true).getDynamicObjectCollection("rule_entity");
        for (ConvertRuleExceptionItem ruleExceptionItem : failed_rule) {
            DynamicObject item = ruleEntity.addNew();
            item.set("src_field", (Object)ruleExceptionItem.getSrcField());
            item.set("src_value", (Object)ruleExceptionItem.getSrcValue());
            item.set("tar_field", (Object)ruleExceptionItem.getTarField());
            item.set("rule_number", (Object)ruleExceptionItem.getRuleNumber());
            item.set("rule_type", (Object)ruleExceptionItem.getRuleType());
            item.set("tar_value", (Object)ruleExceptionItem.getTarValue());
            item.set("err_msg_info", (Object)ruleExceptionItem.getErrMsgInfo());
            item.set("op", (Object)ResManager.loadKDString((String)"\u67e5\u770b\u89e3\u51b3\u5efa\u8bae", (String)"DataCopyExecLogFormPlugin_4", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
        }
        this.setFontColor(ruleEntity);
        this.getView().updateView("rule_entity");
    }

    private void setFontColor(DynamicObjectCollection entryentity) {
        ArrayList<CellStyle> styles = new ArrayList<CellStyle>(entryentity.size());
        for (int i = 0; i < entryentity.size(); ++i) {
            DynamicObject object = (DynamicObject)entryentity.get(i);
            CellStyle cellStyle = new CellStyle();
            cellStyle.setRow(i);
            cellStyle.setFieldKey("tar_value");
            Object className = object.get("tar_value");
            if (className.equals("failure")) {
                cellStyle.setForeColor("rgb(255,0,0)");
            } else if (className.equals("empty")) {
                cellStyle.setForeColor("#6d7278");
            }
            styles.add(cellStyle);
        }
        EntryGrid grid = (EntryGrid)this.getView().getControl("rule_entity");
        grid.setCellStyle(styles);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("rule_entity");
        entryGrid.addHyperClickListener((HyperLinkClickListener)this);
    }

    public void hyperLinkClick(HyperLinkClickEvent hyperLinkClickEvent) {
        if ("rule_number".equals(hyperLinkClickEvent.getFieldName())) {
            this.showViewForRule(hyperLinkClickEvent);
        } else if ("op".equals(hyperLinkClickEvent.getFieldName())) {
            int rowIndex = hyperLinkClickEvent.getRowIndex();
            DynamicObjectCollection ruleEntity = this.getModel().getDataEntity(true).getDynamicObjectCollection("rule_entity");
            String type = ((DynamicObject)ruleEntity.get(rowIndex)).getString("rule_type");
            String errMsgInfo = ((DynamicObject)ruleEntity.get(rowIndex)).getString("err_msg_info");
            this.openUrl(type, errMsgInfo);
        }
    }

    private void showViewForRule(HyperLinkClickEvent hyperLinkClickEvent) {
        int rowIndex = hyperLinkClickEvent.getRowIndex();
        DynamicObjectCollection ruleEntity = this.getModel().getDataEntity(true).getDynamicObjectCollection("rule_entity");
        String number = ((DynamicObject)ruleEntity.get(rowIndex)).getString("rule_number");
        DynamicObject rule = DynamicObjectCacheProxy.getByNumber((String)"isc_value_conver_rule", (String)number);
        if (rule == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6253\u5f00\u503c\u8f6c\u6362\u5931\u8d25\uff0c\u539f\u56e0\uff1a", (String)"DataCopyExecLogFormPlugin_33", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]) + "\n" + String.format(ResManager.loadKDString((String)"1. \u7f16\u7801\u4e3a\u3010%s\u3011\u7684\u503c\u8f6c\u6362\u89c4\u5219\u5728\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728\u3002", (String)"DataCopyExecLogFormPlugin_34", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), number) + "\n" + ResManager.loadKDString((String)"2. \u539f\u7f16\u7801\u4e2d\u5b58\u5728\u7279\u6b8a\u5b57\u7b26\uff0c\u5bfc\u81f4\u89e3\u6790\u5931\u8d25\uff0c\u8bf7\u5230\u3010\u65e5\u5fd7\u8be6\u60c5\u3011\u9875\u7b7e\u4e0b\u590d\u5236\u8be5\u5f02\u5e38\u503c\u8f6c\u6362\u7f16\u7801\uff0c\u5230\u5bf9\u5e94\u503c\u8f6c\u6362\u89c4\u5219\u5217\u8868\u4e2d\u641c\u7d22\u3002", (String)"DataCopyExecLogFormPlugin_8", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
            return;
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("src_value", ((DynamicObject)ruleEntity.get(rowIndex)).getString("src_value"));
        FormOpener.showView((AbstractFormPlugin)this, "isc_value_conver_rule", rule.getPkValue(), params);
    }

    private void openUrl(String type, String errMsgInfo) {
        switch (RuleType.valueOf(type)) {
            case mapping: {
                this.getView().openUrl(MAPPING_URL);
                break;
            }
            case sql: {
                if (errMsgInfo.contains("\u6570\u636e\u67e5\u8be2\u5931\u8d25")) {
                    this.getView().openUrl(SQL_QUERY_FAILURE_URL);
                    break;
                }
                this.getView().openUrl(SQL_URL);
                break;
            }
            case auto: {
                this.getView().openUrl(AUTO_URL);
                break;
            }
            case script: {
                this.getView().openUrl(SCRIPT_URL);
                break;
            }
            case composite: {
                this.getView().openUrl(COMPOSITE_URL);
                break;
            }
            case tlb: {
                this.getView().openUrl(TLB_URL);
                break;
            }
            default: {
                this.getView().openUrl(DEFAULT_URL);
            }
        }
    }

    private void showMessage(IDataModel model, long logId, DynamicObject copySchema) {
        DynamicObject targetschema;
        DynamicObject sourceSchema;
        DynamicObject dataCopy = BusinessDataServiceHelper.loadSingle((Object)copySchema.getPkValue(), (String)"isc_data_copy");
        if (this.checkSchema(dataCopy, sourceSchema = dataCopy.getDynamicObject("source_schema"), targetschema = dataCopy.getDynamicObject("target_schema"))) {
            return;
        }
        DynamicObject log = BusinessDataServiceHelper.loadSingle((Object)logId, (String)"isc_data_copy_exec_log");
        String sourceDataTag = D.s((Object)log.getString("source_data_tag"));
        String targetDataTag = D.s((Object)log.getString("target_data_tag"));
        String logContent = D.s((Object)log.getString("message_tag"));
        this.handlerMessageView(model, logContent);
        CodeEdit sourceEdit = (CodeEdit)this.getView().getControl("sourceedit");
        CodeEdit targetEditor = (CodeEdit)this.getView().getControl("targetedit");
        this.handleCopyDataView(sourceDataTag, sourceEdit);
        this.handleCopyDataView(targetDataTag, targetEditor);
    }

    private void handlerMessageView(IDataModel model, String logContent) {
        if (StringUtils.isNotEmpty((String)logContent)) {
            if (this.checkCharLength(logContent)) {
                model.setValue("message_tag", (Object)logContent);
            } else {
                String stringAndTip = this.subStringAndConcatTip(logContent);
                model.setValue("message_tag", (Object)stringAndTip);
            }
        }
    }

    private void handleCopyDataView(String dataTag, CodeEdit editor) {
        if (StringUtils.isNotEmpty((String)dataTag)) {
            if (this.checkCharLength(dataTag)) {
                editor.setText(D.s((Object)SchemaEncryptDataUtil.getVarTag(dataTag)));
            } else {
                String jsonString = D.s((Object)SchemaEncryptDataUtil.getVarTag(dataTag));
                String stringAndTip = this.subStringAndConcatTip(jsonString);
                editor.setText(stringAndTip);
            }
        }
    }

    private boolean checkCharLength(String param) {
        return param.length() <= 102400;
    }

    private String subStringAndConcatTip(String param) {
        param = param.substring(0, 102400);
        StringBuilder sb = new StringBuilder();
        sb.append(param).append("\n\n\n\n").append(ResManager.loadKDString((String)"\u8bf7\u6ce8\u610f\uff1a\u56e0\u5185\u5bb9\u592a\u957f\uff0c\u540e\u7eed\u90e8\u5206\u88ab\u81ea\u52a8\u622a\u65ad\uff0c\u8bf7\u4e0b\u8f7d\u65e5\u5fd7\u7528\u6587\u672c\u7f16\u8f91\u5668\u67e5\u770b...", (String)"DataCopyExecLogFormPlugin_36", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
        return sb.toString();
    }

    private boolean checkSchema(DynamicObject dataCopy, DynamicObject sourceSchema, DynamicObject targetSchema) {
        String number = dataCopy.getString("number");
        if (null == sourceSchema) {
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u7f16\u7801\u4e3a\uff1a\u3010%s\u3011\u7684\u96c6\u6210\u65b9\u6848\u6e90\u5bf9\u8c61\u7f3a\u5931\u3002", (String)"DataCopyExecLogFormPlugin_37", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), number));
            return true;
        }
        if (null == targetSchema) {
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u7f16\u7801\u4e3a\uff1a\u3010%s\u3011\u7684\u96c6\u6210\u65b9\u6848\u76ee\u6807\u5bf9\u8c61\u7f3a\u5931\u3002", (String)"DataCopyExecLogFormPlugin_38", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), number));
            return true;
        }
        return false;
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String key = args.getOperateKey();
        if ("download".equals(key)) {
            LinkedHashMap<String, Object> log = new LinkedHashMap<String, Object>();
            Object id = this.getModel().getValue("id");
            log.put("log_id", id);
            log.put("data_src", this.getEncryptData(true));
            log.put("data_tar", this.getEncryptData(false));
            log.put("src_jf", this.getModel().getValue("judgefields"));
            log.put("exec_state", this.getModel().getValue("state"));
            log.put("trigger_number", this.getModel().getDataEntity().get("data_copy_trigger.number"));
            log.put("execution_number", this.getModel().getDataEntity().get("data_copy_execution.number"));
            log.put("log", D.s((Object)this.getModel().getValue("message")));
            StringBuilder sb = new StringBuilder();
            try {
                sb.append(Json2.toString(log));
            }
            catch (Exception e) {
                sb.append(log);
            }
            String detail = D.s((Object)this.getModel().getValue("message_tag"));
            if (detail != null) {
                sb.append("\r\n\r\n").append(ResManager.loadKDString((String)"=================\u65e5\u5fd7\u8be6\u60c5=================", (String)"DataCopyExecLogFormPlugin_39", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0])).append("\r\n").append(detail);
            }
            SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd_HHmmss");
            String format = sdf.format(new Date());
            try (ByteArrayInputStream input = new ByteArrayInputStream(sb.toString().getBytes(StandardCharsets.UTF_8));){
                String urls = CacheFactory.getCommonCacheFactory().getTempFileCache().saveAsUrl(String.format(ResManager.loadKDString((String)"\u6267\u884c\u65e5\u5fd7_%s.txt", (String)"DataCopyExecLogFormPlugin_40", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), format), (InputStream)input, 600);
                FileUtil.addDownloadPermission((String)"isc_data_copy_exec_log", (String)urls, (String)this.getView().getFormShowParameter().getServiceAppId());
                this.getView().openUrl(urls);
            }
            catch (Exception e) {
                throw new IscBizException(String.format(ResManager.loadKDString((String)"\u5bfc\u51fa\u5931\u8d25\uff0c\u539f\u56e0\uff1a%s", (String)"DataCopyExecLogFormPlugin_41", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), e.getMessage()), (Throwable)e);
            }
        }
    }

    private Object getEncryptData(boolean src) {
        DynamicObject meta;
        long pk = D.l((Object)this.getModel().getValue("data_copy_schema_id"));
        DynamicObject object = DataCopySchema.get((long)pk);
        DynamicObject dynamicObject = meta = src ? object.getDynamicObject("source_schema") : object.getDynamicObject("target_schema");
        if (meta == null) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7f16\u7801\u4e3a\uff1a\u3010%s\u3011\u7684\u96c6\u6210\u65b9\u6848\u5173\u8054\u96c6\u6210\u5bf9\u8c61\u7f3a\u5931\u3002", (String)"DataCopyExecLogFormPlugin_42", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), object.getString("number")));
        }
        String data = D.s((Object)(src ? this.getModel().getValue("source_data_tag") : this.getModel().getValue("target_data_tag")));
        try {
            return SchemaEncryptDataUtil.getData(D.l((Object)meta.getPkValue()), data);
        }
        catch (Exception e) {
            logger.warn("\u4e0b\u8f7d\u65e5\u5fd7\u52a0\u5bc6\u8fc7\u7a0b\u4e2d\u5931\u8d25\uff0c\u539f\u56e0\uff1a" + e.getMessage(), (Throwable)e);
            return data;
        }
    }

    public static enum RuleType {
        tlb(new MultiLangEnumBridge("\u5e38\u91cf\u8f6c\u6362", "DataCopyExecLogFormPlugin_10", "isc-iscb-platform-formplugin")),
        auto(new MultiLangEnumBridge("\u5019\u9009\u952e\u6620\u5c04", "DataCopyExecLogFormPlugin_11", "isc-iscb-platform-formplugin")),
        composite(new MultiLangEnumBridge("\u7ec4\u5408\u89c4\u5219", "DataCopyExecLogFormPlugin_12", "isc-iscb-platform-formplugin")),
        sql(new MultiLangEnumBridge("SQL", "DataCopyExecLogFormPlugin_35", "isc-iscb-platform-formplugin")),
        script(new MultiLangEnumBridge("\u811a\u672c", "DataCopyExecLogFormPlugin_13", "isc-iscb-platform-formplugin")),
        java(new MultiLangEnumBridge("Java/\u5fae\u670d\u52a1", "DataCopyExecLogFormPlugin_14", "isc-iscb-platform-formplugin")),
        mapping(new MultiLangEnumBridge("\u4eba\u5de5\u6620\u5c04", "DataCopyExecLogFormPlugin_15", "isc-iscb-platform-formplugin")),
        unknown(new MultiLangEnumBridge("\u672a\u77e5", "DataCopyExecLogFormPlugin_16", "isc-iscb-platform-formplugin"));

        private final MultiLangEnumBridge name;

        private RuleType(MultiLangEnumBridge name) {
            this.name = name;
        }

        public String getName() {
            return this.name.loadKDString();
        }
    }
}

