/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.formplugin.mq;

import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.Save;
import kd.bos.entity.operate.StatusConvert;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.operate.Modify;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.isc.iscb.formplugin.util.FormOpener;
import kd.isc.iscb.formplugin.util.InitBindDataUtil;
import kd.isc.iscb.platform.core.connector.ConnectorUtil;
import kd.isc.iscb.platform.core.connector.DatabaseType;
import kd.isc.iscb.platform.core.dc.mq.MessageQueueInitiator;
import kd.isc.iscb.platform.core.dc.mq.MessageQueueManager;
import kd.isc.iscb.platform.core.dc.mq.MessageQueueServerFactory;
import kd.isc.iscb.platform.core.factory.FactoryManager;
import kd.isc.iscb.platform.core.license.IscLicenseUtil;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.misc.Json;
import kd.isc.iscb.util.misc.StringUtil;

public class MqServerFormPlugin
extends AbstractFormPlugin {
    private static final String ISC_MQ_SERVER = "isc_mq_server";
    private static final String VHOST = "vhost";
    private static final String BOOTSTRAP_SERVERS = "bootstrap_servers";
    private static final String SERVER_PORT = "server_port";
    private static final String SERVER_IP = "server_ip";
    private static final String USER = "user";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"custom_config"});
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        DynamicObject[] types = BusinessDataServiceHelper.load((String)"isc_connection_type", (String)"number,name,index", (QFilter[])new QFilter[]{new QFilter("enable", "=", (Object)"1")});
        if (types.length == 0) {
            return;
        }
        Arrays.sort(types, new Comparator<DynamicObject>(){

            @Override
            public int compare(DynamicObject a, DynamicObject b) {
                return D.i((Object)a.get("index")) - D.i((Object)b.get("index"));
            }
        });
        ComboEdit combo = (ComboEdit)this.getView().getControl("type");
        List<ComboItem> items = InitBindDataUtil.getDefaultMq();
        items.addAll(InitBindDataUtil.getComboItems(types, MessageQueueServerFactory.class));
        combo.setComboItems(items);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        super.beforeDoOperation(e);
        Object source = e.getSource();
        if (source instanceof Save) {
            this.validateMQConfig(e);
            ConnectorUtil.setCurrentAccount((BeforeDoOperationEventArgs)e, (IDataModel)this.getModel());
        } else if (source instanceof Modify) {
            if (D.x((Object)this.getModel().getValue("enable"))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u65b9\u6848\u542f\u7528\u4e2d\uff0c\u8bf7\u5148\u7981\u7528\u540e\u4fee\u6539\u3002", (String)"MqServerFormPlugin_0", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), Integer.valueOf(1000));
                e.setCancel(true);
            }
        } else if (source instanceof StatusConvert) {
            StatusConvert convert = (StatusConvert)source;
            long id = D.l((Object)this.getModel().getValue("id"));
            if ("enable".equals(convert.getOperateKey())) {
                try {
                    MessageQueueManager.get((long)id);
                }
                catch (Exception exception) {
                    e.setCancel(true);
                    FormOpener.showErrorMessage(this.getView(), exception);
                }
            } else if ("disable".equals(convert.getOperateKey())) {
                try {
                    MessageQueueInitiator.disableAllListeners((long)id);
                    MessageQueueManager.remove((long)id);
                }
                catch (Exception exception) {
                    FormOpener.showErrorMessage(this.getView(), exception);
                }
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        if ("save".equals(operateKey)) {
            String type = D.s((Object)this.getModel().getValue("type"));
            String formId = DatabaseType.getForm((String)type);
            if (ISC_MQ_SERVER.equals(formId)) {
                return;
            }
            IscLicenseUtil.refreshCache();
            this.checkLicense();
            this.openDetailForm();
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propName = e.getProperty().getName();
        if ("type".equals(propName)) {
            String type = D.s((Object)this.getModel().getValue("type"));
            String formId = null;
            try {
                formId = DatabaseType.getForm((String)type);
                this.getView().setEnable(Boolean.TRUE, new String[]{"bar_save"});
            }
            catch (Exception exception) {
                this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u6839\u636e\u6d88\u606f\u961f\u5217\u670d\u52a1\u5de5\u5382\u7c7b\u8def\u5f84\u672a\u627e\u5230\u8be5\u7c7b\u3002\uff1a%s\u5982\u9700\u4f7f\u7528\u8be5\u5de5\u5382\u7c7b\uff0c\u9700\u8054\u7cfb\u96c6\u6210\u4e91\u90e8\u95e8\u4eba\u5458\u63d0\u4f9b\u5bf9\u5e94\u90e8\u7f72\u5305\u3002", (String)"MqServerFormPlugin_12", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), exception.getMessage()));
                this.getView().setEnable(Boolean.FALSE, new String[]{"bar_save"});
            }
            if (ISC_MQ_SERVER.equals(formId)) {
                this.getView().setVisible(Boolean.TRUE, new String[]{"flexpanelap"});
            } else {
                this.getView().setVisible(Boolean.FALSE, new String[]{"flexpanelap"});
            }
            this.setCustomParamVisible();
        }
    }

    private void setCustomParamVisible() {
        Object factory = null;
        try {
            String type = D.s((Object)this.getModel().getValue("type"));
            factory = FactoryManager.get((String)type);
        }
        catch (Exception e) {
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u6839\u636e\u6d88\u606f\u961f\u5217\u670d\u52a1\u5de5\u5382\u7c7b\u8def\u5f84\u672a\u627e\u5230\u8be5\u7c7b\u3002\uff1a%s\u5982\u9700\u4f7f\u7528\u8be5\u5de5\u5382\u7c7b\uff0c\u9700\u8054\u7cfb\u96c6\u6210\u4e91\u90e8\u95e8\u4eba\u5458\u63d0\u4f9b\u5bf9\u5e94\u90e8\u7f72\u5305\u3002", (String)"MqServerFormPlugin_12", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), e.getMessage()));
            this.getView().setEnable(Boolean.FALSE, new String[]{"bar_save"});
        }
        if (factory instanceof MessageQueueServerFactory) {
            MessageQueueServerFactory mqFactory = (MessageQueueServerFactory)factory;
            this.getView().setVisible(Boolean.valueOf(mqFactory.supportCustomParam()), new String[]{"custom_config"});
            if (!mqFactory.supportCustomParam()) {
                this.getModel().setValue("custom_config", null);
            }
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control c = (Control)evt.getSource();
        if ("custom_config".equals(c.getKey())) {
            Map<String, Object> config = this.getConfig();
            HashMap<String, Object> param = new HashMap<String, Object>();
            param.put("configuration", Json.toString(config, (boolean)true));
            param.put("edit", Boolean.TRUE);
            String caption = ResManager.loadKDString((String)"\u81ea\u5b9a\u4e49\u53c2\u6570\u914d\u7f6e", (String)"MessageSubscriberFormPlugin_1", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]);
            FormOpener.showForm(this, "isc_param_custom_config", caption, param, "getCustomParam");
        }
    }

    private Map<String, Object> getConfig() {
        String configValue = D.s((Object)this.getModel().getValue("custom_config"));
        if (StringUtil.isEmpty((String)configValue)) {
            return Collections.emptyMap();
        }
        return (Map)Json.toObject((String)configValue);
    }

    private Map<String, Object> getDefaultConfig() {
        String type = D.s((Object)this.getModel().getValue("type"));
        Object factory = FactoryManager.get((String)type);
        if (factory instanceof MessageQueueServerFactory) {
            MessageQueueServerFactory mqFactory = (MessageQueueServerFactory)factory;
            return mqFactory.getDefaultConfig();
        }
        return Collections.emptyMap();
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        Map returnMap;
        super.closedCallBack(evt);
        if ("getCustomParam".equals(evt.getActionId()) && evt.getReturnData() != null && (returnMap = (Map)Json.toObject((String)evt.getReturnData().toString())) != null && !returnMap.isEmpty()) {
            this.getModel().setValue("custom_config", evt.getReturnData());
        }
    }

    private void openDetailForm() {
        String formId = this.getView().getFormShowParameter().getFormId();
        if (ISC_MQ_SERVER.equals(formId)) {
            BillShowParameter param = new BillShowParameter();
            String type = D.s((Object)this.getModel().getValue("type"));
            param.setFormId(DatabaseType.getForm((String)type));
            param.setPkId(this.getModel().getValue("id"));
            param.getOpenStyle().setShowType(ShowType.InCurrentForm);
            param.setParentPageId(this.getView().getParentView().getPageId());
            this.getView().showForm((FormShowParameter)param);
        }
    }

    private void validateMQConfig(BeforeDoOperationEventArgs e) {
        String type = D.s((Object)this.getModel().getValue("type"));
        if (!"InternalRabbit".equals(type)) {
            this.checkLicense();
        }
        String ip = D.s((Object)this.getModel().getValue(SERVER_IP));
        long port = D.l((Object)this.getModel().getValue(SERVER_PORT));
        String servers = D.s((Object)this.getModel().getValue(BOOTSTRAP_SERVERS));
        String vHost = D.s((Object)this.getModel().getValue(VHOST));
        long id = D.l((Object)this.getModel().getValue("id"));
        QFilter filter1 = new QFilter("id", "!=", (Object)id).and(new QFilter("type", "=", (Object)type));
        QFilter filter2 = new QFilter(SERVER_IP, "=", (Object)ip);
        QFilter filter3 = new QFilter(SERVER_PORT, "=", (Object)port);
        QFilter filter4 = new QFilter(VHOST, "=", (Object)vHost);
        QFilter filter5 = new QFilter(BOOTSTRAP_SERVERS, "=", (Object)servers);
        if ("InternalRabbit".equals(type)) {
            this.getModel().setValue(SERVER_IP, null);
            this.getModel().setValue(SERVER_PORT, null);
            this.getModel().setValue(VHOST, null);
            this.getModel().setValue(BOOTSTRAP_SERVERS, null);
            this.validateInternalRabbit(e, id, filter1);
        } else if ("ExternalRabbit".equals(type)) {
            this.getModel().setValue(BOOTSTRAP_SERVERS, null);
            this.validateExternalRabbit(e, ip, port, vHost, filter1, filter2, filter3, filter4);
        } else if ("ExternalKafka".equals(type) || "ExternalRocket".equals(type)) {
            this.getModel().setValue(VHOST, null);
            this.getModel().setValue(SERVER_IP, null);
            this.getModel().setValue(SERVER_PORT, null);
            this.validateOthers(e, servers, ResManager.loadKDString((String)"\u5df2\u5b58\u5728\u76f8\u540c\u7684\u914d\u7f6e\uff0c\u8bf7\u68c0\u67e5\u8fde\u63a5\u5730\u5740!", (String)"MqServerFormPlugin_3", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), filter1, filter5);
        } else if ("ExternalMqs".equals(type)) {
            this.getModel().setValue(VHOST, null);
            this.getModel().setValue(SERVER_IP, null);
            this.getModel().setValue(SERVER_PORT, null);
            String user = D.s((Object)this.getModel().getValue(USER));
            this.validateOthers(e, servers, ResManager.loadKDString((String)"\u5df2\u5b58\u5728\u76f8\u540c\u7684\u914d\u7f6e\uff0c\u8bf7\u68c0\u67e5\u8fde\u63a5\u5730\u5740\u548c\u7528\u6237!", (String)"MqServerFormPlugin_4", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), filter1, filter5, new QFilter(USER, "=", (Object)user));
        }
    }

    private void validateInternalRabbit(BeforeDoOperationEventArgs e, long id, QFilter ... filters) {
        if (QueryServiceHelper.exists((String)ISC_MQ_SERVER, (QFilter[])filters)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u5b58\u5728\u670d\u52a1\u5668\u7c7b\u578b\u4e3a\u5185\u90e8RabbitMQ\u7684\u6d88\u606f\u961f\u5217\u670d\u52a1\uff0c\u8be5\u7c7b\u578b\u7684\u6d88\u606f\u961f\u5217\u670d\u52a1\u53ea\u5141\u8bb8\u5b58\u5728\u4e00\u4e2a\u3002", (String)"MqServerFormPlugin_5", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), Integer.valueOf(1500));
            e.setCancel(true);
            return;
        }
        if (id == 0L) {
            this.getModel().setValue("id", (Object)9999L);
        }
    }

    private void validateExternalRabbit(BeforeDoOperationEventArgs e, String ip, long port, String vHost, QFilter ... filters) {
        if (ip == null || port <= 0L) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u670d\u52a1\u5668IP\u3001\u7aef\u53e3\u4e0d\u80fd\u4e3a\u7a7a!", (String)"MqServerFormPlugin_6", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), Integer.valueOf(1500));
            e.setCancel(true);
            return;
        }
        if (vHost == null) {
            this.getModel().setValue(VHOST, (Object)"/");
        }
        if (QueryServiceHelper.exists((String)ISC_MQ_SERVER, (QFilter[])filters)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u5b58\u5728\u76f8\u540c\u7684\u914d\u7f6e\uff0c\u8bf7\u68c0\u67e5\u670d\u52a1\u5668IP\u3001\u7aef\u53e3\u548c\u865a\u62df\u4e3b\u673a!", (String)"MqServerFormPlugin_7", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), Integer.valueOf(1500));
            e.setCancel(true);
        }
    }

    private void validateOthers(BeforeDoOperationEventArgs e, String servers, String tips, QFilter ... filters) {
        if (servers == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8fde\u63a5\u5730\u5740\u4e0d\u80fd\u4e3a\u7a7a!", (String)"MqServerFormPlugin_8", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), Integer.valueOf(1500));
            e.setCancel(true);
            return;
        }
        if (QueryServiceHelper.exists((String)ISC_MQ_SERVER, (QFilter[])filters)) {
            this.getView().showTipNotification(tips, Integer.valueOf(1500));
            e.setCancel(true);
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.checkLicense();
        this.setCustomParamVisible();
    }

    private void checkLicense() {
        if (IscLicenseUtil.getTenantLicenseInfo().isExpired()) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u68c0\u67e5\u5230\u8bb8\u53ef\u5931\u6548\uff0c\u8bf7\u53ca\u65f6\u7eed\u671f\u6216\u8005\u8d2d\u4e70\u8bb8\u53ef\u3002", (String)"MqServerFormPlugin_9", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
        }
        if (this.isAddNew()) {
            if (!IscLicenseUtil.hasUnusedLicenseCount()) {
                this.getView().showMessage(ResManager.loadKDString((String)"\u5f53\u524d\u8bb8\u53ef\u4e0d\u8db3\uff0c\u4ec5\u65b0\u589e\u5185\u90e8RabbitMQ\u7c7b\u578b\u6d88\u606f\u961f\u5217\u670d\u52a1\u6709\u6548\uff0c\u8bf7\u53ca\u65f6\u8d2d\u4e70\u8bb8\u53ef\u3002", (String)"MqServerFormPlugin_10", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
            }
        } else {
            long id = D.l((Object)this.getModel().getValue("id"));
            if (!IscLicenseUtil.mqHasLicense((long)id)) {
                this.getView().showMessage(ResManager.loadKDString((String)"\u5f53\u524d\u8fde\u63a5\u6ca1\u6709\u8bb8\u53ef\uff01", (String)"MqServerFormPlugin_11", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
            }
        }
    }

    private boolean isAddNew() {
        return this.getView().getFormShowParameter().getStatus() == OperationStatus.ADDNEW;
    }
}

