/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.formplugin.msg;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.StringUtils;
import kd.isc.iscb.formplugin.util.FormOpener;
import kd.isc.iscb.formplugin.util.MsgUtil;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.misc.StringUtil;

public class DataCopyMsgSendFormPlugin
extends AbstractFormPlugin {
    private static final Pattern REGEX = Pattern.compile("(?<=\\()\\d+(?=\\))");

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.getModel().setValue("number", (Object)MsgUtil.getMsgNumber("isc_dc_bill_notify_"));
        SimpleDateFormat format = new SimpleDateFormat("yyyy-mm-dd HH:mm:ss");
        this.getModel().setValue("name", (Object)String.format(ResManager.loadKDString((String)"\u5355\u636e\u901a\u77e5%s", (String)"DataCopyMsgSendFormPlugin_7", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), format.format(new Date())));
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"person", "person_var", "outsideperson", "outsideperson_var"});
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        if ("var_for_title".equals(e.getOperateKey())) {
            this.selectNoticeVar("var_for_title", "var_for_title");
        } else if ("var_for_content".equals(e.getOperateKey())) {
            this.selectNoticeVar("var_for_content", "var_for_content");
        } else if ("modify".equals(e.getOperateKey())) {
            this.getView().setStatus(OperationStatus.EDIT);
            this.getView().setVisible(Boolean.FALSE, new String[]{"baritemap1"});
        } else if ("save".equals(e.getOperateKey()) && e.getOperationResult().isSuccess()) {
            this.getView().setStatus(OperationStatus.VIEW);
            this.getView().setVisible(Boolean.TRUE, new String[]{"baritemap1"});
        }
    }

    public void click(EventObject evt) {
        String key = ((Control)evt.getSource()).getKey();
        if ("person".equals(key)) {
            ListShowParameter parameter = ShowFormHelper.createShowListForm((String)"bos_user", (boolean)true, (int)0);
            parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "person_select"));
            String person = (String)this.getModel().getValue("person");
            Matcher matcher = REGEX.matcher(person);
            ArrayList<String> pks = new ArrayList<String>();
            while (matcher.find()) {
                pks.add(matcher.group());
            }
            parameter.setSelectedRows(pks.toArray());
            this.getView().showForm((FormShowParameter)parameter);
        } else if ("outsideperson".equals(key)) {
            String content = D.s((Object)this.getModel().getValue("outsideperson"));
            if (content != null && content.length() > 0) {
                content = content.replaceAll("\\(", ",");
                content = content.replaceAll("\\);", ";");
            }
            this.getView().showForm(MsgUtil.getFormParam("isc_msg_phonenumber", false, ShowType.Modal, "value", content, new CloseCallBack((IFormPlugin)this, "outsideperson_select")));
        } else if ("person_var".equals(key)) {
            this.selectNoticeVar(key, "person_var_select");
        } else if ("outsideperson_var".equals(key)) {
            this.selectNoticeVar(key, "outsideperson_var_select");
        }
    }

    private void selectNoticeVar(String key, String callback) {
        HashMap<String, Object> param = new HashMap<String, Object>();
        DynamicObject object = (DynamicObject)this.getModel().getValue("trigger");
        if (object == null || D.l((Object)object.getPkValue()) == 0L) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u542f\u52a8\u65b9\u6848\u518d\u9009\u62e9\u53d8\u91cf\u503c\u3002", (String)"DataCopyMsgSendFormPlugin_1", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
            return;
        }
        param.put("trigger", D.l((Object)object.getPkValue()));
        param.put("key", key);
        FormOpener.showForm(this, "isc_datacopy_var_selector", ResManager.loadKDString((String)"\u9009\u62e9\u53d8\u91cf", (String)"DataCopyMsgSendFormPlugin_2", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), param, callback);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        if (args.getSource() instanceof AbstractOperate) {
            Object id;
            DynamicObject object;
            AbstractOperate oper = (AbstractOperate)args.getSource();
            String operateKey = oper.getOperateKey();
            if ("save".equals(operateKey) && StringUtil.isEmpty((String)((String)this.getModel().getValue("person"))) && StringUtil.isEmpty((String)((String)this.getModel().getValue("outsideperson"))) && StringUtil.isEmpty((String)((String)this.getModel().getValue("person_var"))) && StringUtil.isEmpty((String)((String)this.getModel().getValue("outsideperson_var")))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6d88\u606f\u63a5\u6536\u4eba\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"DataCopyMsgSendFormPlugin_3", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), Integer.valueOf(3000));
                args.setCancel(true);
            } else if ("modify".equals(operateKey) && "1".equals((object = BusinessDataServiceHelper.loadSingle((Object)(id = this.getModel().getValue("id")), (String)"isc_dc_bill_notify")).get("state"))) {
                args.setCancel(true);
                ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("disable_notice", (IFormPlugin)this);
                String tips = ResManager.loadKDString((String)"\u7981\u7528\u540e\u624d\u80fd\u4fee\u6539\uff0c\u662f\u5426\u7981\u7528\uff1f", (String)"DataCopyMsgSendFormPlugin_4", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]);
                this.getView().showConfirm(tips, MessageBoxOptions.YesNo, confirmCallBacks);
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent evt) {
        OperationResult result;
        super.confirmCallBack(evt);
        if (evt.getResult() != MessageBoxResult.Yes) {
            return;
        }
        String callback = evt.getCallBackId();
        if ("disable_notice".equalsIgnoreCase(callback) && (result = this.getView().invokeOperation("disable")).isSuccess()) {
            this.getView().setStatus(OperationStatus.EDIT);
            this.getView().setVisible(Boolean.FALSE, new String[]{"baritemap1"});
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String actionId = closedCallBackEvent.getActionId();
        Object returnData = closedCallBackEvent.getReturnData();
        if (returnData == null) {
            return;
        }
        if ("PERSON_SELECT".equalsIgnoreCase(actionId)) {
            ListSelectedRowCollection collection = (ListSelectedRowCollection)returnData;
            this.setPersonClosedCallBack(collection, "bos_user", "person");
        } else if ("outsideperson_select".equalsIgnoreCase(actionId)) {
            Map map;
            if (returnData instanceof Map && !(map = (Map)returnData).isEmpty()) {
                String content = (String)map.get("person_phone");
                content = content.replaceAll(",", "(");
                content = content.replaceAll(";", ");");
                this.getModel().setValue("outsideperson", (Object)content);
            }
        } else if ("person_var_select".equalsIgnoreCase(actionId)) {
            this.setNoticeVar(returnData);
        } else if ("outsideperson_var_select".equalsIgnoreCase(actionId)) {
            this.setNoticeVar(returnData);
        } else if ("var_for_content".equalsIgnoreCase(actionId)) {
            this.concatVar(returnData, "msg_content");
        } else if ("var_for_title".equalsIgnoreCase(actionId)) {
            this.concatVar(returnData, "msg_title");
        }
    }

    private void concatVar(Object returnData, String key) {
        StringBuilder content = new StringBuilder((String)this.getModel().getValue(key));
        List<Map> list = new ArrayList();
        if (returnData instanceof List) {
            list = (List)returnData;
        } else if (returnData instanceof Map) {
            list.add((Map)returnData);
        }
        for (Map data : list) {
            String fieldValue = "#{" + data.get("full_number") + "}";
            content.append(fieldValue);
        }
        String s = content.toString();
        if (this.checkLength(s, key)) {
            this.getModel().setValue(key, (Object)content.toString());
        }
    }

    private boolean checkLength(String s, String key) {
        if ("msg_title".equals(key) && s.length() >= 100) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6807\u9898\u5df2\u8d85\u51fa\u6700\u5927\u957f\u5ea6100\u3002", (String)"DataCopyMsgSendFormPlugin_5", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
            return false;
        }
        if ("msg_content".equals(key) && s.length() >= 1000) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5185\u5bb9\u5df2\u8d85\u51fa\u6700\u5927\u957f\u5ea61000\u3002", (String)"DataCopyMsgSendFormPlugin_6", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private void setNoticeVar(Object returnData) {
        if (returnData instanceof Map) {
            Map data = (Map)returnData;
            String key = D.s(data.get("key"));
            String value = D.s(data.get("full_number"));
            this.getModel().setValue(key, (Object)value);
        } else if (returnData instanceof List) {
            List list = (List)returnData;
            StringBuilder sb = new StringBuilder(list.size());
            String key = null;
            for (Object obj : list) {
                Map data = (Map)obj;
                key = D.s(data.get("key"));
                String value = D.s(data.get("full_number"));
                sb.append(value).append(';');
            }
            if (!StringUtil.isEmpty(key)) {
                this.getModel().setValue(key, (Object)sb.toString());
            }
        }
    }

    private void setPersonClosedCallBack(ListSelectedRowCollection collection, String formId, String colId) {
        if (collection == null || collection.isEmpty()) {
            return;
        }
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)formId);
        DynamicObject[] dos = null;
        ArrayList<Long> selectedIds = new ArrayList<Long>();
        for (ListSelectedRow row : collection) {
            selectedIds.add((Long)row.getPrimaryKeyValue());
        }
        dos = BusinessDataServiceHelper.load((Object[])selectedIds.toArray(), (DynamicObjectType)type);
        if (dos == null || dos.length == 0) {
            return;
        }
        StringBuilder userName = new StringBuilder();
        for (int i = 0; i < dos.length; ++i) {
            if (i == dos.length - 1) {
                userName.append(dos[i].getString("name")).append('(').append(dos[i].getString("id")).append(')');
                continue;
            }
            userName.append(dos[i].getString("name")).append('(').append(dos[i].getString("id")).append("),");
        }
        if (StringUtils.isNotEmpty((String)userName.toString())) {
            this.getModel().setValue(colId, (Object)userName);
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        if (D.l((Object)this.getModel().getValue("id")) == 0L) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"baritemap1"});
        }
        boolean outsideperson = StringUtil.isEmpty((String)D.s((Object)this.getModel().getValue("outsideperson")));
        boolean outsideperson_var = StringUtil.isEmpty((String)D.s((Object)this.getModel().getValue("outsideperson_var")));
        this.getView().setVisible(Boolean.valueOf(!outsideperson), new String[]{"outsideperson"});
        this.getView().setVisible(Boolean.valueOf(!outsideperson_var), new String[]{"outsideperson_var"});
        String msg_content = D.s((Object)this.getModel().getValue("msg_content"));
        if (msg_content == null) {
            this.getModel().setValue("msg_content", (Object)ResManager.loadKDString((String)"\u5f53\u524d\u5355\u6761\u6570\u636e\u6267\u884c\u72b6\u6001\uff1a#{data_execute_status}\uff0c\u542f\u52a8\u65b9\u6848\u7f16\u7801\uff1a#{trigger_number}\uff0c\u542f\u52a8\u65b9\u6848\u540d\u79f0\uff1a#{trigger_name}\uff0c\u9519\u8bef\u4fe1\u606f\uff08\u82e5\u6709\uff09\uff1a#{$error}", (String)"DataCopyMsgSendFormPlugin_8", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
        }
    }
}

