/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.formplugin.msg;

import com.alibaba.fastjson.JSONArray;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.StringUtils;
import kd.isc.iscb.formplugin.util.MsgUtil;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.misc.StringUtil;

public class MessageNotificationFormPlugin
extends AbstractFormPlugin {
    private static final String NUMBER_CODE = "number";
    private static final String NAME_CODE = "name";
    private static final String TRIGGER = "trigger";
    private static final String PERSON = "person";
    private static final String MSGCONTENT = "msg_content";
    private static final String OUTSIDEPERSON = "outsideperson";
    private static final String ISC_TRIGGER = "isc_data_copy_trigger";
    private static final String ISC_MSG_NOTIFICATION = "isc_message_notification";
    private static final String ISC_MSG_CONTEXT = "isc_msg_content";
    private static final String ISC_MSG_PERSONPHONE = "isc_msg_phonenumber";
    private static final String BOS_USER = "bos_user";
    private static final String TRIGGER_SELECT = "trigger_select";
    private static final String MSGCONTENT_SELECT = "msgcontent_select";
    private static final String PERSONPHONE_SELECT = "personphone_select";
    private static final String PERSON_SELECT = "person_select";
    private static final String MSGOBJECT_ENTRY = "msg_object";
    private static final Pattern REGEX = Pattern.compile("(?<=\\()\\d+(?=\\))");

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{PERSON, MSGCONTENT, OUTSIDEPERSON});
    }

    public void beforeBindData(EventObject e) {
        JSONArray triggerIds = (JSONArray)this.getView().getFormShowParameter().getCustomParam("triggers");
        if (triggerIds != null) {
            DynamicObject[] triggers = BusinessDataServiceHelper.load((Object[])triggerIds.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)ISC_TRIGGER));
            this.setDefaultValue(triggers);
        }
    }

    private void setDefaultValue(DynamicObject[] triggers) {
        DynamicObjectCollection msgObjectCollection = this.getModel().getEntryEntity(MSGOBJECT_ENTRY);
        for (DynamicObject trigger : triggers) {
            DynamicObject obj = msgObjectCollection.addNew();
            obj.set(TRIGGER, (Object)trigger);
            obj.set("execute", (Object)"F,P");
        }
        this.getView().updateView(MSGOBJECT_ENTRY);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.getModel().setValue(NUMBER_CODE, (Object)MsgUtil.getMsgNumber());
        SimpleDateFormat format = new SimpleDateFormat("yyyy-mm-dd HH:mm:ss");
        this.getModel().setValue(NAME_CODE, (Object)(MessageNotificationFormPlugin.getTipsCode() + format.format(new Date())));
    }

    public void click(EventObject evt) {
        String key = ((Control)evt.getSource()).getKey();
        if (PERSON.equals(key)) {
            ListShowParameter parameter = ShowFormHelper.createShowListForm((String)BOS_USER, (boolean)true, (int)0);
            parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, PERSON_SELECT));
            String person = (String)this.getModel().getValue(PERSON);
            Matcher matcher = REGEX.matcher(person);
            ArrayList<String> pks = new ArrayList<String>();
            while (matcher.find()) {
                pks.add(matcher.group());
            }
            parameter.setSelectedRows(pks.toArray());
            this.getView().showForm((FormShowParameter)parameter);
        } else if (MSGCONTENT.equals(key)) {
            this.getView().showForm(MsgUtil.getFormParam(ISC_MSG_CONTEXT, false, ShowType.Modal, "value", this.getModel().getValue(MSGCONTENT), new CloseCallBack((IFormPlugin)this, MSGCONTENT_SELECT)));
        } else if (OUTSIDEPERSON.equals(key)) {
            this.getView().showForm(MsgUtil.getFormParam(ISC_MSG_PERSONPHONE, false, ShowType.Modal, "value", this.getModel().getValue(OUTSIDEPERSON), new CloseCallBack((IFormPlugin)this, PERSONPHONE_SELECT)));
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        Map map;
        String actionId = closedCallBackEvent.getActionId();
        if (PERSON_SELECT.equalsIgnoreCase(actionId)) {
            ListSelectedRowCollection lsrc = (ListSelectedRowCollection)closedCallBackEvent.getReturnData();
            this.setEntryFromClosedCallBack(lsrc, BOS_USER, null, PERSON);
        } else if (MSGCONTENT_SELECT.equalsIgnoreCase(actionId)) {
            Map map2 = (Map)closedCallBackEvent.getReturnData();
            if (map2 != null && !map2.isEmpty()) {
                String content = (String)map2.get("customSubject");
                this.getModel().setValue(MSGCONTENT, (Object)content);
            }
        } else if (PERSONPHONE_SELECT.equalsIgnoreCase(actionId) && (map = (Map)closedCallBackEvent.getReturnData()) != null && !map.isEmpty()) {
            String content = (String)map.get("person_phone");
            this.getModel().setValue(OUTSIDEPERSON, (Object)MsgUtil.replaceSymbol(content));
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        AbstractOperate oper;
        String operateKey;
        if (args.getSource() instanceof AbstractOperate && "save".equals(operateKey = (oper = (AbstractOperate)args.getSource()).getOperateKey())) {
            DynamicObjectCollection msgObjectCollection = this.getModel().getEntryEntity(MSGOBJECT_ENTRY);
            if (msgObjectCollection.isEmpty()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6d88\u606f\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"MessageNotificationFormPlugin_0", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), Integer.valueOf(3000));
                args.setCancel(true);
                return;
            }
            for (DynamicObject object : msgObjectCollection) {
                DynamicObject trigger = object.getDynamicObject(TRIGGER);
                if (trigger == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u6d88\u606f\u5bf9\u8c61\u4e2d\u7684\u542f\u52a8\u65b9\u6848\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"MessageNotificationFormPlugin_1", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), Integer.valueOf(3000));
                    args.setCancel(true);
                    return;
                }
                if (!StringUtils.isEmpty((String)object.getString("execute"))) continue;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6d88\u606f\u5bf9\u8c61\u4e2d\u7684\u6267\u884c\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"MessageNotificationFormPlugin_2", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), Integer.valueOf(3000));
                args.setCancel(true);
                return;
            }
            if (StringUtil.isEmpty((String)((String)this.getModel().getValue(PERSON))) && StringUtil.isEmpty((String)((String)this.getModel().getValue(OUTSIDEPERSON)))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6d88\u606f\u63a5\u6536\u4eba\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"MessageNotificationFormPlugin_3", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), Integer.valueOf(3000));
                args.setCancel(true);
                return;
            }
        }
    }

    private void setEntryFromClosedCallBack(ListSelectedRowCollection lsrc, String formId, String entryId, String colId) {
        if (lsrc == null || lsrc.isEmpty()) {
            return;
        }
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)formId);
        DynamicObject[] dos = null;
        ArrayList<Long> selectedIds = new ArrayList<Long>();
        for (ListSelectedRow row : lsrc) {
            selectedIds.add((Long)row.getPrimaryKeyValue());
        }
        dos = BusinessDataServiceHelper.load((Object[])selectedIds.toArray(), (DynamicObjectType)type);
        if (dos == null || dos.length == 0) {
            return;
        }
        StringBuilder userName = new StringBuilder();
        for (int i = 0; i < dos.length; ++i) {
            if (i == dos.length - 1) {
                userName.append(dos[i].getString(NAME_CODE)).append('(').append(dos[i].getString("id")).append(')');
                continue;
            }
            userName.append(dos[i].getString(NAME_CODE)).append('(').append(dos[i].getString("id")).append("),");
        }
        if (StringUtils.isNotEmpty((String)userName.toString())) {
            if (entryId == null) {
                this.getModel().setValue(colId, (Object)userName);
            } else {
                MsgUtil.setContent(this.getModel(), (EntryGrid)this.getControl(entryId), colId, userName.toString());
            }
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        long triggerId = D.l(this.getView().getFormShowParameter().getCustomParams().get("guide_trigger"));
        if (triggerId != 0L) {
            DynamicObjectCollection msgObject = this.getModel().getEntryEntity(MSGOBJECT_ENTRY);
            DynamicObject entity = msgObject.addNew();
            entity.set(TRIGGER, (Object)BusinessDataServiceHelper.loadSingle((Object)triggerId, (String)ISC_TRIGGER));
            this.getView().updateView(MSGOBJECT_ENTRY);
        }
        boolean empty = StringUtil.isEmpty((String)D.s((Object)this.getModel().getValue(OUTSIDEPERSON)));
        this.getView().setVisible(Boolean.valueOf(!empty), new String[]{OUTSIDEPERSON});
        String msg_content = D.s((Object)this.getModel().getValue(MSGCONTENT));
        if (msg_content == null) {
            this.getModel().setValue(MSGCONTENT, (Object)ResManager.loadKDString((String)"{name}\uff1a{number}\uff0c\u6267\u884c\u72b6\u6001\uff1a{state}\uff0c\u603b\u6570\uff1a{total_count}\uff1b\u5176\u4e2d \u6210\u529f {success_count}\uff0c\u5931\u8d25 {failed_count}\uff0c \u5ffd\u7565 {ignored_count}\uff1b\u5171\u6267\u884c{execute_count}\u6b21\uff0c\u6700\u540e\u4e00\u6b21\u6267\u884c\u4ece{start_time} \u81f3 {end_time}\uff0c\u8017\u65f6\uff1a{total_time}\uff1b", (String)"MessageNotificationFormPlugin_5", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
        }
    }

    private static String getTipsCode() {
        return ResManager.loadKDString((String)"\u96c6\u6210\u901a\u77e5_", (String)"MessageNotificationFormPlugin_4", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]);
    }
}

