/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.formplugin.msg;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.control.Control;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.util.StringUtils;
import kd.isc.iscb.formplugin.msg.vo.MsgValidateVo;

public class MsgPersonContentFormPlugin
extends AbstractFormPlugin {
    private static final String CONFIRM = "confirm";
    private static final String CANCEL = "cancel";
    private static final String CONTENT = "content";
    private static final String CELLREGEX = "^((13[0-9])|(14[5,7,9])|(15([0-3]|[5-9]))|(166)|(17[0,1,3,5,6,7,8])|(18[0-9])|(19[8|9]))\\d{8}$";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{CONFIRM, CANCEL});
    }

    /*
     * Enabled aggressive block sorting
     */
    public void click(EventObject evt) {
        String key = ((Control)evt.getSource()).getKey().toLowerCase();
        if (!CONFIRM.equals(key)) {
            if (!CANCEL.equals(key)) return;
            this.getView().close();
            return;
        }
        MsgValidateVo msgValidateVo = this.validateData(this.getModel().getValue(CONTENT).toString());
        if (msgValidateVo.getFlag().booleanValue()) {
            HashMap<String, Object> returnData = new HashMap<String, Object>();
            returnData.put("msgpersoncontent", this.getModel().getValue(CONTENT));
            this.getView().returnDataToParent(returnData);
            this.getView().close();
            return;
        }
        this.getView().showTipNotification(msgValidateVo.getErrorMsg(), Integer.valueOf(5000));
    }

    private MsgValidateVo validateData(String contextInfo) {
        boolean isExit = false;
        List<String> phones = null;
        if (StringUtils.isEmpty((String)contextInfo)) {
            return new MsgValidateVo(Boolean.TRUE, phones);
        }
        if (contextInfo.trim().length() > 100) {
            return new MsgValidateVo(Boolean.FALSE, MsgPersonContentFormPlugin.getErrorMsg1());
        }
        for (char c : contextInfo.trim().toCharArray()) {
            Character.UnicodeBlock ub = Character.UnicodeBlock.of(c);
            if (ub != Character.UnicodeBlock.GENERAL_PUNCTUATION && ub != Character.UnicodeBlock.CJK_SYMBOLS_AND_PUNCTUATION && ub != Character.UnicodeBlock.HALFWIDTH_AND_FULLWIDTH_FORMS && ub != Character.UnicodeBlock.CJK_COMPATIBILITY_FORMS && ub != Character.UnicodeBlock.VERTICAL_FORMS) continue;
            isExit = true;
            break;
        }
        if (isExit) {
            return new MsgValidateVo(Boolean.FALSE, MsgPersonContentFormPlugin.getErrorMsg2());
        }
        String[] persons = contextInfo.trim().split(";");
        return this.checkCell(persons);
    }

    public MsgValidateVo checkCell(String[] persons) {
        String[] cells = null;
        ArrayList<String> phones = new ArrayList<String>(persons.length);
        for (String str : persons) {
            if (!str.contains(",")) {
                return new MsgValidateVo(Boolean.FALSE, MsgPersonContentFormPlugin.getErrorMsg3() + str);
            }
            cells = str.split(",");
            if (cells.length != 2) {
                phones.clear();
                return new MsgValidateVo(Boolean.FALSE, MsgPersonContentFormPlugin.getErrorMsg3() + str);
            }
            if (cells[1].length() != 11) {
                phones.clear();
                return new MsgValidateVo(Boolean.FALSE, MsgPersonContentFormPlugin.getErrorMsg4() + cells[1]);
            }
            Pattern p = Pattern.compile(CELLREGEX);
            Matcher m = p.matcher(cells[1]);
            if (!m.matches()) {
                phones.clear();
                return new MsgValidateVo(Boolean.FALSE, MsgPersonContentFormPlugin.getErrorMsg5() + cells[1]);
            }
            phones.add(cells[1]);
        }
        return new MsgValidateVo(Boolean.TRUE, phones);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        if (StringUtils.isNotEmpty((String)((String)this.getView().getFormShowParameter().getCustomParam("value")))) {
            this.getModel().setValue(CONTENT, this.getView().getFormShowParameter().getCustomParam("value"));
        }
    }

    private static String getErrorMsg1() {
        return ResManager.loadKDString((String)"\u586b\u5199\u5185\u5bb9\u957f\u5ea6\u8d85\u8fc7100.", (String)"MsgPersonContentFormPlugin_0", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]);
    }

    private static String getErrorMsg2() {
        return ResManager.loadKDString((String)"\u586b\u5199\u5185\u5bb9\u5305\u62ec\u4e2d\u6587\u7b26\u53f7.", (String)"MsgPersonContentFormPlugin_1", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]);
    }

    private static String getErrorMsg3() {
        return ResManager.loadKDString((String)"\u586b\u5199\u7684\u5185\u5bb9\u7684\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c\u9519\u8bef\u5185\u5bb9\uff1a", (String)"MsgPersonContentFormPlugin_2", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]);
    }

    private static String getErrorMsg4() {
        return ResManager.loadKDString((String)"\u624b\u673a\u53f7\u5e94\u4e3a11\u4f4d\u6570.", (String)"MsgPersonContentFormPlugin_3", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]);
    }

    private static String getErrorMsg5() {
        return ResManager.loadKDString((String)"\u586b\u5199\u7684\u624b\u673a\u53f7\u4e0d\u5408\u6cd5.", (String)"MsgPersonContentFormPlugin_4", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]);
    }
}

