/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.formplugin.msg;

import java.util.EventObject;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.control.Control;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.util.StringUtils;
import kd.isc.iscb.util.misc.StringUtil;

public class MsgPersonPhoneFormPlugin
extends AbstractFormPlugin {
    private static final String CONFIRM = "confirm";
    private static final String CANCEL = "cancel";
    private static final Pattern CELLREGEX = Pattern.compile("^((13[0-9])|(14[5,7,9])|(15([0-3]|[5-9]))|(166)|(17[0,1,3,5,6,7,8])|(18[0-9])|(19[8|9]))\\d{8}$");

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{CONFIRM, CANCEL});
    }

    public void click(EventObject evt) {
        String key = ((Control)evt.getSource()).getKey().toLowerCase();
        if (CONFIRM.equals(key)) {
            StringBuilder errorMes = new StringBuilder();
            StringBuilder data = new StringBuilder();
            DynamicObjectCollection collection = this.getModel().getEntryEntity("entryentity");
            for (int i = 0; i < collection.size(); ++i) {
                DynamicObject object = (DynamicObject)collection.get(i);
                String name = object.getString("name");
                String phone = object.getString("phone");
                if (StringUtil.isEmpty((String)name) || StringUtil.isEmpty((String)phone)) {
                    errorMes.append('\u7b2c').append(i + 1).append(ResManager.loadKDString((String)"\u884c:\u59d3\u540d\u548c\u624b\u673a\u53f7\u7801\u90fd\u4e0d\u80fd\u4e3a\u7a7a", (String)"MsgPersonPhoneFormPlugin_4", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0])).append('\n');
                    continue;
                }
                if (name.contains(",") || name.contains(";")) {
                    errorMes.append('\u7b2c').append(i + 1).append(ResManager.loadKDString((String)"\u884c:\u59d3\u540d\u542b\u6709\u975e\u6cd5\u5b57\u7b26", (String)"MsgPersonPhoneFormPlugin_5", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0])).append('\n');
                    continue;
                }
                if (!StringUtil.isEmpty((String)phone) && phone.length() != 11) {
                    errorMes.append('\u7b2c').append(i + 1).append(ResManager.loadKDString((String)"\u884c:\u624b\u673a\u53f7\u7801\u957f\u5ea6\u5e94\u4e3a11\u4f4d", (String)"MsgPersonPhoneFormPlugin_6", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0])).append('\n');
                    continue;
                }
                Matcher m = CELLREGEX.matcher(phone);
                if (!m.matches()) {
                    errorMes.append('\u7b2c').append(i + 1).append(ResManager.loadKDString((String)"\u884c:\u624b\u673a\u53f7\u4e0d\u5408\u6cd5", (String)"MsgPersonPhoneFormPlugin_7", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0])).append('\n');
                    continue;
                }
                data.append(name).append(',').append(phone).append(';');
            }
            if (errorMes.length() != 0) {
                this.getView().showErrorNotification(errorMes.toString());
                return;
            }
            HashMap<String, String> returnData = new HashMap<String, String>();
            returnData.put("person_phone", data.toString());
            this.getView().returnDataToParent(returnData);
            this.getView().close();
        } else if (CANCEL.equals(key)) {
            this.getView().close();
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        if (StringUtils.isNotEmpty((String)((String)this.getView().getFormShowParameter().getCustomParam("value")))) {
            String content = (String)this.getView().getFormShowParameter().getCustomParam("value");
            String[] entries = content.split(";");
            DynamicObjectCollection collection = this.getModel().getEntryEntity("entryentity");
            for (String entry : entries) {
                DynamicObject obj = collection.addNew();
                String[] strs = entry.split(",");
                obj.set("name", (Object)strs[0]);
                obj.set("phone", (Object)strs[1]);
            }
        }
    }
}

