/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.formplugin.msg;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.control.Control;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.util.StringUtils;

public class NoticeBaseFormPlugin
extends AbstractFormPlugin {
    private static final String CONFIRM = "confirm";
    private static final String CANCEL = "cancel";
    private static final String CONTENT = "content";
    private static final String PREFIX = "prefix";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{CONFIRM, CANCEL});
    }

    public void click(EventObject evt) {
        String key = ((Control)evt.getSource()).getKey().toLowerCase();
        if (CONFIRM.equals(key)) {
            HashMap<String, Object> returnData = new HashMap<String, Object>();
            returnData.put(CONTENT, this.getModel().getValue(CONTENT));
            this.getView().returnDataToParent(returnData);
        }
        this.getView().close();
    }

    public void afterCreateNewData(EventObject e) {
        this.setFieldComboItems();
        String content = (String)this.getView().getFormShowParameter().getCustomParam("value");
        String preFix = (String)this.getView().getFormShowParameter().getCustomParam(PREFIX);
        if (preFix != null) {
            this.getPageCache().put(PREFIX, preFix);
        } else {
            this.getPageCache().put(PREFIX, "#");
        }
        this.getModel().setValue(CONTENT, (Object)content);
    }

    private void setFieldComboItems() {
        Map properties = (Map)this.getView().getFormShowParameter().getCustomParam("properties");
        ArrayList<ComboItem> items = new ArrayList<ComboItem>(properties.size());
        for (Map.Entry entry : properties.entrySet()) {
            ComboItem item = new ComboItem();
            item.setValue((String)entry.getKey());
            item.setCaption(new LocaleString((String)entry.getValue()));
            items.add(item);
        }
        ComboEdit fieldCombo = (ComboEdit)this.getControl("field");
        fieldCombo.setComboItems(items);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String field;
        String propertyName = e.getProperty().getName().toLowerCase();
        Map properties = (Map)this.getView().getFormShowParameter().getCustomParam("properties");
        String preFix = this.getPageCache().get(PREFIX);
        if ("field".equals(propertyName) && StringUtils.isNotEmpty((String)(field = (String)this.getModel().getValue("field")))) {
            String content = (String)this.getModel().getValue(CONTENT);
            String fieldValue = (String)properties.get(field) + "\uff1a" + preFix + "{" + field + "}\uff1b";
            content = content + fieldValue;
            this.getModel().setValue(CONTENT, (Object)content);
        }
    }
}

