/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.formplugin.panel;

import java.io.Serializable;
import java.lang.constant.Constable;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.entity.ListboxItem;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.ext.form.control.Listbox;
import kd.bos.form.chart.Axis;
import kd.bos.form.chart.AxisType;
import kd.bos.form.chart.BarSeries;
import kd.bos.form.chart.Chart;
import kd.bos.form.chart.GradientItem;
import kd.bos.form.chart.HistogramChart;
import kd.bos.form.chart.Label;
import kd.bos.form.chart.LineSeries;
import kd.bos.form.chart.PieChart;
import kd.bos.form.chart.PieSeries;
import kd.bos.form.chart.PointLineChart;
import kd.bos.form.chart.Position;
import kd.bos.form.chart.RoseType;
import kd.bos.form.chart.Series;
import kd.bos.form.chart.XAlign;
import kd.bos.form.chart.YAlign;
import kd.bos.form.container.Tab;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ListboxClickListener;
import kd.bos.form.control.events.ListboxEvent;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.isc.iscb.util.db.DbUtil;
import kd.isc.iscb.util.dt.D;

public class StatisticalDataPanelFormPlugin
extends AbstractFormPlugin
implements TabSelectListener,
ListboxClickListener {
    private static final String TOOLTIP = "tooltip";
    private static final String DATA_KEY = "data_key";
    private static final String FLOW_KEY = "flow_key";
    private static final String TIME_UNIT_DAY = "day";
    private static final String API_KEY = "api_key";
    private static final String FMQ_CONSUMED_COUNT = "fmq_consumed_count";
    private static final String FMQ_PUBISHED_COUNT = "fmq_pubished_count";
    private static final String TIME_UNIT_MONTH = "month";
    private static final String MQ_KEY = "mq_key";
    private static final String STYLE_NORMAL = "normal";
    private static final String ITEM_STYLE = "itemStyle";
    private static final String LABEL2 = "label";
    private static final String LINE_TYPE = "type";
    private static final String LINE_COLOR = "color";
    private static final String FORMATTER = "formatter";
    private static final String LISTBOX_MQ = "listbox_mq";
    private static final String LISTBOX_API = "listbox_api";
    private static final String LISTBOX_FLOW = "listbox_flow";
    private static final String LISTBOX_DATA = "listbox_data";
    private static final String COLOR_6 = "#45DADE";
    private static final String COLOR_4 = "#989D9E";
    private static final String COLOR_5 = "#6682F5";
    private static final String COLOR_3 = "#9F69E2";
    private static final String COLOR_2 = "#40A9FF";
    private static final String COLOR_1 = "#45DAD1";
    private static final int QUARTER = 4;
    private static final int MONTH = 12;
    private static final int HOUR = 24;
    private static final int NEARLY_30_DAYS = 30;
    private static final String[] DATA_COLOR = new String[]{"#45DAD1", "#40A9FF", "#9F69E2"};
    private static final String[] FLOW_COLOR = new String[]{"#6682F5", "#989D9E"};
    private static final String[] API_COLOR = new String[]{"#45DADE", "#989D9E"};
    private static final String[] MQ_COLOR = new String[]{"#40A9FF", "#45DAD1"};

    public void afterCreateNewData(EventObject e) {
        this.showAllFlex();
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        Tab tab = (Tab)this.getView().getControl("tabap");
        tab.addTabSelectListener((TabSelectListener)this);
        Listbox listbox_data = (Listbox)this.getView().getControl(LISTBOX_DATA);
        listbox_data.addListboxClickListener((ListboxClickListener)this);
        Listbox listbox_flow = (Listbox)this.getView().getControl(LISTBOX_FLOW);
        listbox_flow.addListboxClickListener((ListboxClickListener)this);
        Listbox listbox_api = (Listbox)this.getView().getControl(LISTBOX_API);
        listbox_api.addListboxClickListener((ListboxClickListener)this);
        Listbox listbox_mq = (Listbox)this.getView().getControl(LISTBOX_MQ);
        listbox_mq.addListboxClickListener((ListboxClickListener)this);
    }

    private PointLineChart setPointLineChartStyle(String lineChartName, String titleName) {
        Control pointlinechartap = this.getControl(lineChartName);
        PointLineChart pointLineChart = (PointLineChart)pointlinechartap;
        pointLineChart.setName(new LocaleString(titleName));
        Axis yAxis = pointLineChart.createYAxis(ResManager.loadKDString((String)"\u6570\u91cf/\u6b21", (String)"StatisticalDataPanelFormPlugin_16", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), AxisType.value);
        this.setToolTipStyle((Chart)pointLineChart);
        this.setSplitLineStyle(yAxis);
        this.setAxisLineStyle(yAxis);
        this.setAxisTickStyle(yAxis);
        HashMap<String, String> map = new HashMap<String, String>(1);
        map.put(FORMATTER, "function (value, index) { if(value<0){ return -value; }else{return value}}");
        yAxis.setPropValue("axisLabel", map);
        ArrayList<Object> toolTipFuncPath = new ArrayList<Object>();
        toolTipFuncPath.add("yAxis");
        toolTipFuncPath.add(0);
        toolTipFuncPath.add("axisLabel");
        toolTipFuncPath.add(FORMATTER);
        pointLineChart.addFuncPath(toolTipFuncPath);
        pointLineChart.setShowLegend(true);
        pointLineChart.setLegendAlign(XAlign.right, YAlign.top);
        pointLineChart.setMargin(Position.left, "30px");
        pointLineChart.setShowTooltip(true);
        return pointLineChart;
    }

    private void setSplitLineStyle(Axis axis) {
        HashMap<String, Serializable> splitLine = new HashMap<String, Serializable>();
        HashMap<String, String> lineStyle = new HashMap<String, String>();
        lineStyle.put(LINE_TYPE, "dotted");
        lineStyle.put(LINE_COLOR, "#E2E2E2");
        splitLine.put("lineStyle", lineStyle);
        splitLine.put("show", Boolean.TRUE);
        axis.setPropValue("splitLine", splitLine);
    }

    private HistogramChart setHistogramChartStyle(String histogramchartName, String titleName) {
        Control histogramchart_data = this.getControl(histogramchartName);
        HistogramChart histogramChart = (HistogramChart)histogramchart_data;
        histogramChart.setName(new LocaleString(titleName));
        this.setToolTipStyle((Chart)histogramChart);
        Axis yAxis = histogramChart.createYAxis("histogramchart_mq_b".equals(histogramchartName) ? ResManager.loadKDString((String)"\u6d41\u91cf/\u5b57\u8282", (String)"StatisticalDataPanelFormPlugin_17", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u6570\u91cf/\u6b21", (String)"StatisticalDataPanelFormPlugin_16", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), AxisType.log);
        this.setSplitLineStyle(yAxis);
        this.setAxisLineStyle(yAxis);
        this.setAxisTickStyle(yAxis);
        histogramChart.setMargin(Position.left, "30px");
        histogramChart.setShowLegend(true);
        histogramChart.setShowTooltip(true);
        return histogramChart;
    }

    private void setXAxisStyle(Axis xAxis) {
        xAxis.setPosition(Position.bottom);
        HashMap<String, int[]> xaMap = new HashMap<String, int[]>(1);
        int[] xa = new int[]{0, 0, -25, -35};
        xaMap.put("padding", xa);
        xAxis.setPropValue("nameGap", (Object)"5");
        xAxis.setPropValue("nameTextStyle", xaMap);
        this.setAxisTickStyle(xAxis);
        this.setAxisLineStyle(xAxis);
        HashMap<String, Object> axisPointer = new HashMap<String, Object>();
        HashMap<String, String> shadowStyle = new HashMap<String, String>();
        axisPointer.put("show", Boolean.TRUE);
        axisPointer.put(LINE_TYPE, "shadow");
        shadowStyle.put(LINE_COLOR, "rgba(150,150,150,0.3)");
        axisPointer.put("shadowStyle", shadowStyle);
        xAxis.setPropValue("axisPointer", axisPointer);
    }

    private void showAllFlex() {
        this.showAllTitleData();
        Control piechartap = this.getControl("piechartap");
        this.showOrUpdatePieChart(piechartap);
        Control histogramchartap = this.getControl("histogramchartap");
        this.showCustomChartByQuarter(histogramchartap);
        this.getView().updateView("flex_label");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void showData(String selectField, String flexName, String labelDay, String labelMonth, String labelYear, String type) {
        Timestamp lastMonth = D.t((Object)(this.getInitTime().getTime() - 2505600000L));
        Calendar calendar = Calendar.getInstance();
        calendar.add(2, -12);
        List<Timestamp> valuesYear = Collections.singletonList(D.t((Object)calendar.getTime()));
        List<Timestamp> valuesMonth = Collections.singletonList(lastMonth);
        List<Timestamp> values = Collections.singletonList(D.t((Object)this.getInitTime()));
        List<Integer> types = Collections.singletonList(93);
        Connection cn = TX.getConnection((String)"ISCB", (boolean)true, (String[])new String[0]);
        try {
            if ("decimal".equals(type)) {
                BigDecimal count = D.n((Object)DbUtil.executeScalar((Connection)cn, (String)("select " + selectField + " from T_ISCB_RUNTIME_STAT where FCREATED_TIME >= ?"), values, types));
                this.getModel().setValue(labelDay, (Object)count);
                count = D.n((Object)DbUtil.executeScalar((Connection)cn, (String)("select " + selectField + " from T_ISCB_RUNTIME_STAT where FCREATED_TIME >= ?"), valuesMonth, types));
                this.getModel().setValue(labelMonth, (Object)count);
                count = D.n((Object)DbUtil.executeScalar((Connection)cn, (String)("select " + selectField + " from T_ISCB_RUNTIME_STAT where FCREATED_TIME >= ?"), valuesYear, types));
                this.getModel().setValue(labelYear, (Object)count);
            } else {
                long count = D.l((Object)DbUtil.executeScalar((Connection)cn, (String)("select " + selectField + " from T_ISCB_RUNTIME_STAT where FCREATED_TIME >= ?"), values, types));
                this.getModel().setValue(labelDay, (Object)count);
                count = D.l((Object)DbUtil.executeScalar((Connection)cn, (String)("select " + selectField + " from T_ISCB_RUNTIME_STAT where FCREATED_TIME >= ?"), valuesMonth, types));
                this.getModel().setValue(labelMonth, (Object)count);
                count = D.l((Object)DbUtil.executeScalar((Connection)cn, (String)("select " + selectField + " from T_ISCB_RUNTIME_STAT where FCREATED_TIME >= ?"), valuesYear, types));
                this.getModel().setValue(labelYear, (Object)count);
            }
            this.getView().updateView(flexName);
        }
        finally {
            DbUtil.close((Connection)cn, (boolean)false);
        }
    }

    private void setXAxisCategoryByYear(Axis xAxis) {
        ArrayList<String> data = new ArrayList<String>(12);
        this.setXAxisStyle(xAxis);
        Date initTime = this.getInitTime();
        Calendar calendar = Calendar.getInstance();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy.MM");
        for (int i = 12; i > 0; --i) {
            calendar.setTime(initTime);
            calendar.add(2, 1 - i);
            String category = sdf.format(calendar.getTime());
            data.add(category);
        }
        xAxis.setCategorys(data);
    }

    private void setXAxisCategoryByMonth(Axis xAxis) {
        this.setXAxisStyle(xAxis);
        Date initTime = this.getInitTime();
        ArrayList<String> data = new ArrayList<String>(30);
        for (int i = 30; i > 0; --i) {
            Date date = new Date(initTime.getTime() - (long)(i - 1) * 86400000L);
            SimpleDateFormat sdf = new SimpleDateFormat("MM.dd");
            data.add(D.s((Object)sdf.format(date)));
        }
        xAxis.setCategorys(data);
    }

    private void setXAxisCategoryByDay(Axis xAxis) {
        ArrayList<String> data = new ArrayList<String>(24);
        this.setXAxisStyle(xAxis);
        for (int i = 0; i < 24; ++i) {
            data.add(D.s((Object)i) + ":00");
        }
        xAxis.setCategorys(data);
    }

    private void setTabDataByYear(PointLineChart pointLineChart) {
        pointLineChart.setLegendAlign(XAlign.right, YAlign.top);
        Axis xAxis = pointLineChart.createXAxis("", AxisType.category);
        LineSeries seriesDcr = pointLineChart.createSeries(ResManager.loadKDString((String)"\u6570\u636e\u96c6\u6210\u8bfb\u53d6", (String)"StatisticalDataPanelFormPlugin_18", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
        LineSeries seriesDct = pointLineChart.createSeries(ResManager.loadKDString((String)"\u6570\u636e\u96c6\u6210\u8f6c\u6362", (String)"StatisticalDataPanelFormPlugin_19", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
        LineSeries seriesDcw = pointLineChart.createSeries(ResManager.loadKDString((String)"\u6570\u636e\u96c6\u6210\u52a0\u8f7d", (String)"StatisticalDataPanelFormPlugin_20", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
        this.setXAxisCategoryByYear(xAxis);
        List<Object> numsDcr = this.getNumsByMonth("SUM(fdcr_total_count)", false);
        seriesDcr.setPropValue("data", numsDcr);
        List<Object> numsDct = this.getNumsByMonth("SUM(fdct_total_count)", false);
        seriesDct.setPropValue("data", numsDct);
        List<Object> numsDcw = this.getNumsByMonth("SUM(fdcw_total_count)", false);
        seriesDcw.setPropValue("data", numsDcw);
        this.setDataSeriesColor((Series)seriesDcr, (Series)seriesDct, (Series)seriesDcw);
    }

    private void setDataSeriesColor(Series seriesDcr, Series seriesDct, Series seriesDcw) {
        this.setSeriesColor(seriesDcr, DATA_COLOR[0]);
        this.setSeriesColor(seriesDct, DATA_COLOR[1]);
        this.setSeriesColor(seriesDcw, DATA_COLOR[2]);
    }

    private void setTabDataByYear(HistogramChart histogramChart) {
        Axis xAxis = histogramChart.createXAxis("", AxisType.category);
        histogramChart.setLegendAlign(XAlign.right, YAlign.top);
        BarSeries seriesDcr = histogramChart.createBarSeries(ResManager.loadKDString((String)"\u6570\u636e\u96c6\u6210\u8bfb\u53d6", (String)"StatisticalDataPanelFormPlugin_18", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
        BarSeries seriesDct = histogramChart.createBarSeries(ResManager.loadKDString((String)"\u6570\u636e\u96c6\u6210\u8f6c\u6362", (String)"StatisticalDataPanelFormPlugin_19", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
        BarSeries seriesDcw = histogramChart.createBarSeries(ResManager.loadKDString((String)"\u6570\u636e\u96c6\u6210\u52a0\u8f7d", (String)"StatisticalDataPanelFormPlugin_20", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
        this.setXAxisCategoryByYear(xAxis);
        List<Object> numsDcr = this.getNumsByMonth("SUM(fdcr_total_count)", true);
        seriesDcr.setPropValue("data", numsDcr);
        seriesDcr.setLabel((Label)null);
        List<Object> numsDct = this.getNumsByMonth("SUM(fdct_total_count)", true);
        seriesDct.setPropValue("data", numsDct);
        seriesDct.setLabel((Label)null);
        List<Object> numsDcw = this.getNumsByMonth("SUM(fdcw_total_count)", true);
        seriesDcw.setPropValue("data", numsDcw);
        seriesDcw.setLabel((Label)null);
        this.setDataSeriesColor((Series)seriesDcr, (Series)seriesDct, (Series)seriesDcw);
    }

    private void setTabDataByMonth(PointLineChart pointLineChart) {
        Axis xAxis = pointLineChart.createXAxis("", AxisType.category);
        LineSeries seriesDcr = pointLineChart.createSeries(ResManager.loadKDString((String)"\u6570\u636e\u96c6\u6210\u8bfb\u53d6", (String)"StatisticalDataPanelFormPlugin_18", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
        LineSeries seriesDct = pointLineChart.createSeries(ResManager.loadKDString((String)"\u6570\u636e\u96c6\u6210\u8f6c\u6362", (String)"StatisticalDataPanelFormPlugin_19", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
        LineSeries seriesDcw = pointLineChart.createSeries(ResManager.loadKDString((String)"\u6570\u636e\u96c6\u6210\u52a0\u8f7d", (String)"StatisticalDataPanelFormPlugin_20", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
        this.setXAxisCategoryByMonth(xAxis);
        List<Object> numsDcr = this.getNumsByDay("SUM(fdcr_total_count)", false);
        seriesDcr.setPropValue("data", numsDcr);
        List<Object> numsDct = this.getNumsByDay("SUM(fdct_total_count)", false);
        seriesDct.setPropValue("data", numsDct);
        List<Object> numsDcw = this.getNumsByDay("SUM(fdcw_total_count)", false);
        seriesDcw.setPropValue("data", numsDcw);
        this.setDataSeriesColor((Series)seriesDcr, (Series)seriesDct, (Series)seriesDcw);
    }

    private void setTabDataByMonth(HistogramChart histogramChart) {
        Axis xAxis = histogramChart.createXAxis("", AxisType.category);
        BarSeries seriesDcr = histogramChart.createBarSeries(ResManager.loadKDString((String)"\u6570\u636e\u96c6\u6210\u8bfb\u53d6", (String)"StatisticalDataPanelFormPlugin_18", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
        BarSeries seriesDct = histogramChart.createBarSeries(ResManager.loadKDString((String)"\u6570\u636e\u96c6\u6210\u8f6c\u6362", (String)"StatisticalDataPanelFormPlugin_19", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
        BarSeries seriesDcw = histogramChart.createBarSeries(ResManager.loadKDString((String)"\u6570\u636e\u96c6\u6210\u52a0\u8f7d", (String)"StatisticalDataPanelFormPlugin_20", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
        this.setXAxisCategoryByMonth(xAxis);
        List<Object> numsDcr = this.getNumsByDay("SUM(fdcr_total_count)", true);
        seriesDcr.setPropValue("data", numsDcr);
        seriesDcr.setLabel((Label)null);
        List<Object> numsDct = this.getNumsByDay("SUM(fdct_total_count)", true);
        seriesDct.setPropValue("data", numsDct);
        seriesDct.setLabel((Label)null);
        List<Object> numsDcw = this.getNumsByDay("SUM(fdcw_total_count)", true);
        seriesDcw.setPropValue("data", numsDcw);
        seriesDcw.setLabel((Label)null);
        this.setDataSeriesColor((Series)seriesDcr, (Series)seriesDct, (Series)seriesDcw);
    }

    private void setTabDataByDay(PointLineChart pointLineChart) {
        Axis xAxis = pointLineChart.createXAxis("", AxisType.category);
        LineSeries seriesDcr = pointLineChart.createSeries(ResManager.loadKDString((String)"\u6570\u636e\u96c6\u6210\u8bfb\u53d6", (String)"StatisticalDataPanelFormPlugin_18", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
        LineSeries seriesDct = pointLineChart.createSeries(ResManager.loadKDString((String)"\u6570\u636e\u96c6\u6210\u8f6c\u6362", (String)"StatisticalDataPanelFormPlugin_19", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
        LineSeries seriesDcw = pointLineChart.createSeries(ResManager.loadKDString((String)"\u6570\u636e\u96c6\u6210\u52a0\u8f7d", (String)"StatisticalDataPanelFormPlugin_20", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
        this.setXAxisCategoryByDay(xAxis);
        List<Object> numsDcr = this.getNumsByHour("SUM(fdcr_total_count)", false);
        seriesDcr.setPropValue("data", numsDcr);
        List<Object> numsDct = this.getNumsByHour("SUM(fdct_total_count)", false);
        seriesDct.setPropValue("data", numsDct);
        List<Object> numsDcw = this.getNumsByHour("SUM(fdcw_total_count)", false);
        seriesDcw.setPropValue("data", numsDcw);
        this.setDataSeriesColor((Series)seriesDcr, (Series)seriesDct, (Series)seriesDcw);
    }

    private void setTabDataByDay(HistogramChart histogramChart) {
        Axis xAxis = histogramChart.createXAxis("", AxisType.category);
        BarSeries seriesDcr = histogramChart.createBarSeries(ResManager.loadKDString((String)"\u6570\u636e\u96c6\u6210\u8bfb\u53d6", (String)"StatisticalDataPanelFormPlugin_18", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
        BarSeries seriesDct = histogramChart.createBarSeries(ResManager.loadKDString((String)"\u6570\u636e\u96c6\u6210\u8f6c\u6362", (String)"StatisticalDataPanelFormPlugin_19", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
        BarSeries seriesDcw = histogramChart.createBarSeries(ResManager.loadKDString((String)"\u6570\u636e\u96c6\u6210\u52a0\u8f7d", (String)"StatisticalDataPanelFormPlugin_20", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
        this.setXAxisCategoryByDay(xAxis);
        List<Object> numsDcr = this.getNumsByHour("SUM(fdcr_total_count)", true);
        seriesDcr.setPropValue("data", numsDcr);
        seriesDcr.setLabel((Label)null);
        List<Object> numsDct = this.getNumsByHour("SUM(fdct_total_count)", true);
        seriesDct.setPropValue("data", numsDct);
        seriesDct.setLabel((Label)null);
        List<Object> numsDcw = this.getNumsByHour("SUM(fdcw_total_count)", true);
        seriesDcw.setPropValue("data", numsDcw);
        seriesDcw.setLabel((Label)null);
        this.setDataSeriesColor((Series)seriesDcr, (Series)seriesDct, (Series)seriesDcw);
    }

    private void setTabFlowByYear(PointLineChart pointLineChart) {
        Axis xAxis = pointLineChart.createXAxis("", AxisType.category);
        LineSeries seriesSft = pointLineChart.createSeries(ResManager.loadKDString((String)"\u670d\u52a1\u6d41\u7a0b\u53d1\u8d77\u6b21\u6570", (String)"StatisticalDataPanelFormPlugin_21", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
        LineSeries seriesSff = pointLineChart.createSeries(ResManager.loadKDString((String)"\u670d\u52a1\u6d41\u7a0b\u5931\u8d25\u6b21\u6570", (String)"StatisticalDataPanelFormPlugin_22", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
        this.setXAxisCategoryByYear(xAxis);
        List<Object> numsSft = this.getNumsByMonth("SUM(fsf_total_count)", false);
        seriesSft.setPropValue("data", numsSft);
        List<Object> numsSff = this.getNumsByMonth("SUM(fsf_failed_count)", false);
        seriesSff.setPropValue("data", numsSff);
        this.setFlowSeriesColor((Series)seriesSft, (Series)seriesSff);
    }

    private void setFlowSeriesColor(Series seriesSft, Series seriesSff) {
        this.setSeriesColor(seriesSft, FLOW_COLOR[0]);
        this.setSeriesColor(seriesSff, FLOW_COLOR[1]);
    }

    private void setTabFlowByMonth(PointLineChart pointLineChart) {
        Axis xAxis = pointLineChart.createXAxis("", AxisType.category);
        LineSeries seriesSft = pointLineChart.createSeries(ResManager.loadKDString((String)"\u670d\u52a1\u6d41\u7a0b\u53d1\u8d77\u6b21\u6570", (String)"StatisticalDataPanelFormPlugin_21", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
        LineSeries seriesSff = pointLineChart.createSeries(ResManager.loadKDString((String)"\u670d\u52a1\u6d41\u7a0b\u5931\u8d25\u6b21\u6570", (String)"StatisticalDataPanelFormPlugin_22", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
        this.setXAxisCategoryByMonth(xAxis);
        List<Object> numsSft = this.getNumsByDay("SUM(fsf_total_count)", false);
        seriesSft.setPropValue("data", numsSft);
        List<Object> numsSff = this.getNumsByDay("SUM(fsf_failed_count)", false);
        seriesSff.setPropValue("data", numsSff);
        this.setFlowSeriesColor((Series)seriesSft, (Series)seriesSff);
    }

    private void setTabFlowByDay(PointLineChart pointLineChart) {
        Axis xAxis = pointLineChart.createXAxis("", AxisType.category);
        LineSeries seriesSft = pointLineChart.createSeries(ResManager.loadKDString((String)"\u670d\u52a1\u6d41\u7a0b\u53d1\u8d77\u6b21\u6570", (String)"StatisticalDataPanelFormPlugin_21", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
        LineSeries seriesSff = pointLineChart.createSeries(ResManager.loadKDString((String)"\u670d\u52a1\u6d41\u7a0b\u5931\u8d25\u6b21\u6570", (String)"StatisticalDataPanelFormPlugin_22", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
        this.setXAxisCategoryByDay(xAxis);
        List<Object> numsSft = this.getNumsByHour("SUM(fsf_total_count)", false);
        seriesSft.setPropValue("data", numsSft);
        List<Object> numsSff = this.getNumsByHour("SUM(fsf_failed_count)", false);
        seriesSff.setPropValue("data", numsSff);
        this.setFlowSeriesColor((Series)seriesSft, (Series)seriesSff);
    }

    private void setTabApiByYear(PointLineChart pointLineChart) {
        Axis xAxis = pointLineChart.createXAxis("", AxisType.category);
        LineSeries seriesApit = pointLineChart.createSeries(ResManager.loadKDString((String)"API\u8c03\u7528\u603b\u6b21\u6570", (String)"StatisticalDataPanelFormPlugin_23", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
        LineSeries seriesApif = pointLineChart.createSeries(ResManager.loadKDString((String)"API\u8c03\u7528\u5931\u8d25\u6b21\u6570", (String)"StatisticalDataPanelFormPlugin_24", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
        this.setXAxisCategoryByYear(xAxis);
        List<Object> numsApit = this.getNumsByMonth("SUM(fapi_total_count)", false);
        seriesApit.setPropValue("data", numsApit);
        List<Object> numsApif = this.getNumsByMonth("SUM(fapi_failed_count)", false);
        seriesApif.setPropValue("data", numsApif);
        this.setApiSeriesColor((Series)seriesApit, (Series)seriesApif);
    }

    private void setApiSeriesColor(Series seriesApit, Series seriesApif) {
        this.setSeriesColor(seriesApit, API_COLOR[0]);
        this.setSeriesColor(seriesApif, API_COLOR[1]);
    }

    private void setTabApiByMonth(PointLineChart pointLineChart) {
        Calendar cal = Calendar.getInstance();
        Axis xAxis = pointLineChart.createXAxis("", AxisType.category);
        LineSeries seriesApit = pointLineChart.createSeries(ResManager.loadKDString((String)"API\u8c03\u7528\u603b\u6b21\u6570", (String)"StatisticalDataPanelFormPlugin_23", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
        LineSeries seriesApif = pointLineChart.createSeries(ResManager.loadKDString((String)"API\u8c03\u7528\u5931\u8d25\u6b21\u6570", (String)"StatisticalDataPanelFormPlugin_24", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
        this.setXAxisCategoryByMonth(xAxis);
        List<Object> numsApit = this.getNumsByDay("SUM(fapi_total_count)", false);
        seriesApit.setPropValue("data", numsApit);
        List<Object> numsApif = this.getNumsByDay("SUM(fapi_failed_count)", false);
        seriesApif.setPropValue("data", numsApif);
        this.setApiSeriesColor((Series)seriesApit, (Series)seriesApif);
    }

    private void setTabApiByDay(PointLineChart pointLineChart) {
        Axis xAxis = pointLineChart.createXAxis("", AxisType.category);
        LineSeries seriesApit = pointLineChart.createSeries(ResManager.loadKDString((String)"API\u8c03\u7528\u603b\u6b21\u6570", (String)"StatisticalDataPanelFormPlugin_23", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
        LineSeries seriesApif = pointLineChart.createSeries(ResManager.loadKDString((String)"API\u8c03\u7528\u5931\u8d25\u6b21\u6570", (String)"StatisticalDataPanelFormPlugin_24", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
        this.setXAxisCategoryByDay(xAxis);
        List<Object> numsApit = this.getNumsByHour("SUM(fapi_total_count)", false);
        seriesApit.setPropValue("data", numsApit);
        List<Object> numsApif = this.getNumsByHour("SUM(fapi_failed_count)", false);
        seriesApif.setPropValue("data", numsApif);
        this.setApiSeriesColor((Series)seriesApit, (Series)seriesApif);
    }

    private void setTabMqByYear(HistogramChart histogramChart, String mqPulish, String mqConsumed, String fieldPublish, String fieldConsumed) {
        Axis xAxis = histogramChart.createXAxis("", AxisType.category);
        BarSeries seriesMqp = histogramChart.createBarSeries(mqPulish);
        BarSeries seriesMqc = histogramChart.createBarSeries(mqConsumed);
        this.setXAxisCategoryByYear(xAxis);
        List<Object> numsMqp = this.getNumsByMonth("SUM(" + fieldPublish + ")", true);
        seriesMqp.setPropValue("data", numsMqp);
        seriesMqp.setLabel((Label)null);
        seriesMqp.setStack("1");
        seriesMqp.setBarWidth("22px");
        List<Object> numsMqc = this.getNumsByMonth("SUM(" + fieldConsumed + ")", true);
        seriesMqc.setPropValue("data", numsMqc);
        seriesMqc.setLabel((Label)null);
        seriesMqc.setStack("1");
        seriesMqc.setBarWidth("22px");
        this.setMqSeriesColor((Series)seriesMqp, (Series)seriesMqc);
    }

    private void setMqSeriesColor(Series seriesMqp, Series seriesMqc) {
        this.setSeriesColor(seriesMqp, MQ_COLOR[0]);
        this.setSeriesColor(seriesMqc, MQ_COLOR[1]);
    }

    private void setTabMqByMonth(HistogramChart histogramChart, String mqPulish, String mqConsumed, String fieldPublish, String fieldConsumed) {
        Axis xAxis = histogramChart.createXAxis("", AxisType.category);
        BarSeries seriesMqp = histogramChart.createBarSeries(mqPulish);
        BarSeries seriesMqc = histogramChart.createBarSeries(mqConsumed);
        this.setXAxisCategoryByMonth(xAxis);
        List<Object> numsDcr = this.getNumsByDay("SUM(" + fieldPublish + ")", true);
        seriesMqp.setPropValue("data", numsDcr);
        seriesMqp.setLabel((Label)null);
        seriesMqp.setStack("1");
        seriesMqp.setBarWidth("22px");
        List<Object> numsDct = this.getNumsByDay("SUM(" + fieldConsumed + ")", true);
        seriesMqc.setPropValue("data", numsDct);
        seriesMqc.setLabel((Label)null);
        seriesMqc.setStack("1");
        seriesMqc.setBarWidth("22px");
        this.setMqSeriesColor((Series)seriesMqp, (Series)seriesMqc);
    }

    private void setTabMqByDay(HistogramChart histogramChart, String mqPulish, String mqConsumed, String fieldPublish, String fieldConsumed) {
        Axis xAxis = histogramChart.createXAxis("", AxisType.category);
        BarSeries seriesMqp = histogramChart.createBarSeries(mqPulish);
        BarSeries seriesMqc = histogramChart.createBarSeries(mqConsumed);
        this.setXAxisCategoryByDay(xAxis);
        List<Object> numsDcr = this.getNumsByHour("SUM(" + fieldPublish + ")", true);
        seriesMqp.setPropValue("data", numsDcr);
        seriesMqp.setLabel((Label)null);
        seriesMqp.setStack("1");
        seriesMqp.setBarWidth("22px");
        List<Object> numsDct = this.getNumsByHour("SUM(" + fieldConsumed + ")", true);
        seriesMqc.setPropValue("data", numsDct);
        seriesMqc.setLabel((Label)null);
        seriesMqc.setStack("1");
        seriesMqc.setBarWidth("22px");
        this.setMqSeriesColor((Series)seriesMqp, (Series)seriesMqc);
    }

    private void showCustomChartByQuarter(Control histogramchartap) {
        if (histogramchartap != null) {
            HistogramChart chart = (HistogramChart)histogramchartap;
            ArrayList<String> data = new ArrayList<String>();
            String xAxisName = "";
            data.add(ResManager.loadKDString((String)"\u4e00\u5b63\u5ea6", (String)"StatisticalDataPanelFormPlugin_25", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
            data.add(ResManager.loadKDString((String)"\u4e8c\u5b63\u5ea6", (String)"StatisticalDataPanelFormPlugin_26", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
            data.add(ResManager.loadKDString((String)"\u4e09\u5b63\u5ea6", (String)"StatisticalDataPanelFormPlugin_27", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
            data.add(ResManager.loadKDString((String)"\u56db\u5b63\u5ea6", (String)"StatisticalDataPanelFormPlugin_28", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
            SelfCustomChart selfCustomChart = new SelfCustomChart(chart, data, xAxisName).invoke();
            BarSeries dataSeries = selfCustomChart.getDataSeries();
            BarSeries flowSeries = selfCustomChart.getFlowSeries();
            BarSeries apiSeries = selfCustomChart.getApiSeries();
            BarSeries mqMsgSeries = selfCustomChart.getMqMsgSeries();
            List<Object> dataNums = this.getNumsByQuarter("select SUM(fdcr_total_count + fdct_total_count + fdcw_total_count) from T_ISCB_RUNTIME_STAT where FCREATED_TIME BETWEEN ? AND ?");
            HashMap<String, Boolean> label = new HashMap<String, Boolean>(1);
            label.put("show", Boolean.FALSE);
            dataSeries.setPropValue(LABEL2, label);
            dataSeries.setPropValue("data", dataNums);
            dataSeries.setBarWidth("22px");
            this.setSeriesColor((Series)dataSeries, "#5E80EB");
            List<Object> flowNums = this.getNumsByQuarter("select SUM(fsf_total_count) from T_ISCB_RUNTIME_STAT where FCREATED_TIME BETWEEN ? AND ?");
            this.setSeriesColor((Series)flowSeries, COLOR_1);
            flowSeries.setPropValue(LABEL2, label);
            flowSeries.setPropValue("data", flowNums);
            flowSeries.setBarWidth("22px");
            List<Object> apiNums = this.getNumsByQuarter("select SUM(fapi_total_count) from T_ISCB_RUNTIME_STAT where FCREATED_TIME BETWEEN ? AND ?");
            this.setSeriesColor((Series)apiSeries, "#84A2FB");
            apiSeries.setPropValue(LABEL2, label);
            apiSeries.setPropValue("data", apiNums);
            apiSeries.setBarWidth("22px");
            List<Object> mqMsgNums = this.getNumsByQuarter("select SUM(fmq_pubished_count + fmq_consumed_count) from T_ISCB_RUNTIME_STAT where FCREATED_TIME BETWEEN ? AND ?");
            this.setSeriesColor((Series)mqMsgSeries, COLOR_3);
            mqMsgSeries.setPropValue(LABEL2, label);
            mqMsgSeries.setPropValue("data", mqMsgNums);
            mqMsgSeries.setBarWidth("22px");
            chart.refresh();
        }
    }

    private void setSeriesColor(Series dataSeries, String color) {
        Map<String, Object> dataStyle = this.setColorStyle(color);
        dataSeries.setPropValue(ITEM_STYLE, dataStyle);
        ArrayList<String> list = new ArrayList<String>(3);
        list.add(ITEM_STYLE);
        list.add(STYLE_NORMAL);
        list.add(LINE_COLOR);
        dataSeries.addFuncPath(list);
    }

    private Map<String, Object> setColorStyle(String color) {
        HashMap<String, Object> itemStyle = new HashMap<String, Object>(1);
        HashMap<String, String> normal = new HashMap<String, String>(1);
        normal.put(LINE_COLOR, color);
        itemStyle.put(STYLE_NORMAL, normal);
        return itemStyle;
    }

    private void showCustomChartByMonth(Control histogramchartap) {
        if (histogramchartap != null) {
            HistogramChart chart = (HistogramChart)histogramchartap;
            ArrayList<String> datas = new ArrayList<String>(12);
            String xAxisName = "";
            for (int i = 1; i < 13; ++i) {
                datas.add(String.format(ResManager.loadKDString((String)"%s\u6708", (String)"StatisticalDataPanelFormPlugin_50", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), D.s((Object)i)));
            }
            SelfCustomChart selfCustomChart = new SelfCustomChart(chart, datas, xAxisName).invoke();
            BarSeries dataSeries = selfCustomChart.getDataSeries();
            BarSeries flowSeries = selfCustomChart.getFlowSeries();
            BarSeries apiSeries = selfCustomChart.getApiSeries();
            BarSeries mqMsgSeries = selfCustomChart.getMqMsgSeries();
            List<Object> dataNums = this.getNumsByMonth("SUM(fdcr_total_count)", true);
            Map<String, Object> dataStyle = this.setColorStyle("new echarts.graphic.LinearGradient(0, 0, 0, 1, [{offset: 0,color: '#7ea8ee'}, {offset: 1,color: '#5d87f4'}])");
            dataSeries.setPropValue(ITEM_STYLE, dataStyle);
            dataSeries.setPropValue("data", dataNums);
            ArrayList<String> list = new ArrayList<String>(3);
            list.add(ITEM_STYLE);
            list.add(STYLE_NORMAL);
            list.add(LINE_COLOR);
            dataSeries.addFuncPath(list);
            List<Object> flowNums = this.getNumsByMonth("SUM(fsf_total_count)", true);
            Map<String, Object> flowStyle = this.setColorStyle("new echarts.graphic.LinearGradient(0, 0, 0, 1, [{offset: 0,color: '#90e0d0'}, {offset: 1,color: '#4eb9ad'}])");
            flowSeries.setPropValue(ITEM_STYLE, flowStyle);
            flowSeries.setPropValue("data", flowNums);
            flowSeries.addFuncPath(list);
            List<Object> apiNums = this.getNumsByMonth("SUM(fapi_total_count)", true);
            Map<String, Object> apiStyle = this.setColorStyle("new echarts.graphic.LinearGradient(0, 0, 0, 1, [{offset: 0,color: '#ba7ef3'}, {offset: 1,color: '#965df2'}])");
            apiSeries.setPropValue(ITEM_STYLE, apiStyle);
            apiSeries.setPropValue("data", apiNums);
            apiSeries.addFuncPath(list);
            List<Object> mqMsgNums = this.getNumsByMonth("SUM(fmq_pubished_count)", true);
            Map<String, Object> mqStyle = this.setColorStyle("new echarts.graphic.LinearGradient(0, 0, 0, 1, [{offset: 0,color: '#f9c392'}, {offset: 1,color: '#f09b67'}])");
            mqMsgSeries.setPropValue(ITEM_STYLE, mqStyle);
            mqMsgSeries.setPropValue("data", mqMsgNums);
            mqMsgSeries.addFuncPath(list);
            chart.refresh();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Object> getNumsByQuarter(String sql) {
        ArrayList<Timestamp> values = new ArrayList<Timestamp>(2);
        ArrayList<Integer> types = new ArrayList<Integer>(2);
        types.add(93);
        types.add(93);
        ArrayList<Object> nums = new ArrayList<Object>(4);
        Connection cn = TX.getConnection((String)"ISCB", (boolean)true, (String[])new String[0]);
        try {
            int j = 1;
            for (int i = 0; i < 4; ++i) {
                values.clear();
                values.add(D.t((Object)this.getFirstDayOfMonth(j)));
                values.add(D.t((Object)this.getFirstDayOfMonth(j += 3)));
                long count = D.l((Object)DbUtil.executeScalar((Connection)cn, (String)sql, values, types));
                nums.add(count != 0L ? Long.valueOf(count) : "");
            }
        }
        finally {
            DbUtil.close((Connection)cn, (boolean)false);
        }
        return nums;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Object> getNumsByMonth(String select, boolean isIgnore) {
        Date initTime = this.getInitFirstDayOfMonthTime();
        ArrayList<Timestamp> valuesMonth = new ArrayList<Timestamp>(2);
        ArrayList<Integer> typesMonth = new ArrayList<Integer>(2);
        typesMonth.add(93);
        typesMonth.add(93);
        Calendar calendar = Calendar.getInstance();
        ArrayList<Object> nums = new ArrayList<Object>(12);
        String sql = "select " + select + " from T_ISCB_RUNTIME_STAT where fcreated_time >= ? and fcreated_time < ?";
        Connection cn = TX.getConnection((String)"ISCB", (boolean)true, (String[])new String[0]);
        try {
            for (int i = 12; i > 0; --i) {
                calendar.setTime(initTime);
                calendar.add(2, 1 - i);
                Timestamp before = D.t((Object)calendar.getTime());
                calendar.add(2, 1);
                Timestamp after = D.t((Object)calendar.getTime());
                valuesMonth.clear();
                valuesMonth.add(before);
                valuesMonth.add(after);
                long count = D.l((Object)DbUtil.executeScalar((Connection)cn, (String)sql, valuesMonth, typesMonth));
                if (isIgnore) {
                    nums.add(count != 0L ? Long.valueOf(count) : "");
                    continue;
                }
                nums.add(count);
            }
        }
        finally {
            DbUtil.close((Connection)cn, (boolean)false);
        }
        return nums;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Object> getNumsByDay(String select, boolean isIgnore) {
        Date initTime = this.getInitTime();
        ArrayList<Timestamp> valuesDay = new ArrayList<Timestamp>(2);
        ArrayList<Integer> typesDay = new ArrayList<Integer>(2);
        typesDay.add(93);
        typesDay.add(93);
        ArrayList<Object> nums = new ArrayList<Object>(30);
        String sql = "select " + select + " from T_ISCB_RUNTIME_STAT where fcreated_time >= ? and fcreated_time < ?";
        Connection cn = TX.getConnection((String)"ISCB", (boolean)true, (String[])new String[0]);
        try {
            for (int i = 30; i > 0; --i) {
                valuesDay.clear();
                long initTimeTime = initTime.getTime();
                Timestamp startDate = D.t((Object)(initTimeTime - (long)(i - 1) * 86400000L));
                Timestamp endDate = D.t((Object)(initTimeTime - (long)(i - 2) * 86400000L));
                valuesDay.add(startDate);
                valuesDay.add(endDate);
                long count = D.l((Object)DbUtil.executeScalar((Connection)cn, (String)sql, valuesDay, typesDay));
                if (isIgnore) {
                    nums.add(count != 0L ? Long.valueOf(count) : "");
                    continue;
                }
                nums.add(count);
            }
        }
        finally {
            DbUtil.close((Connection)cn, (boolean)false);
        }
        return nums;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Object> getNumsByHour(String select, boolean isIgnore) {
        ArrayList<Timestamp> valuesDay = new ArrayList<Timestamp>(2);
        Calendar cal = Calendar.getInstance();
        int hour = cal.get(11);
        ArrayList<Integer> typesDay = new ArrayList<Integer>(2);
        typesDay.add(93);
        typesDay.add(93);
        ArrayList<Object> nums = new ArrayList<Object>(24);
        String sql = "select " + select + " from T_ISCB_RUNTIME_STAT where fcreated_time >= ? and fcreated_time < ?";
        Connection cn = TX.getConnection((String)"ISCB", (boolean)true, (String[])new String[0]);
        try {
            for (int i = 0; i < 24; ++i) {
                valuesDay.clear();
                long a = this.getInitTime().getTime() + (long)i * 3600000L;
                Timestamp before = D.t((Object)a);
                long b = a + 3600000L;
                Timestamp after = D.t((Object)b);
                valuesDay.add(before);
                valuesDay.add(after);
                long count = D.l((Object)DbUtil.executeScalar((Connection)cn, (String)sql, valuesDay, typesDay));
                if (isIgnore) {
                    nums.add(count != 0L ? Long.valueOf(count) : "");
                    continue;
                }
                nums.add(i <= hour ? Long.valueOf(count) : "");
            }
        }
        finally {
            DbUtil.close((Connection)cn, (boolean)false);
        }
        return nums;
    }

    private void showOrUpdatePieChart(Control piechartap) {
        Calendar cal = Calendar.getInstance();
        cal.set(6, 1);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        Date date = new Date(cal.getTimeInMillis());
        if (piechartap != null) {
            PieChart pieChart = (PieChart)piechartap;
            PieSeries a = pieChart.createSeries(ResManager.loadKDString((String)"\u767e\u5206\u6bd4", (String)"StatisticalDataPanelFormPlugin_30", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
            LocaleString localeString = new LocaleString(ResManager.loadKDString((String)"", (String)"StatisticalDataPanelFormPlugin_15", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
            pieChart.setName(localeString);
            a.setRoseType(RoseType.radius);
            a.addData(ResManager.loadKDString((String)"\u6570\u636e\u96c6\u6210", (String)"StatisticalDataPanelFormPlugin_31", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), (Number)this.getSuccessCount(date, "fdcw_total_count + fdct_total_count + fdcr_total_count", "fdcw_failed_count + fdct_failed_count + fdcr_failed_count"), "#5C7EE8");
            a.addData(ResManager.loadKDString((String)"\u670d\u52a1\u6d41\u7a0b", (String)"StatisticalDataPanelFormPlugin_32", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), (Number)this.getSuccessCount(date, "fsf_total_count", "fsf_failed_count"), COLOR_1);
            a.addData(ResManager.loadKDString((String)"API\u8c03\u7528", (String)"StatisticalDataPanelFormPlugin_33", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), (Number)this.getSuccessCount(date, "fapi_total_count", "fapi_failed_count"), "#84A2FB");
            a.addData(ResManager.loadKDString((String)"\u6d88\u606f\u96c6\u6210", (String)"StatisticalDataPanelFormPlugin_34", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), (Number)this.getSuccessCount(date, "fmq_pubished_count + fmq_consumed_count", null), COLOR_3);
            pieChart.setShowTooltip(true);
            a.setRadius("30%", "60%");
            pieChart.setLegendAlign(XAlign.center, YAlign.top);
            pieChart.setShowLegend(true);
            pieChart.refresh();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void showAllTitleData() {
        Connection cn = TX.getConnection((String)"ISCB", (boolean)true, (String[])new String[0]);
        try {
            long selectCount = D.l((Object)DbUtil.executeScalar((Connection)cn, (String)"select SUM(fdcr_total_count) + SUM(fdct_total_count) + SUM(fdcw_total_count) from T_ISCB_RUNTIME_STAT"));
            this.getModel().setValue("bigint_data", (Object)selectCount);
            selectCount = D.l((Object)DbUtil.executeScalar((Connection)cn, (String)"select SUM(fsf_total_count) from T_ISCB_RUNTIME_STAT"));
            this.getModel().setValue("bigint_flow", (Object)selectCount);
            selectCount = D.l((Object)DbUtil.executeScalar((Connection)cn, (String)"select SUM(fapi_total_count) from T_ISCB_RUNTIME_STAT"));
            this.getModel().setValue("bigint_api", (Object)selectCount);
            BigDecimal mqBytes = D.n((Object)DbUtil.executeScalar((Connection)cn, (String)"select SUM(fmq_published_bytes + fmq_consumed_bytes)/1024 from T_ISCB_RUNTIME_STAT"));
            this.getModel().setValue("bigint_mq", (Object)mqBytes);
        }
        finally {
            DbUtil.close((Connection)cn, (boolean)false);
        }
    }

    private Date getInitTime() {
        Calendar cal = Calendar.getInstance();
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        return cal.getTime();
    }

    private Date getInitFirstDayOfMonthTime() {
        Calendar cal = Calendar.getInstance();
        cal.set(5, 1);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        return cal.getTime();
    }

    private Date getFirstDayOfMonth(int month) {
        Calendar cal = Calendar.getInstance();
        cal.set(2, month - 1);
        cal.set(5, 1);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        long timeInMillis = cal.getTimeInMillis();
        return new Date(timeInMillis);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long getSuccessCount(Date date, String amount, String failCount) {
        List<Timestamp> values = Collections.singletonList(D.t((Object)date));
        List<Integer> types = Collections.singletonList(93);
        Connection cn = TX.getConnection((String)"ISCB", (boolean)true, (String[])new String[0]);
        try {
            long count;
            long l = count = D.l((Object)DbUtil.executeScalar((Connection)cn, (String)("select SUM(" + amount + ")" + (failCount != null ? "- SUM(" + failCount + ")" : "") + "from T_ISCB_RUNTIME_STAT where FCREATED_TIME > ?"), values, types));
            return l;
        }
        finally {
            DbUtil.close((Connection)cn, (boolean)false);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String prop = e.getProperty().getName();
        if ("radio_data".equals(prop)) {
            this.showDataByListbox();
        } else if ("radio_flow".equals(prop)) {
            this.showFlowByListbox();
        } else if ("radio_api".equals(prop)) {
            this.showApiByListbox();
        } else if ("radio_mq".equals(prop)) {
            this.showMqByListbox();
        }
    }

    private void showMqByListbox() {
        String dataKey = this.getPageCache().get(MQ_KEY);
        dataKey = this.initListBox(LISTBOX_MQ, dataKey);
        this.showData("SUM(fmq_pubished_count + fmq_consumed_count)", "flex_label_mq", "bigint_mq_d", "bigint_mq_m", "bigint_mq_y", "long");
        this.showData("SUM(fmq_published_bytes + fmq_consumed_bytes)/1024", "flex_label_mq", "bigint_mq_bytes_d", "bigint_mq_bytes_m", "bigint_mq_bytes_y", "decimal");
        this.showMqChart(dataKey);
    }

    private void showMqChart(String dataKey) {
        HistogramChart histogramChart = this.setHistogramChartStyle("histogramchart_mq", ResManager.loadKDString((String)"MQ\u53d1\u5e03/\u6d88\u8d39\u6b21\u6570\u7edf\u8ba1", (String)"StatisticalDataPanelFormPlugin_35", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
        HistogramChart histogramChartB = this.setHistogramChartStyle("histogramchart_mq_b", ResManager.loadKDString((String)"MQ\u53d1\u5e03/\u6d88\u8d39\u6d41\u91cf\u7edf\u8ba1", (String)"StatisticalDataPanelFormPlugin_36", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
        histogramChart.setLegendAlign(XAlign.right, YAlign.top);
        histogramChartB.setLegendAlign(XAlign.right, YAlign.top);
        if (TIME_UNIT_MONTH.equals(dataKey)) {
            this.setTabMqByMonth(histogramChart, ResManager.loadKDString((String)"MQ\u53d1\u5e03\u6b21\u6570", (String)"StatisticalDataPanelFormPlugin_37", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"MQ\u6d88\u8d39\u6b21\u6570", (String)"StatisticalDataPanelFormPlugin_38", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), FMQ_PUBISHED_COUNT, FMQ_CONSUMED_COUNT);
            this.setTabMqByMonth(histogramChartB, ResManager.loadKDString((String)"MQ\u53d1\u5e03\u6d41\u91cf\uff08\u5b57\u8282\uff09", (String)"StatisticalDataPanelFormPlugin_39", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"MQ\u6d88\u8d39\u6d41\u91cf\uff08\u5b57\u8282\uff09", (String)"StatisticalDataPanelFormPlugin_40", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), "fmq_published_bytes", "fmq_consumed_bytes");
        } else if (TIME_UNIT_DAY.equals(dataKey)) {
            this.setTabMqByDay(histogramChart, ResManager.loadKDString((String)"MQ\u53d1\u5e03\u6b21\u6570", (String)"StatisticalDataPanelFormPlugin_37", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"MQ\u6d88\u8d39\u6b21\u6570", (String)"StatisticalDataPanelFormPlugin_38", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), FMQ_PUBISHED_COUNT, FMQ_CONSUMED_COUNT);
            this.setTabMqByDay(histogramChartB, ResManager.loadKDString((String)"MQ\u53d1\u5e03\u6d41\u91cf\uff08\u5b57\u8282\uff09", (String)"StatisticalDataPanelFormPlugin_39", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"MQ\u6d88\u8d39\u6d41\u91cf\uff08\u5b57\u8282\uff09", (String)"StatisticalDataPanelFormPlugin_40", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), "fmq_published_bytes", "fmq_consumed_bytes");
        } else {
            this.setTabMqByYear(histogramChart, ResManager.loadKDString((String)"MQ\u53d1\u5e03\u6b21\u6570", (String)"StatisticalDataPanelFormPlugin_37", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"MQ\u6d88\u8d39\u6b21\u6570", (String)"StatisticalDataPanelFormPlugin_38", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), FMQ_PUBISHED_COUNT, FMQ_CONSUMED_COUNT);
            this.setTabMqByYear(histogramChartB, ResManager.loadKDString((String)"MQ\u53d1\u5e03\u6d41\u91cf\uff08\u5b57\u8282\uff09", (String)"StatisticalDataPanelFormPlugin_39", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"MQ\u6d88\u8d39\u6d41\u91cf\uff08\u5b57\u8282\uff09", (String)"StatisticalDataPanelFormPlugin_40", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), "fmq_published_bytes", "fmq_consumed_bytes");
        }
        histogramChart.refresh();
        histogramChartB.refresh();
    }

    private void showApiByListbox() {
        String dataKey = this.getPageCache().get(API_KEY);
        dataKey = this.initListBox(LISTBOX_API, dataKey);
        this.showData("SUM(fapi_total_count)", "flex_label_api", "bigint_api_d", "bigint_api_m", "bigint_api_y", "long");
        this.showApiChart(dataKey);
    }

    private void showApiChart(String dataKey) {
        PointLineChart pointLineChart = this.setPointLineChartStyle("linechart_api", ResManager.loadKDString((String)"API\u8c03\u7528\u7edf\u8ba1\u8d8b\u52bf", (String)"StatisticalDataPanelFormPlugin_41", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
        if (TIME_UNIT_MONTH.equals(dataKey)) {
            this.setTabApiByMonth(pointLineChart);
        } else if (TIME_UNIT_DAY.equals(dataKey)) {
            this.setTabApiByDay(pointLineChart);
        } else {
            this.setTabApiByYear(pointLineChart);
        }
        pointLineChart.refresh();
    }

    private void showFlowByListbox() {
        String dataKey = this.getPageCache().get(FLOW_KEY);
        dataKey = this.initListBox(LISTBOX_FLOW, dataKey);
        this.showData("SUM(fsf_total_count)", "flex_label_flow", "bigint_flow_d", "bigint_flow_m", "bigint_flow_y", "long");
        this.showFlowChart(dataKey);
    }

    private void showFlowChart(String dataKey) {
        PointLineChart pointLineChart = this.setPointLineChartStyle("linechart_flow", ResManager.loadKDString((String)"\u670d\u52a1\u6d41\u7a0b\u7edf\u8ba1\u8d8b\u52bf", (String)"StatisticalDataPanelFormPlugin_42", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
        if (TIME_UNIT_MONTH.equals(dataKey)) {
            this.setTabFlowByMonth(pointLineChart);
        } else if (TIME_UNIT_DAY.equals(dataKey)) {
            this.setTabFlowByDay(pointLineChart);
        } else {
            this.setTabFlowByYear(pointLineChart);
        }
        pointLineChart.refresh();
    }

    private void showDataByListbox() {
        String dataKey = this.getPageCache().get(DATA_KEY);
        dataKey = this.initListBox(LISTBOX_DATA, dataKey);
        this.showData("SUM(fdcr_total_count) + SUM(fdct_total_count) + SUM(fdcw_total_count)", "flex_label_data", "bigint_data_d", "bigint_data_m", "bigint_data_y", "long");
        this.showDataChart(dataKey);
    }

    private String initListBox(String listBoxName, String dataKey) {
        Listbox listbox = (Listbox)this.getView().getControl(listBoxName);
        if (dataKey == null) {
            ListboxItem month = new ListboxItem("year", ResManager.loadKDString((String)"\u6708", (String)"StatisticalDataPanelFormPlugin_29", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
            ListboxItem day = new ListboxItem(TIME_UNIT_MONTH, ResManager.loadKDString((String)"\u65e5", (String)"StatisticalDataPanelFormPlugin_43", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
            ListboxItem hour = new ListboxItem(TIME_UNIT_DAY, ResManager.loadKDString((String)"\u65f6", (String)"StatisticalDataPanelFormPlugin_44", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
            ArrayList<ListboxItem> itemlist = new ArrayList<ListboxItem>();
            itemlist.add(month);
            itemlist.add(day);
            itemlist.add(hour);
            listbox.addItems(itemlist);
            dataKey = "year";
        }
        listbox.activeItem(dataKey);
        return dataKey;
    }

    private void showDataChart(String listboxData) {
        PointLineChart pointLineChart = this.setPointLineChartStyle("linechart_data", ResManager.loadKDString((String)"\u6570\u636e\u96c6\u6210\u7edf\u8ba1\u4fe1\u606f", (String)"StatisticalDataPanelFormPlugin_45", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
        HistogramChart histogramChart = this.setHistogramChartStyle("histogramchart_data", ResManager.loadKDString((String)"\u8bfb\u53d6/\u8f6c\u5316/\u52a0\u8f7d\u7edf\u8ba1", (String)"StatisticalDataPanelFormPlugin_46", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
        if (TIME_UNIT_MONTH.equals(listboxData)) {
            this.setTabDataByMonth(pointLineChart);
            this.setTabDataByMonth(histogramChart);
        } else if (TIME_UNIT_DAY.equals(listboxData)) {
            this.setTabDataByDay(pointLineChart);
            this.setTabDataByDay(histogramChart);
        } else {
            this.setTabDataByYear(pointLineChart);
            this.setTabDataByYear(histogramChart);
        }
        pointLineChart.refresh();
        histogramChart.refresh();
    }

    private void setToolTipStyle(Chart chart) {
        ArrayList<String> toolTipFuncPath = new ArrayList<String>();
        toolTipFuncPath.add(TOOLTIP);
        toolTipFuncPath.add(FORMATTER);
        chart.addFuncPath(toolTipFuncPath);
        chart.addTooltip(FORMATTER, (Object)"function(params){\n\tlet res = \"\";\n\n\tres += params[0].axisValue + '<br/>';\n\tfor (var i = 0, l = params.length; i < l; i++) {\n\t\tres += params[i].marker + params[i].seriesName + ' : ';\n\t\tif(params[i].value) {\n\t\t\tres += params[i].value;\n\t\t}else{\n\t\t\tres += '0';\n\t\t}\n\t\tres += '<br/>';\n\t}\n\treturn res;\n}");
    }

    public void tabSelected(TabSelectEvent tabSelectEvent) {
        String subTabKey = tabSelectEvent.getTabKey();
        this.showAllTitleData();
        switch (subTabKey) {
            case "tab_data": {
                this.showDataByListbox();
                break;
            }
            case "tab_flow": {
                this.showFlowByListbox();
                break;
            }
            case "tab_api": {
                this.showApiByListbox();
                break;
            }
            case "tab_mq": {
                this.showMqByListbox();
                break;
            }
            default: {
                this.showAllFlex();
            }
        }
    }

    private void setMqBytesByMonth(PointLineChart pointLineChart) {
        Calendar cal = Calendar.getInstance();
        Axis xAxis = pointLineChart.createXAxis("", AxisType.category);
        this.setXAxisCategoryByMonth(xAxis);
        LineSeries seriesApit = pointLineChart.createSeries(ResManager.loadKDString((String)"MQ\u53d1\u5e03\u6d41\u91cf", (String)"StatisticalDataPanelFormPlugin_47", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
        LineSeries seriesApif = pointLineChart.createSeries(ResManager.loadKDString((String)"MQ\u6d88\u8d39\u6d41\u91cf", (String)"StatisticalDataPanelFormPlugin_48", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
        ArrayList<String> toolTipFuncPath = new ArrayList<String>();
        toolTipFuncPath.add(TOOLTIP);
        toolTipFuncPath.add(FORMATTER);
        pointLineChart.addFuncPath(toolTipFuncPath);
        List<Object> numsMqp = this.getNumsByDay("SUM(fmq_published_bytes)", false);
        this.setMqPublishPointChartColor(seriesApit, numsMqp);
        List<Object> numsMqc = this.getNumsByDay("SUM(fmq_consumed_bytes)", false);
        this.setMqConsumedPointChartColor(seriesApif, numsMqc);
        pointLineChart.refresh();
    }

    private void setMqConsumedPointChartColor(LineSeries seriesApif, List<Object> numsMqc) {
        seriesApif.setPropValue("data", this.getNegativeNums(numsMqc));
        this.setSeriesColor((Series)seriesApif, "#0066ff");
        List<GradientItem> itemsApif = this.setGradientItems("#0066ff", "#00cccc");
        seriesApif.setAreaColor(0, 0, 0, 1, itemsApif);
    }

    private void setMqPublishPointChartColor(LineSeries seriesApit, List<Object> numsMqp) {
        seriesApit.setPropValue("data", numsMqp);
        this.setSeriesColor((Series)seriesApit, "#cc00ff");
        List<GradientItem> itemsApit = this.setGradientItems("#cc00ff", "#ff66ff");
        seriesApit.setAreaColor(0, 0, 0, 1, itemsApit);
    }

    private void setMqBytesByDay(PointLineChart pointLineChart) {
        Axis xAxis = pointLineChart.createXAxis("", AxisType.category);
        LineSeries seriesApit = pointLineChart.createSeries(ResManager.loadKDString((String)"MQ\u53d1\u5e03\u6d41\u91cf", (String)"StatisticalDataPanelFormPlugin_47", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
        LineSeries seriesApif = pointLineChart.createSeries(ResManager.loadKDString((String)"MQ\u6d88\u8d39\u6d41\u91cf", (String)"StatisticalDataPanelFormPlugin_48", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
        ArrayList<String> toolTipFuncPath = new ArrayList<String>();
        toolTipFuncPath.add(TOOLTIP);
        toolTipFuncPath.add(FORMATTER);
        pointLineChart.addFuncPath(toolTipFuncPath);
        this.setXAxisCategoryByDay(xAxis);
        List<Object> numsMqp = this.getNumsByHour("SUM(fmq_published_bytes)", false);
        this.setMqPublishPointChartColor(seriesApit, numsMqp);
        List<Object> numsMqc = this.getNumsByHour("SUM(fmq_consumed_bytes)", false);
        this.setMqConsumedPointChartColor(seriesApif, numsMqc);
        pointLineChart.refresh();
    }

    private void setMqBytesByYear(PointLineChart pointLineChart) {
        Axis xAxis = pointLineChart.createXAxis("", AxisType.category);
        LineSeries seriesApit = pointLineChart.createSeries(ResManager.loadKDString((String)"MQ\u53d1\u5e03\u6d41\u91cf", (String)"StatisticalDataPanelFormPlugin_47", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
        LineSeries seriesApif = pointLineChart.createSeries(ResManager.loadKDString((String)"MQ\u6d88\u8d39\u6d41\u91cf", (String)"StatisticalDataPanelFormPlugin_48", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
        ArrayList<String> toolTipFuncPath = new ArrayList<String>();
        toolTipFuncPath.add(TOOLTIP);
        toolTipFuncPath.add(FORMATTER);
        pointLineChart.addFuncPath(toolTipFuncPath);
        this.setXAxisCategoryByYear(xAxis);
        List<Object> numsMqp = this.getNumsByMonth("SUM(fmq_published_bytes)", false);
        this.setMqPublishPointChartColor(seriesApit, numsMqp);
        List<Object> numsMqc = this.getNumsByMonth("SUM(fmq_consumed_bytes)", false);
        this.setMqConsumedPointChartColor(seriesApif, numsMqc);
        pointLineChart.refresh();
    }

    private List<GradientItem> setGradientItems(String Fcolor, String Scolor) {
        ArrayList<GradientItem> items = new ArrayList<GradientItem>();
        GradientItem a = new GradientItem();
        a.setOffset(0);
        a.setColor(Fcolor);
        items.add(a);
        GradientItem b = new GradientItem();
        b.setOffset(1);
        b.setColor(Scolor);
        items.add(b);
        return items;
    }

    private List<Object> getNegativeNums(List<Object> numsApit) {
        ArrayList<Object> list = new ArrayList<Object>();
        for (Object o : numsApit) {
            if (!(o instanceof Long)) continue;
            Long num = (Long)o;
            list.add(-num.longValue());
        }
        return list;
    }

    public void listboxClick(ListboxEvent listboxEvent) {
        String box_key;
        String itemId = listboxEvent.getItemId();
        Listbox source = (Listbox)listboxEvent.getSource();
        switch (box_key = source.getKey()) {
            case "listbox_data": {
                this.getPageCache().put(DATA_KEY, itemId);
                this.showDataChart(itemId);
                break;
            }
            case "listbox_flow": {
                this.getPageCache().put(FLOW_KEY, itemId);
                this.showFlowChart(itemId);
                break;
            }
            case "listbox_api": {
                this.getPageCache().put(API_KEY, itemId);
                this.showApiChart(itemId);
                break;
            }
            case "listbox_mq": {
                this.getPageCache().put(MQ_KEY, itemId);
                this.showMqChart(itemId);
                break;
            }
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        this.getPageCache().remove(DATA_KEY);
        this.getPageCache().remove(FLOW_KEY);
        this.getPageCache().remove(API_KEY);
        this.getPageCache().remove(MQ_KEY);
    }

    private void setAxisLineStyle(Axis axis) {
        HashMap axisLineMap = new HashMap();
        HashMap<String, String> lineStyleMap = new HashMap<String, String>(1);
        lineStyleMap.put(LINE_COLOR, "#999999");
        axisLineMap.put("lineStyle", lineStyleMap);
        axis.setPropValue("axisLine", axisLineMap);
    }

    private void setAxisTickStyle(Axis axis) {
        HashMap<String, Constable> xaxisTick = new HashMap<String, Constable>();
        xaxisTick.put("interval", Integer.valueOf(0));
        xaxisTick.put("show", Boolean.FALSE);
        axis.setPropValue("axisTick", xaxisTick);
    }

    private class SelfCustomChart {
        private HistogramChart chart;
        private List<String> data;
        private String xAxisName;
        private BarSeries dataSeries;
        private BarSeries flowSeries;
        private BarSeries apiSeries;
        private BarSeries mqMsgSeries;

        public SelfCustomChart(HistogramChart chart, List<String> data, String xAxisName) {
            this.chart = chart;
            this.data = data;
            this.xAxisName = xAxisName;
        }

        public BarSeries getDataSeries() {
            return this.dataSeries;
        }

        public BarSeries getFlowSeries() {
            return this.flowSeries;
        }

        public BarSeries getApiSeries() {
            return this.apiSeries;
        }

        public BarSeries getMqMsgSeries() {
            return this.mqMsgSeries;
        }

        public SelfCustomChart invoke() {
            Axis yAxis = this.chart.createYAxis(ResManager.loadKDString((String)"\u6570\u91cf", (String)"StatisticalDataPanelFormPlugin_49", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), AxisType.log);
            Axis xAxis = this.chart.createXAxis(this.xAxisName, AxisType.category);
            StatisticalDataPanelFormPlugin.this.setToolTipStyle((Chart)this.chart);
            xAxis.setCategorys(this.data);
            xAxis.setPosition(Position.bottom);
            HashMap<String, int[]> xaMap = new HashMap<String, int[]>(1);
            int[] xa = new int[]{0, 0, -25, -35};
            xaMap.put("padding", xa);
            xAxis.setPropValue("nameGap", (Object)"5");
            xAxis.setPropValue("nameTextStyle", xaMap);
            StatisticalDataPanelFormPlugin.this.setAxisTickStyle(xAxis);
            StatisticalDataPanelFormPlugin.this.setAxisTickStyle(yAxis);
            StatisticalDataPanelFormPlugin.this.setSplitLineStyle(yAxis);
            StatisticalDataPanelFormPlugin.this.setAxisLineStyle(xAxis);
            StatisticalDataPanelFormPlugin.this.setAxisLineStyle(yAxis);
            StatisticalDataPanelFormPlugin.this.setToolTipStyle((Chart)this.chart);
            HashMap<String, Object> axisPointer = new HashMap<String, Object>();
            HashMap<String, String> shadowStyle = new HashMap<String, String>();
            axisPointer.put("show", Boolean.TRUE);
            axisPointer.put(StatisticalDataPanelFormPlugin.LINE_TYPE, "shadow");
            shadowStyle.put(StatisticalDataPanelFormPlugin.LINE_COLOR, "rgba(150,150,150,0.3)");
            axisPointer.put("shadowStyle", shadowStyle);
            xAxis.setPropValue("axisPointer", axisPointer);
            yAxis.setMin((Number)1);
            this.dataSeries = this.chart.createBarSeries(ResManager.loadKDString((String)"\u6570\u636e\u96c6\u6210", (String)"StatisticalDataPanelFormPlugin_31", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
            this.flowSeries = this.chart.createBarSeries(ResManager.loadKDString((String)"\u670d\u52a1\u6d41\u7a0b", (String)"StatisticalDataPanelFormPlugin_32", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
            this.apiSeries = this.chart.createBarSeries(ResManager.loadKDString((String)"API\u8c03\u7528", (String)"StatisticalDataPanelFormPlugin_33", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
            this.mqMsgSeries = this.chart.createBarSeries(ResManager.loadKDString((String)"\u6d88\u606f\u96c6\u6210", (String)"StatisticalDataPanelFormPlugin_34", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
            this.chart.setLegendAlign(XAlign.right, YAlign.top);
            LocaleString localeString = new LocaleString("");
            this.chart.setShowLegend(true);
            this.chart.setShowTooltip(true);
            this.chart.setName(localeString);
            this.chart.setMargin(Position.right, "30px");
            this.chart.setMargin(Position.left, "30px");
            this.chart.setMargin(Position.top, "30px");
            this.chart.setLegendPropValue("itemWidth", (Object)25);
            this.chart.setLegendPropValue("itemHeight", (Object)15);
            return this;
        }
    }
}

