/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.formplugin.resource;

import java.util.EventObject;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.isv.ISVService;
import kd.isc.iscb.util.dt.D;

public class ResourceIsvFormPlugin
extends AbstractFormPlugin {
    private static final String ISV = "isv";
    private static final String KINGDEE = "kingdee";

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        if (this.hasIsvProp()) {
            String isv = this.getIsvNameFromSys();
            this.getView().setEnable(Boolean.valueOf(KINGDEE.equalsIgnoreCase(isv)), new String[]{ISV});
            this.setIsv(isv);
        }
    }

    private void setIsv(String isv) {
        String value;
        OperationStatus status = this.getView().getFormShowParameter().getStatus();
        if (!(!OperationStatus.ADDNEW.equals((Object)status) && !OperationStatus.EDIT.equals((Object)status) || (value = D.s((Object)this.getModel().getValue(ISV))) != null && value.startsWith(isv + '.'))) {
            this.getModel().setValue(ISV, (Object)(KINGDEE.equalsIgnoreCase(isv) ? isv + '.' : isv));
        }
    }

    private boolean hasIsvProp() {
        DynamicProperty property = this.getModel().getDataEntityType().getProperty(ISV);
        return property != null;
    }

    private String getIsvNameFromSys() {
        String isvName = ISVService.getISVInfo().getName();
        isvName = isvName == null ? "undefined" : isvName;
        return isvName;
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate source = (AbstractOperate)args.getSource();
        String operateKey = source.getOperateKey();
        if ("save".equals(operateKey) || "form_save".equals(operateKey)) {
            this.save(args);
        }
    }

    private void save(BeforeDoOperationEventArgs args) {
        if (this.hasIsvProp() && this.isInvalidIsv()) {
            args.setCancel(true);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5728\u3010\u5f00\u53d1\u5546\u3011\u5b57\u6bb5\u4e2d\u8865\u5145\u5b8c\u6574\u4e1a\u52a1\u4e91\u540d\u79f0\uff0c\u4e0d\u53ef\u4fee\u6539\u524d\u7f00\u5f00\u53d1\u5546\u4fe1\u606f\uff0c\u4f8b\u5982\u3010kingdee.\u67d0\u67d0\u4e1a\u52a1\u4e91\u3011\u3002", (String)"ResourceIsvFormPlugin_0", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
        }
    }

    private boolean isInvalidIsv() {
        String isvName = this.getIsvNameFromSys();
        if (KINGDEE.equalsIgnoreCase(isvName)) {
            String isv = D.s((Object)this.getModel().getValue(ISV));
            String initIsvName = isvName + '.';
            if (isv == null || !isv.startsWith(initIsvName) || isv.equals(initIsvName)) {
                this.getModel().setValue(ISV, (Object)(isvName + '.'));
                return true;
            }
        }
        return false;
    }
}

