/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.formplugin.resource;

import java.util.EventObject;
import java.util.Map;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.operate.Modify;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.isc.iscb.platform.core.permission.ResourceControl;
import kd.isc.iscb.util.dt.D;

public class ResourceProtectFormPlugin
extends AbstractFormPlugin {
    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        DynamicObject resource;
        String opMessage;
        super.beforeDoOperation(args);
        if (this.modifyOperate(args) && (opMessage = ResourceControl.checkOpPermission((String)"modify", (DynamicObject)(resource = this.getModel().getDataEntity()))) != null) {
            args.setCancel(true);
            this.getView().showTipNotification(opMessage);
        }
    }

    private boolean modifyOperate(BeforeDoOperationEventArgs args) {
        AbstractOperate operate = (AbstractOperate)args.getSource();
        if (operate instanceof Modify) {
            return true;
        }
        String operateKey = operate.getOperateKey();
        return "modify".equals(operateKey) || "modify_category".equals(operateKey) || "modify_btn".equals(operateKey);
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        DynamicObject resource = this.getModel().getDataEntity();
        OperationStatus status = this.getView().getFormShowParameter().getStatus();
        this.initButton(resource, status);
        status = this.getView().getFormShowParameter().getStatus();
        this.initParameters(status);
        this.adjustProtectLevel();
    }

    private void adjustProtectLevel() {
        Object level;
        String casted;
        IDataModel model = this.getModel();
        boolean hasField = model.getDataEntityType().getProperties().containsKey((Object)"protect_level");
        if (hasField && !(casted = ResourceControl.cast((Object)(level = model.getValue("protect_level")))).equals(level)) {
            model.setValue("protect_level", (Object)casted);
        }
    }

    private void initButton(DynamicObject resource, OperationStatus status) {
        if (this.isCheckPermission(resource, status)) {
            String opMessage;
            Map customParams;
            long flow;
            if ("isc_service_flow_editor".equals(resource.getDataEntityType().getName()) && (flow = D.l((customParams = this.getView().getFormShowParameter().getCustomParams()).get("flow"))) != 0L) {
                resource = BusinessDataServiceHelper.loadSingle((Object)flow, (String)"isc_service_flow", (String)"protect_level,source_tenant,source_trace");
            }
            if ((opMessage = ResourceControl.checkOpPermission((String)"modify", (DynamicObject)resource)) != null) {
                this.getView().setVisible(Boolean.FALSE, new String[]{"bar_modify", "modify", "modify_btn"});
                this.getView().setVisible(Boolean.FALSE, new String[]{"bar_save", "btn_save", "baritemap", "save", "buttonap1"});
                if (OperationStatus.VIEW != status) {
                    this.getView().setStatus(OperationStatus.VIEW);
                    this.getView().showTipNotification(opMessage);
                }
            }
        }
    }

    private boolean isCheckPermission(DynamicObject resource, OperationStatus status) {
        if (OperationStatus.VIEW == status) {
            return true;
        }
        if (OperationStatus.EDIT == status) {
            String id = D.s((Object)resource.getPkValue());
            return !"0".equals(id);
        }
        if (OperationStatus.ADDNEW == status) {
            String name = resource.getDataEntityType().getName();
            if ("isc_service_flow_editor".equals(name)) {
                return D.x(this.getView().getFormShowParameter().getCustomParams().get("editable"));
            }
            return false;
        }
        return false;
    }

    private void initParameters(OperationStatus status) {
        if (OperationStatus.ADDNEW.equals((Object)status) || OperationStatus.EDIT.equals((Object)status)) {
            String currentTenantId = this.getTenantId();
            this.setSourceTenant(currentTenantId);
            this.setSourceTrace(currentTenantId);
            this.setProtectLevel();
        }
    }

    private void setSourceTenant(String currentTenantId) {
        if (this.notContainsProperty("source_tenant")) {
            return;
        }
        this.getModel().setValue("source_tenant", (Object)currentTenantId);
    }

    private void setProtectLevel() {
        if (this.notContainsProperty("protect_level")) {
            return;
        }
        String protectLevel = D.s((Object)this.getModel().getValue("protect_level"));
        if (protectLevel == null) {
            this.getModel().setValue("protect_level", (Object)"DEFAULT");
        }
    }

    private void setSourceTrace(String currentTenantId) {
        if (this.notContainsProperty("source_trace")) {
            return;
        }
        String sourceTrace = D.s((Object)this.getModel().getValue("source_trace"));
        if (sourceTrace == null) {
            sourceTrace = currentTenantId + ";";
            this.getModel().setValue("source_trace", (Object)sourceTrace);
        } else if (!sourceTrace.endsWith(currentTenantId + ";")) {
            sourceTrace = sourceTrace + currentTenantId + ";";
            this.getModel().setValue("source_trace", (Object)sourceTrace);
        }
    }

    public String getTenantId() {
        String currentTenantId = D.s((Object)RequestContext.get().getTenantId());
        currentTenantId = currentTenantId == null ? "undefined" : currentTenantId;
        return currentTenantId;
    }

    private boolean notContainsProperty(String property) {
        DataEntityPropertyCollection properties = this.getModel().getDataEntityType().getProperties();
        return !properties.containsKey((Object)property);
    }
}

