/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.formplugin.resource;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.Delete;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.operate.Copy;
import kd.bos.form.operate.Modify;
import kd.bos.form.operate.New;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.isc.iscb.formplugin.util.FormOpener;
import kd.isc.iscb.platform.core.permission.ResourceControl;

public class ResourceProtectListPlugin
extends AbstractListPlugin {
    private static final Set<String> ENTITIES_SHOULD_IGNORE_MODIFY = new HashSet<String>();

    public void beforeDoOperation(BeforeDoOperationEventArgs evt) {
        super.beforeDoOperation(evt);
        AbstractOperate operate = (AbstractOperate)evt.getSource();
        String entityName = operate.getEntityId();
        if (this.isAddOperation(operate)) {
            String opMessage = ResourceControl.checkNewPermission();
            if (opMessage != null) {
                evt.setCancel(true);
                this.getView().showTipNotification(opMessage);
            }
        } else if (this.isDeleteOperation(operate)) {
            this.checkOpPermission(evt, entityName, "delete");
        } else if (this.isModifyOperation(operate)) {
            if (this.shouldIgnoreModifyOperation(entityName)) {
                return;
            }
            this.checkOpPermission(evt, entityName, "modify");
        } else if (this.isCopyOperation(operate)) {
            this.checkOpPermission(evt, entityName, "copy");
        }
    }

    private boolean shouldIgnoreModifyOperation(String entityName) {
        return ENTITIES_SHOULD_IGNORE_MODIFY.contains(entityName);
    }

    private boolean isAddOperation(AbstractOperate operate) {
        if (operate instanceof New) {
            return true;
        }
        String operateKey = operate.getOperateKey();
        return "new".equals(operateKey) || "custom_new".equals(operateKey) || "guide_for_dc".equals(operateKey);
    }

    private boolean isModifyOperation(AbstractOperate operate) {
        if (operate instanceof Modify) {
            return true;
        }
        String operateKey = operate.getOperateKey();
        return "modify".equals(operateKey) || "modify_category".equals(operateKey) || "modify_flow_category".equals(operateKey);
    }

    private boolean isDeleteOperation(AbstractOperate operate) {
        if (operate instanceof Delete) {
            return true;
        }
        String operateKey = operate.getOperateKey();
        return "delete".equals(operateKey);
    }

    private boolean isCopyOperation(AbstractOperate operate) {
        if (operate instanceof Copy) {
            return true;
        }
        String operateKey = operate.getOperateKey();
        return "copy".equals(operateKey);
    }

    private void checkOpPermission(BeforeDoOperationEventArgs evt, String entityName, String operation) {
        ListSelectedRowCollection selectedRows = evt.getListSelectedData();
        if (selectedRows.isEmpty()) {
            return;
        }
        try {
            Map<Object, DynamicObject> objects = this.getSelectData(entityName, selectedRows);
            if (objects.isEmpty()) {
                return;
            }
            for (DynamicObject object : objects.values()) {
                String opMessage = ResourceControl.checkOpPermission((String)operation, (DynamicObject)object);
                if (opMessage == null) continue;
                evt.setCancel(true);
                this.getView().showTipNotification(opMessage);
                return;
            }
        }
        catch (Exception e) {
            evt.setCancel(true);
            FormOpener.showErrorMessage(this.getView(), e);
        }
    }

    private Map<Object, DynamicObject> getSelectData(String entityId, ListSelectedRowCollection collection) {
        QFilter filter = new QFilter("id", "in", (Object)collection.getPrimaryKeyValues());
        return BusinessDataServiceHelper.loadFromCache((String)entityId, (QFilter[])new QFilter[]{filter});
    }

    static {
        ENTITIES_SHOULD_IGNORE_MODIFY.add("isc_call_api_by_timer");
        ENTITIES_SHOULD_IGNORE_MODIFY.add("isc_call_api_by_evt");
        ENTITIES_SHOULD_IGNORE_MODIFY.add("isc_call_api_by_mq");
        ENTITIES_SHOULD_IGNORE_MODIFY.add("isc_dataset_schema");
    }
}

