/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.formplugin.resource.backup;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.report.CellStyle;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.CellClickEvent;
import kd.bos.form.control.events.CellClickListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.isc.iscb.formplugin.resource.backup.Util;
import kd.isc.iscb.formplugin.util.FormOpener;
import kd.isc.iscb.platform.core.job.Job;
import kd.isc.iscb.platform.core.job.JobEngine;
import kd.isc.iscb.platform.core.job.JobInfo;
import kd.isc.iscb.platform.core.resource.backup.GitlabNetUtil;
import kd.isc.iscb.platform.core.resource.backup.PushJob;
import kd.isc.iscb.util.misc.Json;

public class CompareFormPlugin
extends AbstractFormPlugin
implements CellClickListener {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
        entryGrid.addCellClickListener((CellClickListener)this);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        long taskId = (Long)this.getView().getFormShowParameter().getCustomParam("taskId");
        DynamicObject task = BusinessDataServiceHelper.loadSingle((Object)taskId, (String)"isc_res_backup_task", (String)"entryentity.res_type,entryentity.res_number,,entryentity.res_name,,entryentity.res_pk,,entryentity.res_time");
        DynamicObjectCollection resources = task.getDynamicObjectCollection("entryentity");
        DynamicObjectCollection entryentity = this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity");
        entryentity.clear();
        ArrayList<CellStyle> styles = new ArrayList<CellStyle>(resources.size());
        int i = 0;
        for (DynamicObject res : resources) {
            DynamicObject o = entryentity.addNew();
            o.set("res_type", res.get("res_type"));
            o.set("number", res.get("res_number"));
            o.set("name", res.get("res_name"));
            o.set("pk", res.get("res_pk"));
            o.set("res_time", res.get("res_time"));
            boolean exists = GitlabNetUtil.exists((String)res.getString("res_type.number"), (String)res.getString("res_pk"));
            o.set("mode", (Object)(exists ? "cover" : "new"));
            CellStyle cellStyle = new CellStyle();
            cellStyle.setRow(i++);
            cellStyle.setFieldKey("mode");
            cellStyle.setForeColor(exists ? "red" : "green");
            styles.add(cellStyle);
        }
        EntryGrid grid = (EntryGrid)this.getView().getControl("entryentity");
        grid.setCellStyle(styles);
        this.getView().updateView("entryentity");
    }

    public void cellClick(CellClickEvent evt) {
        String fieldKey = evt.getFieldKey();
        if ("compare_column".equals(fieldKey)) {
            this.doCompare(evt);
        }
    }

    private void doCompare(CellClickEvent evt) {
        DynamicObjectCollection entryentity = this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity");
        DynamicObject object = (DynamicObject)entryentity.get(evt.getRow());
        String entity = object.getString("res_type.id");
        String pk = object.getString("pk");
        Util.showCompareLocalAndGit(this, entity, pk);
    }

    public void cellDoubleClick(CellClickEvent cellClickEvent) {
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        if ("push".equals(args.getOperateKey()) && args.getOperationResult().isSuccess()) {
            long taskId = (Long)this.getView().getFormShowParameter().getCustomParam("taskId");
            this.startPushJob(taskId);
        }
    }

    private void startPushJob(long taskId) {
        List jobs = JobEngine.getJobsWithOwnerId((long)taskId);
        String title = String.format(ResManager.loadKDString((String)"\u89e3\u6790\u8d44\u6e90\u5e76\u5907\u4efd", (String)"CompareFormPlugin_4", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), new Object[0]);
        HashMap<String, Object> param = new HashMap<String, Object>(3);
        param.put("taskId", taskId);
        param.put("remark", this.getModel().getValue("remark"));
        if (jobs.isEmpty()) {
            PushJob job = new PushJob(title, Json.toString(param));
            FormOpener.startJob(this, (Job)job, "started", param);
        } else {
            JobInfo jobInfo = (JobInfo)jobs.get(0);
            FormOpener.reopenJob(this, jobInfo.getId(), jobInfo.getTitle(), "started", param);
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        this.getView().close();
    }
}

