/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.formplugin.resource.backup;

import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.bill.BillShowParameter;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.entity.list.QueryResult;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.PagerClickEvent;
import kd.bos.form.events.PagerClickListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.id.IDService;
import kd.bos.list.BillList;
import kd.bos.list.events.CreateListDataProviderListener;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.isc.iscb.formplugin.resource.backup.Util;
import kd.isc.iscb.formplugin.util.FormOpener;
import kd.isc.iscb.platform.core.imp.FileResourceUtil;
import kd.isc.iscb.platform.core.job.Job;
import kd.isc.iscb.platform.core.job.JobEngine;
import kd.isc.iscb.platform.core.job.JobInfo;
import kd.isc.iscb.platform.core.job.JobState;
import kd.isc.iscb.platform.core.resource.backup.GitlabNetUtil;
import kd.isc.iscb.platform.core.resource.backup.PullJob;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.except.IscBizException;
import kd.isc.iscb.util.misc.Hash;
import kd.isc.iscb.util.misc.Json;
import kd.isc.iscb.util.misc.StringUtil;

public class ResourceBackupFormPlugin
extends AbstractFormPlugin
implements CreateListDataProviderListener,
TreeNodeClickListener,
PagerClickListener {
    private static Log logger = LogFactory.getLog(ResourceBackupFormPlugin.class);
    private static final String ROOT_ID = "ROOT";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        TreeView treeView = (TreeView)this.getView().getControl("treeviewap");
        treeView.addTreeNodeClickListener((TreeNodeClickListener)this);
        BillList list = (BillList)this.getView().getControl("billlistap");
        list.addPagerClickListener((PagerClickListener)this);
    }

    private void query() {
        BillList list = (BillList)this.getView().getControl("billlistap");
        list.setBillFormId(this.getFocusNodeId());
        list.addCreateListDataProviderListener((CreateListDataProviderListener)this);
    }

    public void createListDataProvider(BeforeCreateListDataProviderArgs e) {
        ListDataProvider provider = new ListDataProvider(){

            public DynamicObjectCollection getData(int start, int limit) {
                DynamicObjectCollection rows = super.getData(start, limit);
                rows.clear();
                int page = start / limit + 1;
                ResourceBackupFormPlugin.this.queryData(page, limit, rows, this.getQueryResult());
                return rows;
            }
        };
        e.setListDataProvider((IListDataProvider)provider);
    }

    private void queryData(int page, int limit, DynamicObjectCollection rows, QueryResult queryResult) {
        BillList billList = (BillList)this.getControl("billlistap");
        String entity = billList.getBillFormId();
        Map queryData = GitlabNetUtil.queryRepositoryTree((String)GitlabNetUtil.createResourceCatalogPath((String)entity), (int)page, (int)limit);
        List files = (List)queryData.get("data");
        int i = 0;
        for (Map item : files) {
            String fullpath = D.s(item.get("path"));
            String filename = D.s(item.get("name"));
            Map fileHead = GitlabNetUtil.queryFileHead((String)fullpath);
            Map commitMap = GitlabNetUtil.querySingleCommit((String)((String)fileHead.get("lastCommitId")));
            String title = D.s(commitMap.get("title"));
            HashMap<String, String> resInfo = null;
            try {
                resInfo = (HashMap<String, String>)Json.toObject((String)title);
            }
            catch (Exception e) {
                logger.warn("git\u5907\u4efd\u7684\u8d44\u6e90[" + fullpath + "]\u7684\u63d0\u4ea4\u5907\u6ce8\u4fe1\u606f\u89e3\u6790json\u5931\u8d25\u4e86\uff0c\u65e0\u6cd5\u83b7\u53d6\u540d\u79f0\u548c\u7f16\u7801\u3002");
                resInfo = new HashMap<String, String>(2);
                resInfo.put("number", "-");
                resInfo.put("name", "-");
            }
            String createdAt = commitMap.get("created_at").toString();
            DateTimeFormatter formatter = DateTimeFormatter.ISO_OFFSET_DATE_TIME;
            LocalDateTime localDateTime = OffsetDateTime.parse(createdAt, formatter).toLocalDateTime();
            DynamicObject row = new DynamicObject(rows.getDynamicObjectType());
            row.set("number", resInfo.get("number"));
            row.set("name", resInfo.get("name"));
            row.set("id", (Object)filename.split("\\.")[0]);
            row.set("createtime", (Object)D.t((Object)localDateTime));
            rows.add(i++, row);
        }
        queryResult.setDataCount(D.i(queryData.get("total")));
        queryResult.setCollection(rows);
        queryResult.setBillDataCount(0);
        billList.clearSelection();
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        try {
            this.initTree();
            this.query();
        }
        catch (Throwable t) {
            FormOpener.showErrorMessage(this.getView(), t);
        }
    }

    public void treeNodeClick(TreeNodeEvent evt) {
        this.query();
        this.getView().updateView("billlistap");
    }

    private void initTree() {
        TreeView treeView = (TreeView)this.getView().getControl("treeviewap");
        treeView.deleteAllNodes();
        treeView.setMulti(false);
        TreeNode root = new TreeNode("", ROOT_ID, ResManager.loadKDString((String)"\u5168\u90e8", (String)"ResourceBackupFormPlugin_0", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
        root.setExpend(true);
        List<TreeNode> nodes = this.getChildrenNodes();
        if (nodes.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u67e5\u8be2\u5230\u5907\u4efd\u6570\u636e", (String)"ResourceBackupFormPlugin_1", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
            return;
        }
        root.setChildren(nodes);
        root.setDisabled(true);
        treeView.addNode(root);
        treeView.setRootVisible(true);
        treeView.expand(ROOT_ID);
        treeView.focusNode(new TreeNode(ROOT_ID, nodes.get(0).getId(), this.getEntityName(nodes.get(0).getId())));
    }

    private List<TreeNode> getChildrenNodes() {
        Map queryData = GitlabNetUtil.queryRepositoryTree((String)GitlabNetUtil.createDataCenterCatalogPath(), (int)1, (int)Integer.MAX_VALUE);
        List list = (List)queryData.get("data");
        ArrayList<TreeNode> nodes = new ArrayList<TreeNode>();
        for (Map item : list) {
            String entity = D.s(item.get("name"));
            String type = D.s(item.get("type"));
            if (!"tree".equals(type)) continue;
            nodes.add(new TreeNode(ROOT_ID, entity, this.getEntityName(entity)));
        }
        return nodes;
    }

    private String getEntityName(String entity) {
        return EntityMetadataCache.getDataEntityType((String)entity).getDisplayName().getLocaleValue();
    }

    private String getFocusNodeId() {
        TreeView treeView = (TreeView)this.getView().getControl("treeviewap");
        return treeView.getTreeState().getFocusNodeId();
    }

    public void pagerClick(PagerClickEvent evt) {
        this.query();
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        BillList list;
        ListSelectedRowCollection collection;
        super.beforeDoOperation(args);
        AbstractOperate oper = (AbstractOperate)args.getSource();
        String key = oper.getOperateKey();
        if ("pull".equals(key) && (collection = (list = (BillList)this.getView().getControl("billlistap")).getSelectedRows()).size() == 0) {
            String tips = ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6570\u636e", (String)"ResourceBackupFormPlugin_5", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]);
            this.getView().showTipNotification(tips);
            args.setCancel(Boolean.TRUE.booleanValue());
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String key = args.getOperateKey();
        try {
            if ("refresh".equals(key)) {
                this.query();
                this.getView().updateView("billlistap");
            } else if ("pull".equals(key)) {
                this.download();
            } else if ("pull_all".equals(key)) {
                String focusNodeId = this.getFocusNodeId();
                if (!StringUtil.isEmpty((String)focusNodeId)) {
                    String tips = String.format(ResManager.loadKDString((String)"\u786e\u5b9a\u62c9\u53d6%s\u7684\u5168\u91cf\u5907\u4efd\u6570\u636e\u5417\uff1f", (String)"ResourceBackupFormPlugin_2", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), this.getEntityName(focusNodeId));
                    ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("pull_all", (IFormPlugin)this);
                    this.getView().showConfirm(tips, MessageBoxOptions.YesNo, confirmCallBacks);
                }
            } else if ("log".equals(key)) {
                this.showLog();
            }
        }
        catch (Throwable t) {
            FormOpener.showErrorMessage(this.getView(), t);
        }
    }

    private void showLog() {
        BillList list = (BillList)this.getView().getControl("billlistap");
        ListSelectedRowCollection rows = list.getSelectedRows();
        if (rows.size() != 1) {
            String tips = String.format(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u6570\u636e\u67e5\u770b\u65e5\u5fd7", (String)"ResourceBackupFormPlugin_6", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), new Object[0]);
            this.getView().showTipNotification(tips);
            return;
        }
        ListSelectedRow row = rows.get(0);
        String pk = D.s((Object)row.getPrimaryKeyValue());
        String entity = this.getFocusNodeId();
        Util.showLog(this.getView(), entity, pk);
    }

    private void download() {
        BillList list = (BillList)this.getView().getControl("billlistap");
        ListSelectedRowCollection rows = list.getSelectedRows();
        ArrayList<Map<String, String>> pullData = new ArrayList<Map<String, String>>(rows.size());
        for (ListSelectedRow row : rows) {
            String pk = D.s((Object)row.getPrimaryKeyValue());
            String entity = this.getFocusNodeId();
            boolean exists = GitlabNetUtil.exists((String)entity, (String)pk);
            if (exists) {
                HashMap<String, String> item = new HashMap<String, String>(2);
                item.put("entity", entity);
                item.put("pk", pk);
                pullData.add(item);
                continue;
            }
            String tips = ResManager.loadKDString((String)"\u6ca1\u6709\u67e5\u8be2\u5230ID\u4e3a[%s]\u7684\u8d44\u6e90\u5907\u4efd\u8bb0\u5f55", (String)"ResourceBackupFormPlugin_3", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]);
            throw new IscBizException(String.format(tips, pk));
        }
        this.startJob(pullData);
    }

    public void confirmCallBack(MessageBoxClosedEvent evt) {
        super.confirmCallBack(evt);
        if ("pull_all".equals(evt.getCallBackId()) && evt.getResult() == MessageBoxResult.Yes) {
            this.downloadAll();
        }
    }

    private void downloadAll() {
        String entity = this.getFocusNodeId();
        Map map = GitlabNetUtil.queryRepositoryTree((String)GitlabNetUtil.createResourceCatalogPath((String)entity), (int)1, (int)Integer.MAX_VALUE);
        List list = (List)map.get("data");
        ArrayList<Map<String, String>> pullData = new ArrayList<Map<String, String>>(list.size());
        for (Map item : list) {
            String filename = D.s(item.get("name"));
            String pk = filename.split("\\.")[0];
            HashMap<String, String> params = new HashMap<String, String>(2);
            params.put("entity", entity);
            params.put("pk", pk);
            pullData.add(params);
        }
        this.startJob(pullData);
    }

    private void startJob(List<Map<String, String>> pullData) {
        HashMap<String, Object> param = new HashMap<String, Object>(2);
        long billId = this.saveImportBillHead();
        param.put("billId", billId);
        param.put("pullData", pullData);
        List jobs = JobEngine.getJobsWithOwnerId((long)billId);
        if (jobs.isEmpty()) {
            String title = ResManager.loadKDString((String)"\u62c9\u53d6\u6587\u4ef6", (String)"ResourceBackupFormPlugin_4", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]);
            PullJob job = new PullJob(title, Json.toString(param));
            FormOpener.startJob(this, (Job)job, "pulljob", param);
        } else {
            JobInfo jobInfo = (JobInfo)jobs.get(0);
            FormOpener.reopenJob(this, jobInfo.getId(), jobInfo.getTitle(), "pulljob", param);
        }
    }

    private long saveImportBillHead() {
        DynamicObject object = BusinessDataServiceHelper.newDynamicObject((String)"isc_dts_imp");
        long billId = IDService.get().genLongId();
        String billno = Hash.mur32((Object[])new Object[]{billId});
        object.set("id", (Object)billId);
        object.set("billstatus", (Object)Character.valueOf('A'));
        object.set("creator", (Object)RequestContext.get().getUserId());
        object.set("billno", (Object)billno);
        object.set("res_type", (Object)FileResourceUtil.getEntityTitle((String)"isc_res_backup_task"));
        object.set("progress", (Object)"PARSED");
        object.set("state", (Object)"READY");
        object.set("modifytime", (Object)D.t((Object)System.currentTimeMillis()));
        object.set("modifier", (Object)RequestContext.get().getUserId());
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{object});
        return billId;
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        super.closedCallBack(evt);
        String action = evt.getActionId();
        if ("pulljob".equals(action)) {
            boolean failed;
            Map returnData = (Map)evt.getReturnData();
            long billId = D.l(returnData.get("billId"));
            boolean jobComplete = !JobEngine.existsRunningJobWithOwnerId((long)billId);
            List jobs = JobEngine.getAllJobsWithOwnerId((long)billId);
            boolean bl = failed = ((JobInfo)jobs.get(0)).getState() == JobState.FAILED;
            if (jobComplete && !failed) {
                BillShowParameter billShowParameter = new BillShowParameter();
                billShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                billShowParameter.setFormId("isc_dts_backup_recover");
                billShowParameter.setPkId((Object)billId);
                this.getView().showForm((FormShowParameter)billShowParameter);
            }
        }
    }
}

