/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.formplugin.resource.backup;

import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.isc.iscb.formplugin.util.FormOpener;
import kd.isc.iscb.platform.core.resource.backup.GitlabNetUtil;
import kd.isc.iscb.platform.core.resource.packages.ExportUtil;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.misc.Json;

public class Util {
    private static Log logger = LogFactory.getLog(Util.class);

    public static void showLog(IFormView view, String entity, String pk) {
        List commits = GitlabNetUtil.queryFileCommits((String)GitlabNetUtil.createResourceFilePath((String)entity, (String)pk));
        ArrayList param = new ArrayList(commits.size());
        for (Map c : commits) {
            HashMap<String, String> item = new HashMap<String, String>();
            String createdAt = (String)c.get("created_at");
            DateTimeFormatter formatter = DateTimeFormatter.ISO_OFFSET_DATE_TIME;
            LocalDateTime localDateTime = OffsetDateTime.parse(createdAt, formatter).toLocalDateTime();
            item.put("created_at", D.t((Object)localDateTime).toString());
            String title = D.s(c.get("title"));
            HashMap<String, String> resInfo = null;
            try {
                resInfo = (HashMap<String, String>)Json.toObject((String)title);
            }
            catch (Exception e) {
                logger.warn("git\u5907\u4efd\u7684\u8d44\u6e90[" + GitlabNetUtil.createResourceFilePath((String)entity, (String)pk) + "]\u7684\u63d0\u4ea4\u5907\u6ce8\u4fe1\u606f\u89e3\u6790json\u5931\u8d25\u4e86\uff0c\u65e0\u6cd5\u83b7\u53d6\u540d\u79f0\u548c\u7f16\u7801\u3002");
                resInfo = new HashMap<String, String>(2);
                resInfo.put("number", "-");
                resInfo.put("name", "-");
            }
            item.put("name", (String)resInfo.get("name"));
            item.put("number", (String)resInfo.get("number"));
            item.put("pk", pk);
            item.put("author", (String)resInfo.get("author"));
            item.put("remark", (String)resInfo.get("remark"));
            item.put("commit_id", (String)c.get("id"));
            param.add(item);
        }
        FormShowParameter p = new FormShowParameter();
        p.setFormId("isc_res_backup_log");
        p.setCustomParam("data", param);
        p.setCustomParam("entity", (Object)entity);
        p.getOpenStyle().setShowType(ShowType.Modal);
        view.showForm(p);
    }

    public static Map<String, Object> getMainResMap(String content) {
        String[] jsons;
        for (String json : jsons = content.split("\\n")) {
            boolean isRef;
            Map data = (Map)Json.toObject((String)json);
            if (data == null || (isRef = D.x(data.get("$isref")))) continue;
            return data;
        }
        return null;
    }

    public static void showCompareLocalAndGit(AbstractFormPlugin form, String entity, String pk) {
        Util.showCompareLocalAndGit(form, entity, pk, null);
    }

    public static void showCompareLocalAndGit(AbstractFormPlugin form, String entity, String pk, String commitId) {
        if (GitlabNetUtil.exists((String)entity, (String)pk)) {
            String content = GitlabNetUtil.queryFileContent((String)entity, (String)pk, (String)commitId);
            Map<String, Object> cloudResMap = Util.getMainResMap(content);
            if (!QueryServiceHelper.exists((String)entity, (Object)pk)) {
                String tips = ResManager.loadKDString((String)"\u6b64\u8d44\u6e90\u5728\u672c\u5730\u5df2\u4e0d\u5b58\u5728", (String)"BackupUtil_1", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]);
                form.getView().showTipNotification(tips);
            } else {
                DynamicObject o = BusinessDataServiceHelper.loadSingle((Object)pk, (String)entity);
                String dts = ExportUtil.exportDynamicObjectToDts((DynamicObject)o);
                Map<String, Object> localResMap = Util.getMainResMap(dts);
                String s1 = ResManager.loadKDString((String)"\u4e91\u7aef", (String)"BackupUtil_2", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]);
                String s2 = ResManager.loadKDString((String)"\u672c\u5730", (String)"BackupUtil_3", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]);
                FormOpener.showDiffComp(form, entity, localResMap, s2, cloudResMap, s1);
            }
        } else {
            String tips = ResManager.loadKDString((String)"\u4e91\u7aef\u8fd8\u6ca1\u6709\u5907\u4efd\u6b64\u8d44\u6e90", (String)"BackupUtil_0", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]);
            form.getView().showTipNotification(tips);
        }
    }
}

