/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.formplugin.resource.packages;

import java.util.EventObject;
import java.util.LinkedHashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.control.Html;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.isc.iscb.formplugin.resource.packages.PackagesUtil;
import kd.isc.iscb.platform.core.solution.SolutionUtil;
import kd.isc.iscb.util.dt.D;

public class PackagesFormPlugin
extends AbstractFormPlugin {
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.getModel().setValue("number", (Object)"PACKAGE_");
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        Html htmlap = (Html)this.getView().getControl("htmlap");
        String tips = ResManager.loadKDString((String)"\u4e3a\u907f\u514d\u6253\u5305\u540e\u672c\u5730\u8d44\u6e90\u53d1\u751f\u53d8\u52a8\u5bfc\u81f4\u8d44\u6e90\u5305\u53d1\u751f\u66f4\u6539\uff0c\u8bf7\u5373\u65f6\u5bfc\u51fa\u8d44\u6e90\u5305\u3002", (String)"PackagesFormPlugin_3", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]);
        String html = "<div style=\"background: #E0EEFD;padding: 4px 16px 4px 30px; box-sizing: border-box; width: 100%;font-weight: 400; font-style: normal; font-size: 12px; color: #1890FF; line-height: 40px;\"> <p><span>" + tips + "</span></p> </div>";
        htmlap.setConent(html);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate oper = (AbstractOperate)args.getSource();
        String key = oper.getOperateKey();
        if ("save".equals(key)) {
            int size = this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity").size();
            if (size == 0) {
                String tips = ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8d44\u6e90", (String)"PackagesFormPlugin_1", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]);
                this.getView().showTipNotification(tips);
                args.setCancel(Boolean.TRUE.booleanValue());
            } else if (size > PackagesUtil.getPackagesLimit()) {
                String tips = ResManager.loadKDString((String)"\u6700\u591a\u6dfb\u52a0%s\u4e2a\u8d44\u6e90", (String)"PackagesFormPlugin_2", (String)"isc-iscb-platform-formplugin", (Object[])new Object[]{PackagesUtil.getPackagesLimit()});
                this.getView().showTipNotification(tips, Integer.valueOf(10000));
                args.setCancel(Boolean.TRUE.booleanValue());
            } else {
                this.getModel().setValue("res_count", (Object)size);
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String key = args.getOperateKey();
        if ("choose_res".equals(key)) {
            this.showF7();
        }
    }

    private void showF7() {
        ListShowParameter p = new ListShowParameter();
        p.setFormId("isc_resource_f7");
        p.getOpenStyle().setShowType(ShowType.Modal);
        p.setF7Style(0);
        p.setMultiSelect(true);
        p.setShowTitle(true);
        p.setHasRight(true);
        StyleCss css = new StyleCss();
        css.setWidth("1200px");
        css.setHeight("700px");
        p.getOpenStyle().setInlineStyleCss(css);
        p.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "select_res"));
        p.setShowFilter(false);
        p.setShowQuickFilter(false);
        p.setCustomParam("limit", (Object)PackagesUtil.getPackagesLimit());
        this.getView().showForm((FormShowParameter)p);
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        String actionId = e.getActionId();
        Object returnData = e.getReturnData();
        if (returnData == null) {
            return;
        }
        if ("select_res".equals(actionId)) {
            this.addResources((ListSelectedRowCollection)returnData);
        }
    }

    private void addResources(ListSelectedRowCollection collection) {
        DynamicObjectCollection entries = this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity");
        Map<String, DynamicObject> objectMap = PackagesFormPlugin.convertToMap(entries);
        for (ListSelectedRow row : collection) {
            DynamicObject item;
            Object resourcesId = row.getPrimaryKeyValue();
            String entity = row.getFormID();
            String key = SolutionUtil.getFullKey((String)entity, (Object)resourcesId);
            DynamicObject existedRes = objectMap.get(key);
            if (existedRes != null) {
                item = existedRes;
            } else {
                int limit = PackagesUtil.getPackagesLimit();
                if (entries.size() >= limit) {
                    String tips = ResManager.loadKDString((String)"\u9009\u62e9\u7684\u8d44\u6e90\u5df2\u7ecf\u8fbe\u5230%1$s\u6761\uff0c\u5df2\u7ecf\u622a\u65ad\uff0c\u4e00\u4e2a\u8d44\u6e90\u5305\u53ea\u80fd\u6253\u5305%2$s\u6761\u8d44\u6e90\u3002\u5982\u679c\u60a8\u89c9\u5f97\u4e0d\u591f\uff0c\u53ef\u4ee5\u7528 isc_packages_limit \u79df\u6237\u7ea7\u53c2\u6570\u4fee\u6539\u914d\u7f6e", (String)"PackagesFormPlugin_4", (String)"isc-iscb-platform-formplugin", (Object[])new Object[]{limit, limit});
                    this.getView().showTipNotification(tips, Integer.valueOf(10000));
                    break;
                }
                item = entries.addNew();
            }
            DynamicObject res = BusinessDataServiceHelper.loadSingle((Object)resourcesId, (String)entity);
            item.set("res_type", (Object)BusinessDataServiceHelper.loadSingleFromCache((Object)entity, (String)"bos_objecttype"));
            item.set("res_number", (Object)res.getString("number"));
            item.set("res_name", (Object)res.getString("name"));
            item.set("res_pk", res.getPkValue());
            item.set("res_time", res.get(SolutionUtil.getTimeField((String)entity)));
        }
        this.getModel().setValue("res_count", (Object)entries.size());
        this.getView().updateView("entryentity");
    }

    private static Map<String, DynamicObject> convertToMap(DynamicObjectCollection entries) {
        LinkedHashMap<String, DynamicObject> map = new LinkedHashMap<String, DynamicObject>(entries.size());
        for (DynamicObject object : entries) {
            String entity = D.s((Object)((DynamicObject)object.get("res_type")).getPkValue());
            String pk = D.s((Object)object.get("res_pk"));
            map.put(SolutionUtil.getFullKey((String)entity, (Object)pk), object);
        }
        return map;
    }
}

