/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.formplugin.resource.packages;

import java.util.EventObject;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.control.AttachmentPanel;
import kd.bos.form.control.events.UploadEvent;
import kd.bos.form.control.events.UploadListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.isc.iscb.formplugin.util.FormOpener;
import kd.isc.iscb.platform.core.job.Job;
import kd.isc.iscb.platform.core.job.JobEngine;
import kd.isc.iscb.platform.core.job.JobInfo;
import kd.isc.iscb.platform.core.resource.packages.ImportPackagesParseJob;
import kd.isc.iscb.util.dt.D;

public class PackagesImportFormPlugin
extends AbstractFormPlugin
implements UploadListener {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        AttachmentPanel attachmentPanel = (AttachmentPanel)this.getView().getControl("attachmentpanel");
        attachmentPanel.addUploadListener((UploadListener)this);
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.setParseBtnByResIsEmpty();
        String progress = D.s((Object)this.getModel().getValue("progress"));
        this.setButtonParse(progress);
    }

    private void setButtonParse(String progress) {
        boolean isParseable = "READY".equals(progress);
        this.getView().setEnable(Boolean.valueOf(isParseable), new String[]{"parse_zip"});
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        if ("parse_zip".equals(e.getOperateKey())) {
            this.startParsingFiles();
        }
    }

    private void startParsingFiles() {
        IDataModel m = this.getModel();
        long id = D.l((Object)m.getValue("id"));
        List jobs = JobEngine.getJobsWithOwnerId((long)id);
        if (jobs.isEmpty()) {
            ImportPackagesParseJob job = new ImportPackagesParseJob(id, String.format(ResManager.loadKDString((String)"\u89e3\u6790\u8d44\u6e90\u5305\uff0c\u6279\u53f7\uff1a%s", (String)"PackagesImportFormPlugin_1", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), m.getValue("billno")));
            FormOpener.startJob(this, (Job)job, "parsed");
        } else {
            JobInfo jobInfo = (JobInfo)jobs.get(0);
            FormOpener.reopenJob(this, jobInfo.getId(), jobInfo.getTitle(), "parsed");
        }
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        super.closedCallBack(evt);
        String action = evt.getActionId();
        if ("parsed".equals(action) || "imported".equals(action)) {
            this.getView().invokeOperation("refresh");
        }
    }

    private void setParseBtnByResIsEmpty() {
        AttachmentPanel attachmentPanel = (AttachmentPanel)this.getView().getControl("attachmentpanel");
        List list = attachmentPanel.getAttachmentData();
        this.getView().setEnable(Boolean.valueOf(!list.isEmpty()), new String[]{"parse_zip"});
    }

    public void afterUpload(UploadEvent evt) {
        this.setParseBtnByResIsEmpty();
    }

    public void afterRemove(UploadEvent evt) {
        this.setParseBtnByResIsEmpty();
    }
}

