/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.formplugin.robot;

import java.sql.Timestamp;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.id.IDService;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.isc.iscb.formplugin.robot.SmartRobotListPlugin;
import kd.isc.iscb.platform.core.connector.ConnectorUtil;
import kd.isc.iscb.platform.core.solution.PublicResourceUtil;
import kd.isc.iscb.util.dt.D;

public class SmartRobotCloudListPlugin
extends AbstractFormPlugin {
    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        List data = (List)this.getView().getFormShowParameter().getCustomParam("data");
        DynamicObjectCollection entryentity = this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity");
        entryentity.clear();
        for (Map datum : data) {
            DynamicObject object = entryentity.addNew();
            object.set("id", datum.get("id"));
            object.set("name", datum.get("name"));
            object.set("cosmicversion", datum.get("cosmicversion"));
            object.set("suggest_model", datum.get("suggest_model"));
            object.set("version", datum.get("version"));
            object.set("scene", datum.get("scene"));
            object.set("label", datum.get("label"));
            object.set("modifytime", (Object)D.t(datum.get("modifytime")));
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        if ("ok".equals(operateKey)) {
            int[] rowNum = ((EntryGrid)this.getView().getControl("entryentity")).getSelectRows();
            if (rowNum.length == 1) {
                DynamicObject rowEntity = this.getModel().getEntryRowEntity("entryentity", rowNum[0]);
                HashMap<String, Long> data = new HashMap<String, Long>();
                data.put("id", rowEntity.getLong("id"));
                Map result = (Map)PublicResourceUtil.queryListByGet((String)"kapi/v2/kdec/kdec_eip_resource/kdec_smart_robot_cloud/KD_ISC_GET_CLOUD_BYID", data).get(0);
                this.updateSmartRobot(result);
                this.getView().returnDataToParent((Object)"ok");
                this.getView().close();
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"SmartRobotCloudListPlugin_0", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
            }
        }
    }

    private void updateSmartRobot(Map<String, Object> result) {
        QFilter q = new QFilter("number", "=", result.get("number"));
        DynamicObject robot = BusinessDataServiceHelper.loadSingle((String)"isc_smart_robot", (String)"id", (QFilter[])new QFilter[]{q});
        if (robot == null) {
            DynamicObject obj = BusinessDataServiceHelper.newDynamicObject((String)"isc_smart_robot");
            obj.set("creator", (Object)1);
            obj.set("createtime", (Object)new Timestamp(System.currentTimeMillis()));
            obj.set("enable", (Object)"0");
            obj.set("id", (Object)IDService.get().genLongId());
            this.updateRobot(result, obj);
        } else {
            long id = robot.getLong("id");
            DynamicObject obj = BusinessDataServiceHelper.loadSingle((Object)id, (String)"isc_smart_robot");
            this.updateRobot(result, obj);
            if (D.x((Object)obj.getBoolean("enable"))) {
                SmartRobotListPlugin.enableGaiPrompt(id);
            }
        }
    }

    private void updateRobot(Map<String, Object> result, DynamicObject obj) {
        obj.set("number", result.get("number"));
        obj.set("name", result.get("name"));
        obj.set("scene", result.get("scene"));
        obj.set("version", result.get("version"));
        obj.set("label", result.get("label"));
        obj.set("suggest_model", result.get("suggest_model"));
        obj.set("cosmicversion", result.get("cosmicversion"));
        obj.set("model_style", result.get("model_style") == null ? "BALANCE" : result.get("model_style"));
        obj.set("type", result.get("type"));
        obj.set("remembercount", result.get("remembercount"));
        obj.set("desc", result.get("desc"));
        obj.set("prompt", result.get("prompt"));
        obj.set("prompt_tag", result.get("prompt_tag"));
        DynamicObjectCollection collection = obj.getDynamicObjectCollection("var_configs");
        collection.clear();
        for (Map map : (List)result.get("var_configs")) {
            DynamicObject row = collection.addNew();
            row.set("var", map.get("var"));
            row.set("var_name", map.get("var_name"));
            row.set("var_type", map.get("vartype"));
        }
        ConnectorUtil.save((DynamicObject)obj);
    }
}

