/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.formplugin.sf;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.control.Control;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.isc.iscb.formplugin.util.FormOpener;
import kd.isc.iscb.platform.core.sf.Const;
import kd.isc.iscb.platform.core.util.CollectionUtils;
import kd.isc.iscb.platform.core.util.DynamicObjectUtil;
import kd.isc.iscb.util.dt.D;

public class DataCopyNodeEditorFormPlugin
extends AbstractFormPlugin
implements Const {
    private static final String PARAMS_VAR = "params_var";
    private static final String PARAMS_NAME = "params_name";
    private static final String PARAMS_ENTRY = "params_entry";
    private static final String DATA_COPY2 = "data_copy";
    private static final String ENTRY_ENTITY = "entryentity";

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        Map params = this.getView().getFormShowParameter().getCustomParams();
        boolean editable = D.x(params.get("editable"));
        if (editable) {
            String flowId = D.s(params.get("flow"));
            DynamicObject flow = BusinessDataServiceHelper.loadSingle((Object)flowId, (String)"isc_service_flow");
            this.loadSchema(flow, params);
        } else {
            this.getView().setStatus(OperationStatus.VIEW);
            this.viewSchema(params);
        }
        this.getModel().setValue("title", params.get("title"));
        this.getModel().setValue("src_var", params.get("src_var"));
        this.getModel().setValue("tar_var", params.get("tar_var"));
    }

    private void viewSchema(Map<String, Object> params) {
        Map schema = (Map)params.get(DATA_COPY2);
        if (schema == null) {
            return;
        }
        String var = D.s(schema.get("var"));
        ComboEdit combo = (ComboEdit)this.getView().getControl(DATA_COPY2);
        ComboItem item = new ComboItem();
        item.setCaption(new LocaleString(var + " - " + D.s(schema.get("name"))));
        item.setValue(var);
        combo.setComboItems(Collections.singletonList(item));
        this.getModel().setValue(DATA_COPY2, (Object)var);
        this.loadParams((List)params.get(PARAMS_ENTRY));
    }

    private void loadSchema(DynamicObject flow, Map<String, Object> params) {
        Map schema = (Map)params.get(DATA_COPY2);
        DynamicObjectCollection resources = flow.getDynamicObjectCollection("resources");
        HashMap<String, String> existedSchema = null;
        ArrayList<ComboItem> items = new ArrayList<ComboItem>(resources.size());
        ComboEdit combo = (ComboEdit)this.getView().getControl(DATA_COPY2);
        for (DynamicObject resource : resources) {
            if (!"isc_data_copy".equals(D.s((Object)resource.get("res_category")))) continue;
            HashMap<String, String> map = new HashMap<String, String>();
            String resAlias = D.s((Object)resource.get("res_alias"));
            ComboItem item = new ComboItem();
            item.setCaption(new LocaleString(resAlias + "-" + D.s((Object)resource.get("res_ref.name"))));
            item.setValue(resAlias);
            items.add(item);
            map.put("var", resAlias);
            map.put("id", D.s((Object)resource.get("res_ref.id")));
            if (schema == null || !resAlias.equals(schema.get("var"))) continue;
            existedSchema = map;
        }
        this.getModel().setValue(DATA_COPY2, existedSchema != null ? D.s(existedSchema.get("var")) : null);
        combo.setComboItems(items);
        if (existedSchema != null) {
            List p = (List)params.get(PARAMS_ENTRY);
            List existedParamList = p == null ? Collections.emptyList() : p;
            List<Map<String, Object>> dcParamsList = this.getDcParamsList(D.l(existedSchema.get("id")));
            this.refreshParams(existedParamList, dcParamsList);
        }
    }

    private void refreshParams(List<Map<String, Object>> existedParamList, List<Map<String, Object>> dcParamsList) {
        HashMap<String, Map<String, Object>> existed = new HashMap<String, Map<String, Object>>(existedParamList.size());
        for (Map<String, Object> map : existedParamList) {
            existed.put(D.s((Object)map.get(PARAMS_NAME)), map);
        }
        for (Map<String, Object> map : dcParamsList) {
            String name = D.s((Object)map.get(PARAMS_NAME));
            Map original = (Map)existed.get(name);
            if (original == null) continue;
            map.put(PARAMS_VAR, original.get(PARAMS_VAR));
        }
        this.loadParams(dcParamsList);
    }

    private void loadParams(List<Map<String, Object>> array) {
        if (!CollectionUtils.isEmpty(array)) {
            DynamicObjectCollection collection = this.getEntryCollection();
            collection.clear();
            for (Map<String, Object> map : array) {
                DynamicObject object = collection.addNew();
                object.set(PARAMS_NAME, map.get(PARAMS_NAME));
                object.set("params_label", map.get("params_label"));
                object.set("params_data_type", map.get("params_data_type"));
                object.set(PARAMS_VAR, map.get(PARAMS_VAR));
            }
            this.getView().updateView(ENTRY_ENTITY);
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btnok", "src_var", "tar_var"});
        this.addItemClickListeners(new String[]{DATA_COPY2});
        this.addClickListeners(new String[]{"vectorap"});
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        String dataCopy = null;
        if ("src_var".equals(key) || "tar_var".equals(key)) {
            HashMap<String, Object> param = new HashMap<String, Object>();
            param.put("flow_id", this.getView().getFormShowParameter().getCustomParam("flow"));
            param.put("key", key);
            FormOpener.showForm(this, "isc_sf_var_selector", ResManager.loadKDString((String)"\u9009\u62e9\u5c5e\u6027", (String)"DataCopyNodeEditorFormPlugin_0", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), param, "get_property");
        } else if ("vectorap".equals(key) && (dataCopy = D.s((Object)this.getModel().getValue(DATA_COPY2))) != null) {
            Map<String, Object> schema = this.getSelectedSchema(dataCopy);
            FormOpener.showView(this, "isc_data_copy", schema.get("id"));
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs evt) {
        super.afterDoOperation(evt);
        if (!D.x((Object)this.getView().getFormShowParameter().getCustomParam("editable"))) {
            this.getView().close();
            return;
        }
        if (this.getEntryCollection().isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u96c6\u6210\u65b9\u6848\u6ca1\u6709\u53c2\u6570\uff0c\u8bf7\u91cd\u65b0\u914d\u7f6e!", (String)"DataCopyNodeEditorFormPlugin_1", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
            return;
        }
        if (evt.getOperationResult() != null && evt.getOperationResult().isSuccess() && evt.getOperateKey().equals("returndata")) {
            this.returnData();
        }
    }

    private void returnData() {
        Map params = this.getView().getFormShowParameter().getCustomParams();
        params.put("title", this.getModel().getValue("title"));
        params.put("src_var", this.getModel().getValue("src_var"));
        params.put("tar_var", this.getModel().getValue("tar_var"));
        String dataCopy = D.s((Object)this.getModel().getValue(DATA_COPY2));
        params.put(DATA_COPY2, this.getSelectedSchema(dataCopy));
        DynamicObjectCollection entryEntity = this.getEntryCollection();
        params.put(PARAMS_ENTRY, DynamicObjectUtil.objectCollection2List((DynamicObjectCollection)entryEntity));
        this.getView().returnDataToParent((Object)params);
        this.getView().close();
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        Object returnData;
        super.closedCallBack(evt);
        String action = evt.getActionId();
        if (action.equals("get_property") && (returnData = evt.getReturnData()) instanceof Map) {
            String key = D.s(((Map)returnData).get("key"));
            String value = D.s(((Map)returnData).get("full_number"));
            this.getModel().setValue(key, (Object)value);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String prop = e.getProperty().getName();
        if (DATA_COPY2.equals(prop)) {
            String dataCopy = D.s((Object)this.getModel().getValue(DATA_COPY2));
            if (dataCopy == null) {
                this.getEntryCollection().clear();
                this.getView().updateView(ENTRY_ENTITY);
                return;
            }
            Map<String, Object> schema = this.getSelectedSchema(dataCopy);
            List<Map<String, Object>> dcParamsList = this.getDcParamsList(schema.get("id"));
            if (dcParamsList.isEmpty()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u96c6\u6210\u65b9\u6848\u6ca1\u6709\u53c2\u6570\uff0c\u8bf7\u91cd\u65b0\u914d\u7f6e!", (String)"DataCopyNodeEditorFormPlugin_1", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
                this.getEntryCollection().clear();
                this.getView().updateView(ENTRY_ENTITY);
            }
            this.loadParams(dcParamsList);
        }
    }

    private Map<String, Object> getSelectedSchema(String var) {
        if (!D.x((Object)this.getView().getFormShowParameter().getCustomParam("editable"))) {
            return (Map)this.getView().getFormShowParameter().getCustomParam(DATA_COPY2);
        }
        long flowId = D.l((Object)this.getView().getFormShowParameter().getCustomParam("flow"));
        DynamicObject flow = BusinessDataServiceHelper.loadSingle((Object)flowId, (String)"isc_service_flow");
        DynamicObjectCollection resources = flow.getDynamicObjectCollection("resources");
        for (DynamicObject res : resources) {
            if (!var.equals(D.s((Object)res.get("res_alias")))) continue;
            HashMap<String, Object> map = new HashMap<String, Object>(4);
            map.put("id", res.get("res_ref.id"));
            map.put("name", res.get("res_ref.name.zh_CN"));
            map.put("var", var);
            return map;
        }
        return Collections.emptyMap();
    }

    private List<Map<String, Object>> getDcParamsList(Object dataCopyId) {
        if (D.l((Object)dataCopyId) == 0L) {
            return Collections.emptyList();
        }
        DynamicObject obj = BusinessDataServiceHelper.loadSingle((Object)dataCopyId, (String)"isc_data_copy");
        DynamicObjectCollection paramEntries = obj.getDynamicObjectCollection("param_entries");
        return DynamicObjectUtil.objectCollection2List((DynamicObjectCollection)paramEntries);
    }

    private DynamicObjectCollection getEntryCollection() {
        return this.getModel().getDataEntity(true).getDynamicObjectCollection(ENTRY_ENTITY);
    }
}

