/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.formplugin.sf;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.IDataStorage;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Vector;
import kd.bos.form.control.events.CellClickEvent;
import kd.bos.form.control.events.CellClickListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.TextEdit;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.util.Assert;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.isc.iscb.formplugin.dc.DataCopyValidator;
import kd.isc.iscb.formplugin.sf.EditorUtil;
import kd.isc.iscb.formplugin.sf.ScriptTextUtil;
import kd.isc.iscb.formplugin.sf.Util;
import kd.isc.iscb.formplugin.util.FormOpener;
import kd.isc.iscb.platform.core.sf.Const;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.misc.StringUtil;

public class DataLoaderEditorFormPlugin
extends AbstractFormPlugin
implements Const,
CellClickListener {
    private static final String FULL_NUMBER2 = "full_number";
    private static final String RES_ALIAS = "res_alias";
    private static final String VAR_DESC = "var_desc";
    private static final String VAR = "var";
    private static final String VAR_NAME = "var_name";
    private static final String VAR_CATEGORY = "var_category";
    private static final String OUTPUT_FIELD_DESC = "output_field_desc";
    private static final String OUTPUT_FIELD_TYPE = "output_field_type";
    private static final String CANDIDATE_KEY = "candidate_key";
    private static final String CANDIDATE_KEYS = "candidate_keys";
    private static final String TAR_ACTION_TYPE = "tar_action_type";
    private static final String TAR_ACTION_NUMBER = "tar_action_number";
    private static final String TAR_ACTION_LABEL = "tar_action_label";
    private static final String ISC_METADATA_SCHEMA2 = "isc_metadata_schema";
    private static final String ISC_TYPE_SIMPLE_VALUE = "isc_type_simple_value";
    private static final String ACTIONS2 = "actions";
    private static final String ISC_SERVICE_FLOW2 = "isc_service_flow";
    private static final String TAR_IDS_OUTPUT_VAR = "tar_ids_output_var";
    private static final String TAR_RESULTS_OUTPUT_VAR = "tar_results_output_var";
    private static final String TAR_VAR_VALUE = "tar_var_value";
    private static final String DATA_SCHEMA_VALUE = "data_schema_value";
    private static final String DATA_SCHEMA_LABEL = "vectorap";
    private static final String TAR_VAR_LABEL = "vectorap1";
    private static final String BATCH_SIZE = "batch_size";
    private static final String TAR_ACTION_PARAMS = "tar_action_params";
    private static final String TAR_ACT_PARAMS_DESC = "tar_act_params_desc";

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        Map params = this.getView().getFormShowParameter().getCustomParams();
        long flowId = D.l(params.get("flow"));
        Map<String, String> dataSchemaValue = this.getMapFromParams(params, DATA_SCHEMA_VALUE, "dsName");
        Map<String, String> tarVarValue = this.getMapFromParams(params, TAR_VAR_VALUE, VAR);
        String outPutId = D.s(params.get(TAR_IDS_OUTPUT_VAR));
        String outPutResult = D.s(params.get(TAR_RESULTS_OUTPUT_VAR));
        boolean editable = D.x(params.get("editable"));
        if (flowId != 0L && editable) {
            DynamicObject flow = BusinessDataServiceHelper.loadSingle((Object)flowId, (String)ISC_SERVICE_FLOW2);
            this.initDataSchema(dataSchemaValue, flow);
            this.setComboEdit(flow);
            this.initTarVar(tarVarValue, flow);
        } else {
            this.setViewStatus(dataSchemaValue, outPutId, tarVarValue);
        }
        this.loadParamEntity(params, editable);
        this.getModel().setValue("proxy_user", params.get("proxy_user"));
        this.getModel().setValue("proxy_user_var", params.get("proxy_user_var"));
        this.getModel().setValue(TAR_IDS_OUTPUT_VAR, (Object)outPutId);
        this.getModel().setValue(TAR_RESULTS_OUTPUT_VAR, (Object)outPutResult);
        this.getModel().setValue("title", params.get("title"));
        this.getModel().setValue("save_state_on_success", (Object)D.x(params.get("save_state_on_success")));
        this.getModel().setValue("wait_for_on_failed", (Object)D.s(params.get("wait_for_on_failed")));
        this.getModel().setValue("wait_for_premise", (Object)D.s(params.get("wait_for_premise")));
        this.getModel().setValue(BATCH_SIZE, params.get(BATCH_SIZE));
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate operate = (AbstractOperate)args.getSource();
        String operationKey = operate.getOperateKey();
        if ("btnok".equalsIgnoreCase(operationKey)) {
            this.checkUpsertOp(args);
        }
    }

    private void checkUpsertOp(BeforeDoOperationEventArgs args) {
        DynamicObjectCollection actions = this.getModel().getEntryEntity(ACTIONS2);
        int batchSize = D.i((Object)this.getModel().getValue(BATCH_SIZE));
        if (this.containsUpsert(actions) && batchSize <= 1) {
            args.setCancel(true);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u76ee\u6807\u6570\u636e\u5206\u6279\u5927\u5c0f>1\u624d\u5141\u8bb8\u4f7f\u7528_UPSERT\u64cd\u4f5c\uff0c\u8bf7\u91cd\u65b0\u8bbe\u7f6e\u3002", (String)"DataLoaderEditorFormPlugin_21", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
        }
    }

    private boolean containsUpsert(DynamicObjectCollection actions) {
        for (DynamicObject op : actions) {
            if (!"_UPSERT".equals(op.get(TAR_ACTION_NUMBER))) continue;
            return true;
        }
        return false;
    }

    private Map<String, String> getMapFromParams(Map<String, Object> params, String key, String varName) {
        Map<Object, Object> map = new HashMap(3);
        Object obj = params.get(key);
        if (obj instanceof Map) {
            map = (Map)obj;
        } else if (obj instanceof String) {
            map = this.getMapFromString(params, key, varName);
        }
        return map;
    }

    private Map<String, String> getMapFromString(Map<String, Object> params, String key, String varName) {
        HashMap<String, String> map = new HashMap<String, String>(3);
        String s = D.s((Object)params.get(key));
        String id = s.split("\\$/")[1];
        String front = s.split("\\$/")[0];
        String name = front.split("\\(")[0];
        String desc = front.split("\\(")[1].substring(0, front.split("\\(")[1].lastIndexOf(41));
        map.put("id", id);
        map.put("desc", desc);
        map.put(varName, name);
        return map;
    }

    private void setViewStatus(Map<String, String> dataSchemaValue, String outPutId, Map<String, String> tarVar) {
        String desc;
        this.getView().setStatus(OperationStatus.VIEW);
        ComboEdit combo = (ComboEdit)this.getView().getControl("data_schema");
        ComboItem item = new ComboItem();
        if (dataSchemaValue != null) {
            String dsName = dataSchemaValue.get("dsName");
            desc = dataSchemaValue.get("desc");
            item.setCaption(new LocaleString(Util.getVarOrResName(desc, dsName)));
            item.setValue(dsName);
            combo.setComboItems(Collections.singletonList(item));
            this.getModel().setValue("data_schema", (Object)dsName);
        }
        if (tarVar != null) {
            combo = (ComboEdit)this.getView().getControl("tar_var");
            item = new ComboItem();
            String varName = tarVar.get(VAR);
            desc = tarVar.get("desc");
            item.setCaption(new LocaleString(Util.getVarOrResName(desc, varName)));
            item.setValue(varName);
            combo.setComboItems(Collections.singletonList(item));
            this.getModel().setValue("tar_var", (Object)varName);
        }
        this.getModel().setValue(TAR_IDS_OUTPUT_VAR, (Object)outPutId);
    }

    private void loadParamEntity(Map<String, Object> params, boolean editable) {
        List actions = (List)params.get(ACTIONS2);
        Map<String, String> dataSchemaValue = this.getMapFromParams(params, DATA_SCHEMA_VALUE, "dsName");
        this.setParamEntity(params, editable, actions, dataSchemaValue);
        List candidateKeys = (List)params.get("candidateKeys");
        if (candidateKeys != null) {
            if (candidateKeys.size() == 0 && editable) {
                this.addEmptyCankeysRow();
            } else {
                this.setCandidates(candidateKeys);
            }
        }
    }

    private void setParamEntity(Map<String, Object> params, boolean editable, List<Map<String, Object>> actions, Map<String, String> dataSchemaValue) {
        if (dataSchemaValue != null) {
            long flowId = this.getFlowId(params, editable);
            if (flowId == 0L) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u76f8\u5e94\u6d41\u7a0b\u5728\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728\u3002", (String)"DataLoaderEditorFormPlugin_0", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
                return;
            }
            this.innerSetParamEntitiy(editable, actions, dataSchemaValue, flowId);
        }
    }

    private long getFlowId(Map<String, Object> params, boolean editable) {
        long flowId = 0L;
        if (editable) {
            flowId = D.l((Object)params.get("flow"));
        } else {
            long released_id = D.l((Object)params.get("released_id"));
            if (released_id != 0L) {
                DynamicObject rFlow = BusinessDataServiceHelper.loadSingle((Object)released_id, (String)"isc_service_flow_r");
                flowId = D.l((Object)rFlow.get("flow"));
            }
        }
        return flowId;
    }

    private void innerSetParamEntitiy(boolean editable, List<Map<String, Object>> actions, Map<String, String> dataSchemaValue, long flowId) {
        DynamicObject flow = BusinessDataServiceHelper.loadSingle((Object)flowId, (String)ISC_SERVICE_FLOW2);
        String dsName = dataSchemaValue.get("dsName");
        if (dsName != null) {
            DynamicObject schema;
            long schemaId = D.l((Object)DataLoaderEditorFormPlugin.getResDsByName(flow, dsName));
            DynamicObject dynamicObject = schema = schemaId != 0L ? BusinessDataServiceHelper.loadSingle((Object)schemaId, (String)ISC_METADATA_SCHEMA2) : null;
            if (schema != null && actions != null) {
                if (actions.size() == 0 && editable) {
                    this.addEmptyActionsRow();
                } else {
                    this.setTargetActions(actions, schema);
                }
            }
        }
    }

    private void addEmptyActionsRow() {
        DynamicObjectCollection collection = this.getModel().getDataEntity(true).getDynamicObjectCollection(ACTIONS2);
        collection.clear();
        DynamicObject object = collection.addNew();
        object.set(TAR_ACTION_LABEL, null);
        object.set(TAR_ACTION_NUMBER, (Object)"");
        object.set(TAR_ACTION_TYPE, (Object)"");
        object.set(TAR_ACTION_PARAMS, (Object)"");
        object.set(TAR_ACT_PARAMS_DESC, (Object)"");
        this.getView().updateView(ACTIONS2);
    }

    private void addEmptyCankeysRow() {
        DynamicObjectCollection collection = this.getModel().getDataEntity(true).getDynamicObjectCollection(CANDIDATE_KEYS);
        collection.clear();
        DynamicObject object = collection.addNew();
        object.set(CANDIDATE_KEY, null);
        object.set(OUTPUT_FIELD_TYPE, (Object)"");
        object.set(OUTPUT_FIELD_DESC, (Object)"");
        this.getView().updateView(CANDIDATE_KEYS);
    }

    private void setTargetActions(List<Map<String, Object>> actions, DynamicObject schema) {
        List<ComboItem> comboItems = this.getComboItems(schema);
        DynamicObjectCollection collection = this.getModel().getDataEntity(true).getDynamicObjectCollection(ACTIONS2);
        collection.clear();
        for (Map<String, Object> action : actions) {
            DynamicObject object = collection.addNew();
            object.set(TAR_ACTION_LABEL, (Object)this.getCaption(comboItems, D.s((Object)action.get(TAR_ACTION_LABEL))));
            object.set(TAR_ACTION_NUMBER, action.get(TAR_ACTION_NUMBER));
            object.set(TAR_ACTION_TYPE, action.get(TAR_ACTION_TYPE));
            object.set(TAR_ACTION_PARAMS, action.get(TAR_ACTION_PARAMS));
            object.set(TAR_ACT_PARAMS_DESC, action.get(TAR_ACT_PARAMS_DESC));
        }
        this.getView().updateView(ACTIONS2);
    }

    private String getCaption(List<ComboItem> list, String value) {
        for (ComboItem item : list) {
            if (!item.getValue().equals(value)) continue;
            return D.s((Object)item.getCaption());
        }
        return value;
    }

    private void setCandidates(List<Map<String, Object>> candidateKeys) {
        DynamicObjectCollection collection = this.getModel().getDataEntity(true).getDynamicObjectCollection(CANDIDATE_KEYS);
        collection.clear();
        for (Map<String, Object> action : candidateKeys) {
            DynamicObject object = collection.addNew();
            object.set(CANDIDATE_KEY, action.get(CANDIDATE_KEY));
            object.set(OUTPUT_FIELD_TYPE, action.get(OUTPUT_FIELD_TYPE));
            object.set(OUTPUT_FIELD_DESC, action.get(OUTPUT_FIELD_DESC));
        }
        this.getView().updateView(CANDIDATE_KEYS);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{TAR_RESULTS_OUTPUT_VAR, TAR_IDS_OUTPUT_VAR, DATA_SCHEMA_LABEL, TAR_VAR_LABEL, "proxy_user_var", "wait_for_premise", "wait_for_on_failed"});
        EntryGrid mappingEntries = (EntryGrid)this.getView().getControl(CANDIDATE_KEYS);
        mappingEntries.addCellClickListener((CellClickListener)this);
        EntryGrid filterEntries = (EntryGrid)this.getView().getControl(ACTIONS2);
        filterEntries.addCellClickListener((CellClickListener)this);
        this.addClickListeners(new String[]{TAR_ACTION_PARAMS});
    }

    private void initTarVar(Map<String, String> tarVarValue, DynamicObject flow) {
        DynamicObjectCollection variables = flow.getDynamicObjectCollection("variables");
        ArrayList<ComboItem> items = new ArrayList<ComboItem>(variables.size());
        Map<String, String> currentId = null;
        ComboEdit combo = (ComboEdit)this.getView().getControl("tar_var");
        for (DynamicObject variable : variables) {
            if (!ISC_METADATA_SCHEMA2.equals(variable.get(VAR_CATEGORY))) continue;
            String varDesc = D.s((Object)variable.get(VAR_DESC));
            String varName = D.s((Object)variable.get(VAR_NAME));
            ComboItem item = new ComboItem();
            item.setCaption(new LocaleString(Util.getVarOrResName(varDesc, varName)));
            item.setValue(varName);
            items.add(item);
            if (tarVarValue == null || !varName.equals(tarVarValue.get(VAR))) continue;
            currentId = tarVarValue;
        }
        this.getModel().setValue("tar_var", currentId != null ? currentId.get(VAR) : null);
        combo.setComboItems(items);
    }

    private void initDataSchema(Map<String, String> dataSchemaValue, DynamicObject flow) {
        DynamicObjectCollection resources = flow.getDynamicObjectCollection("resources");
        ArrayList<ComboItem> items = new ArrayList<ComboItem>(resources.size());
        ComboEdit combo = (ComboEdit)this.getView().getControl("data_schema");
        Map<String, String> currentId = null;
        for (DynamicObject resource : resources) {
            if (!ISC_METADATA_SCHEMA2.equals(D.s((Object)resource.get("res_category")))) continue;
            String desc = D.s((Object)resource.get("res_ref.name"));
            String resAlias = D.s((Object)resource.get(RES_ALIAS));
            ComboItem item = new ComboItem();
            item.setCaption(new LocaleString(Util.getVarOrResName(desc, resAlias)));
            item.setValue(resAlias);
            items.add(item);
            if (dataSchemaValue == null || !resAlias.equals(dataSchemaValue.get("dsName"))) continue;
            currentId = dataSchemaValue;
        }
        this.getModel().setValue("data_schema", currentId != null ? currentId.get("dsName") : null);
        combo.setComboItems(items);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String prop = e.getProperty().getName();
        ChangeData[] changeSet = e.getChangeSet();
        if ("data_schema".equals(prop)) {
            this.setComboEdit(changeSet);
            this.resetEntries();
        }
        if (TAR_ACTION_LABEL.equals(prop)) {
            this.setTarActions(e);
        } else if (changeSet.length > 0 && BATCH_SIZE.equals(prop)) {
            long oldSize = D.l((Object)changeSet[0].getOldValue());
            long newSize = D.l((Object)changeSet[0].getNewValue());
            String tar_ids = D.s((Object)this.getModel().getValue(TAR_IDS_OUTPUT_VAR));
            String tar_results = D.s((Object)this.getModel().getValue(TAR_RESULTS_OUTPUT_VAR));
            if (oldSize <= 1L && newSize > 1L && tar_ids != null) {
                this.getModel().setValue(TAR_IDS_OUTPUT_VAR, null);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u76ee\u6807\u5355\u8f93\u51fa\u53d8\u91cf\u53d1\u751f\u4e86\u53d8\u5316\uff0c\u8bf7\u91cd\u65b0\u8bbe\u7f6e\u3002", (String)"DataLoaderEditorFormPlugin_1", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), Integer.valueOf(3000));
            } else if (oldSize > 1L && newSize <= 1L && tar_results != null) {
                this.getModel().setValue(TAR_RESULTS_OUTPUT_VAR, null);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u76ee\u6807\u5355\u8f93\u51fa\u53d8\u91cf\u53d1\u751f\u4e86\u53d8\u5316\uff0c\u8bf7\u91cd\u65b0\u8bbe\u7f6e\u3002", (String)"DataLoaderEditorFormPlugin_1", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), Integer.valueOf(3000));
            }
        }
    }

    private void resetEntries() {
        DynamicObjectCollection actions = this.getModel().getDataEntity(true).getDynamicObjectCollection(ACTIONS2);
        DynamicObjectCollection candidateKeys = this.getModel().getDataEntity(true).getDynamicObjectCollection(CANDIDATE_KEYS);
        if (actions != null) {
            actions.clear();
            actions.addNew();
        }
        if (candidateKeys != null) {
            candidateKeys.clear();
            candidateKeys.addNew();
        }
        this.getView().updateView(ACTIONS2);
        this.getView().updateView(CANDIDATE_KEYS);
    }

    private void setTarActions(PropertyChangedArgs e) {
        ChangeData[] changeSet = e.getChangeSet();
        DynamicObject row = this.getModel().getEntryRowEntity(ACTIONS2, changeSet[0].getRowIndex());
        IDataStorage dataStorage = row.getDataStorage();
        if (StringUtil.isEmpty((String)row.getString(TAR_ACTION_LABEL))) {
            row.set(TAR_ACTION_NUMBER, (Object)"");
            row.set(TAR_ACTION_TYPE, (Object)"");
            row.set(TAR_ACTION_PARAMS, (Object)"");
            row.set(TAR_ACT_PARAMS_DESC, (Object)"");
            this.getView().updateView(ACTIONS2, changeSet[0].getRowIndex());
            return;
        }
        ComboEdit combo = (ComboEdit)this.getView().getControl(TAR_ACTION_LABEL);
        IDataEntityProperty property = combo.getProperty();
        String localValue = D.s((Object)dataStorage.getLocalValue(property));
        if (!StringUtil.isEmpty((String)localValue)) {
            String[] split = localValue.split("-");
            row.set(TAR_ACTION_NUMBER, (Object)split[0]);
            row.set(TAR_ACTION_TYPE, (Object)split[1]);
        }
        this.getView().updateView(ACTIONS2, changeSet[0].getRowIndex());
    }

    private void setComboEdit(ChangeData[] changeSet) {
        String schemaField = D.s((Object)this.getModel().getValue("data_schema"));
        ComboEdit combo = (ComboEdit)this.getView().getControl(TAR_ACTION_LABEL);
        if (StringUtil.isEmpty((String)schemaField)) {
            combo.setComboItems(null);
            return;
        }
        Map params = this.getView().getFormShowParameter().getCustomParams();
        long flowId = D.l(params.get("flow"));
        DynamicObject flow = BusinessDataServiceHelper.loadSingle((Object)flowId, (String)ISC_SERVICE_FLOW2);
        String schemaId = DataLoaderEditorFormPlugin.getResDsByName(flow, schemaField);
        if (changeSet.length > 0 && D.l((Object)schemaId) != 0L && !schemaId.equals(changeSet[0].getOldValue())) {
            DynamicObject schema = BusinessDataServiceHelper.loadSingle((Object)schemaId, (String)ISC_METADATA_SCHEMA2);
            List<ComboItem> items = this.getComboItems(schema);
            combo.setComboItems(items);
        }
    }

    private void setComboEdit(DynamicObject flow) {
        String schemaField = D.s((Object)this.getModel().getValue("data_schema"));
        if (StringUtil.isEmpty((String)schemaField)) {
            return;
        }
        String schemaId = DataLoaderEditorFormPlugin.getResDsByName(flow, schemaField);
        if (D.l((Object)schemaId) != 0L) {
            DynamicObject schema = BusinessDataServiceHelper.loadSingle((Object)schemaId, (String)ISC_METADATA_SCHEMA2);
            List<ComboItem> items = this.getComboItems(schema);
            ComboEdit combo = (ComboEdit)this.getView().getControl(TAR_ACTION_LABEL);
            combo.setComboItems(items);
        }
    }

    private static String getResDsByName(DynamicObject flow, String schemaField) {
        DynamicObjectCollection resources = flow.getDynamicObjectCollection("resources");
        for (DynamicObject resource : resources) {
            if (!ISC_METADATA_SCHEMA2.equals(resource.get("res_category")) || !schemaField.equals(resource.get(RES_ALIAS))) continue;
            return resource.getString("res_ref.id");
        }
        return "";
    }

    private static String getVarDsByName(DynamicObject flow, String schemaField) {
        DynamicObjectCollection variables = flow.getDynamicObjectCollection("variables");
        for (DynamicObject variable : variables) {
            if (!ISC_METADATA_SCHEMA2.equals(variable.get(VAR_CATEGORY)) || !schemaField.equals(variable.get(VAR_NAME))) continue;
            return variable.getString("var_type.id");
        }
        return "";
    }

    private List<ComboItem> getComboItems(DynamicObject schema) {
        ArrayList<ComboItem> items = new ArrayList<ComboItem>();
        boolean isTable = schema.getString("type").equals("TABLE");
        if (isTable) {
            items.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\uff08\u6570\u636e\u8868 - \u4fdd\u5b58\uff09", (String)"DataLoaderEditorFormPlugin_2", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0])), "_SAVE-save"));
            items.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\uff08\u6570\u636e\u8868 - \u65b0\u589e\uff09", (String)"DataLoaderEditorFormPlugin_3", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0])), "_INSERT-insert"));
            items.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\uff08\u6570\u636e\u8868 - \u4fee\u6539\uff09", (String)"DataLoaderEditorFormPlugin_4", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0])), "_UPDATE-update"));
            items.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\uff08\u6570\u636e\u8868 - UPSERT\uff09", (String)"DataLoaderEditorFormPlugin_20", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0])), "_UPSERT-save"));
        }
        boolean hasOperations = false;
        for (DynamicObject p : (DynamicObjectCollection)schema.get("op_entryentity")) {
            String op_type = p.getString("op_type");
            String op_number = p.getString("op_number");
            String op_label = p.getString("op_label");
            hasOperations = true;
            if (isTable && "insert".equals(op_type)) continue;
            items.add(new ComboItem(new LocaleString(op_label), op_number + "-" + op_type));
        }
        if (isTable && !hasOperations) {
            items.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\uff08\u6570\u636e\u8868 - \u5220\u9664\uff09", (String)"DataLoaderEditorFormPlugin_5", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0])), "_DELETE-delete"));
        }
        return items;
    }

    public void click(EventObject evt) {
        super.click(evt);
        Object src = evt.getSource();
        boolean editable = D.x((Object)this.getView().getFormShowParameter().getCustomParam("editable"));
        if (src instanceof TextEdit) {
            String key = ((TextEdit)src).getKey();
            Map params = this.getView().getFormShowParameter().getCustomParams();
            long flowId = D.l(params.get("flow"));
            if (TAR_IDS_OUTPUT_VAR.equals(key)) {
                HashMap<String, Object> param = new HashMap<String, Object>();
                param.put("flow_id", flowId);
                param.put("key", key);
                FormOpener.showForm(this, "isc_sf_var_selector", ResManager.loadKDString((String)"\u9009\u62e9\u5c5e\u6027", (String)"DataLoaderEditorFormPlugin_6", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), param, "set_tarIds_property");
            } else if (TAR_RESULTS_OUTPUT_VAR.equals(key)) {
                HashMap<String, Object> param = new HashMap<String, Object>();
                param.put("flow_id", flowId);
                param.put("key", key);
                FormOpener.showForm(this, "isc_sf_var_selector", ResManager.loadKDString((String)"\u9009\u62e9\u5c5e\u6027", (String)"DataLoaderEditorFormPlugin_6", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), param, "set_tarResults_property");
            } else if ("proxy_user_var".equals(key)) {
                HashMap<String, Object> param = new HashMap<String, Object>();
                param.put("flow_id", flowId);
                param.put("key", key);
                FormOpener.showForm(this, "isc_sf_var_selector", ResManager.loadKDString((String)"\u9009\u62e9\u5c5e\u6027", (String)"DataLoaderEditorFormPlugin_6", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), param, "set_proxy_var");
            } else if (TAR_ACTION_PARAMS.equals(key)) {
                HashMap<String, Object> param = new HashMap<String, Object>();
                param.put("flow_id", this.getView().getFormShowParameter().getCustomParam("flow"));
                param.put("key", TAR_ACTION_PARAMS);
                FormOpener.showForm(this, "isc_sf_var_selector", ResManager.loadKDString((String)"\u9009\u62e9\u53d8\u91cf", (String)"DataLoaderEditorFormPlugin_7", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), param, TAR_ACTION_PARAMS);
            } else if (editable && ("wait_for_premise".equals(key) || "wait_for_on_failed".equals(key))) {
                ScriptTextUtil.openRetryScriptForm(this.getModel().getValue(key), this, key, key);
            }
        } else if (src instanceof Vector) {
            String key = ((Control)src).getKey();
            if (DATA_SCHEMA_LABEL.equals(key)) {
                this.showMetaDetails("data_schema", ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u96c6\u6210\u5bf9\u8c61\uff01", (String)"DataLoaderEditorFormPlugin_8", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
            } else if (TAR_VAR_LABEL.equals(key)) {
                this.showMetaDetails("tar_var", ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u76ee\u6807\u6570\u636e\uff01", (String)"DataLoaderEditorFormPlugin_9", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs evt) {
        super.afterDoOperation(evt);
        if (!D.x((Object)this.getView().getFormShowParameter().getCustomParam("editable"))) {
            this.getView().close();
            return;
        }
        if (evt.getOperationResult() != null && evt.getOperationResult().isSuccess() && evt.getOperateKey().equals("btnok")) {
            this.returnData();
        }
    }

    private void returnData() {
        String title = D.s((Object)this.getModel().getValue("title"));
        String dataSchema = D.s((Object)this.getModel().getValue("data_schema"));
        String tarVar = D.s((Object)this.getModel().getValue("tar_var"));
        int batchSize = D.i((Object)this.getModel().getValue(BATCH_SIZE));
        Map params = this.getView().getFormShowParameter().getCustomParams();
        params.put("title", title);
        params.put("proxy_user_var", D.s((Object)this.getModel().getValue("proxy_user_var")));
        params.put("proxy_user", this.getModel().getValue("proxy_user"));
        params.put(TAR_IDS_OUTPUT_VAR, D.s((Object)this.getModel().getValue(TAR_IDS_OUTPUT_VAR)));
        String tarResults = D.s((Object)this.getModel().getValue(TAR_RESULTS_OUTPUT_VAR));
        long flowId = D.l(params.get("flow"));
        DynamicObject flow = BusinessDataServiceHelper.loadSingle((Object)flowId, (String)ISC_SERVICE_FLOW2);
        DynamicObjectCollection variables = flow.getDynamicObjectCollection("variables");
        for (DynamicObject next : variables) {
            if (tarResults == null || !tarResults.equals(next.get(VAR_NAME))) continue;
            if (ISC_TYPE_SIMPLE_VALUE.equals(next.get(VAR_CATEGORY)) && "variant".equals(next.get("var_type.number")) && D.x((Object)next.get("is_array"))) break;
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6279\u91cf\u76ee\u6807\u5355\u8f93\u51fa\u53d8\u91cf\uff1a\u53d8\u91cf\u7c7b\u522b\u5fc5\u987b\u662f\u7b80\u5355\u503c\u7684\u201c\u4efb\u610f\u503c\u201d\u6570\u636e\u7c7b\u578b\uff0c\u4e14\u9700\u8981\u52fe\u9009\u201c\u591a\u503c\u201d\u3002", (String)"DataLoaderEditorFormPlugin_10", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
            return;
        }
        params.put(TAR_RESULTS_OUTPUT_VAR, tarResults);
        Map<String, Object> selectedSchema = this.getSelectedSchema(dataSchema);
        params.put(DATA_SCHEMA_VALUE, selectedSchema);
        params.put(TAR_VAR_VALUE, this.getSelectedVar(tarVar));
        params.put("data_schema", dataSchema);
        params.put("tar_var", tarVar);
        params.put(BATCH_SIZE, batchSize);
        DynamicObjectCollection actions = this.getModel().getEntryEntity(ACTIONS2);
        DynamicObjectCollection candidateKeys = this.getModel().getEntryEntity(CANDIDATE_KEYS);
        this.clearNoDataRow(candidateKeys, CANDIDATE_KEY, CANDIDATE_KEYS);
        List<Map<String, Object>> list = this.getActionsList(actions);
        if (list.size() > 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u52a0\u8f7d\u8282\u70b9\u5f53\u524d\u4ec5\u652f\u6301\u5355\u64cd\u4f5c\uff01", (String)"DataLoaderEditorFormPlugin_11", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
            return;
        }
        params.put(ACTIONS2, list);
        List<Map<String, Object>> candidateKeysList = this.getCandidateKeysList(candidateKeys);
        params.put("save_state_on_success", this.getModel().getValue("save_state_on_success"));
        params.put("wait_for_on_failed", this.getModel().getValue("wait_for_on_failed"));
        params.put("wait_for_premise", this.getModel().getValue("wait_for_premise"));
        params.put("candidateKeys", candidateKeysList);
        String schemaId = DataLoaderEditorFormPlugin.getResDsByName(flow, dataSchema);
        if (D.l((Object)schemaId) > 0L) {
            DynamicObject schema = BusinessDataServiceHelper.loadSingleFromCache((Object)D.l((Object)selectedSchema.get("id")), (String)ISC_METADATA_SCHEMA2);
            String type = schema.getString("type");
            if (("ENTITY".equals(type) || "TABLE".equals(type)) && candidateKeysList.isEmpty()) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u76ee\u6807\u96c6\u6210\u5bf9\u8c61\u7c7b\u578b\u4e3a\u5b9e\u4f53\u6216\u6570\u636e\u8868\u65f6\uff0c\u5019\u9009\u952e\u4e0d\u5141\u8bb8\u4e3a\u7a7a\uff01", (String)"DataLoaderEditorFormPlugin_12", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
                DynamicObject item = candidateKeys.addNew();
                item.set(CANDIDATE_KEY, (Object)"");
                item.set(OUTPUT_FIELD_TYPE, (Object)"");
                item.set(OUTPUT_FIELD_DESC, (Object)"");
                this.getView().updateView(CANDIDATE_KEYS);
                return;
            }
            try {
                DataCopyValidator validator = new DataCopyValidator(this, this.getModel(), this.getView());
                validator.checkCandidateKey(D.l((Object)schemaId), validator.getEntryCandidateKeys(CANDIDATE_KEYS, CANDIDATE_KEY));
            }
            catch (Exception e) {
                this.getView().cacheFormShowParameter();
                ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("checkCandidateKey", (IFormPlugin)this);
                this.getView().showConfirm(String.format(ResManager.loadKDString((String)"%s\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u7ee7\u7eed\u4fdd\u5b58\uff1f", (String)"DataLoaderEditorFormPlugin_19", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), StringUtil.getCascadeMessage((Throwable)e)), MessageBoxOptions.YesNo, confirmCallBacks);
                return;
            }
        }
        this.getView().returnDataToParent((Object)params);
        this.getView().close();
    }

    public void confirmCallBack(MessageBoxClosedEvent evt) {
        super.confirmCallBack(evt);
        if (evt.getResult() != MessageBoxResult.Yes) {
            return;
        }
        String callback = evt.getCallBackId();
        if ("checkCandidateKey".equals(callback)) {
            Map params = this.getView().getFormShowParameter().getCustomParams();
            this.getView().returnDataToParent((Object)params);
            this.getView().close();
        }
    }

    private Map<String, Object> getSelectedVar(String varName) {
        long flowId = D.l((Object)this.getView().getFormShowParameter().getCustomParam("flow"));
        DynamicObject flow = BusinessDataServiceHelper.loadSingle((Object)flowId, (String)ISC_SERVICE_FLOW2);
        DynamicObjectCollection variables = flow.getDynamicObjectCollection("variables");
        for (DynamicObject var : variables) {
            if (!ISC_METADATA_SCHEMA2.equals(var.get(VAR_CATEGORY)) || !varName.equals(D.s((Object)var.get(VAR_NAME)))) continue;
            HashMap<String, Object> map = new HashMap<String, Object>(3);
            map.put("id", var.get("var_type.id"));
            map.put("desc", var.get(VAR_DESC));
            map.put(VAR, varName);
            return map;
        }
        return Collections.emptyMap();
    }

    private Map<String, Object> getSelectedSchema(String dsName) {
        long flowId = D.l((Object)this.getView().getFormShowParameter().getCustomParam("flow"));
        DynamicObject flow = BusinessDataServiceHelper.loadSingle((Object)flowId, (String)ISC_SERVICE_FLOW2);
        DynamicObjectCollection resources = flow.getDynamicObjectCollection("resources");
        for (DynamicObject resource : resources) {
            if (!ISC_METADATA_SCHEMA2.equals(resource.get("res_category")) || !dsName.equals(D.s((Object)resource.get(RES_ALIAS)))) continue;
            HashMap<String, Object> map = new HashMap<String, Object>(3);
            map.put("id", resource.get("res_ref.id"));
            map.put("desc", D.s((Object)resource.get("res_ref.name.zh_CN")));
            map.put("dsName", dsName);
            return map;
        }
        return Collections.emptyMap();
    }

    private void clearNoDataRow(DynamicObjectCollection entity, String checkField, String entityName) {
        for (int i = 0; i < entity.size(); ++i) {
            if (!StringUtil.isEmpty((String)((DynamicObject)entity.get(i)).getString(checkField))) continue;
            this.getModel().deleteEntryRow(entityName, i);
            --i;
        }
    }

    private void showMetaDetails(String key, String s) {
        Map params = this.getView().getFormShowParameter().getCustomParams();
        boolean editable = D.x(params.get("editable"));
        if (editable) {
            String value = D.s((Object)this.getModel().getValue(key));
            if (value == null || value.isEmpty()) {
                this.getView().showMessage(s);
            } else {
                long flowId = D.l(params.get("flow"));
                DynamicObject flow = BusinessDataServiceHelper.loadSingle((Object)flowId, (String)ISC_SERVICE_FLOW2);
                String dsId = null;
                if ("data_schema".equals(key)) {
                    dsId = DataLoaderEditorFormPlugin.getResDsByName(flow, value);
                } else if ("tar_var".equals(key)) {
                    dsId = DataLoaderEditorFormPlugin.getVarDsByName(flow, value);
                }
                if (D.l((Object)dsId) <= 0L) {
                    return;
                }
                FormOpener.showView(this, ISC_METADATA_SCHEMA2, dsId);
            }
        } else if ("data_schema".equals(key)) {
            Object tarVarValue = params.get(TAR_VAR_VALUE);
            if (tarVarValue instanceof Map) {
                Object id = ((Map)tarVarValue).get("id");
                FormOpener.showView(this, ISC_METADATA_SCHEMA2, id);
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u76ee\u6807\u6570\u636e\u53d8\u91cf\u4e3a\u7a7a\u6216\u8005\u6570\u636e\u683c\u5f0f\u4e0d\u662fMap\uff01", (String)"DataLoaderEditorFormPlugin_14", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
            }
        } else if ("tar_var".equals(key)) {
            Object dataSchema = params.get(DATA_SCHEMA_VALUE);
            if (dataSchema instanceof Map) {
                Object id = ((Map)dataSchema).get("id");
                FormOpener.showView(this, ISC_METADATA_SCHEMA2, id);
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u76ee\u6807\u96c6\u6210\u5bf9\u8c61\u4e3a\u7a7a\u6216\u8005\u6570\u636e\u683c\u5f0f\u4e0d\u662fMap\uff01", (String)"DataLoaderEditorFormPlugin_15", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
            }
        }
    }

    private List<Map<String, Object>> getCandidateKeysList(DynamicObjectCollection candidateKeys) {
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        if (candidateKeys.isEmpty()) {
            return Collections.emptyList();
        }
        for (DynamicObject candidateKey : candidateKeys) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put(CANDIDATE_KEY, candidateKey.get(CANDIDATE_KEY));
            map.put(OUTPUT_FIELD_TYPE, candidateKey.get(OUTPUT_FIELD_TYPE));
            map.put(OUTPUT_FIELD_DESC, candidateKey.get(OUTPUT_FIELD_DESC));
            list.add(map);
        }
        return list;
    }

    private List<Map<String, Object>> getActionsList(DynamicObjectCollection actions) {
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        for (DynamicObject action : actions) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put(TAR_ACTION_LABEL, action.get(TAR_ACTION_LABEL));
            map.put(TAR_ACTION_NUMBER, action.get(TAR_ACTION_NUMBER));
            map.put(TAR_ACTION_TYPE, action.get(TAR_ACTION_TYPE));
            map.put(TAR_ACTION_PARAMS, action.get(TAR_ACTION_PARAMS));
            map.put(TAR_ACT_PARAMS_DESC, action.get(TAR_ACT_PARAMS_DESC));
            list.add(map);
        }
        return list;
    }

    public void cellClick(CellClickEvent cellClickEvent) {
    }

    public void cellDoubleClick(CellClickEvent cellClickEvent) {
        String fieldKey = cellClickEvent.getFieldKey();
        if (CANDIDATE_KEY.equals(fieldKey)) {
            String schema = D.s((Object)this.getModel().getValue("data_schema"));
            if (schema == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u76ee\u6807\u96c6\u6210\u5bf9\u8c61\uff01", (String)"DataLoaderEditorFormPlugin_16", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
                return;
            }
            Map params = this.getView().getFormShowParameter().getCustomParams();
            long flowId = D.l(params.get("flow"));
            DynamicObject flow = BusinessDataServiceHelper.loadSingle((Object)flowId, (String)ISC_SERVICE_FLOW2);
            String resDsByName = DataLoaderEditorFormPlugin.getResDsByName(flow, schema);
            Assert.notNull((Object)resDsByName, (String)ResManager.loadKDString((String)"\u96c6\u6210\u5bf9\u8c61ID\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u9009\u62e9\u5c5e\u6027!", (String)"DataLoaderEditorFormPlugin_17", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
            HashMap<String, Object> param = new HashMap<String, Object>();
            param.put("id", resDsByName);
            param.put("$type", "tar");
            param.put("$row", cellClickEvent.getRow());
            param.put("operation", "batch_add");
            FormOpener.showForm(this, "isc_meta_property_tree", ResManager.loadKDString((String)"\u9009\u62e9\u5c5e\u6027", (String)"DataLoaderEditorFormPlugin_6", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), param, "get_property");
        }
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        super.closedCallBack(evt);
        String action = evt.getActionId();
        Object returnData = evt.getReturnData();
        if (action.equals("get_property")) {
            if (returnData instanceof List) {
                List returnLists = (List)returnData;
                DynamicObjectCollection candidateKeys = this.getModel().getDataEntity(true).getDynamicObjectCollection(CANDIDATE_KEYS);
                if (returnLists.size() == 1) {
                    Map map = (Map)returnLists.get(0);
                    int rowIndex = D.i(map.get("$row"));
                    if (this.hasField(candidateKeys, map)) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u5b57\u6bb5\u5728\u5206\u5f55\u4e2d\u5df2\u5b58\u5728\u3002", (String)"DataLoaderEditorFormPlugin_18", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
                        return;
                    }
                    DynamicObject rowData = (DynamicObject)candidateKeys.get(rowIndex);
                    rowData.set(CANDIDATE_KEY, map.get(FULL_NUMBER2));
                    rowData.set(OUTPUT_FIELD_TYPE, map.get("data_type"));
                    rowData.set(OUTPUT_FIELD_DESC, map.get("name"));
                } else {
                    for (Map returnList : returnLists) {
                        if (this.hasField(candidateKeys, returnList)) continue;
                        DynamicObject row = candidateKeys.addNew();
                        row.set(CANDIDATE_KEY, (Object)D.s(returnList.get(FULL_NUMBER2)));
                        row.set(OUTPUT_FIELD_TYPE, (Object)D.s(returnList.get("data_type")));
                        row.set(OUTPUT_FIELD_DESC, (Object)D.s(returnList.get("name")));
                    }
                }
                this.clearNoDataRow(candidateKeys, CANDIDATE_KEY, CANDIDATE_KEYS);
                this.getView().updateView(CANDIDATE_KEYS);
            }
        } else if ("set_tarIds_property".equals(action)) {
            if (returnData instanceof Map) {
                Map data = (Map)returnData;
                String key = D.s(data.get("key"));
                String value = D.s(data.get(FULL_NUMBER2));
                this.getModel().setValue(key, (Object)value);
            }
        } else if ("set_tarResults_property".equals(action)) {
            if (returnData instanceof Map) {
                Map data = (Map)returnData;
                String key = D.s(data.get("key"));
                String value = D.s(data.get(FULL_NUMBER2));
                Map params = this.getView().getFormShowParameter().getCustomParams();
                long flowId = D.l(params.get("flow"));
                DynamicObject flow = BusinessDataServiceHelper.loadSingle((Object)flowId, (String)ISC_SERVICE_FLOW2);
                DynamicObjectCollection variables = flow.getDynamicObjectCollection("variables");
                boolean hasError = true;
                for (DynamicObject next : variables) {
                    if (!value.equals(next.get(VAR_NAME))) continue;
                    if (!ISC_TYPE_SIMPLE_VALUE.equals(next.get(VAR_CATEGORY)) || !"variant".equals(next.get("var_type.number")) || !D.x((Object)next.get("is_array"))) break;
                    this.getModel().setValue(key, (Object)value);
                    hasError = false;
                    break;
                }
                if (hasError) {
                    this.getModel().setValue(key, null);
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u6279\u91cf\u76ee\u6807\u5355\u8f93\u51fa\u53d8\u91cf\uff1a\u53d8\u91cf\u7c7b\u522b\u5fc5\u987b\u662f\u7b80\u5355\u503c\u7684\u201c\u4efb\u610f\u503c\u201d\u6570\u636e\u7c7b\u578b\uff0c\u4e14\u9700\u8981\u52fe\u9009\u201c\u591a\u503c\u201d\u3002", (String)"DataLoaderEditorFormPlugin_10", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
                }
            }
        } else if ("set_proxy_var".equals(action)) {
            if (returnData instanceof Map) {
                Map data = (Map)returnData;
                String key = D.s(data.get("key"));
                String value = D.s(data.get(FULL_NUMBER2));
                this.getModel().setValue(key, (Object)value);
            }
        } else if ("wait_for_premise".equals(action) || "wait_for_on_failed".equals(action)) {
            ScriptTextUtil.retryScriptFormCallBack(evt, this, this.getModel(), action);
        } else if (TAR_ACTION_PARAMS.equals(action)) {
            EditorUtil.setReturnDataAfterChosedVar(this.getModel(), evt);
        }
    }

    private boolean hasField(DynamicObjectCollection entries, Map<String, Object> item) {
        return entries.stream().anyMatch(x -> x.getString(CANDIDATE_KEY).equals(item.get(FULL_NUMBER2)));
    }
}

