/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.formplugin.sf;

import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.ext.form.control.CustomControl;
import kd.isc.iscb.formplugin.sf.ErrorType;
import kd.isc.iscb.formplugin.tools.AbstractScriptEditorFormPlugin;
import kd.isc.iscb.platform.core.sf.Const;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.misc.StringUtil;

public class ErrorLinkEditorFormPlugin
extends AbstractScriptEditorFormPlugin
implements Const {
    private static final String EDITOR = "editor";

    @Override
    public void beforeBindData(EventObject e) {
        Map params = this.getView().getFormShowParameter().getCustomParams();
        this.getModel().setValue("title", params.get("title"));
        this.getModel().setValue("error_type", params.get("error_type"));
        Boolean editable = D.x(params.get("editable"));
        this.getView().setEnable(editable, new String[]{"title", EDITOR});
        params.put("script", params.get("condition"));
        params.put("env", "sf_error_condition");
        if (D.x(params.get("editable"))) {
            params.put("context_variables", Collections.singletonList("$error"));
        }
        super.beforeBindData(e);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String type;
        super.propertyChanged(e);
        if ("error_type".equals(e.getProperty().getName()) && (type = D.s((Object)this.getModel().getValue("error_type"))) != null) {
            String script = ErrorType.valueOf(type).getScript();
            HashMap<String, Object> data = new HashMap<String, Object>();
            data.put("cmd", "set_script_data");
            data.put("id", UUID.randomUUID().toString());
            data.put("script", script);
            data.put("breakpoints", Collections.emptyList());
            ((CustomControl)this.getControl(EDITOR)).setData(data);
        }
    }

    @Override
    protected int getHeight() {
        return 280;
    }

    @Override
    protected int getWidth() {
        return 700;
    }

    @Override
    protected void handleScript(String script) {
        Map params = this.getView().getFormShowParameter().getCustomParams();
        params.put("title", this.getModel().getValue("title"));
        params.put("script", script);
        params.put("condition", script);
        if (!StringUtil.isEmpty((String)script) && StringUtil.isEmpty((String)D.s(params.get("title")))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u6807\u9898", (String)"ErrorLinkEditorFormPlugin_0", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
        } else {
            params.put("error_type", null);
            for (ErrorType error : ErrorType.values()) {
                if (!error.getScript().equals(script)) continue;
                params.put("error_type", error.name());
            }
            this.getView().returnDataToParent((Object)params);
            this.getView().close();
        }
    }
}

