/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.formplugin.sf;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.CellClickEvent;
import kd.bos.form.control.events.CellClickListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.isc.iscb.formplugin.hub.HubTriggerEventChecker;
import kd.isc.iscb.formplugin.sf.Util;
import kd.isc.iscb.formplugin.util.DataSchemaUtil;
import kd.isc.iscb.formplugin.util.FormOpener;
import kd.isc.iscb.platform.core.sf.Const;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.misc.Json;
import kd.isc.iscb.util.misc.StringUtil;

public class EventStarterNodeEditorFormPlugin
extends AbstractFormPlugin
implements CellClickListener,
Const {
    protected static final String BATCH_ADD = "batch_add";
    protected static final String OPERATOR = "operation";
    protected static final String SELECTOR_ENTRY = "selector_entry";
    protected static final String PROPROW = "$row";
    protected static final String PROPTYPE = "$type";
    private static final int TIMEOUT = 5000;
    private static final String VIEW_META = "view_meta";
    private static final String AUTO_FILL = "auto_fill";
    private static final String NAME = "name";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        EntryGrid selectors = (EntryGrid)this.getView().getControl(SELECTOR_ENTRY);
        selectors.addCellClickListener((CellClickListener)this);
        this.addClickListeners(new String[]{VIEW_META});
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        Map params = this.getView().getFormShowParameter().getCustomParams();
        boolean editable = D.x(params.get("editable"));
        this.getPageCache().put("editable", D.s((Object)editable));
        if (editable) {
            this.getView().setStatus(OperationStatus.EDIT);
            DynamicObject flowDefine = BusinessDataServiceHelper.loadSingle(params.get("flow"), (String)"isc_service_flow");
            this.initFormByFlowDef(params, this.getResComboItems(flowDefine), this.getVarComboItems(flowDefine));
            this.initOthers(params);
        } else if (params.get("released_id") != null) {
            this.getView().setStatus(OperationStatus.VIEW);
            DynamicObject releaseDefine = BusinessDataServiceHelper.loadSingle(params.get("released_id"), (String)"isc_service_flow_r");
            String defineJson = releaseDefine.getString("define_json_tag");
            Map map = (Map)Json.toObject((String)defineJson);
            this.initFormByFlowDef(params, this.getResComboItems(params, map), this.getVarComboItems(params, map));
            this.initOthers(params);
        }
    }

    protected void initOthers(Map<String, Object> params) {
    }

    protected void addOtherParams(Map<String, Object> params) {
    }

    private List<ComboItem> getVarComboItems(Map<String, Object> params, Map<String, Object> map) {
        List varList = (List)map.get("variables");
        String varName = D.s((Object)params.get("variables_value"));
        if (varName != null) {
            for (Map var : varList) {
                if (!varName.equals(var.get(NAME))) continue;
                ComboItem item = new ComboItem();
                String varTitle = D.s(var.get("title"));
                item.setCaption(new LocaleString(Util.getVarOrResName(varTitle, varName)));
                item.setValue(varName);
                return Collections.singletonList(item);
            }
        }
        return null;
    }

    private List<ComboItem> getResComboItems(Map<String, Object> params, Map<String, Object> map) {
        List resList = (List)map.get("resources");
        String metaId = D.s((Object)params.get("data_schema"));
        if (metaId != null) {
            for (Map res : resList) {
                if (!metaId.equals(res.get("id"))) continue;
                String resName = D.s(res.get(NAME));
                String resTitle = D.s(res.get("title"));
                ComboItem item = new ComboItem();
                item.setCaption(new LocaleString(Util.getVarOrResName(resTitle, resName)));
                item.setValue(metaId);
                return Collections.singletonList(item);
            }
        }
        return null;
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs evt) {
        super.beforeDoOperation(evt);
        AbstractOperate operate = (AbstractOperate)evt.getSource();
        String operationKey = operate.getOperateKey();
        if ("returndata".equals(operationKey)) {
            HubTriggerEventChecker.checkActions(this.getView(), evt, D.l((Object)this.getModel().getValue("data_schema")), this.getModel().getValue("bill_events"));
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs evt) {
        super.afterDoOperation(evt);
        if (!D.x((Object)this.getPageCache().get("editable"))) {
            this.getView().close();
            return;
        }
        if (AUTO_FILL.equals(evt.getOperateKey())) {
            ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener(AUTO_FILL, (IFormPlugin)this);
            this.getView().showConfirm(ResManager.loadKDString((String)"\u81ea\u52a8\u586b\u5145\u4f1a\u6e05\u9664\u5df2\u6709\u5b57\u6bb5\uff0c\u662f\u5426\u786e\u8ba4\u6267\u884c\uff1f", (String)"EventStarterNodeEditorFormPlugin_0", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, confirmCallBacks);
        } else if (evt.getOperationResult() != null && evt.getOperationResult().isSuccess() && evt.getOperateKey().equals("returndata")) {
            try {
                Map params = this.getView().getFormShowParameter().getCustomParams();
                this.getView().returnDataToParent(this.addParams(params));
                this.getView().close();
            }
            catch (Exception e) {
                this.getView().showTipNotification(StringUtil.getCascadeMessage((Throwable)e));
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        super.confirmCallBack(event);
        MessageBoxResult result = event.getResult();
        if (result == MessageBoxResult.Yes && AUTO_FILL.equals(event.getCallBackId())) {
            try {
                this.autofill();
            }
            catch (Throwable e) {
                FormOpener.showErrorMessage(this.getView(), e);
            }
        }
    }

    private void autofill() {
        long metaId = D.l((Object)this.getModel().getValue("data_schema"));
        if (metaId != 0L) {
            DynamicObjectCollection selectors = this.getModel().getDataEntity(true).getDynamicObjectCollection(SELECTOR_ENTRY);
            selectors.clear();
            List<Map<String, Object>> fields = DataSchemaUtil.getAllFields(metaId);
            this.resetEntry(fields, selectors);
            this.getView().updateView(SELECTOR_ENTRY);
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6e90\u96c6\u6210\u5bf9\u8c61!", (String)"EventStarterNodeEditorFormPlugin_1", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
        }
    }

    private void initFormByFlowDef(Map<String, Object> params, List<ComboItem> resComboItems, List<ComboItem> varComboItems) {
        ComboEdit resCombo = (ComboEdit)this.getView().getControl("data_schema");
        ComboEdit varCombo = (ComboEdit)this.getView().getControl("variables_value");
        resCombo.setComboItems(resComboItems);
        varCombo.setComboItems(varComboItems);
        this.getModel().setValue("title", params.get("title"));
        this.getModel().setValue("data_schema", params.get("data_schema"));
        this.initEventCombo(D.l((Object)params.get("data_schema")));
        this.getModel().setValue("bill_events", params.get("bill_events"));
        this.getModel().setValue("variables_value", params.get("variables_value"));
        this.initSelectorEntry(params);
    }

    private void initSelectorEntry(Map<String, Object> params) {
        List flatData = (List)params.get(SELECTOR_ENTRY);
        if (flatData != null) {
            DynamicObjectCollection entries = this.getModel().getDataEntity(true).getDynamicObjectCollection(SELECTOR_ENTRY);
            entries.clear();
            this.resetEntry(flatData, entries);
        }
    }

    private void resetEntry(List<Map<String, Object>> flatData, DynamicObjectCollection entries) {
        for (Map<String, Object> data : flatData) {
            DynamicObject object = entries.addNew();
            object.set("field", data.get("field"));
            object.set("data_type", data.get("data_type"));
            object.set("description", data.get("description"));
        }
    }

    private void initEventCombo(long metaSchemaId) {
        if (metaSchemaId != 0L && QueryServiceHelper.exists((String)"isc_metadata_schema", (Object)metaSchemaId)) {
            DynamicObject meta = BusinessDataServiceHelper.loadSingle((Object)metaSchemaId, (String)"isc_metadata_schema");
            ComboEdit eventCombo = (ComboEdit)this.getView().getControl("bill_events");
            eventCombo.setComboItems(this.getEventComboItems(meta));
        }
    }

    private List<ComboItem> getEventComboItems(DynamicObject meta) {
        DynamicObjectCollection events = meta.getDynamicObjectCollection("event_entryentity");
        ArrayList<ComboItem> items = new ArrayList<ComboItem>(events.size());
        for (DynamicObject event : events) {
            ComboItem item = new ComboItem();
            item.setCaption(new LocaleString(event.getString("event_label") + '(' + event.getString("event_number") + ')'));
            item.setValue(event.getString("event_number"));
            items.add(item);
        }
        return items;
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String name = e.getProperty().getName();
        if (name.equals("data_schema")) {
            this.resetEventCombo(e);
        } else if (name.equals("field")) {
            this.resetSelectorEntries(e);
        }
    }

    private void resetSelectorEntries(PropertyChangedArgs e) {
        ChangeData[] changeSet = e.getChangeSet();
        if (changeSet.length == 1) {
            DynamicObject row = this.getModel().getEntryRowEntity(SELECTOR_ENTRY, changeSet[0].getRowIndex());
            if (D.s((Object)changeSet[0].getNewValue()) == null) {
                row.set("description", null);
                row.set("data_type", null);
                this.getView().updateView(SELECTOR_ENTRY);
            }
        }
    }

    private void resetEventCombo(PropertyChangedArgs e) {
        if (e.getChangeSet().length != 0) {
            long oldId = D.l((Object)e.getChangeSet()[0].getOldValue());
            long newId = D.l((Object)e.getChangeSet()[0].getNewValue());
            if (oldId > 0L && oldId != newId) {
                this.getModel().setValue("bill_events", null);
            }
            this.initEventCombo(newId);
        }
    }

    private List<ComboItem> getResComboItems(DynamicObject flowDefine) {
        DynamicObjectCollection resources = flowDefine.getDynamicObjectCollection("resources");
        ArrayList<ComboItem> resourcesRef = new ArrayList<ComboItem>(resources.size());
        HashSet<String> existResIds = new HashSet<String>();
        for (DynamicObject resource : resources) {
            String id;
            if (!"isc_metadata_schema".equals(resource.get("res_category")) || !existResIds.add(id = D.s((Object)resource.get("res_ref.id")))) continue;
            ComboItem item = new ComboItem();
            String resAlias = D.s((Object)resource.get("res_alias"));
            String resName = D.s((Object)resource.get("res_ref.name"));
            item.setCaption(new LocaleString(Util.getVarOrResName(resName, resAlias)));
            item.setValue(id);
            resourcesRef.add(item);
        }
        return resourcesRef;
    }

    private List<ComboItem> getVarComboItems(DynamicObject flowDefine) {
        DynamicObjectCollection variables = flowDefine.getDynamicObjectCollection("variables");
        ArrayList<ComboItem> variablesRef = new ArrayList<ComboItem>(variables.size());
        for (DynamicObject variable : variables) {
            if (!"isc_metadata_schema".equals(variable.get("var_category"))) continue;
            ComboItem item = new ComboItem();
            String varName = D.s((Object)variable.get("var_name"));
            item.setValue(varName);
            String varDesc = D.s((Object)variable.get("var_desc"));
            item.setCaption(new LocaleString(Util.getVarOrResName(varDesc, varName)));
            variablesRef.add(item);
        }
        return variablesRef;
    }

    private Map<String, Object> addParams(Map<String, Object> params) {
        params.put("title", this.getModel().getValue("title"));
        params.put("data_schema", this.getModel().getValue("data_schema"));
        params.put("bill_events", this.getModel().getValue("bill_events"));
        params.put("variables_value", this.getModel().getValue("variables_value"));
        DynamicObjectCollection selectors = this.getModel().getDataEntity(true).getDynamicObjectCollection(SELECTOR_ENTRY);
        ArrayList flatData = new ArrayList(selectors.size());
        for (DynamicObject selector : selectors) {
            HashMap<String, Object> data = new HashMap<String, Object>();
            data.put("field", selector.get("field"));
            data.put("description", selector.get("description"));
            data.put("data_type", selector.get("data_type"));
            flatData.add(data);
        }
        params.put(SELECTOR_ENTRY, flatData);
        this.addOtherParams(params);
        return params;
    }

    public void cellClick(CellClickEvent cellClickEvent) {
    }

    public void click(EventObject evt) {
        super.click(evt);
        Object src = evt.getSource();
        String key = ((Control)src).getKey();
        if (VIEW_META.equals(key)) {
            long value = D.l((Object)this.getModel().getValue("data_schema"));
            if (value > 0L) {
                FormOpener.showView(this, "isc_metadata_schema", value);
            } else {
                this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6e90\u96c6\u6210\u5bf9\u8c61\uff01", (String)"EventStarterNodeEditorFormPlugin_2", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
            }
        }
    }

    public void cellDoubleClick(CellClickEvent cellClickEvent) {
        long metaSchemaId = this.getModel().getDataEntity().getLong("data_schema");
        if (metaSchemaId == 0L) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u96c6\u6210\u5bf9\u8c61", (String)"EventStarterNodeEditorFormPlugin_3", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), Integer.valueOf(5000));
            return;
        }
        String fieldKey = cellClickEvent.getFieldKey();
        if ("field".equals(fieldKey)) {
            this.openPropertyWin(cellClickEvent, metaSchemaId, fieldKey);
        }
    }

    protected void openPropertyWin(CellClickEvent cellClickEvent, long metaSchemaId, String fieldKey) {
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("id", metaSchemaId);
        param.put(PROPROW, cellClickEvent.getRow());
        if ("field".equals(fieldKey)) {
            param.put(OPERATOR, BATCH_ADD);
            param.put(PROPTYPE, "field");
            FormOpener.showForm(this, "isc_meta_property_tree", ResManager.loadKDString((String)"\u9009\u62e9\u5bf9\u8c61\u5c5e\u6027", (String)"EventStarterNodeEditorFormPlugin_4", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), param, "get_property");
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String action = closedCallBackEvent.getActionId();
        try {
            if (action.equals("get_property")) {
                Object returnData = closedCallBackEvent.getReturnData();
                this.setSelectors(returnData);
            }
        }
        catch (Throwable e) {
            this.getView().showTipNotification(e.getMessage());
        }
    }

    protected void setSelectors(Object returnData) {
        if (returnData instanceof List) {
            DynamicObjectCollection selectors = this.getModel().getDataEntity(true).getDynamicObjectCollection(SELECTOR_ENTRY);
            List dataList = (List)returnData;
            if (dataList.size() > 0) {
                this.updateSelectorEntryByDataList(selectors, dataList);
                this.getView().updateView(SELECTOR_ENTRY);
            }
        }
    }

    private void updateSelectorEntryByDataList(DynamicObjectCollection selectors, List<Map<String, Object>> dataList) {
        Object rowValue = dataList.get(0).get(PROPROW);
        if (rowValue != null) {
            int index = D.i((Object)rowValue);
            Set<String> fieldSet = this.getExistedFieldSet(selectors);
            if (dataList.size() == 1) {
                this.updateOneRecord(dataList, index, fieldSet);
            } else {
                DynamicObject entry = this.getModel().getEntryRowEntity(SELECTOR_ENTRY, index);
                if (StringUtil.isEmpty((String)entry.getString("field"))) {
                    selectors.remove(index);
                }
                this.updateSelectors(selectors, dataList, fieldSet);
            }
        }
    }

    private void updateOneRecord(List<Map<String, Object>> dataList, int index, Set<String> fieldSet) {
        Map<String, Object> dataMap = dataList.get(0);
        Object field = dataMap.get("full_number");
        if (!fieldSet.contains(field)) {
            DynamicObject entry = this.getModel().getEntryRowEntity(SELECTOR_ENTRY, index);
            entry.set("field", field);
            entry.set("data_type", dataMap.get("data_type"));
            entry.set("description", dataMap.get(NAME));
        } else {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"%s\uff1a\u5df2\u5b58\u5728\uff01", (String)"EventStarterNodeEditorFormPlugin_6", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), field));
        }
    }

    private void updateSelectors(DynamicObjectCollection selectors, List<Map<String, Object>> dataList, Set<String> fieldSet) {
        for (Map<String, Object> dataMap : dataList) {
            Object field = dataMap.get("full_number");
            if (fieldSet.contains(field)) continue;
            DynamicObject entry = selectors.addNew();
            entry.set("field", field);
            entry.set("data_type", dataMap.get("data_type"));
            entry.set("description", dataMap.get(NAME));
        }
    }

    private Set<String> getExistedFieldSet(DynamicObjectCollection selectors) {
        HashSet<String> fieldSet = new HashSet<String>();
        for (DynamicObject selector : selectors) {
            String field = D.s((Object)selector.get("field"));
            if (field == null) continue;
            fieldSet.add(field);
        }
        return fieldSet;
    }
}

