/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.formplugin.sf;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.isc.iscb.formplugin.export.ProcInstVarsTxtDownload;
import kd.isc.iscb.formplugin.export.ProcInstVarsXlsDownload;
import kd.isc.iscb.formplugin.sf.VariableType;
import kd.isc.iscb.formplugin.util.FormOpener;
import kd.isc.iscb.platform.core.sf.Const;
import kd.isc.iscb.platform.core.sf.runtime.ProcessRuntime;
import kd.isc.iscb.platform.core.util.QFilterUtil;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.flow.core.Flow;
import kd.isc.iscb.util.flow.core.FlowRuntime;
import kd.isc.iscb.util.flow.core.Variable;

public class FlowVariableDownLoadListPlugin
extends AbstractListPlugin
implements Const {
    public static final String ENTRY_ENTITY = "entryentity";

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.getVarInfo();
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        if ("download".equals(args.getOperateKey())) {
            List proc_inst_ids = (List)this.getView().getFormShowParameter().getCustomParam("proc_inst_id");
            List<String> vars = this.getVars();
            if (vars.size() == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u81f3\u5c11\u9009\u62e9\u4e00\u884c", (String)"CustomFunctionListPlugin_1", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
                return;
            }
            try {
                if ("txt".equals(this.getView().getFormShowParameter().getCustomParam("type"))) {
                    this.getView().openUrl(new ProcInstVarsTxtDownload(proc_inst_ids, vars).download());
                } else {
                    this.getView().openUrl(new ProcInstVarsXlsDownload(proc_inst_ids, vars).download());
                }
                this.getView().close();
            }
            catch (Throwable e) {
                FormOpener.showErrorMessage(this.getView(), e);
            }
        }
    }

    public List<String> getVars() {
        EntryGrid control = (EntryGrid)this.getControl(ENTRY_ENTITY);
        int[] selectRows = control.getSelectRows();
        ArrayList<String> vars = new ArrayList<String>(selectRows.length);
        for (int selectRow : selectRows) {
            DynamicObjectCollection entryList = this.getModel().getEntryEntity(ENTRY_ENTITY);
            DynamicObject object = (DynamicObject)entryList.get(selectRow);
            vars.add(object.getString("var_name"));
        }
        return vars;
    }

    private void getVarInfo() {
        List proc_inst_ids = (List)this.getView().getFormShowParameter().getCustomParam("proc_inst_id");
        DynamicObjectCollection entryList = this.getModel().getEntryEntity(ENTRY_ENTITY);
        entryList.clear();
        FlowRuntime flowRuntime = ProcessRuntime.loadRuntime((long)D.l(proc_inst_ids.get(0)));
        this.showVarsList(entryList, flowRuntime.getFlow());
    }

    private void showVarsList(DynamicObjectCollection entryList, Flow flow) {
        Map vmap = flow.getVariables();
        for (Map.Entry entry : vmap.entrySet()) {
            Variable variable = (Variable)entry.getValue();
            this.showVar(entryList.addNew(), variable);
        }
    }

    private void showVar(DynamicObject row, Variable variable) {
        Map varDefine = (Map)variable.getAttribute("define");
        String varCategory = D.s(varDefine.get("category"));
        String varType = D.s(varDefine.get("type"));
        DynamicObject meta = null;
        if (VariableType.isc_metadata_schema.name().equalsIgnoreCase(varCategory)) {
            meta = BusinessDataServiceHelper.loadSingle((Object)varType, (String)"isc_metadata_schema");
        } else if (VariableType.isc_type_simple_value.name().equalsIgnoreCase(varCategory)) {
            meta = BusinessDataServiceHelper.loadSingleFromCache((String)"isc_type_simple_value", (QFilter[])QFilterUtil.builder().put("number", "=", (Object)varType.toLowerCase()).build());
        }
        row.set("var_name", (Object)variable.getName());
        row.set("var_desc", (Object)variable.getTitle());
        row.set("var_category", (Object)varCategory.toLowerCase());
        row.set("var_type", (Object)meta);
        row.set("is_array", varDefine.get("is_array"));
        row.set("is_input", varDefine.get("is_input"));
        row.set("is_output", varDefine.get("is_output"));
    }
}

