/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.formplugin.sf;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.Map;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.control.Control;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.isc.iscb.formplugin.sf.Util;
import kd.isc.iscb.formplugin.util.FormOpener;
import kd.isc.iscb.platform.core.cache.DynamicObjectCacheProxy;
import kd.isc.iscb.platform.core.sf.Const;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.misc.Json;
import kd.isc.iscb.util.misc.StringUtil;

public class MessageStarterNodeEditorPlugin
extends AbstractFormPlugin
implements Const {
    private static final String VIEW_SUBSCRIBER = "view_subscriber";
    private static final String VIEW_VARIABLE = "view_var";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{VIEW_SUBSCRIBER, VIEW_VARIABLE});
    }

    public void beforeBindData(EventObject e) {
        Object flowId;
        DynamicObject flow;
        super.beforeBindData(e);
        Map params = this.getView().getFormShowParameter().getCustomParams();
        if (params.get("editable") != null && !((Boolean)params.get("editable")).booleanValue()) {
            this.getView().setStatus(OperationStatus.VIEW);
        }
        if ((flow = DynamicObjectCacheProxy.getById((Object)D.l(flowId = params.get("flow")), (String)"isc_service_flow")) != null) {
            this.reSetSubscriber(flow, "isc_mq_subscriber", params.get("mq_subscriber"));
            this.reSetVariablesValue(flow, params.get("variables_value"));
        } else if (params.get("released_id") != null) {
            DynamicObject releaseDefine = BusinessDataServiceHelper.loadSingle(params.get("released_id"), (String)"isc_service_flow_r");
            String defineJson = releaseDefine.getString("define_json_tag");
            Map map = (Map)Json.toObject((String)defineJson);
            flowId = map.get("flow_id");
            DynamicObject flowDefine = BusinessDataServiceHelper.loadSingle(flowId, (String)"isc_service_flow");
            this.reSetSubscriber(flowDefine, "isc_mq_subscriber", params.get("mq_subscriber"));
            this.reSetVariablesValue(flowDefine, params.get("variables_value"));
        }
        this.getPageCache().put("flow_id", D.s(flowId));
        this.getModel().setValue("title", params.get("title"));
    }

    public void afterDoOperation(AfterDoOperationEventArgs evt) {
        String operateKey = evt.getOperateKey();
        if ("btnok".equals(operateKey)) {
            Map params = this.getView().getFormShowParameter().getCustomParams();
            if (!D.x(params.get("editable"))) {
                this.getView().close();
            } else if (evt.getOperationResult() != null && evt.getOperationResult().isSuccess()) {
                try {
                    this.clickOkBtn(params);
                }
                catch (Exception e) {
                    this.getView().showTipNotification(e.getMessage());
                }
            }
        }
    }

    private void clickOkBtn(Map<String, Object> params) {
        IDataModel model = this.getModel();
        params.put("title", model.getValue("title"));
        params.put("mq_subscriber", model.getValue("mq_subscriber"));
        params.put("variables_value", model.getValue("variables_value"));
        this.getView().returnDataToParent(params);
    }

    private void reSetVariablesValue(DynamicObject flow, Object selected) {
        DynamicObjectCollection variables = flow.getDynamicObjectCollection("variables");
        Object existed = null;
        ArrayList<ComboItem> items = new ArrayList<ComboItem>(variables.size());
        for (DynamicObject variable : variables) {
            if (!"isc_metadata_schema".equals(variable.get("var_category"))) continue;
            String varName = variable.getString("var_name");
            String varDesc = variable.getString("var_type.name");
            ComboItem item = new ComboItem();
            item.setCaption(new LocaleString(Util.getVarOrResName(varDesc, varName)));
            item.setValue(varName);
            items.add(item);
            if (!varName.equals(selected)) continue;
            existed = selected;
        }
        ComboEdit combo = (ComboEdit)this.getView().getControl("variables_value");
        combo.setComboItems(items);
        this.getModel().setValue("variables_value", existed);
    }

    private void reSetSubscriber(DynamicObject flow, String resFormId, Object selected) {
        DynamicObjectCollection resources = flow.getDynamicObjectCollection("resources");
        ArrayList<ComboItem> items = new ArrayList<ComboItem>(resources.size());
        Object existed = null;
        for (DynamicObject resource : resources) {
            if (!resFormId.equals(D.s((Object)resource.get("res_category")))) continue;
            String resAlias = D.s((Object)resource.get("res_alias"));
            String resName = D.s((Object)resource.get("res_ref.name"));
            ComboItem item = new ComboItem();
            item.setCaption(new LocaleString(Util.getVarOrResName(resName, resAlias)));
            item.setValue(resAlias);
            items.add(item);
            if (!resAlias.equals(selected)) continue;
            existed = selected;
        }
        ComboEdit combo = (ComboEdit)this.getView().getControl("mq_subscriber");
        combo.setComboItems(items);
        this.getModel().setValue("mq_subscriber", existed);
    }

    public void click(EventObject evt) {
        long id;
        String value;
        super.click(evt);
        Object src = evt.getSource();
        String key = ((Control)src).getKey();
        if (VIEW_VARIABLE.equals(key)) {
            value = D.s((Object)this.getModel().getValue("variables_value"));
            if (StringUtil.isEmpty((String)value)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u8d4b\u503c\u53d8\u91cf\uff01", (String)"MessageStarterNodeEditorPlugin_0", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
            } else {
                id = this.getFromVariableId(value);
                FormOpener.showView(this, "isc_metadata_schema", id);
            }
        }
        if (VIEW_SUBSCRIBER.equals(key)) {
            value = D.s((Object)this.getModel().getValue("mq_subscriber"));
            if (StringUtil.isEmpty((String)value)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6d88\u606f\u8ba2\u9605\u4e3b\u9898!", (String)"MessageStarterNodeEditorPlugin_1", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
            } else {
                id = this.getFromSubscriberId(value);
                FormOpener.showView(this, "isc_mq_subscriber", id);
            }
        }
    }

    private long getFromSubscriberId(String aliasName) {
        long flowId = D.l((Object)this.getPageCache().get("flow_id"));
        DynamicObject flow = DynamicObjectCacheProxy.getById((Object)flowId, (String)"isc_service_flow");
        DynamicObjectCollection resources = flow.getDynamicObjectCollection("resources");
        for (DynamicObject res : resources) {
            if (!"isc_mq_subscriber".equals(D.s((Object)res.get("res_category"))) || !aliasName.equals(D.s((Object)res.get("res_alias")))) continue;
            DynamicObject subscriberTmp = res.getDynamicObject("res_ref");
            return D.l((Object)subscriberTmp.getPkValue());
        }
        return 0L;
    }

    private long getFromVariableId(String aliasName) {
        long flowId = D.l((Object)this.getPageCache().get("flow_id"));
        DynamicObject flow = DynamicObjectCacheProxy.getById((Object)flowId, (String)"isc_service_flow");
        DynamicObjectCollection resources = flow.getDynamicObjectCollection("variables");
        for (DynamicObject res : resources) {
            if (!"isc_metadata_schema".equals(D.s((Object)res.get("var_category"))) || !aliasName.equals(D.s((Object)res.get("var_name")))) continue;
            DynamicObject varTmp = res.getDynamicObject("var_type");
            return D.l((Object)varTmp.getPkValue());
        }
        return 0L;
    }
}

