/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.formplugin.sf;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.isc.iscb.formplugin.util.FormOpener;
import kd.isc.iscb.formplugin.util.MsgUtil;
import kd.isc.iscb.platform.core.constant.MessageType;
import kd.isc.iscb.platform.core.sf.Const;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.misc.StringUtil;

public class NoticeSenderNodeEditorFormPlugin
extends AbstractFormPlugin
implements Const {
    private static final String EDITABLE2 = "editable";
    private static final String TARGET_SYSTEM2 = "target_system";
    private static final String RECIPRENT = "recipient";
    private static final String RECIPRENT_NOTERP = "recipient_noterp";
    private static final String RECIPRENTVAR_ERP = "recipientvar_erp";
    private static final String RECIPRENTVAR_NOTERP = "recipientvar_noterp";
    private static final String BOS_USER = "bos_user";
    private static final String SEND_FLOW_DETAILS = "send_flow_details";
    private static final String RECIPRENT_SELECT = "recipient_select";
    private static final Pattern REGEX = Pattern.compile("(?<=\\()\\d+(?=\\))");

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{RECIPRENT, RECIPRENT_NOTERP, RECIPRENTVAR_ERP, RECIPRENTVAR_NOTERP, "btnok"});
    }

    public void beforeBindData(EventObject e) {
        int l = MessageType.values().length;
        ComboEdit combo = (ComboEdit)this.getView().getControl(TARGET_SYSTEM2);
        ArrayList<ComboItem> items = new ArrayList<ComboItem>(l);
        for (MessageType messageType : MessageType.values()) {
            ComboItem item = new ComboItem();
            item.setCaption(new LocaleString(((MultiLangEnumBridge)messageType.getName().getB()).loadKDString()));
            item.setValue((String)messageType.getName().getA());
            items.add(item);
        }
        combo.setComboItems(items);
        Map params = this.getView().getFormShowParameter().getCustomParams();
        this.getModel().setValue("title", params.get("title"));
        this.getModel().setValue(TARGET_SYSTEM2, params.get(TARGET_SYSTEM2));
        this.setNoticeMethod((String)params.get(TARGET_SYSTEM2));
        this.getModel().setValue("notice_method", params.get("notice_method"));
        this.getModel().setValue(RECIPRENT, params.get(RECIPRENT));
        this.getModel().setValue(RECIPRENT_NOTERP, params.get(RECIPRENT_NOTERP));
        this.getModel().setValue(RECIPRENTVAR_ERP, params.get(RECIPRENTVAR_ERP));
        this.getModel().setValue(RECIPRENTVAR_NOTERP, params.get(RECIPRENTVAR_NOTERP));
        this.getModel().setValue("msg_title", params.get("msg_title"));
        this.getModel().setValue("msg_content", params.get("msg_content"));
        this.getModel().setValue(SEND_FLOW_DETAILS, (Object)params.getOrDefault(SEND_FLOW_DETAILS, Boolean.TRUE));
        if (params.get(EDITABLE2) != null && !((Boolean)params.get(EDITABLE2)).booleanValue()) {
            this.getView().setStatus(OperationStatus.VIEW);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String prop = e.getProperty().getName();
        if (TARGET_SYSTEM2.equals(prop)) {
            this.setNoticeMethod((String)this.getModel().getValue(TARGET_SYSTEM2));
        }
    }

    public void click(EventObject evt) {
        String key = ((Control)evt.getSource()).getKey();
        if (RECIPRENT.equals(key)) {
            ListShowParameter parameter = ShowFormHelper.createShowListForm((String)BOS_USER, (boolean)true, (int)0);
            parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, RECIPRENT_SELECT));
            String person = (String)this.getModel().getValue(RECIPRENT);
            Matcher matcher = REGEX.matcher(person);
            ArrayList<String> pks = new ArrayList<String>();
            while (matcher.find()) {
                pks.add(matcher.group());
            }
            parameter.setSelectedRows(pks.toArray());
            this.getView().showForm((FormShowParameter)parameter);
        } else if (RECIPRENT_NOTERP.equals(key)) {
            String content = D.s((Object)this.getModel().getValue(RECIPRENT_NOTERP));
            if (content != null && content.length() > 0) {
                content = content.replaceAll("\\(", ",");
                content = content.replaceAll("\\);", ";");
            }
            this.getView().showForm(MsgUtil.getFormParam("isc_msg_phonenumber", true, ShowType.Modal, "value", content, new CloseCallBack((IFormPlugin)this, "personphone_select")));
        } else if (RECIPRENTVAR_ERP.equals(key)) {
            this.selectNoticeVar(key, "set_notice_var_erp");
        } else if (RECIPRENTVAR_NOTERP.equals(key)) {
            this.selectNoticeVar(key, "set_notice_var_noterp");
        }
    }

    private void selectNoticeVar(String key, String set_notice_var_noterp) {
        HashMap<String, Object> param = new HashMap<String, Object>();
        Map params = this.getView().getFormShowParameter().getCustomParams();
        long flowId = D.l(params.get("flow"));
        param.put("flow_id", flowId);
        param.put("key", key);
        param.put("multi", "1");
        FormOpener.showForm(this, "isc_sf_var_selector", ResManager.loadKDString((String)"\u9009\u62e9\u5c5e\u6027", (String)"NoticeSenderNodeEditorFormPlugin_0", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), param, set_notice_var_noterp);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate oper = (AbstractOperate)args.getSource();
        String operateKey = oper.getOperateKey();
        if ("btnok".equals(operateKey)) {
            String content = D.s((Object)this.getModel().getValue(RECIPRENT));
            String content1 = D.s((Object)this.getModel().getValue(RECIPRENT_NOTERP));
            String content2 = D.s((Object)this.getModel().getValue(RECIPRENTVAR_ERP));
            String content3 = D.s((Object)this.getModel().getValue(RECIPRENTVAR_NOTERP));
            if (StringUtil.isEmpty((String)content) && StringUtil.isEmpty((String)content1) && StringUtil.isEmpty((String)content2) && StringUtil.isEmpty((String)content3)) {
                args.setCancel(true);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6d88\u606f\u63a5\u6536\u4eba\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"NoticeSenderNodeEditorFormPlugin_1", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs evt) {
        super.afterDoOperation(evt);
        if (evt.getOperationResult() != null && evt.getOperationResult().isSuccess() && evt.getOperateKey().equals("btnok")) {
            Map params = this.getView().getFormShowParameter().getCustomParams();
            IDataModel model = this.getModel();
            params.put("title", model.getValue("title"));
            params.put(TARGET_SYSTEM2, model.getValue(TARGET_SYSTEM2));
            params.put("notice_method", model.getValue("notice_method"));
            params.put(RECIPRENT, model.getValue(RECIPRENT));
            params.put(RECIPRENT_NOTERP, model.getValue(RECIPRENT_NOTERP));
            params.put(RECIPRENTVAR_ERP, model.getValue(RECIPRENTVAR_ERP));
            params.put(RECIPRENTVAR_NOTERP, model.getValue(RECIPRENTVAR_NOTERP));
            params.put("msg_title", model.getValue("msg_title"));
            params.put("msg_content", model.getValue("msg_content"));
            params.put(SEND_FLOW_DETAILS, model.getValue(SEND_FLOW_DETAILS));
            this.getView().returnDataToParent((Object)params);
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String actionId = closedCallBackEvent.getActionId();
        Object returnData = closedCallBackEvent.getReturnData();
        if (RECIPRENT_SELECT.equalsIgnoreCase(actionId)) {
            ListSelectedRowCollection lsrc = (ListSelectedRowCollection)returnData;
            if (lsrc == null || lsrc.isEmpty()) {
                return;
            }
            DynamicObject[] dos = null;
            ArrayList<Long> selectedIds = new ArrayList<Long>();
            for (ListSelectedRow row : lsrc) {
                selectedIds.add((Long)row.getPrimaryKeyValue());
            }
            dos = BusinessDataServiceHelper.load((Object[])selectedIds.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)BOS_USER));
            if (dos == null || dos.length == 0) {
                return;
            }
            StringBuilder userName = new StringBuilder();
            for (int i = 0; i < dos.length; ++i) {
                if (i > 0) {
                    userName.append(',');
                }
                userName.append(dos[i].getString("name")).append('(').append(dos[i].getString("id")).append(')');
            }
            if (userName.length() > 0) {
                this.getModel().setValue(RECIPRENT, (Object)userName);
            }
        } else if ("personphone_select".equalsIgnoreCase(actionId)) {
            Map map;
            if (returnData instanceof Map && !(map = (Map)returnData).isEmpty()) {
                String content = (String)map.get("person_phone");
                content = content.replaceAll(",", "(");
                content = content.replaceAll(";", ");");
                this.getModel().setValue(RECIPRENT_NOTERP, (Object)content);
            }
        } else if ("set_notice_var_erp".equals(actionId)) {
            this.setNoticeVar(returnData);
        } else if ("set_notice_var_noterp".equals(actionId)) {
            this.setNoticeVar(returnData);
        }
    }

    private void setNoticeVar(Object returnData) {
        if (returnData instanceof Map) {
            Map data = (Map)returnData;
            String key = D.s(data.get("key"));
            String value = D.s(data.get("full_number"));
            this.getModel().setValue(key, (Object)value);
        } else if (returnData instanceof List) {
            List list = (List)returnData;
            StringBuilder sb = new StringBuilder(list.size());
            String key = null;
            for (Object obj : list) {
                Map data = (Map)obj;
                key = D.s(data.get("key"));
                String value = D.s(data.get("full_number"));
                sb.append(value).append(';');
            }
            if (!StringUtil.isEmpty(key)) {
                this.getModel().setValue(key, (Object)sb.toString());
            }
        }
    }

    private void setNoticeMethod(String targetSystem) {
        ComboEdit combo = (ComboEdit)this.getView().getControl("notice_method");
        try {
            MessageType messageType = MessageType.valueOf((String)targetSystem.toUpperCase());
            ArrayList<ComboItem> items = new ArrayList<ComboItem>(messageType.getTypes().size());
            for (Map.Entry e : messageType.getTypes().entrySet()) {
                ComboItem item = new ComboItem();
                item.setCaption(new LocaleString(((MultiLangEnumBridge)e.getValue()).loadKDString()));
                item.setValue((String)e.getKey());
                items.add(item);
            }
            combo.setComboItems(items);
        }
        catch (Exception e) {
            combo.setComboItems(Collections.emptyList());
        }
    }
}

