/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.formplugin.sf;

import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.context.RequestContextCreator;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.CellClickEvent;
import kd.bos.form.control.events.CellClickListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.isc.iscb.formplugin.sf.EditorUtil;
import kd.isc.iscb.formplugin.util.FormOpener;
import kd.isc.iscb.platform.core.sf.Const;
import kd.isc.iscb.platform.core.util.ContextUtil;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.except.IscBizException;
import kd.isc.iscb.util.misc.StringUtil;

public class RPANodeEditorFormPlugin
extends AbstractFormPlugin
implements Const,
CellClickListener {
    private static final Log LOG = LogFactory.getLog(RPANodeEditorFormPlugin.class);
    private static final String ENTRY_ENTITY = "entryentity";
    private static final String OUTPUT = "output";
    private static final String RPA_FLOW = "rpa_flow";
    private static final String RPA_ROBOT = "rpa_robot";
    public static final String PARAM_NAME = "param_name";
    public static final String PARAM_DESC = "param_desc";
    public static final String PARAM_IS_NEED = "param_is_need";
    public static final String PARAM_TYPE = "param_type";
    public static final String PARAM_VAR_FIXED = "param_var_fixed";
    public static final String PARAM_VAR = "param_var";
    private static final String RPA_ROBOT_ID = "rpa_robot_id";
    private static final String VERSION = "version";
    private static final String PROXY_USER = "proxy_user";

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        Map params = this.getView().getFormShowParameter().getCustomParams();
        this.getModel().setValue("title", params.get("title"));
        this.getModel().setValue(RPA_FLOW, params.get(RPA_FLOW));
        this.getModel().setValue(RPA_ROBOT, params.get(RPA_ROBOT));
        this.getModel().setValue("rpa_flow_id", params.get("rpa_flow_id"));
        this.getModel().setValue(RPA_ROBOT_ID, params.get(RPA_ROBOT_ID));
        this.getModel().setValue(VERSION, params.get(VERSION));
        this.getModel().setValue(PROXY_USER, params.get(PROXY_USER));
        this.getModel().setValue(OUTPUT, params.get(OUTPUT));
        this.setInputEntry(params);
        if (!this.isEditable()) {
            this.getView().setStatus(OperationStatus.VIEW);
        }
        if (this.getModel().getValue("title") == null) {
            this.getModel().setValue("title", (Object)ResManager.loadKDString((String)"\u6570\u636e\u6cbb\u7406", (String)"RPANodeEditorFormPlugin_13", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
        }
    }

    private void setInputEntry(Map<String, Object> params) {
        Map inputs = (Map)params.get("input");
        if (inputs == null) {
            return;
        }
        DynamicObjectCollection param_entryentity = this.getModel().getEntryEntity(ENTRY_ENTITY);
        param_entryentity.clear();
        for (Map.Entry input : inputs.entrySet()) {
            DynamicObject item = param_entryentity.addNew();
            item.set(PARAM_NAME, input.getKey());
            item.set(PARAM_TYPE, ((Map)input.getValue()).get(PARAM_TYPE));
            item.set(PARAM_DESC, ((Map)input.getValue()).get(PARAM_DESC));
            item.set(PARAM_IS_NEED, ((Map)input.getValue()).get(PARAM_IS_NEED));
            item.set(PARAM_VAR_FIXED, ((Map)input.getValue()).get(PARAM_VAR_FIXED));
            item.set(PARAM_VAR, ((Map)input.getValue()).get(PARAM_VAR));
        }
    }

    private boolean isEditable() {
        return D.x((Object)this.getView().getFormShowParameter().getCustomParam("editable"));
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        try {
            super.afterDoOperation(args);
            String operateKey = args.getOperateKey();
            if ("btnok".equals(operateKey)) {
                if (this.isEditable()) {
                    this.check();
                    this.checkInputParams();
                    this.setReturnData();
                }
                this.getView().close();
            }
        }
        catch (Exception e) {
            this.getView().showTipNotification(e.getMessage());
        }
    }

    private void setReturnData() {
        Map params = this.getView().getFormShowParameter().getCustomParams();
        params.put("title", this.getModel().getValue("title"));
        params.put(RPA_FLOW, D.s((Object)this.getModel().getValue(RPA_FLOW)));
        params.put(RPA_ROBOT, D.s((Object)this.getModel().getValue(RPA_ROBOT)));
        params.put("rpa_flow_id", D.s((Object)this.getModel().getValue("rpa_flow_id")));
        params.put(RPA_ROBOT_ID, D.s((Object)this.getModel().getValue(RPA_ROBOT_ID)));
        params.put(VERSION, D.s((Object)this.getModel().getValue(VERSION)));
        params.put(PROXY_USER, D.s((Object)this.getModel().getValue(PROXY_USER)));
        params.put(OUTPUT, D.s((Object)this.getModel().getValue(OUTPUT)));
        this.setInputParamsReturnData(params);
        this.getView().returnDataToParent((Object)params);
    }

    private void setInputParamsReturnData(Map<String, Object> params) {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(ENTRY_ENTITY);
        LinkedHashMap input = new LinkedHashMap(entryEntity.size());
        for (DynamicObject entry : entryEntity) {
            HashMap<String, String> line = new HashMap<String, String>(6);
            line.put(PARAM_NAME, entry.getString(PARAM_NAME));
            line.put(PARAM_DESC, entry.getString(PARAM_DESC));
            line.put(PARAM_TYPE, entry.getString(PARAM_TYPE));
            line.put(PARAM_IS_NEED, entry.getString(PARAM_IS_NEED));
            line.put(PARAM_VAR_FIXED, entry.getString(PARAM_VAR_FIXED));
            line.put(PARAM_VAR, entry.getString(PARAM_VAR));
            input.put(entry.getString(PARAM_NAME), line);
        }
        params.put("input", input);
    }

    private void checkInputParams() {
        DynamicObjectCollection paramEntries = this.getModel().getEntryEntity(ENTRY_ENTITY);
        for (DynamicObject entry : paramEntries) {
            if (!D.x((Object)entry.getString(PARAM_IS_NEED)) || !StringUtil.isEmpty((String)entry.getString(PARAM_VAR_FIXED)) || !StringUtil.isEmpty((String)entry.getString(PARAM_VAR))) continue;
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5fc5\u586b\u53c2\u6570%s\u7684\u5e38\u91cf\u4e0e\u8868\u8fbe\u5f0f\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a\u3002", (String)"RPANodeEditorFormPlugin_10", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), entry.getString(PARAM_NAME)));
        }
    }

    private void check() {
        EditorUtil.checkTitle(this.getModel());
        String rpa_flow = D.s((Object)this.getModel().getValue(RPA_FLOW));
        if (StringUtil.isEmpty((String)rpa_flow)) {
            throw new IscBizException(ResManager.loadKDString((String)"RPA\u6d41\u7a0b\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"RPANodeEditorFormPlugin_2", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
        }
        String rpa_robot = D.s((Object)this.getModel().getValue(RPA_ROBOT));
        if (StringUtil.isEmpty((String)rpa_robot)) {
            throw new IscBizException(ResManager.loadKDString((String)"RPA\u673a\u5668\u4eba\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"RPANodeEditorFormPlugin_3", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
        }
    }

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{RPA_FLOW, RPA_ROBOT, OUTPUT});
        EntryGrid entries = (EntryGrid)this.getView().getControl(ENTRY_ENTITY);
        entries.addCellClickListener((CellClickListener)this);
        this.addClickListeners(new String[]{PARAM_VAR});
    }

    public void cellClick(CellClickEvent cellClickEvent) {
    }

    public void click(EventObject evt) {
        super.click(evt);
        if (!this.isEditable()) {
            return;
        }
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        if (OUTPUT.equals(key)) {
            EditorUtil.selectVariableProperty(this, key);
        } else if (RPA_FLOW.equals(key)) {
            this.openRPAFlows();
        } else if (RPA_ROBOT.equals(key)) {
            this.openRPARobots();
        }
    }

    private void openRPARobots() {
        String process_id = D.s((Object)this.getModel().getValue("rpa_flow_id"));
        if (!StringUtil.isEmpty((String)process_id)) {
            HashMap<String, Object> params = new HashMap<String, Object>(1);
            params.put("rpa_flow_id", process_id);
            FormOpener.showForm(this, "isc_rpa_robot", ResManager.loadKDString((String)"RPA\u673a\u5668\u4eba", (String)"RPANodeEditorFormPlugin_4", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), params, "rpa_flow_id");
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5fc5\u987b\u9009\u62e9\u4e00\u4e2aRPA\u6d41\u7a0b", (String)"RPANodeEditorFormPlugin_5", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void openRPAFlows() {
        RequestContext current = RequestContext.get();
        RequestContext new_rc = null;
        try {
            String proxyUser = D.s((Object)this.getModel().getValue(PROXY_USER));
            new_rc = StringUtil.isEmpty((String)proxyUser) ? current : ContextUtil.restoreAndGetContext((RequestContext)current, (String)proxyUser);
            List list = (List)DispatchServiceHelper.invokeBizService((String)"rpac", (String)"rpacp", (String)"RpaService", (String)"getProcessList", (Object[])new Object[]{RequestContext.get().getUserId(), null});
            HashMap<String, Object> params = new HashMap<String, Object>(1);
            params.put("rpa_flow_list", list);
            FormOpener.showForm(this, "isc_rpa_flow", ResManager.loadKDString((String)"RPA\u6d41\u7a0b", (String)"RPANodeEditorFormPlugin_6", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), params, "rpa_flow_list");
        }
        catch (Exception e) {
            LOG.warn("\u8c03\u7528RPA\u5fae\u670d\u52a1\u5931\u8d25, \u539f\u56e0\uff1a" + StringUtil.getCascadeMessage((Throwable)e), (Throwable)e);
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u8c03\u7528RPA\u5fae\u670d\u52a1\u83b7\u53d6\u6d41\u7a0b\u5217\u8868\u5931\u8d25\uff0c\u539f\u56e0\u662f\uff1a%s", (String)"RPANodeEditorFormPlugin_11", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), StringUtil.getCascadeMessage((Throwable)e)));
        }
        finally {
            if (new_rc != null) {
                RequestContextCreator.restoreForMQ((RequestContext)current);
            }
        }
    }

    public void cellDoubleClick(CellClickEvent event) {
        String fieldKey = event.getFieldKey();
        if (PARAM_VAR.equals(fieldKey)) {
            EditorUtil.selectVariableProperty(this, fieldKey);
        }
    }

    private void setEntries(String number, String version) {
        try {
            List list = (List)DispatchServiceHelper.invokeBizService((String)"rpac", (String)"rpacp", (String)"RpaService", (String)"getProcessParms", (Object[])new Object[]{number, version});
            this.getModel().deleteEntryData(ENTRY_ENTITY);
            DynamicObjectCollection entries = this.getModel().getDataEntity(true).getDynamicObjectCollection(ENTRY_ENTITY);
            for (Map rpa : list) {
                DynamicObject obj = entries.addNew();
                obj.set(PARAM_NAME, rpa.get("Name"));
                obj.set(PARAM_DESC, rpa.get("Desc"));
                obj.set(PARAM_TYPE, rpa.get("Type"));
                obj.set(PARAM_IS_NEED, rpa.get("IsEmpty"));
                obj.set(PARAM_VAR_FIXED, rpa.get("Value"));
                obj.set(PARAM_VAR, rpa.get("procVer"));
            }
            this.getView().updateView(ENTRY_ENTITY);
        }
        catch (Exception e) {
            LOG.warn("\u8c03\u7528RPA\u5fae\u670d\u52a1\u5931\u8d25, \u539f\u56e0\uff1a" + StringUtil.getCascadeMessage((Throwable)e), (Throwable)e);
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u8c03\u7528RPA\u5fae\u670d\u52a1\u83b7\u53d6\u8f93\u5165\u53c2\u6570\u5931\u8d25\uff0c\u539f\u56e0\u662f\uff1a%s", (String)"RPANodeEditorFormPlugin_12", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), StringUtil.getCascadeMessage((Throwable)e)));
        }
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        super.closedCallBack(evt);
        String action = evt.getActionId();
        if ("get_property".equals(action)) {
            EditorUtil.setReturnDataAfterChosedVar(this.getModel(), evt);
        } else if ("rpa_flow_id".equals(action)) {
            Map returnData = (Map)evt.getReturnData();
            if (returnData == null) {
                return;
            }
            String alias = D.s(returnData.get("alias"));
            String id = D.s(returnData.get("id"));
            this.getModel().setValue(RPA_ROBOT, (Object)alias);
            this.getModel().setValue(RPA_ROBOT_ID, (Object)id);
        } else if ("rpa_flow_list".equals(action)) {
            Map returnData = (Map)evt.getReturnData();
            if (returnData == null) {
                return;
            }
            String number = D.s(returnData.get("number"));
            String id = D.s(returnData.get("id"));
            String version = D.s(returnData.get(VERSION));
            this.getModel().setValue(RPA_FLOW, (Object)number);
            this.getModel().setValue("rpa_flow_id", (Object)id);
            this.getModel().setValue(VERSION, (Object)version);
            this.setEntries(number, version);
        }
    }
}

