/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.formplugin.sf;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.Control;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.isc.iscb.formplugin.sf.ScriptTextUtil;
import kd.isc.iscb.formplugin.sf.StartNodeTypeMap;
import kd.isc.iscb.formplugin.util.CustomFunctionUtil;
import kd.isc.iscb.formplugin.util.FormOpener;
import kd.isc.iscb.platform.core.cache.data.DataSource;
import kd.isc.iscb.platform.core.cache.data.MetaDataSchema;
import kd.isc.iscb.platform.core.sf.Const;
import kd.isc.iscb.platform.core.sf.ServiceFlowReleaser;
import kd.isc.iscb.platform.core.util.CommonUtil;
import kd.isc.iscb.util.connector.server.MetaType;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.misc.Hash;
import kd.isc.iscb.util.misc.Json;
import kd.isc.iscb.util.misc.StringUtil;

public class ServiceFlowFormPlugin
extends AbstractFormPlugin
implements Const {
    private static final String ENABLE = "enable";
    private static final String RES_SOURCE_TEXT = "res_source_text";
    private static final String RES_ALIAS = "res_alias";
    private static final String RESOURCES2 = "resources";
    private static final String VAR_SOURCE = "var_source";
    private static final String VAR_CATEGORY = "var_category";
    private static final String VAR_NAME = "var_name";
    private static final String VARIABLES2 = "variables";
    private static final String INIT_MODE2 = "init_mode";
    private static final String EVENT = "EVENT";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"proc_digest"});
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        ChangeData[] changeSet = e.getChangeSet();
        if (changeSet.length == 1) {
            switch (name) {
                case "init_mode": {
                    ChangeData changeData = changeSet[0];
                    String startType = D.s((Object)changeData.getNewValue());
                    if (startType.equals(changeData.getOldValue())) break;
                    this.resetStartNode(startType);
                    break;
                }
                case "var_type": {
                    this.resRefChanged(changeSet, VARIABLES2, VAR_SOURCE);
                    this.setDescAndImportResource(changeSet);
                    break;
                }
                case "res_ref": {
                    DynamicObject resourceItem = this.getModel().getEntryRowEntity(RESOURCES2, changeSet[0].getRowIndex());
                    if (D.s((Object)resourceItem.get(RES_ALIAS)) == null) {
                        this.setRandVarName(resourceItem, RES_ALIAS, RESOURCES2);
                    }
                    this.resRefChanged(changeSet, RESOURCES2, RES_SOURCE_TEXT);
                    break;
                }
                case "res_category": {
                    this.clearSource(changeSet, RESOURCES2, RES_SOURCE_TEXT);
                    break;
                }
                case "var_category": {
                    this.clearSource(changeSet, VARIABLES2, VAR_SOURCE);
                    break;
                }
            }
        }
    }

    private void setDescAndImportResource(ChangeData[] changeSet) {
        int rowIndex = changeSet[0].getRowIndex();
        DynamicObject newValue = (DynamicObject)changeSet[0].getNewValue();
        if (newValue != null) {
            DynamicObject schema;
            String resRefName = newValue.getDynamicObjectType().getName();
            long resourcesId = D.l((Object)newValue.get("id"));
            if ("isc_metadata_schema".equals(resRefName) && (schema = BusinessDataServiceHelper.loadSingle((Object)resourcesId, (String)"isc_metadata_schema")) != null) {
                String name = D.s((Object)schema.get("name"));
                ((DynamicObject)this.getModel().getDataEntity(true).getDynamicObjectCollection(VARIABLES2).get(rowIndex)).set("var_desc", (Object)name);
                DynamicObjectCollection resources = this.getModel().getDataEntity(true).getDynamicObjectCollection(RESOURCES2);
                boolean isExists = this.isExists(resourcesId, resources);
                if (!isExists) {
                    DynamicObject item = resources.addNew();
                    item.set("res_category", (Object)"isc_metadata_schema");
                    item.set("res_ref", (Object)schema);
                    String resAliasName = this.getResAliasName(schema);
                    item.set(RES_ALIAS, (Object)(resAliasName.length() > 50 ? resAliasName.substring(0, 50) : resAliasName));
                    DynamicObject group = schema.getDynamicObject("group");
                    if (group != null) {
                        item.set(RES_SOURCE_TEXT, group.get("name"));
                    }
                }
            }
        }
        this.getView().updateView(VARIABLES2);
        this.getView().updateView(RESOURCES2);
    }

    private String getResAliasName(DynamicObject schema) {
        String number = D.s((Object)schema.get("number"));
        if (number != null) {
            if (MetaType.TABLE.name().equals(schema.get("type")) && number.contains("@")) {
                number = number.substring(0, number.lastIndexOf(64));
            }
            number = number.toLowerCase();
        } else {
            number = ServiceFlowFormPlugin.getRandVarName().toLowerCase();
        }
        return "r_" + number;
    }

    private boolean isExists(long resourcesId, DynamicObjectCollection resources) {
        for (DynamicObject resource : resources) {
            Object res_category = resource.get("res_category");
            long res_ref_id = D.l((Object)resource.get("res_ref_id"));
            if (resourcesId != res_ref_id || !"isc_metadata_schema".equals(res_category)) continue;
            return true;
        }
        return false;
    }

    private void setRandVarName(DynamicObject resourceItem, String prop, String entityName) {
        resourceItem.set(prop, (Object)ServiceFlowFormPlugin.getRandVarName());
        this.getView().updateView(entityName);
    }

    private void clearSource(ChangeData[] changeSet, String entityName, String property) {
        if (changeSet.length == 1) {
            int rowIndex = changeSet[0].getRowIndex();
            ((DynamicObject)this.getModel().getEntryEntity(entityName).get(rowIndex)).set(property, null);
            this.getView().updateView(entityName);
        }
    }

    public static String getRandVarName() {
        String name = Hash.mur16((Object[])new Object[]{UUID.randomUUID()});
        char c = name.charAt(0);
        if (c < 'A') {
            name = (char)(c + 23) + name.substring(1);
        }
        return name;
    }

    private void resRefChanged(ChangeData[] changeSet, String entityName, String property) {
        DynamicObject newValue = (DynamicObject)changeSet[0].getNewValue();
        DynamicObject group = null;
        DynamicObject tarGroup = null;
        int rowIndex = changeSet[0].getRowIndex();
        if (newValue != null) {
            String resRefName = newValue.getDynamicObjectType().getName();
            long resourcesId = (Long)newValue.get("id");
            if ("isc_metadata_schema".equals(resRefName)) {
                DynamicObject schema = BusinessDataServiceHelper.loadSingle((Object)resourcesId, (String)"isc_metadata_schema");
                group = schema.getDynamicObject("group");
            } else if ("isc_value_conver_rule".equals(resRefName)) {
                DynamicObject meta = BusinessDataServiceHelper.loadSingle((Object)resourcesId, (String)"isc_value_conver_rule");
                group = meta.getDynamicObject("source_data_source");
                tarGroup = meta.getDynamicObject("target_data_source");
            } else if ("isc_data_copy".equals(resRefName)) {
                DynamicObject datacopy = BusinessDataServiceHelper.loadSingle((Object)resourcesId, (String)"isc_data_copy");
                group = datacopy.getDynamicObject("data_source");
                tarGroup = datacopy.getDynamicObject("data_target");
            } else if ("isc_data_copy_trigger".equals(resRefName)) {
                DynamicObject datacopy;
                QFilter qFilter;
                MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)"isc_data_copy_trigger");
                DynamicObject trigger = BusinessDataServiceHelper.loadSingle((Object)resourcesId, (DynamicObjectType)entityType);
                if (trigger.getLong("new_source_system_id") > 0L) {
                    qFilter = new QFilter("id", "=", (Object)trigger.getLong("new_source_system_id"));
                    group = QueryServiceHelper.queryOne((String)"isc_data_source", (String)"name", (QFilter[])new QFilter[]{qFilter});
                } else {
                    datacopy = BusinessDataServiceHelper.loadSingle((Object)trigger.getDynamicObject("data_copy").get("id"), (String)"isc_data_copy");
                    group = datacopy.getDynamicObject("data_source");
                }
                if (trigger.getLong("new_target_system_id") > 0L) {
                    qFilter = new QFilter("id", "=", (Object)trigger.getLong("new_target_system_id"));
                    tarGroup = QueryServiceHelper.queryOne((String)"isc_data_source", (String)"name", (QFilter[])new QFilter[]{qFilter});
                } else {
                    datacopy = BusinessDataServiceHelper.loadSingle((Object)trigger.getDynamicObject("data_copy").get("id"), (String)"isc_data_copy");
                    tarGroup = datacopy.getDynamicObject("data_target");
                }
            } else if ("isc_mq_subscriber".equals(resRefName)) {
                DynamicObject mqsubscriber = BusinessDataServiceHelper.loadSingle((Object)resourcesId, (String)"isc_mq_subscriber");
                group = mqsubscriber.getDynamicObject("data_source");
            } else if ("isc_apic_for_external_api".equals(resRefName)) {
                DynamicObject externalApi = BusinessDataServiceHelper.loadSingle((Object)resourcesId, (String)"isc_apic_for_external_api");
                group = externalApi.getDynamicObject("group");
            } else if ("isc_mq_publisher".equals(resRefName)) {
                DynamicObject mqPublisher = BusinessDataServiceHelper.loadSingle((Object)resourcesId, (String)"isc_mq_publisher");
                group = mqPublisher.getDynamicObject("data_source");
            } else if ("isc_data_comp".equals(resRefName)) {
                DynamicObject dataComp = BusinessDataServiceHelper.loadSingle((Object)resourcesId, (String)"isc_data_comp");
                DynamicObject datacopy = BusinessDataServiceHelper.loadSingle((Object)dataComp.getDynamicObject("data_copy").get("id"), (String)"isc_data_copy");
                group = datacopy.getDynamicObject("data_source");
                tarGroup = datacopy.getDynamicObject("data_target");
            } else if ("isc_user_defined_event".equals(resRefName)) {
                group = DataSource.get((String)"PREISCHUB").getConfig();
            } else if ("isc_apic_webapi".equals(resRefName)) {
                DynamicObject webApi = BusinessDataServiceHelper.loadSingle((Object)resourcesId, (String)"isc_apic_webapi");
                group = webApi.getDynamicObject("group");
            }
        }
        if (RES_SOURCE_TEXT.equals(property)) {
            String groupText = "";
            if (group != null) {
                groupText = group.getString("name");
            }
            if (group != null && tarGroup != null && (groupText = groupText + "\uff1b\u3000" + tarGroup.getString("name")).length() > 255) {
                groupText = StringUtil.trim((String)groupText, (int)255);
            }
            ((DynamicObject)this.getModel().getEntryEntity(entityName).get(rowIndex)).set(property, (Object)groupText);
        } else {
            ((DynamicObject)this.getModel().getEntryEntity(entityName).get(rowIndex)).set(property, group);
        }
        this.getView().updateView(entityName);
    }

    private void resetStartNode(String startType) {
        String defineJsonTag = D.s((Object)this.getModel().getValue("define_json_tag"));
        if (defineJsonTag != null) {
            Map graph = this.modifyDataTag(startType, defineJsonTag);
            this.getModel().setValue("define_json_tag", (Object)Json.toString((Object)graph));
        }
    }

    private Map modifyDataTag(String startType, String defineJsonTag) {
        Map startNode;
        Map graph = (Map)Json.toObject((String)defineJsonTag);
        Map nodes = (Map)graph.get("nodes");
        if (nodes != null && (startNode = (Map)nodes.get("1")) != null) {
            startNode.put("type", StartNodeTypeMap.getStarterByType(startType));
        }
        return graph;
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        AbstractOperate oper;
        String operateKey;
        super.beforeDoOperation(args);
        if (args.getSource() instanceof AbstractOperate && "save".equals(operateKey = (oper = (AbstractOperate)args.getSource()).getOperateKey())) {
            if (this.isArgumentsIllegal()) {
                args.setCancel(true);
            } else {
                this.getModel().setValue("is_released", (Object)Boolean.FALSE);
                this.disableFlowConfirm(args);
            }
        }
    }

    private boolean isArgumentsIllegal() {
        if (this.hasImportDuplicateRes()) {
            return true;
        }
        if (CustomFunctionUtil.isEntryDuplicate(RESOURCES2, RES_ALIAS, this.getModel(), this.getView())) {
            return true;
        }
        if (CustomFunctionUtil.isEntryDuplicate(VARIABLES2, VAR_NAME, this.getModel(), this.getView())) {
            return true;
        }
        if (EVENT.equals(this.getModel().getValue(INIT_MODE2)) && !this.hasMetaTypeVarAndResource()) {
            return true;
        }
        if (this.isIllegalName(RESOURCES2, RES_ALIAS, ResManager.loadKDString((String)"\u522b\u540d", (String)"ServiceFlowFormPlugin_0", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]))) {
            return true;
        }
        if (this.isIllegalName(VARIABLES2, VAR_NAME, ResManager.loadKDString((String)"\u53d8\u91cf\u540d", (String)"ServiceFlowFormPlugin_1", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]))) {
            return true;
        }
        return "SUB_FLOW".equals(this.getModel().getValue(INIT_MODE2)) && this.isValidSubFlow();
    }

    private boolean hasEventSourceTypeRes() {
        DynamicObjectCollection collection = this.getModel().getEntryEntity(RESOURCES2);
        for (DynamicObject resource : collection) {
            long resRefId;
            DynamicObject dataSchema;
            if (!"isc_metadata_schema".equals(resource.get("res_category")) || !"EVT_RSC".equals((dataSchema = MetaDataSchema.get((long)(resRefId = D.l((Object)resource.get("res_ref_id"))))).get("type"))) continue;
            return true;
        }
        return false;
    }

    private boolean hasEventSourceTypeVar() {
        DynamicObjectCollection collection = this.getModel().getEntryEntity(VARIABLES2);
        for (DynamicObject variable : collection) {
            long varType;
            DynamicObject dataSchema;
            if (!"isc_metadata_schema".equals(variable.get(VAR_CATEGORY)) || !"EVT_RSC".equals((dataSchema = MetaDataSchema.get((long)(varType = D.l((Object)variable.get("var_type_id"))))).get("type"))) continue;
            return true;
        }
        return false;
    }

    private boolean isValidSubFlow() {
        String json = D.s((Object)this.getModel().getValue("define_json_tag"));
        Map diagram = (Map)Json.toObject((String)json);
        if (diagram != null) {
            Map nodes = (Map)diagram.get("nodes");
            for (Map.Entry entry : nodes.entrySet()) {
                Map node = (Map)entry.getValue();
                if ("EndTermination".equals(node.get("type"))) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5b50\u6d41\u7a0b\u5185\u5b58\u5728\u6d41\u7a0b\u7ec8\u6b62\u8282\u70b9\uff0c\u7981\u6b62\u590d\u5236\u3002", (String)"ServiceFlowFormPlugin_2", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
                    return true;
                }
                if (!"SubFlow".equals(node.get("type"))) continue;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5b50\u6d41\u7a0b\u5185\u5b58\u5728\u5b50\u6d41\u7a0b\u8282\u70b9\uff0c\u7981\u6b62\u590d\u5236\u3002", (String)"ServiceFlowFormPlugin_3", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
                return true;
            }
        }
        if (!this.isSubVarsHasInput()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5b50\u6d41\u7a0b\u81f3\u5c11\u6709\u4e00\u4e2a\u8f93\u5165\u53d8\u91cf\u3002", (String)"ServiceFlowFormPlugin_4", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
            return true;
        }
        DynamicObjectCollection collection = this.getModel().getEntryEntity(RESOURCES2);
        for (DynamicObject dynamicObject : collection) {
            if (!this.isSubFlow(dynamicObject)) continue;
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5b50\u6d41\u7a0b\u5185\u4e0d\u5141\u8bb8\u5f15\u7528\u5b50\u6d41\u7a0b\u8d44\u6e90\u3002", (String)"ServiceFlowFormPlugin_5", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
            return true;
        }
        return false;
    }

    private boolean isSubVarsHasInput() {
        DynamicObjectCollection vars = this.getModel().getEntryEntity(VARIABLES2);
        for (DynamicObject var : vars) {
            if (!var.getBoolean("is_input_param")) continue;
            return true;
        }
        return false;
    }

    private boolean isSubFlow(DynamicObject resource) {
        if (!"isc_service_flow".equals(D.s((Object)resource.get("res_category")))) {
            return false;
        }
        Object resFlowId = resource.getDynamicObject("res_ref").getPkValue();
        DynamicObject resFlow = BusinessDataServiceHelper.loadSingle((Object)resFlowId, (String)"isc_service_flow");
        String mode = resFlow.getString(INIT_MODE2);
        return "sub_flow".equalsIgnoreCase(mode);
    }

    private boolean hasImportDuplicateRes() {
        DynamicObjectCollection entries = this.getModel().getEntryEntity(RESOURCES2);
        HashMap<String, List<DynamicObject>> resRefRowMap = new HashMap<String, List<DynamicObject>>();
        HashSet<String> duplicateResIds = new HashSet<String>();
        if (entries != null && entries.size() > 0) {
            this.groupResEntriesByResId(entries, resRefRowMap, duplicateResIds);
            if (duplicateResIds.size() > 0) {
                StringBuilder sb = this.generateTipContent(resRefRowMap, duplicateResIds);
                FormOpener.showErrorMessage(this.getView(), ResManager.loadKDString((String)"\u6d41\u7a0b\u91cd\u590d\u5f15\u5165\u4e86\u76f8\u540c\u8d44\u6e90,\u8bf7\u8fdb\u884c\u8c03\u6574", (String)"ServiceFlowFormPlugin_6", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), sb.toString());
                return true;
            }
        }
        return false;
    }

    private void groupResEntriesByResId(DynamicObjectCollection entries, Map<String, List<DynamicObject>> resRefRowMap, Set<String> duplicateResIds) {
        for (DynamicObject entry : entries) {
            String resid = entry.getString("res_ref.id");
            List<DynamicObject> dynamicObjects = resRefRowMap.get(resid);
            if (dynamicObjects == null) {
                dynamicObjects = new ArrayList<DynamicObject>();
            }
            dynamicObjects.add(entry);
            if (dynamicObjects.size() > 1) {
                duplicateResIds.add(resid);
            }
            resRefRowMap.put(resid, dynamicObjects);
        }
    }

    private StringBuilder generateTipContent(Map<String, List<DynamicObject>> resRefRowMap, Set<String> duplicateResIds) {
        StringBuilder sb = new StringBuilder(ResManager.loadKDString((String)"\u6d41\u7a0b\u91cd\u590d\u5f15\u5165\u4e86\u76f8\u540c\u8d44\u6e90\uff0c\u4f1a\u5bf9\u6d41\u7a0b\u5e26\u6765\u4e0d\u826f\u5f71\u54cd\uff0c\u8bf7\u8fdb\u884c\u8c03\u6574", (String)"ServiceFlowFormPlugin_22", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0])).append("\r\n").append(ResManager.loadKDString((String)"\u3010\u4f9d\u8d56\u8d44\u6e90\u3011\u5206\u5f55\u4e2d:", (String)"ServiceFlowFormPlugin_23", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0])).append("\r\n");
        for (String duplicateResId : duplicateResIds) {
            List<DynamicObject> resList = resRefRowMap.get(duplicateResId);
            sb.append('\u7b2c');
            for (int i = 0; i < resList.size(); ++i) {
                DynamicObject obj = resList.get(i);
                if (i > 0) {
                    sb.append(',');
                }
                sb.append(obj.getString("seq"));
            }
            sb.append(ResManager.loadKDString((String)"\u884c\u5f15\u5165\u4e86\u76f8\u540c\u7684\u8d44\u6e90", (String)"ServiceFlowFormPlugin_24", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0])).append("\r\n");
        }
        return sb;
    }

    private void disableFlowConfirm(BeforeDoOperationEventArgs args) {
        if (this.isEnabled()) {
            args.setCancel(true);
            ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("disable_flow", (IFormPlugin)this);
            this.getView().showConfirm(ResManager.loadKDString((String)"\u670d\u52a1\u6d41\u7a0b\u5df2\u542f\u7528\uff0c\u662f\u5426\u7981\u7528\uff1f", (String)"ServiceFlowFormPlugin_9", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, confirmCallBacks);
        }
    }

    private boolean isEnabled() {
        Object id = this.getModel().getValue("id");
        if (D.l((Object)id) != 0L && OperationStatus.EDIT == this.getView().getFormShowParameter().getStatus()) {
            DynamicObject model = BusinessDataServiceHelper.loadSingle((Object)id, (String)this.getModel().getDataEntityType().getName(), (String)ENABLE);
            return D.x((Object)model.get(ENABLE));
        }
        return false;
    }

    public void confirmCallBack(MessageBoxClosedEvent evt) {
        if (evt.getResult() == MessageBoxResult.Yes && "disable_flow".equals(evt.getCallBackId())) {
            try {
                long id = D.l((Object)this.getModel().getValue("id"));
                this.getModel().setValue(ENABLE, (Object)Boolean.FALSE);
                DB.execute((DBRoute)DBRoute.of((String)"ISCB"), (String)"UPDATE T_ISC_SERVICE_FLOW SET FENABLE = '0' WHERE FID = ?", (Object[])new Object[]{id});
                ServiceFlowReleaser.disableDefine((long)id);
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5df2\u7981\u7528\u6210\u529f\uff0c\u8bf7\u518d\u6b21\u5c1d\u8bd5\u4fdd\u5b58!", (String)"ServiceFlowFormPlugin_10", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), Integer.valueOf(1000));
            }
            catch (Exception e) {
                FormOpener.showErrorMessage(this.getView(), e);
            }
        }
    }

    private boolean hasMetaTypeVarAndResource() {
        boolean hasMetaResource;
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        boolean hasMetaVariable = this.hasMetaType(dataEntity, VARIABLES2, VAR_CATEGORY);
        if (!hasMetaVariable) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u542f\u52a8\u65b9\u5f0f\u4e3a\u4e8b\u4ef6\u89e6\u53d1\u7684\u670d\u52a1\u6d41\u7a0b\u81f3\u5c11\u914d\u7f6e\u4e00\u4e2a\u96c6\u6210\u5bf9\u8c61\u7c7b\u578b\u7684\u53d8\u91cf", (String)"ServiceFlowFormPlugin_11", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
        }
        if (!(hasMetaResource = this.hasMetaType(dataEntity, RESOURCES2, "res_category"))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u542f\u52a8\u65b9\u5f0f\u4e3a\u4e8b\u4ef6\u89e6\u53d1\u7684\u670d\u52a1\u6d41\u7a0b\u81f3\u5c11\u914d\u7f6e\u4e00\u4e2a\u96c6\u6210\u5bf9\u8c61\u7c7b\u578b\u7684\u8d44\u6e90", (String)"ServiceFlowFormPlugin_12", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
        }
        return hasMetaVariable && hasMetaResource;
    }

    private boolean hasMetaType(DynamicObject dataEntity, String entryField, String categoryType) {
        boolean hasMetaType = false;
        DynamicObjectCollection resources = dataEntity.getDynamicObjectCollection(entryField);
        for (DynamicObject resource : resources) {
            if (!"isc_metadata_schema".equals(resource.get(categoryType))) continue;
            hasMetaType = true;
            break;
        }
        return hasMetaType;
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        Object iscopy = this.getView().getFormShowParameter().getCustomParam("iscopy");
        if (D.x((Object)iscopy)) {
            DynamicObject dataEntity = this.getModel().getDataEntity(true);
            dataEntity.set("version", (Object)0);
            dataEntity.set("is_released", (Object)Boolean.FALSE);
            dataEntity.set(ENABLE, (Object)0);
            this.getModel().updateCache();
        }
        this.setCategory();
        this.refreshDataSource(VARIABLES2, "var_type", VAR_SOURCE);
        this.refreshDataSource(RESOURCES2, "res_ref", RES_SOURCE_TEXT);
    }

    private void setCategory() {
        Object nodeId = this.getView().getFormShowParameter().getCustomParam("classification_id");
        if (!ObjectUtils.isEmpty((Object)nodeId)) {
            this.getModel().setValue("classification", nodeId);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        AbstractOperate operate = (AbstractOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        if ("service_flow_editor".equals(operateKey)) {
            this.openFlowEditor(args);
        } else if ("save".equals(operateKey)) {
            this.getView().setEnable(Boolean.FALSE, new String[]{INIT_MODE2});
        } else if ("refresh_flow".equals(operateKey)) {
            this.refreshDataSource(VARIABLES2, "var_type", VAR_SOURCE);
            this.refreshDataSource(RESOURCES2, "res_ref", RES_SOURCE_TEXT);
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5237\u65b0\u6210\u529f!", (String)"ServiceFlowFormPlugin_13", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
        }
    }

    private void refreshDataSource(String entryEntity, String type, String dataSourceProperty) {
        DynamicObjectCollection entries = this.getModel().getEntryEntity(entryEntity);
        ChangeData[] changeDataArray = new ChangeData[entries.size()];
        for (int i = 0; i < entries.size(); ++i) {
            DynamicObject entry = ((DynamicObject)entries.get(i)).getDynamicObject(type);
            changeDataArray[i] = new ChangeData(i, this.getModel().getDataEntity(), (Object)entry, (Object)entry);
        }
        for (ChangeData data : changeDataArray) {
            this.resRefChanged(new ChangeData[]{data}, entryEntity, dataSourceProperty);
        }
    }

    private void openFlowEditor(AfterDoOperationEventArgs args) {
        Object id = FormOpener.getSelectedId(this, args);
        if (D.l((Object)id) == 0L) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u4fdd\u5b58\u540e\u518d\u64cd\u4f5c\uff01", (String)"ServiceFlowFormPlugin_14", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
            return;
        }
        if (id != null) {
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("flow", id);
            params.put("ENTITY", "isc_service_flow");
            params.put("editable", Boolean.TRUE);
            FormOpener.showTabForm(this, "isc_service_flow_editor", ResManager.loadKDString((String)"\u6d41\u7a0b\u56fe", (String)"ServiceFlowFormPlugin_15", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), params, null);
        }
    }

    private boolean isIllegalName(String entryEntity, String property, String label) {
        DynamicObjectCollection collection = this.getModel().getEntryEntity(entryEntity);
        for (int seq = 0; seq < collection.size(); ++seq) {
            DynamicObject item = (DynamicObject)collection.get(seq);
            String alias = item.getString(property);
            if (!CommonUtil.isIllegalString((String)alias)) continue;
            String title = RESOURCES2.equals(entryEntity) ? ResManager.loadKDString((String)"\u4f9d\u8d56\u8d44\u6e90", (String)"ServiceFlowFormPlugin_16", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u6d41\u7a0b\u53d8\u91cf", (String)"ServiceFlowFormPlugin_17", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]);
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"%1$s\u7b2c%2$s\u884c%3$s\u547d\u540d\u4e0d\u89c4\u8303\uff0c%4$s\u53ea\u5141\u8bb8\u4ee5\u5b57\u6bcd\u3001\u6570\u5b57\u6216\u4e0b\u5212\u7ebf\u4f5c\u4e3a\u5143\u7d20, \u4e0d\u5141\u8bb8\u4ee5\u6570\u5b57\u5f00\u5934\uff0c\u66f4\u4e0d\u5141\u8bb8\u4f7f\u7528\u5176\u4ed6\u7279\u6b8a\u5b57\u7b26'%5$s'", (String)"ServiceFlowFormPlugin_25", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), title, seq + 1, label, label, alias));
            return true;
        }
        return false;
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        if ("proc_digest".equals(key)) {
            ScriptTextUtil.openDigestScriptForm(this.getModel().getValue(key), this, key, key);
        }
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        String action = event.getActionId();
        if ("proc_digest".equals(action)) {
            ScriptTextUtil.retryScriptFormCallBack(event, this, this.getModel(), action);
        }
    }
}

