/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.formplugin.sf;

import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.OperateOptionPrivate;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.Donothing;
import kd.bos.form.IFormView;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.isc.iscb.formplugin.common.topology.TopologyFormUtil;
import kd.isc.iscb.formplugin.sf.ServiceFlowReleasedListPlugin;
import kd.isc.iscb.formplugin.tools.ScriptDebuggerFormPlugin;
import kd.isc.iscb.formplugin.util.EventLogUtil;
import kd.isc.iscb.formplugin.util.ExportUtil;
import kd.isc.iscb.formplugin.util.FormOpener;
import kd.isc.iscb.formplugin.util.MetaTypeChecker;
import kd.isc.iscb.platform.core.connector.eas.Util;
import kd.isc.iscb.platform.core.sf.Const;
import kd.isc.iscb.platform.core.sf.FlowStarter;
import kd.isc.iscb.platform.core.sf.ServiceFlowEngine;
import kd.isc.iscb.platform.core.sf.ServiceFlowParser;
import kd.isc.iscb.platform.core.sf.ServiceFlowReleaser;
import kd.isc.iscb.platform.core.sf.parser.n.EventStarterParser;
import kd.isc.iscb.platform.core.trace.Caller;
import kd.isc.iscb.platform.core.trace.TraceStack;
import kd.isc.iscb.platform.core.util.ExportAndImportFormUtil;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.flow.core.Flow;
import kd.isc.iscb.util.flow.core.Variable;
import kd.isc.iscb.util.flow.trace.LineCollector;
import kd.isc.iscb.util.misc.StringUtil;
import kd.isc.iscb.util.trace.TraceTask;

public class ServiceFlowListPlugin
extends AbstractListPlugin
implements Const {
    private static final String REFRESH = "refresh";
    private static final String ISC_SERVICE_FLOW2 = "isc_service_flow";
    private static final String MODIFY_FLOW_CATEGORY = "modify_flow_category";

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        if (D.x(customParams.get("autoOpenWizard"))) {
            this.getView().invokeOperation("guide_for_dc");
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        if (args.getOperationResult() == null || !args.getOperationResult().isSuccess()) {
            return;
        }
        try {
            String operateKey = args.getOperateKey();
            if ("service_flow_editor".equals(operateKey)) {
                this.openFlowEditor(args);
            } else if ("start_flow".equals(operateKey)) {
                this.startFlow(args);
            } else if ("export_flow".equals(operateKey)) {
                List pkIds = args.getOperationResult().getSuccessPkIds();
                ExportUtil.exportDts((AbstractFormPlugin)this, pkIds, ISC_SERVICE_FLOW2);
            } else if ("import_flow".equals(operateKey)) {
                this.importFlow();
            } else if ("export_batch".equals(operateKey)) {
                ExportUtil.exportZip((AbstractFormPlugin)this, args, ISC_SERVICE_FLOW2);
            } else if ("view_flow_inst".equals(operateKey)) {
                this.openFlowInstList(args);
            } else if ("diff_comp".equals(operateKey)) {
                this.openDiffComp(args);
            } else if ("view_flow_history".equals(operateKey)) {
                this.openRelesedFlowList(args);
            } else if (MODIFY_FLOW_CATEGORY.equals(operateKey)) {
                FormOpener.showListForSelected((AbstractFormPlugin)this, "isc_schema_category", ResManager.loadKDString((String)"\u6279\u91cf\u5206\u7c7b", (String)"ServiceFlowListPlugin_0", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), new Object[0], Collections.emptyMap(), MODIFY_FLOW_CATEGORY);
            } else if ("new".equals(operateKey)) {
                this.openAddNew();
            } else if ("view_evt_que".equals(operateKey)) {
                EventLogUtil.showEventLogList((AbstractFormPlugin)this, "S", FormOpener.getSelectedId((AbstractFormPlugin)this, args));
            } else if ("show_notice".equals(operateKey)) {
                Object id = FormOpener.getSelectedId((AbstractFormPlugin)this, args);
                if (id != null) {
                    FormOpener.showList((AbstractFormPlugin)this, "isc_flow_notification", new QFilter("flow", "=", id));
                }
            } else if ("topology".equals(operateKey)) {
                this.showTopologyView(args);
            } else if ("view_flow_imp".equals(operateKey)) {
                QFilter filter = new QFilter("res_type", "like", (Object)"%(isc_service_flow)");
                FormOpener.openBillList((AbstractFormPlugin)this, "isc_dts_imp", Collections.singletonList(filter), ResManager.loadKDString((String)"\u8d44\u6e90\u5bfc\u5165\u8bb0\u5f55", (String)"DataCopyListPlugin_11", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
            }
        }
        catch (Exception e) {
            FormOpener.showErrorMessage(this.getView(), e);
        }
    }

    private void showTopologyView(AfterDoOperationEventArgs args) {
        long id = D.l((Object)FormOpener.getSelectedId((AbstractFormPlugin)this, args));
        if (id > 0L) {
            HashMap<String, Object> params = new HashMap<String, Object>(2);
            params.put("type", ISC_SERVICE_FLOW2);
            params.put("id", id);
            FormOpener.showTabForm((AbstractFormPlugin)this, "isc_topology_view", TopologyFormUtil.getName("isc_service_flow," + id), params, "");
        }
    }

    private void openAddNew() {
        Map<String, Object> params = this.getCategory();
        FormOpener.showTabBill((AbstractFormPlugin)this, ISC_SERVICE_FLOW2, ResManager.loadKDString((String)"\u670d\u52a1\u6d41\u7a0b", (String)"ServiceFlowListPlugin_1", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), params, null);
    }

    private Map<String, Object> getCategory() {
        TreeView treeviewap = (TreeView)this.getView().getControl("treeviewap");
        HashMap<String, Object> params = new HashMap<String, Object>(1);
        if (treeviewap == null) {
            params.put("classification_id", 0);
            return params;
        }
        Map focusNode = treeviewap.getTreeState().getFocusNode();
        String id = focusNode == null ? "root" : focusNode.get("id");
        long nodeId = id.equals("root") ? 0L : D.l((Object)id);
        params.put("classification_id", nodeId);
        return params;
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        if ("number".equalsIgnoreCase(args.getHyperLinkClickEvent().getFieldName())) {
            args.setCancel(true);
            Object id = ((BillList)args.getHyperLinkClickEvent().getSource()).getCurrentSelectedRowInfo().getPrimaryKeyValue();
            this.innerOpenFlowEditor(id);
        }
    }

    private void openRelesedFlowList(AfterDoOperationEventArgs args) {
        Object id = FormOpener.getSelectedId((AbstractFormPlugin)this, args);
        if (id != null) {
            QFilter filter = new QFilter("flow", "=", id);
            FormOpener.showList((AbstractFormPlugin)this, "isc_service_flow_r", filter);
        }
    }

    private void openFlowInstList(AfterDoOperationEventArgs args) {
        Object id = FormOpener.getSelectedId((AbstractFormPlugin)this, args);
        if (id != null) {
            DynamicObject object = QueryServiceHelper.queryOne((String)ISC_SERVICE_FLOW2, (String)"init_mode", (QFilter[])new QFilter[]{new QFilter("id", "=", id)});
            if (object != null && "SUB_FLOW".equals(object.getString("init_mode"))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5b50\u6d41\u7a0b\u4e0d\u80fd\u5355\u72ec\u542f\u52a8\uff0c\u65e0\u6cd5\u67e5\u770b\u6d41\u7a0b\u5b9e\u4f8b\u3002", (String)"ServiceFlowListPlugin_2", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
                return;
            }
            QFilter filter = new QFilter("flow.flow", "=", id);
            FormOpener.showList((AbstractFormPlugin)this, "isc_sf_proc_inst", filter);
        }
    }

    private void openDiffComp(AfterDoOperationEventArgs args) {
        long flowId = D.l((Object)FormOpener.getSelectedId((AbstractFormPlugin)this, args));
        if (flowId != 0L) {
            long id = ServiceFlowParser.findReleasedFlowId((long)flowId);
            if (id == 0L) {
                this.getView().showMessage(ResManager.loadKDString((String)"\u670d\u52a1\u6d41\u7a0b\u672a\u53d1\u5e03\uff0c\u4e0d\u80fd\u67e5\u770b\u4e0e\u5df2\u53d1\u5e03\u6d41\u7a0b\u7684\u5dee\u5f02\u3002", (String)"ServiceFlowListPlugin_3", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
                return;
            }
            DynamicObject obj = BusinessDataServiceHelper.loadSingle((Object)flowId, (String)ISC_SERVICE_FLOW2);
            Map define = ServiceFlowReleaser.generateFlowDefine((DynamicObject)obj);
            DynamicObject current = ServiceFlowReleaser.createReleaseFlow((DynamicObject)obj, (Map)define);
            current.set("version", (Object)"-1");
            current.set("creator", obj.get("creator"));
            current.set("modifier", obj.get("modifier"));
            current.set("createtime", null);
            current.set("id", null);
            current.set("modifytime", obj.get("modifytime"));
            DynamicObject last = BusinessDataServiceHelper.loadSingle((Object)id, (String)"isc_service_flow_r");
            ServiceFlowReleasedListPlugin.showDiff((AbstractFormPlugin)this, last, current);
        }
    }

    private void startFlow(AfterDoOperationEventArgs args) {
        Object id = FormOpener.getSelectedId((AbstractFormPlugin)this, args);
        if (id != null) {
            long releasedFlowId = ServiceFlowParser.findReleasedFlowId((long)D.l((Object)id));
            if (releasedFlowId > 0L) {
                OperateOption option = ((Donothing)args.getSource()).getOption();
                String debug = option.getVariableValue("#DEBUG", "");
                Flow flow = ServiceFlowParser.getFlow((long)releasedFlowId);
                FlowStarter starter = ServiceFlowParser.getStarter((Flow)flow);
                if (starter instanceof EventStarterParser.EventStarter) {
                    this.executeEvent(id, (EventStarterParser.EventStarter)starter, debug);
                } else {
                    this.executeManual(flow, debug);
                }
            } else {
                throw new IllegalArgumentException(ResManager.loadKDString((String)"\u6240\u9009\u6d41\u7a0b\u672a\u53d1\u5e03\uff01", (String)"ServiceFlowListPlugin_4", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
            }
        }
    }

    private void executeEvent(Object flowId, EventStarterParser.EventStarter starter, String debug) {
        DynamicObject meta = starter.getMeta();
        Map nodeInfo = starter.getNodeInfo();
        MetaTypeChecker.checkMetaType(meta);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("meta", meta.getPkValue());
        params.put("node", nodeInfo);
        params.put("flow_id", flowId);
        params.put("#DEBUG", debug);
        FormOpener.showForm((AbstractFormPlugin)this, "isc_sf_event_param", ResManager.loadKDString((String)"\u4e8b\u4ef6\u89e6\u53d1\u8865\u507f", (String)"ServiceFlowListPlugin_5", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), params, "execute_event");
    }

    private void executeManual(Flow flow, final String debug) {
        List variables = flow.getInputVariables();
        if (!variables.isEmpty()) {
            this.setManualParams(flow, variables, debug);
        } else {
            final long flowId = Long.parseLong(flow.getId());
            TraceStack.trace((Caller)Caller.Front, (TraceTask)new TraceTask(){

                public void run() {
                    HashMap<String, String> properties = new HashMap<String, String>();
                    properties.put("#DEBUG", debug);
                    ServiceFlowEngine.createAndStart((long)flowId, (Object[])new Object[0], new HashMap(), properties);
                }
            });
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u6d41\u7a0b\u5df2\u89e6\u53d1\uff01", (String)"ServiceFlowListPlugin_6", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
        }
    }

    private void setManualParams(Flow flow, List<? extends Variable> variables, String debug) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        long flowId = Long.parseLong(flow.getId());
        params.put("flow_id", flowId);
        params.put("#DEBUG", debug);
        ArrayList<HashMap<String, Object>> list = new ArrayList<HashMap<String, Object>>(variables.size());
        for (Variable variable : variables) {
            HashMap<String, Object> m = new HashMap<String, Object>();
            m.put("name", variable.getName());
            this.setVarType(m, variable);
            m.put("init_value", variable.getInitValue());
            m.put("var_desc", variable.getTitle());
            list.add(m);
        }
        params.put("params", list);
        FormOpener.showForm((AbstractFormPlugin)this, "isc_sf_manual_params", ResManager.loadKDString((String)"\u8bbe\u7f6e\u53c2\u6570\u503c", (String)"ServiceFlowListPlugin_7", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), params, "get_params");
    }

    private void setVarType(Map<String, Object> m, Variable var) {
        Object define = var.getAttribute("define");
        if (define instanceof Map) {
            String category = D.s(((Map)define).get("category")).toLowerCase();
            m.put("class_type", category);
            m.put("type", D.s(((Map)define).get("type")));
            m.put("category", category);
            m.put("is_array", ((Map)define).get("is_array"));
        }
    }

    private void exportBatch(AfterDoOperationEventArgs evt) {
        List pkIds = evt.getOperationResult().getSuccessPkIds();
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("data", StringUtil.join((Collection)pkIds, (String)","));
        params.put("entity", ISC_SERVICE_FLOW2);
        FormOpener.showForm((AbstractFormPlugin)this, "isc_export_progress", ResManager.loadKDString((String)"\u5bfc\u51fazip\u5305", (String)"ServiceFlowListPlugin_8", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), params, null);
    }

    private void exportFlow(AfterDoOperationEventArgs args) {
        List pkIds = args.getOperationResult().getSuccessPkIds();
        DynamicObject[] dObjects = BusinessDataServiceHelper.load((Object[])pkIds.toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)ISC_SERVICE_FLOW2));
        ExportAndImportFormUtil.export((IFormView)this.getView(), (DynamicObject[])dObjects);
    }

    private void importFlow() {
        FormOpener.openImportForm((IFormPlugin)this, this.getView(), ISC_SERVICE_FLOW2);
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        super.closedCallBack(evt);
        String action = evt.getActionId();
        Object data = evt.getReturnData();
        if ("get_params".equals(action)) {
            this.parseAndStartFlow(data);
        } else if (MODIFY_FLOW_CATEGORY.equals(action)) {
            this.classifyFlows(data);
        } else if ("importschema".equals(action)) {
            this.getView().invokeOperation(REFRESH);
        } else if ("execute_event".equals(action) && "success".equals(data)) {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5df2\u7ecf\u63d0\u4ea4\u6d41\u7a0b\u6267\u884c!", (String)"ServiceFlowListPlugin_9", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
        } else if (StringUtils.equals((CharSequence)evt.getActionId(), (CharSequence)"iscExportTaskCloseCallBack")) {
            ExportUtil.iscExportTaskCallBack((AbstractFormPlugin)this, evt.getReturnData());
        }
    }

    private void parseAndStartFlow(Object returnData) {
        if (returnData instanceof Map) {
            final Map map = (Map)returnData;
            final long flowId = D.l(map.get("flow_id"));
            final List values = (List)map.get("values");
            try {
                TraceStack.trace((Caller)Caller.Front, (TraceTask)new TraceTask(){

                    public void run() {
                        HashMap properties = new HashMap();
                        properties.put("#DEBUG", map.get("#DEBUG"));
                        ServiceFlowEngine.createAndStart((long)flowId, (Object[])values.toArray(), new HashMap(), properties);
                    }
                });
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5df2\u7ecf\u63d0\u4ea4\u6d41\u7a0b\u6267\u884c!", (String)"ServiceFlowListPlugin_9", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
            }
            catch (Exception e) {
                FormOpener.showErrorMessage(this.getView(), e);
            }
        }
    }

    private void classifyFlows(Object result) {
        if (result instanceof ListSelectedRowCollection) {
            try {
                ListSelectedRowCollection listSelectedRowCollection = (ListSelectedRowCollection)result;
                if (!listSelectedRowCollection.isEmpty()) {
                    this.modifyFlowCategory(listSelectedRowCollection.get(0).getPrimaryKeyValue());
                    this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u6279\u91cf\u4fee\u6539\u670d\u52a1\u6d41\u7a0b\u5206\u7c7b\u6210\u529f\uff01", (String)"ServiceFlowListPlugin_10", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), Integer.valueOf(2500));
                    this.getView().invokeOperation(REFRESH);
                }
            }
            catch (Exception e) {
                FormOpener.showErrorMessage(this.getView(), e);
            }
        }
    }

    private void modifyFlowCategory(Object categoryPk) {
        ListSelectedRowCollection selectedFlowRows = this.getSelectedRows();
        for (ListSelectedRow selectedRow : selectedFlowRows) {
            Object flowPk = selectedRow.getPrimaryKeyValue();
            DynamicObject flow = BusinessDataServiceHelper.loadSingle((Object)flowPk, (String)ISC_SERVICE_FLOW2);
            if (null != flow && null != flow.getDataEntityType().getProperties().get((Object)"classification")) {
                if (flow.get("classification_id").equals(categoryPk)) continue;
                flow.set("classification", categoryPk);
                flow.set("modifier", (Object)RequestContext.get().getUserId());
                flow.set("modifytime", (Object)Timestamp.valueOf(LocalDateTime.now()));
                Util.save((DynamicObject)flow);
                continue;
            }
            this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u68c0\u67e5\u670d\u52a1\u6d41\u7a0b\u662f\u5426\u88ab\u5220\u9664\uff0c\u5e76\u4fee\u6539\u670d\u52a1\u6d41\u7a0b\u6dfb\u52a0\u5206\u7c7b\uff01\u82e5\u65e0\u6cd5\u4fee\u6539\uff0c\u8bf7\u66f4\u65b0\u5143\u6570\u636e!", (String)"ServiceFlowListPlugin_11", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        try {
            if (args.getSource() instanceof AbstractOperate) {
                AbstractOperate operate = (AbstractOperate)args.getSource();
                String operateKey = operate.getOperateKey();
                ListSelectedRowCollection collection = args.getListSelectedData();
                if ("release".equals(operateKey) && collection.size() > 0) {
                    operate.getOption().setVariableValue("batchop_batchsize", "1");
                } else if (!operateKey.equals("export_flow") && !operateKey.equals("export_batch") || collection.size() <= 100) {
                    if (operateKey.equals("enable")) {
                        Function<Long, Boolean> enableDefine = ServiceFlowReleaser::enableDefine;
                        String tip = this.changeState(collection, enableDefine);
                        if (tip.length() > 0) {
                            FormOpener.showErrorMessage(this.getView(), ResManager.loadKDString((String)"\u4ee5\u4e0b\u670d\u52a1\u6d41\u7a0b\u542f\u7528\u5931\u8d25", (String)"ServiceFlowListPlugin_13", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), tip);
                        }
                        if (collection.isEmpty()) {
                            args.setCancel(true);
                        }
                    } else if (operateKey.equals("disable")) {
                        Function<Long, Boolean> disableDefine = ServiceFlowReleaser::disableDefine;
                        String tip = this.changeState(collection, disableDefine);
                        if (tip.length() > 0) {
                            FormOpener.showErrorMessage(this.getView(), ResManager.loadKDString((String)"\u4ee5\u4e0b\u670d\u52a1\u6d41\u7a0b\u7981\u7528\u5931\u8d25", (String)"ServiceFlowListPlugin_14", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), tip);
                        }
                        if (collection.isEmpty()) {
                            args.setCancel(true);
                        }
                    } else if (operateKey.equals("guide_for_dc")) {
                        Map<String, Object> params = this.getCategory();
                        if (args.isCancel()) {
                            return;
                        }
                        FormOpener.showForm((AbstractFormPlugin)this, "isc_sf_guide_by_dc", null, params, null);
                    } else if ("view".equals(operateKey) && collection.size() > 1) {
                        args.setCancel(true);
                        this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u884c!", (String)"ServiceFlowListPlugin_15", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
                    }
                }
            }
        }
        catch (Exception e) {
            FormOpener.showErrorMessage(this.getView(), e);
            args.setCancel(true);
        }
    }

    private String changeState(ListSelectedRowCollection collection, Function<Long, Boolean> changeState) {
        StringBuilder sb = new StringBuilder();
        Iterator it = collection.iterator();
        while (it.hasNext()) {
            ListSelectedRow row = (ListSelectedRow)it.next();
            try {
                changeState.apply(D.l((Object)row.getPrimaryKeyValue()));
            }
            catch (Exception e) {
                DynamicObject flow = BusinessDataServiceHelper.loadSingle((Object)row.getPrimaryKeyValue(), (String)ISC_SERVICE_FLOW2, (String)"id,name,number");
                sb.append(flow.get("name")).append("(number = ").append(flow.get("number")).append("):").append(e.getMessage()).append("\r\n");
                it.remove();
            }
        }
        return sb.toString();
    }

    private void openFlowEditor(AfterDoOperationEventArgs args) {
        Object id = FormOpener.getSelectedId((AbstractFormPlugin)this, args);
        this.innerOpenFlowEditor(id);
    }

    private void innerOpenFlowEditor(Object id) {
        if (id != null) {
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("flow", id);
            params.put("ENTITY", ISC_SERVICE_FLOW2);
            params.put("editable", Boolean.TRUE);
            FormOpener.showTabForm((AbstractFormPlugin)this, "isc_service_flow_editor", ResManager.loadKDString((String)"\u6d41\u7a0b\u56fe", (String)"ServiceFlowListPlugin_16", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), params, null);
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        super.addItemClickListeners(new String[]{"debug_flow"});
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        if ("node_debug".equals(evt.getItemKey())) {
            this.startFlowDebugger(LineCollector.NODE_LINE);
        } else if ("command_debug".equals(evt.getItemKey())) {
            this.startFlowDebugger(LineCollector.COMMAND_LINE);
        }
    }

    private void startFlowDebugger(LineCollector mode) {
        if (ScriptDebuggerFormPlugin.enableDebug((AbstractFormPlugin)this)) {
            FormOpener.showAppIdTabForm((AbstractFormPlugin)this, "isc_script_debugger", ResManager.loadKDString((String)"\u6d41\u7a0b\u8c03\u8bd5", (String)"ServiceFlowListPlugin_17", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), new HashMap<String, Object>());
            OperateOptionPrivate option = new OperateOptionPrivate();
            option.setVariableValue("#DEBUG", mode.name());
            this.getView().invokeOperation("start_flow", (OperateOption)option);
        }
    }
}

