/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.formplugin.sf;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.isc.iscb.formplugin.sf.ProcessTraceUtil;
import kd.isc.iscb.formplugin.util.FormOpener;
import kd.isc.iscb.platform.core.sf.runtime.ProcessRuntime;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.flow.core.Execution;
import kd.isc.iscb.util.flow.core.FlowRuntime;
import kd.isc.iscb.util.flow.core.Node;
import kd.isc.iscb.util.flow.core.Transition;
import kd.isc.iscb.util.flow.core.i.model.NodeImpl;
import kd.isc.iscb.util.flow.core.i.model.TransitionImpl;

public class SfJumpFormPlugin
extends AbstractFormPlugin {
    private static final String SRC_ACT = "src_act";
    private static final String TAR_NODES = "tar_nodes";

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        Map params = this.getView().getFormShowParameter().getCustomParams();
        List actList = (List)params.get("act_list");
        this.initSrcActCombo(actList);
        this.setDefaultVal(actList);
    }

    private void setDefaultVal(List<Map<String, Object>> actList) {
        Map<String, Object> defaultItem = actList.get(0);
        String actId = D.s((Object)defaultItem.get("id"));
        this.getModel().setValue(SRC_ACT, (Object)actId);
        this.initTarNodeCombo(actId);
    }

    private void initSrcActCombo(List<Map<String, Object>> actList) {
        ComboEdit srcCombo = (ComboEdit)this.getView().getControl(SRC_ACT);
        ArrayList<ComboItem> items = new ArrayList<ComboItem>(actList.size());
        for (Map<String, Object> act : actList) {
            ComboItem item = new ComboItem();
            item.setCaption(new LocaleString(D.s((Object)act.get("title"))));
            item.setValue(D.s((Object)act.get("id")));
            items.add(item);
        }
        srcCombo.setComboItems(items);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String name = e.getProperty().getName();
        if (name.equals(SRC_ACT)) {
            String srcActId = D.s((Object)this.getModel().getValue(SRC_ACT));
            this.initTarNodeCombo(srcActId);
        }
    }

    private void initTarNodeCombo(String srcActId) {
        if (srcActId != null) {
            Map params = this.getView().getFormShowParameter().getCustomParams();
            FlowRuntime flowRuntime = ProcessRuntime.loadRuntime((long)D.l(params.get("proc_inst_id")));
            Execution srcAct = flowRuntime.getExecution(srcActId);
            List outGoing = ((NodeImpl)srcAct.getDefine()).getOutGoing();
            List<Node> targetNodes = this.getNextNodes(outGoing);
            if (targetNodes.size() > 0) {
                this.initTarNodeCombo(targetNodes);
            } else {
                this.getView().showMessage(ResManager.loadKDString((String)"\u6ca1\u6709\u627e\u5230\u80fd\u8fdb\u884c\u8df3\u8f6c\u7684\u540e\u7ee7\u8282\u70b9", (String)"SfJumpFormPlugin_0", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
            }
        } else {
            this.getModel().setValue(TAR_NODES, null);
        }
    }

    private void initTarNodeCombo(List<Node> targetNodes) {
        ComboEdit tarCombo = (ComboEdit)this.getView().getControl(TAR_NODES);
        ArrayList<ComboItem> items = new ArrayList<ComboItem>(targetNodes.size());
        for (Node node : targetNodes) {
            ComboItem item = new ComboItem();
            item.setCaption(new LocaleString(node.getTitle()));
            item.setValue(node.getId());
            items.add(item);
        }
        tarCombo.setComboItems(items);
    }

    private List<Node> getNextNodes(List<TransitionImpl> outGoing) {
        ArrayList<Node> targetNodes = new ArrayList<Node>(outGoing.size());
        for (TransitionImpl transition : outGoing) {
            if (Transition.Type.NORMAL != transition.getType()) continue;
            targetNodes.add((Node)transition.getTarget());
        }
        return targetNodes;
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        if (args.getOperationResult() == null || !args.getOperationResult().isSuccess()) {
            return;
        }
        String operateKey = args.getOperateKey();
        if ("jump".equals(operateKey)) {
            this.showConfirm(ResManager.loadKDString((String)"\u82e5\u5f53\u524d\u5931\u8d25\u8282\u70b9\u4e2d\u5b58\u5728\u53d8\u91cf\u8d4b\u503c\u64cd\u4f5c\uff0c\u5728\u8df3\u8f6c\u524d\u8bf7\u5148\u7ed9\u53d8\u91cf\u8d4b\u4e0a\u6b63\u786e\u7684\u503c\u4f9b\u540e\u7eed\u8282\u70b9\u4f7f\u7528\uff0c\u4ee5\u514d\u4ea7\u751f\u4e0d\u826f\u5f71\u54cd\u3002", (String)"SfJumpFormPlugin_1", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent evt) {
        if (evt.getResult() != MessageBoxResult.Yes) {
            return;
        }
        try {
            String callback = evt.getCallBackId();
            if ("jumpNode".equals(callback)) {
                this.jump();
            }
        }
        catch (Exception e) {
            FormOpener.showErrorMessage(this.getView(), e);
        }
    }

    private void jump() {
        Map params = this.getView().getFormShowParameter().getCustomParams();
        long procInstId = D.l(params.get("proc_inst_id"));
        String srcActId = D.s((Object)this.getModel().getValue(SRC_ACT));
        List<String> tarNodeIds = this.getTarNodeIdList();
        List<Map<String, List<String>>> jumpList = this.makeJumpList(srcActId, tarNodeIds);
        if (srcActId != null && jumpList.size() > 0) {
            ProcessTraceUtil.jump(procInstId, jumpList);
            this.getView().getParentView().showSuccessNotification(ResManager.loadKDString((String)"\u8df3\u8f6c\u6210\u529f,\u8bf7\u7a0d\u540e\u5237\u65b0\u6d41\u7a0b\u56fe", (String)"SfJumpFormPlugin_2", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
            this.getView().close();
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u8df3\u8f6c\u7684\u8282\u70b9", (String)"SfJumpFormPlugin_3", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
        }
    }

    private List<Map<String, List<String>>> makeJumpList(String srcActId, List<String> tarNodeIds) {
        ArrayList<Map<String, List<String>>> jumpList = new ArrayList<Map<String, List<String>>>();
        HashMap<String, List<String>> jumpItem = new HashMap<String, List<String>>();
        jumpItem.put(srcActId, tarNodeIds);
        jumpList.add(jumpItem);
        return jumpList;
    }

    private List<String> getTarNodeIdList() {
        String tarNodeIdStr = D.s((Object)this.getModel().getValue(TAR_NODES));
        String[] split = tarNodeIdStr.split(",");
        ArrayList<String> tarNodeIds = new ArrayList<String>(split.length);
        for (String s : split) {
            String tarNodeId = D.s((Object)s);
            if (tarNodeId == null) continue;
            tarNodeIds.add(tarNodeId);
        }
        return tarNodeIds;
    }

    private void showConfirm(String tips) {
        ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("jumpNode", (IFormPlugin)this);
        this.getView().showConfirm(tips, MessageBoxOptions.OKCancel, confirmCallBacks);
    }
}

