/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.formplugin.sf;

import java.sql.Timestamp;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.bill.OperationStatus;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.control.Control;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.isc.iscb.formplugin.util.ArtificialF7Util;
import kd.isc.iscb.formplugin.util.FormOpener;
import kd.isc.iscb.platform.core.dc.DataCopyTaskUtil;
import kd.isc.iscb.platform.core.sf.Const;
import kd.isc.iscb.platform.core.util.TimerJobUtil;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.script.feature.tool.date.TimeSpan;

public class TimerStarterNodeEditorFormPlugin
extends AbstractFormPlugin
implements Const {
    private static final String CRON_EXPR2 = "cron_expr";
    private static final String BOS_USER = "bos_user";
    private static final String USER_SELECT = "user_select";

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        Map params = this.getView().getFormShowParameter().getCustomParams();
        this.getModel().setValue("title", params.get("title"));
        this.getModel().setValue("start_time", (Object)D.t(params.get("start_time")));
        this.getModel().setValue("end_time", (Object)D.t(params.get("end_time")));
        this.getModel().setValue(CRON_EXPR2, params.get(CRON_EXPR2));
        this.getModel().setValue("interval", params.get("interval"));
        this.getModel().setValue("exe_job_user", params.get("exe_job_user"));
        this.getView().setEnable(Boolean.valueOf("0".equals(params.get("interval"))), new String[]{CRON_EXPR2});
        if (params.get("editable") != null && !((Boolean)params.get("editable")).booleanValue()) {
            this.getView().setStatus(OperationStatus.VIEW);
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btnok", "exe_job_user", CRON_EXPR2});
    }

    public void afterDoOperation(AfterDoOperationEventArgs evt) {
        super.afterDoOperation(evt);
        if (evt.getOperationResult() != null && evt.getOperationResult().isSuccess() && evt.getOperateKey().equals("btnok")) {
            Map params = this.getView().getFormShowParameter().getCustomParams();
            IDataModel model = this.getModel();
            params.put("title", model.getValue("title"));
            params.put("start_time", model.getValue("start_time"));
            params.put("end_time", model.getValue("end_time"));
            params.put(CRON_EXPR2, model.getValue(CRON_EXPR2));
            params.put("interval", model.getValue("interval"));
            params.put("exe_job_user", model.getValue("exe_job_user"));
            this.getView().returnDataToParent((Object)params);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        if ("interval".equals(name)) {
            String interval = (String)e.getChangeSet()[0].getNewValue();
            if (!"0".equals(interval)) {
                this.getModel().setValue(CRON_EXPR2, (Object)this.getCorn(interval));
            }
            this.getView().setEnable(Boolean.valueOf("0".equals(interval)), new String[]{CRON_EXPR2});
        }
    }

    private String getCorn(String interval) {
        Date start = (Date)this.getModel().getValue("start_time");
        if (start == null) {
            start = new Timestamp(System.currentTimeMillis() - 86400000L);
        }
        TimeSpan timeSpan = DataCopyTaskUtil.getTimeSpan((long)start.getTime());
        return DataCopyTaskUtil.buildCron((String)interval, (TimeSpan)timeSpan);
    }

    public void click(EventObject evt) {
        String operationKey = ((Control)evt.getSource()).getKey();
        if ("exe_job_user".equals(operationKey)) {
            this.showPersonForm();
        } else if (CRON_EXPR2.equals(operationKey)) {
            this.showCronForm();
        }
    }

    private void showCronForm() {
        HashMap<String, Object> params = new HashMap<String, Object>(1);
        params.put(CRON_EXPR2, this.getModel().getValue(CRON_EXPR2));
        params.put("end_time", D.t((Object)this.getModel().getValue("end_time")));
        params.put("start_time", D.t((Object)this.getModel().getValue("start_time")));
        FormOpener.showForm(this, "isc_cron_expression", "", params, CRON_EXPR2);
    }

    private void showPersonForm() {
        ListShowParameter parameter = ShowFormHelper.createShowListForm((String)BOS_USER, (boolean)false, (int)0);
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, USER_SELECT));
        String user = (String)this.getModel().getValue("exe_job_user");
        parameter.setSelectedRow((Object)TimerJobUtil.getUserIdByNumber((String)user));
        this.getView().showForm((FormShowParameter)parameter);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String actionId = closedCallBackEvent.getActionId();
        if (USER_SELECT.equalsIgnoreCase(actionId)) {
            ListSelectedRowCollection lsrc = (ListSelectedRowCollection)closedCallBackEvent.getReturnData();
            ArtificialF7Util.setValue(this.getView(), lsrc, "exe_job_user");
        } else if (CRON_EXPR2.equals(actionId)) {
            Object returnData = closedCallBackEvent.getReturnData();
            if (returnData == null) {
                return;
            }
            this.getModel().setValue(CRON_EXPR2, ((Map)returnData).get(CRON_EXPR2));
        }
    }
}

