/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.formplugin.sf;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.ext.form.control.CustomControl;
import kd.bos.form.control.CodeEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.isc.iscb.formplugin.util.FormOpener;
import kd.isc.iscb.platform.core.sf.Const;
import kd.isc.iscb.platform.core.sf.ServiceFlowReleaser;
import kd.isc.iscb.platform.core.sf.parser.NodeCategory;
import kd.isc.iscb.platform.core.sf.parser.TransitionCategory;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.except.IscBizException;
import kd.isc.iscb.util.misc.Json;
import kd.isc.iscb.util.misc.StringUtil;

public class Util
implements Const {
    public static final String META_JS = "meta.js";
    private static final DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("isc.sf");
    private static Log logger = LogFactory.getLog(Util.class);

    static void openEditor(AbstractFormPlugin form, String event, Map<String, Object> params, boolean editable) {
        String type = (String)params.get("type");
        Object id = params.get("id");
        Map<String, Object> define = Util.getDefineFromCache(form);
        Object flow = form.getView().getFormShowParameter().getCustomParam("flow");
        Object released_id = form.getView().getFormShowParameter().getCustomParam("released_id");
        if (type.endsWith("Transition")) {
            String editor = TransitionCategory.valueOf((String)type).getEditorForm();
            FormOpener.showForm(form, editor, ResManager.loadKDString((String)"\u8f6c\u79fb\u914d\u7f6e", (String)"Util_16", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), Util.wrap(Util.findLink(define, id), editable, flow, released_id), event, false);
        } else {
            String editor = NodeCategory.valueOf((String)type).getEditorForm();
            Map<String, Object> wrap = Util.wrap(Util.findNode(define, id), editable, flow, released_id);
            Util.subFlowWrap(form, wrap);
            Util.loopBlockWrap(form, wrap);
            FormOpener.showForm(form, editor, ResManager.loadKDString((String)"\u8282\u70b9\u914d\u7f6e", (String)"Util_17", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), wrap, event, false);
        }
    }

    private static void loopBlockWrap(AbstractFormPlugin form, Map<String, Object> wrap) {
        Map params = form.getView().getFormShowParameter().getCustomParams();
        if ("LoopBlock".equals(params.get("type"))) {
            wrap.put("is_loop_block", "LoopBlock".equals(params.get("type")));
            wrap.put("loop_block_id", params.get("id"));
        }
    }

    private static void subFlowWrap(AbstractFormPlugin form, Map<String, Object> wrap) {
        wrap.put("proc_inst_id", form.getView().getFormShowParameter().getCustomParam("proc_inst_id"));
        wrap.put("is_sub_flow", form.getView().getFormShowParameter().getCustomParam("is_sub_flow"));
        wrap.put("sub_id", form.getView().getFormShowParameter().getCustomParam("sub_id"));
    }

    static void openBlock(AbstractFormPlugin form, Map<String, Object> params, String event, boolean editable) {
        Map<String, Object> define = Util.getDefineFromCache(form);
        Map nodes = (Map)define.get("nodes");
        Object id = params.get("id");
        Map node = (Map)nodes.get(id);
        node.put("editable", editable);
        Util.setMetaJs(form, node);
        Object released_id = form.getView().getFormShowParameter().getCustomParam("released_id");
        node.put("released_id", released_id);
        if (!editable) {
            node.put("acts", form.getView().getFormShowParameter().getCustomParam("acts"));
            node.put("trans", form.getView().getFormShowParameter().getCustomParam("trans"));
            node.put("proc_inst_id", form.getView().getFormShowParameter().getCustomParam("proc_inst_id"));
        }
        FormOpener.showForm(form, "isc_sf_block_editor", ResManager.loadKDString((String)"\u8282\u70b9\u5757\u914d\u7f6e", (String)"Util_18", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), node, event, false);
    }

    private static void setMetaJs(AbstractFormPlugin form, Map<String, Object> node) {
        if (!D.x((Object)form.getView().getFormShowParameter().getCustomParam("editable"))) {
            node.put(META_JS, META_JS);
        } else {
            node.put("flow", form.getView().getFormShowParameter().getCustomParam("flow"));
            String type = D.s((Object)node.get("type"));
            String js = "LoopBlock".equals(type) ? "loopBlockMeta.js" : "blockMeta.js";
            node.put(META_JS, js);
        }
    }

    static Map<String, Object> getDefineFromCache(AbstractFormPlugin form) {
        return (Map)Json.toObject((String)Util.getDefineStringFromCache(form));
    }

    static void setEditorData(AbstractFormPlugin form, Map<String, Object> define, boolean editable) {
        Util.repairDamage(form, define);
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("editable", editable);
        data.put("define", define);
        Map params = form.getView().getFormShowParameter().getCustomParams();
        Object acts = params.get("acts");
        data.put("acts", acts != null ? acts : Collections.EMPTY_MAP);
        Object trans = params.get("trans");
        data.put("trans", trans != null ? trans : Collections.EMPTY_MAP);
        data.put(META_JS, params.get(META_JS) == null ? META_JS : params.get(META_JS));
        data.put("flow.js", "flow.js");
        ((CustomControl)form.getControl("editor")).setData(data);
    }

    private static void repairDamage(AbstractFormPlugin form, Map<String, Object> define) {
        Map links = (Map)define.get("links");
        Map nodes = (Map)define.get("nodes");
        int damagedLinks = 0;
        Iterator it = links.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry e = it.next();
            Map link = (Map)e.getValue();
            if (nodes.containsKey(link.get("target")) && nodes.containsKey(link.get("source"))) continue;
            ++damagedLinks;
            it.remove();
        }
        if (damagedLinks > 0) {
            form.getView().showMessage(String.format(ResManager.loadKDString((String)"\u6d41\u7a0b\u56fe\u5185\u5bb9\u88ab\u635f\u574f\uff0c\u5176\u4e2d\u6709%s\u6839\u8fde\u7ebf\u56e0\u4e3a\u6e90\u8282\u70b9\u6216\u76ee\u6807\u8282\u70b9\u4e0d\u5b58\u5728\u5df2\u6392\u9664\uff0c\u8bf7\u4ed4\u7ec6\u68c0\u67e5\u6d41\u7a0b\u56fe\u5e76\u4fee\u590d\u3002", (String)"Util_31", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), damagedLinks));
        }
    }

    private static Map<String, Object> wrap(Map<String, Object> element, boolean editable, Object flow, Object released_id) {
        element.put("flow", flow);
        element.put("editable", editable);
        element.put("released_id", released_id);
        return element;
    }

    static Map<String, Object> findLink(Map<String, Object> define, Object id) {
        Map line = (Map)((Map)define.get("links")).get(id);
        return line;
    }

    static Map<String, Object> findNode(Map<String, Object> define, Object id) {
        Map nodes = (Map)define.get("nodes");
        Map node = (Map)nodes.get(id);
        return node;
    }

    public static void openProcessDiagram(AbstractFormPlugin form, long procInstId, String tag) {
        DynamicObject proc = BusinessDataServiceHelper.loadSingle((Object)procInstId, (String)"isc_sf_proc_inst", (String)"flow,context_tag");
        Map diagram = ServiceFlowReleaser.getDiagramJson((long)D.l((Object)proc.get("flow_id")));
        HashMap<String, Object> params = new HashMap<String, Object>(7);
        params.put("diagram", diagram);
        params.put("released_id", proc.get("flow_id"));
        params.put("proc_inst_id", procInstId);
        params.put("$tag", tag);
        DynamicObject flow = proc.getDynamicObject("flow");
        params.put("name", flow.getString("name"));
        params.put("number", flow.getString("number"));
        params.put("version", flow.getString("version"));
        Util.setStates(proc, params);
        FormOpener.showTabForm(form, "isc_service_flow_editor", ResManager.loadKDString((String)"\u670d\u52a1\u6d41\u7a0b\u76d1\u63a7", (String)"Util_21", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), params, null);
    }

    public static void openFlowDiagram(AbstractFormPlugin form, long flowId, String tag) {
        Map diagram = ServiceFlowReleaser.getDiagramJson((long)flowId);
        HashMap<String, Object> params = new HashMap<String, Object>(5);
        params.put("diagram", diagram);
        params.put("$tag", tag);
        DynamicObject flowReleased = BusinessDataServiceHelper.loadSingle((Object)flowId, (String)"isc_service_flow_r");
        DynamicObject flow = QueryServiceHelper.queryOne((String)"isc_service_flow", (String)"number,name", (QFilter[])new QFilter[]{new QFilter("id", "=", flowReleased.get("flow"))});
        params.put("version", flowReleased.get("version"));
        params.put("name", flow.getString("name"));
        params.put("number", flow.getString("number"));
        params.put("released_id", flowId);
        FormOpener.showTabForm(form, "isc_service_flow_editor", ResManager.loadKDString((String)"\u6d41\u7a0b\u56fe\uff08\u5df2\u53d1\u5e03\uff09", (String)"Util_22", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), params, null);
    }

    public static void setStates(DynamicObject proc, Map<String, Object> params) {
        Map runtime = (Map)Json.toObject((String)((String)proc.get("context_tag")));
        Collection properties = (Collection)runtime.get("properties");
        if (properties != null) {
            Util.setParamMap(params, properties);
        }
    }

    private static void setParamMap(Map<String, Object> params, Collection<Map<?, ?>> properties) {
        for (Map<?, ?> o : properties) {
            String key = (String)o.get("key");
            if (!key.startsWith("acts") && !key.startsWith("trans") && !key.startsWith("subflows")) continue;
            params.put(key, o.get("value"));
        }
    }

    static String putScript(Map<String, Object> params, String field, AbstractFormPlugin plugin) {
        CodeEdit editor = (CodeEdit)plugin.getView().getControl(field);
        String script = editor.getText();
        if (script != null) {
            params.put(field, script);
        } else {
            script = D.s((Object)params.get(field));
        }
        return script;
    }

    public static String getVarOrResName(String desc, String name) {
        return StringUtil.isEmpty((String)desc) ? name : desc + "(" + name + ")";
    }

    static String getDefineStringFromCache(AbstractFormPlugin form) {
        String s = (String)cache.get(form.getView().getPageId() + "/sf");
        if (s != null) {
            return s;
        }
        throw new IscBizException(ResManager.loadKDString((String)"\u975e\u5e38\u62b1\u6b49\uff0c\u6d41\u7a0b\u56fe\u7f13\u5b58\u56e0\u4e3a\u4e0d\u660e\u539f\u56e0\u5931\u6548\uff0c\u8bf7\u5173\u95ed\u6d41\u7a0b\u56fe\u91cd\u65b0\u914d\u7f6e\u3002", (String)"Util_23", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
    }

    static boolean saveDefineToCache(AbstractFormPlugin form, Map<String, Object> define) {
        try {
            cache.put(form.getView().getPageId() + "/sf", (Object)Json.toString(define));
            return true;
        }
        catch (Exception e) {
            logger.warn("\u5206\u5e03\u5f0f\u7f13\u5b58\u5f02\u5e38\uff0c\u4e0d\u80fd\u4f7f\u7528\u6d41\u7a0b\u56fe\u529f\u80fd", (Throwable)e);
            return false;
        }
    }

    static void removeDefineFromCache(AbstractFormPlugin form) {
        try {
            cache.remove(form.getView().getPageId() + "/sf");
        }
        catch (Exception e) {
            logger.warn("\u5206\u5e03\u5f0f\u7f13\u5b58\u5f02\u5e38\uff0c\u4e0d\u80fd\u4f7f\u7528\u6d41\u7a0b\u56fe\u529f\u80fd", (Throwable)e);
        }
    }

    public static String getDefineStringFromCache(String pageId) {
        return (String)cache.get(pageId + "/sf");
    }
}

