/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.formplugin.sf.rpa;

import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.CellClickEvent;
import kd.bos.form.control.events.CellClickListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.isc.iscb.util.misc.StringUtil;

public class RPARobotFormPlugin
extends AbstractFormPlugin
implements CellClickListener {
    private static final String ENTRY_ENTITY = "entryentity";
    private static final String RPA_FLOW_ID = "rpa_flow_id";
    private static final Log LOG = LogFactory.getLog(RPARobotFormPlugin.class);

    public void registerListener(EventObject e) {
        super.registerListener(e);
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl(ENTRY_ENTITY);
        entryGrid.addCellClickListener((CellClickListener)this);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.initEntry();
    }

    private void initEntry() {
        try {
            String processId = (String)this.getView().getFormShowParameter().getCustomParam(RPA_FLOW_ID);
            List robotList = (List)DispatchServiceHelper.invokeBizService((String)"rpac", (String)"rpacp", (String)"RpaService", (String)"getRobotList", (Object[])new Object[]{processId});
            this.initEntryByList(robotList);
        }
        catch (Exception e) {
            LOG.warn("\u8c03\u7528RPA\u5fae\u670d\u52a1\u5931\u8d25, \u539f\u56e0\uff1a" + StringUtil.getCascadeMessage((Throwable)e), (Throwable)e);
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u8c03\u7528RPA\u5fae\u670d\u52a1\u83b7\u53d6\u673a\u5668\u4eba\u5217\u8868\u5931\u8d25\uff0c\u539f\u56e0\u662f\uff1a%s", (String)"RPARobotFormPlugin_1", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), StringUtil.getCascadeMessage((Throwable)e)));
        }
    }

    private void initEntryByList(List<Map<String, Object>> dcList) {
        this.getModel().deleteEntryData(ENTRY_ENTITY);
        DynamicObjectCollection entries = this.getModel().getDataEntity(true).getDynamicObjectCollection(ENTRY_ENTITY);
        for (Map<String, Object> rpa : dcList) {
            DynamicObject obj = entries.addNew();
            obj.set("id", rpa.get("id"));
            obj.set("number", rpa.get("agentNo"));
            obj.set("agentname", rpa.get("agentName"));
            obj.set("alias", rpa.get("agentAlias"));
            obj.set("org", rpa.get("curOrgName"));
            obj.set("status", rpa.get("dataStatus"));
            obj.set("licstatus", rpa.get("licStatus"));
            obj.set("system", rpa.get("agentOs"));
        }
        this.getView().updateView(ENTRY_ENTITY);
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        int[] rowNum;
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        if ("select".equals(operateKey) && (rowNum = ((EntryGrid)this.getView().getControl(ENTRY_ENTITY)).getSelectRows()).length == 1) {
            Map<String, Object> selectedRowData = this.getSelectedRowData(rowNum[0]);
            this.getView().returnDataToParent(selectedRowData);
            this.getView().close();
        }
    }

    private Map<String, Object> getSelectedRowData(int row) {
        DynamicObject rowEntity = this.getModel().getEntryRowEntity(ENTRY_ENTITY, row);
        HashMap<String, Object> data = new HashMap<String, Object>(3);
        data.put("id", rowEntity.getString("id"));
        data.put("number", rowEntity.getString("number"));
        data.put("alias", rowEntity.getString("alias"));
        return data;
    }

    public void cellClick(CellClickEvent cellClickEvent) {
    }

    public void cellDoubleClick(CellClickEvent evt) {
        Map<String, Object> data = this.getSelectedRowData(evt.getRow());
        this.getView().returnDataToParent(data);
        this.getView().close();
    }
}

