/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.formplugin.sf.select;

import com.alibaba.fastjson.annotation.JSONField;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.isc.iscb.util.misc.Triple;

public class TreeModel {
    private String id;
    private String text;
    private String longText;
    private String parentid;
    private boolean isOpened;
    private boolean isExpend_i;
    private List<TreeModel> childrens;

    public TreeModel(String id, String parentid, String text) {
        this.id = id;
        this.text = text + "(" + id + ")";
        this.parentid = parentid;
    }

    public TreeModel(String id, long metaId, String parentid, int level) {
        DynamicObject meta = BusinessDataServiceHelper.loadSingleFromCache((Object)metaId, (String)"isc_metadata_schema");
        String full_name = meta.getString("full_name");
        this.id = id;
        this.text = meta.getLocaleString("name").getLocaleValue() + "(" + this.id + ")";
        this.longText = full_name;
        this.parentid = parentid;
        this.isOpened = true;
        this.isExpend_i = true;
        List<Triple<String, String, Long>> entryIds = this.loadChildren(meta, level);
        ArrayList<TreeModel> childrens = new ArrayList<TreeModel>(entryIds.size() + 1);
        if (level == 1) {
            DynamicObjectCollection collection = meta.getDynamicObjectCollection("prop_entryentity");
            for (DynamicObject prop : collection) {
                if (this.isEntry(prop.getString("data_type"))) continue;
                childrens.add(new TreeModel(prop.getString("prop_name"), this.id, prop.getString("prop_label")));
            }
        }
        ++level;
        for (Triple<String, String, Long> entryId : entryIds) {
            childrens.add(new TreeModel((String)entryId.getA(), (Long)entryId.getC(), "", level));
        }
        if (childrens.size() > 0) {
            this.childrens = childrens;
        }
    }

    private List<Triple<String, String, Long>> loadChildren(DynamicObject meta, int level) {
        if (level > 0) {
            return Collections.emptyList();
        }
        DynamicObjectCollection collection = meta.getDynamicObjectCollection("prop_entryentity");
        ArrayList<Triple<String, String, Long>> data_schemas = new ArrayList<Triple<String, String, Long>>();
        long dataSourceId = meta.getLong("group_id");
        for (DynamicObject object : collection) {
            String data_type = object.getString("data_type");
            String schema = object.getString("data_schema");
            if (!this.isEntry(data_type) || this.isAttachmentField(schema)) continue;
            QFilter qFilter = new QFilter("group", "=", (Object)dataSourceId).and("number", "=", (Object)schema);
            DynamicObject obj = BusinessDataServiceHelper.loadSingle((String)"isc_metadata_schema", (String)"id", (QFilter[])new QFilter[]{qFilter});
            String entriesName = object.getString("prop_name");
            Triple triple = new Triple((Object)entriesName, (Object)schema, (Object)obj.getLong("id"));
            data_schemas.add((Triple<String, String, Long>)triple);
        }
        return data_schemas;
    }

    public boolean isAttachmentField(String schema) {
        return "bd_attachment".equals(schema) || "bos_attachment".equals(schema);
    }

    private boolean isEntry(String data_type) {
        return "ENTRIES".equals(data_type);
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public String getLongText() {
        return this.longText;
    }

    public void setLongText(String longText) {
        this.longText = longText;
    }

    public String getParentid() {
        return this.parentid;
    }

    public void setParentid(String parentid) {
        this.parentid = parentid;
    }

    public List<TreeModel> getChildren() {
        return this.childrens;
    }

    public void setChildren(List<TreeModel> childrens) {
        this.childrens = childrens;
    }

    @JSONField(name="isOpened")
    public boolean isOpened() {
        return this.isOpened;
    }

    public void setOpened(boolean opened) {
        this.isOpened = opened;
    }

    public List<TreeModel> getChildrens() {
        return this.childrens;
    }

    public void setChildrens(List<TreeModel> childrens) {
        this.childrens = childrens;
    }

    @JSONField(name="isExpend_i")
    public boolean isExpend_i() {
        return this.isExpend_i;
    }

    public void setExpend_i(boolean expend_i) {
        this.isExpend_i = expend_i;
    }
}

