/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.formplugin.solution;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.id.IDService;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.isc.iscb.formplugin.util.FormOpener;
import kd.isc.iscb.platform.core.imp.FileResourceUtil;
import kd.isc.iscb.platform.core.job.JobEngine;
import kd.isc.iscb.platform.core.job.JobInfo;
import kd.isc.iscb.platform.core.solution.PublicResourceUtil;
import kd.isc.iscb.platform.core.solution.SolutionUtil;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.misc.Hash;

public class DeployUtil {
    private static Log logger = LogFactory.getLog(DeployUtil.class);

    public static void deploy(IFormView view, AbstractFormPlugin plugin, long pkValue) {
        DynamicObject[] deployArray;
        String api = "kapi/v2/kdec/iscb/isc_solution_center/query_solution_by_id?id=" + pkValue;
        List solutionList = Collections.emptyList();
        try {
            solutionList = PublicResourceUtil.queryListByGet((String)api, null);
        }
        catch (Exception e) {
            String log = String.format(ResManager.loadKDString((String)"\u90e8\u7f72\u65b9\u6848\u5305id\u4e3a\uff1a[%s]\u7684\u65b9\u6848\u5305\u65f6\uff0c\u56e0\u4e3a\u4ee5\u4e0b\u539f\u56e0\uff0c\u6ca1\u6709\u8bbf\u95ee\u5230\u4e91\u8d44\u6e90\u5e94\u7528\u3002\u4f1a\u8df3\u8fc7\uff0c\u7ee7\u7eed\u90e8\u7f72", (String)"DeployUtil_2", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), pkValue);
            logger.warn(log, (Throwable)e);
        }
        if (!solutionList.isEmpty()) {
            String cloudVersion = D.s(((Map)solutionList.get(0)).get("version"));
            DynamicObject local = BusinessDataServiceHelper.loadSingle((Object)pkValue, (String)"isc_solution_center", (String)"version");
            String localVersion = local.getString("version");
            if (D.i((Object)cloudVersion.replace("-", "")) > D.i((Object)localVersion.replace("-", ""))) {
                String tips = String.format(ResManager.loadKDString((String)"\u5f53\u524d\u65b9\u6848\u7248\u672c\u662f\uff1a%1$s\uff0c\u5df2\u8fc7\u65f6\u3002\u4e91\u7aef\u65b9\u6848\u7248\u672c\u662f\uff1a%2$s\uff0c\u8bf7\u8fdb\u884c\u65b9\u6848\u8ba2\u9605\uff0c\u66f4\u65b0\u540e\u518d\u90e8\u7f72\u3002", (String)"DeployUtil_3", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), localVersion, cloudVersion);
                view.showTipNotification(tips);
                return;
            }
        }
        if ((deployArray = BusinessDataServiceHelper.load((String)"isc_dts_solution_deploy", (String)"id,resid", (QFilter[])new QFilter[]{new QFilter("resid", "=", (Object)D.s((Object)pkValue)).and(new QFilter("progress", "=", (Object)"IMPORTING"))})).length != 0) {
            List jobs = JobEngine.getJobsWithOwnerId((long)D.l((Object)deployArray[0].getPkValue()));
            if (!jobs.isEmpty()) {
                JobInfo jobInfo = (JobInfo)jobs.get(0);
                FormOpener.reopenJob(plugin, jobInfo.getId(), jobInfo.getTitle(), "imported");
            } else {
                DeployUtil.openDeployForm(view, plugin, pkValue);
            }
        } else {
            DeployUtil.openDeployForm(view, plugin, pkValue);
        }
    }

    private static void openDeployForm(IFormView view, AbstractFormPlugin plugin, long pkValue) {
        long id = DeployUtil.saveAsDtsImpl2(pkValue);
        BillShowParameter param = new BillShowParameter();
        param.setFormId("isc_dts_solution_deploy");
        param.setPkId((Object)id);
        param.getOpenStyle().setShowType(ShowType.Modal);
        param.setCustomParam("MUTEX_OBJ_ID", (Object)String.valueOf(pkValue));
        param.setCustomParam("entity", (Object)"isc_solution_center_m");
        param.setStatus(OperationStatus.EDIT);
        param.setCaption(ResManager.loadKDString((String)"\u90e8\u7f72\u89e3\u51b3\u65b9\u6848", (String)"DeployUtil_0", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
        param.setCloseCallBack(new CloseCallBack((IFormPlugin)plugin, "importschema"));
        view.showForm((FormShowParameter)param);
    }

    private static long saveAsDtsImpl2(long pkValue) {
        DynamicObject solution = BusinessDataServiceHelper.loadSingle((Object)pkValue, (String)"isc_solution_center_m");
        DynamicObjectCollection mainEntries = solution.getDynamicObjectCollection("main_resources");
        if (mainEntries.isEmpty()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u89e3\u51b3\u65b9\u6848\u7684\u8d44\u6e90\u5217\u8868\u4e3a\u7a7a\uff0c\u8bf7\u901a\u8fc7\u3010\u65b9\u6848\u8ba2\u9605\u3011\u8fdb\u884c\u65b9\u6848\u8d44\u6e90\u7684\u4e0b\u8f7d\uff0c\u4e0b\u8f7d\u8d44\u6e90\u540e\u518d\u8fdb\u884c\u90e8\u7f72\u64cd\u4f5c\u3002", (String)"DeployUtil_1", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
        }
        long billId = DeployUtil.saveHead(solution);
        DeployUtil.saveMainContents(billId, mainEntries);
        DynamicObjectCollection refEntries = solution.getDynamicObjectCollection("ref_resources");
        if (!refEntries.isEmpty()) {
            DeployUtil.saveRefContents(billId, refEntries);
        }
        return billId;
    }

    private static long saveHead(DynamicObject solution) {
        DynamicObject object = BusinessDataServiceHelper.newDynamicObject((String)"isc_dts_solution_deploy");
        long billId = IDService.get().genLongId();
        object.set("id", (Object)billId);
        object.set("billstatus", (Object)Character.valueOf('A'));
        object.set("creator", (Object)RequestContext.get().getUserId());
        object.set("billno", (Object)Hash.mur32((Object[])new Object[]{UUID.randomUUID().toString()}));
        object.set("resid", solution.getPkValue());
        object.set("res_version", solution.get("version"));
        object.set("res_type", (Object)FileResourceUtil.getEntityTitle((String)"isc_solution_center_m"));
        object.set("progress", (Object)"PARSED");
        object.set("state", (Object)"READY");
        object.set("modifytime", (Object)D.t((Object)System.currentTimeMillis()));
        object.set("modifier", (Object)RequestContext.get().getUserId());
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{object});
        return billId;
    }

    private static void saveMainContents(long billId, DynamicObjectCollection mainEntries) {
        ArrayList<Object[]> allParams = new ArrayList<Object[]>(mainEntries.size());
        for (int i = 0; i < mainEntries.size(); ++i) {
            DynamicObject e = (DynamicObject)mainEntries.get(i);
            Object[] params = new Object[12];
            params[0] = billId;
            params[1] = IDService.get().genLongId();
            params[2] = i + 1;
            params[3] = "INSERT";
            params[4] = e.getString("main_res_name");
            params[5] = e.getString("main_res_number");
            params[6] = D.t((Object)e.get("main_res_time"));
            DynamicObject type = e.getDynamicObject("main_res_type");
            String entity = D.s((Object)type.getPkValue());
            String pk = D.s((Object)e.get("main_res_pk"));
            params[7] = SolutionUtil.getLocalTime((String)entity, (String)pk);
            params[8] = "READY";
            params[9] = e.getString("main_res_content_tag");
            params[10] = pk;
            params[11] = type.getString("name") + "(" + type.getString("number") + ")";
            allParams.add(params);
        }
        String sql = "INSERT INTO T_ISCB_DTS_IMP_MRS2(FID,FENTRYID, FSEQ, FOPERATION,FNAME,FNUMBER,FRES_TIME,FLOCAL_TIME,FSTATE,    FCONTENT,FRES_PK, FTYPE)VALUES(?,?,?,?,    ?,?,?,?,?,    ?,?,?)";
        DB.executeBatch((DBRoute)DBRoute.of((String)"ISCB"), (String)sql, allParams);
    }

    private static void saveRefContents(long billId, DynamicObjectCollection refEntries) {
        if (refEntries.isEmpty()) {
            return;
        }
        ArrayList<Object[]> allParams = new ArrayList<Object[]>(refEntries.size());
        for (int i = 0; i < refEntries.size(); ++i) {
            DynamicObject e = (DynamicObject)refEntries.get(i);
            Object[] params = new Object[12];
            params[0] = billId;
            params[1] = IDService.get().genLongId();
            params[2] = i + 1;
            params[3] = "INSERT";
            params[4] = e.getString("ref_res_name");
            params[5] = e.getString("ref_res_number");
            params[6] = D.t((Object)e.get("ref_res_time"));
            DynamicObject type = e.getDynamicObject("ref_res_type");
            String entity = D.s((Object)type.getPkValue());
            String pk = D.s((Object)e.get("ref_res_pk"));
            params[7] = SolutionUtil.getLocalTime((String)entity, (String)pk);
            params[8] = "READY";
            params[9] = e.getString("ref_res_content_tag");
            params[10] = pk;
            params[11] = type.getString("name") + "(" + type.getString("number") + ")";
            allParams.add(params);
        }
        String sql = "INSERT INTO T_ISCB_DTS_IMP_RRS2(FID,FENTRYID, FSEQ, FOPERATION,FNAME,FNUMBER,FRES_TIME,FLOCAL_TIME,FSTATE,    FCONTENT,FRES_PK,FTYPE)VALUES(?,?,?,?,     ?,?,?,?,    ?,?,?,?)";
        DB.executeBatch((DBRoute)DBRoute.of((String)"ISCB"), (String)sql, allParams);
    }

    public static void deployBySelect(IFormView view, AbstractFormPlugin plugin, long pkValue, List<DynamicObject> deployMainEntryList, List<DynamicObject> deployRefEntryList) {
        DynamicObject[] deployArray = BusinessDataServiceHelper.load((String)"isc_dts_solution_deploy", (String)"id,resid", (QFilter[])new QFilter[]{new QFilter("resid", "=", (Object)D.s((Object)pkValue)).and(new QFilter("progress", "=", (Object)"IMPORTING"))});
        if (deployArray.length != 0) {
            List jobs = JobEngine.getJobsWithOwnerId((long)D.l((Object)deployArray[0].getPkValue()));
            if (!jobs.isEmpty()) {
                JobInfo jobInfo = (JobInfo)jobs.get(0);
                FormOpener.reopenJob(plugin, jobInfo.getId(), jobInfo.getTitle(), "imported");
            } else {
                DeployUtil.openDeployForm(view, plugin, pkValue, deployMainEntryList, deployRefEntryList);
            }
        } else {
            DeployUtil.openDeployForm(view, plugin, pkValue, deployMainEntryList, deployRefEntryList);
        }
    }

    private static void openDeployForm(IFormView view, AbstractFormPlugin plugin, long pkValue, List<DynamicObject> deployMainEntryList, List<DynamicObject> deployRefEntryList) {
        DynamicObject solution = BusinessDataServiceHelper.loadSingle((Object)pkValue, (String)"isc_solution_center_m");
        long billId = DeployUtil.saveHead(solution);
        SolutionUtil.saveMainContents((long)billId, deployMainEntryList, (boolean)true);
        SolutionUtil.saveRefContents((long)billId, deployRefEntryList, (boolean)false);
        BillShowParameter param = new BillShowParameter();
        param.setFormId("isc_dts_solution_deploy");
        param.setPkId((Object)billId);
        param.getOpenStyle().setShowType(ShowType.Modal);
        param.setCustomParam("MUTEX_OBJ_ID", (Object)String.valueOf(pkValue));
        param.setCustomParam("entity", (Object)"isc_solution_center_m");
        param.setStatus(OperationStatus.EDIT);
        param.setCaption(ResManager.loadKDString((String)"\u90e8\u7f72\u89e3\u51b3\u65b9\u6848", (String)"DeployUtil_0", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
        param.setCloseCallBack(new CloseCallBack((IFormPlugin)plugin, "importschema"));
        view.showForm((FormShowParameter)param);
    }
}

