/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.formplugin.solution;

import java.io.InputStream;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import kd.bos.cache.CacheFactory;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.fileservice.FileItem;
import kd.bos.fileservice.impl.FileServiceVersion;
import kd.bos.fileservice.impl.HttpFileClient;
import kd.bos.form.control.AttachmentPanel;
import kd.bos.form.control.Rate;
import kd.bos.form.control.events.RateEvent;
import kd.bos.form.control.events.RateListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.StringUtils;
import kd.isc.iscb.platform.core.imp.SolutionSyncCloudUtil;
import kd.isc.iscb.platform.core.solution.SolutionResourceUtil;
import kd.isc.iscb.util.db.DbUtil;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.except.IscBizException;
import kd.isc.iscb.util.misc.StringUtil;

public class SolutionFeedbackFormPlugin
extends AbstractFormPlugin
implements RateListener {
    private static final String RATEAP = "rateap";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        Rate rate = (Rate)this.getControl(RATEAP);
        rate.addRateListener((RateListener)this);
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        String userName = RequestContext.get().getUserName();
        this.getModel().setValue("feedbacker", (Object)userName);
        DynamicObject user = BusinessDataServiceHelper.loadSingle((Object)RequestContext.get().getCurrUserId(), (String)"bos_user", (String)"email");
        String email = D.s((Object)user.get("email"));
        if (email != null) {
            this.getModel().setValue("email", (Object)email);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate operate = (AbstractOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        if ("submit".equals(operateKey) && StringUtils.isEmpty((String)this.getPageCache().get(RATEAP))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u8bc4\u5206", (String)"SolutionFeedbackFormPlugin_0", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        if ("submit".equals(operateKey)) {
            long id = (Long)this.getView().getFormShowParameter().getCustomParam("id");
            AttachmentPanel attachmentPanel = (AttachmentPanel)this.getControl("attachmentpanelap");
            DynamicObject dataEntity = this.getView().getModel().getDataEntity();
            try {
                List<Map<String, Object>> attachmentList = this.remoteUploadFile(attachmentPanel);
                this.uploadSolutionFeedback(id, dataEntity, attachmentList);
            }
            catch (Throwable t) {
                this.getView().showTipNotification(StringUtil.getCascadeMessage((Throwable)t));
                return;
            }
            this.setReturnData();
            this.getView().close();
        }
    }

    public List<Map<String, Object>> remoteUploadFile(AttachmentPanel attachmentPanel) {
        List attachmentList = attachmentPanel.getAttachmentData();
        for (Map map : attachmentList) {
            String url = D.s(map.get("url"));
            InputStream inputStream = CacheFactory.getCommonCacheFactory().getTempFileCache().getInputStream(url);
            String path = "/public/attachment/" + UUID.randomUUID() + "/" + D.s(map.get("name"));
            map.put("url", path);
            FileItem fileItem = new FileItem(D.s(map.get("name")), path, inputStream);
            this.upload(fileItem, this.getFileServerUploadUrl());
        }
        return attachmentList;
    }

    public void uploadSolutionFeedback(long id, DynamicObject dataEntity, List<Map<String, Object>> attachmentList) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("attachmentList", attachmentList);
        params.put("grade", this.getPageCache().get(RATEAP));
        params.put("feedback", dataEntity.getString("feedback"));
        params.put("email", dataEntity.getString("email"));
        params.put("feedbacker", dataEntity.getString("feedbacker"));
        SolutionSyncCloudUtil.uploadSolutionFeedBackInfo((long)id, params);
    }

    public void setReturnData() {
        HashMap<String, Boolean> params = new HashMap<String, Boolean>();
        params.put("submitSuccess", Boolean.TRUE);
        this.getView().returnDataToParent(params);
    }

    private String getFileServerUploadUrl() {
        String fileServer = SolutionResourceUtil.getFileServer();
        fileServer = fileServer.endsWith("/") ? fileServer : fileServer + "/";
        return fileServer + "file/upload.do";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void upload(FileItem item, String uploadUrl) {
        boolean createNewFileWhenExists = item.isCreateNewFileWhenExists();
        InputStream inputStream = item.getInputStream();
        try {
            String path = item.getPath();
            path = path.replaceAll("\\\\", "/");
            String filename = path.substring(path.lastIndexOf(47) + 1);
            item = new FileItem(filename, path, inputStream);
            HashMap<String, String> arg = new HashMap<String, String>();
            arg.put("version", FileServiceVersion.VERSION1.toString());
            arg.put("url", item.getPath().replaceAll("[=+%?&#]", "_"));
            arg.put("fileName", item.getFileName().replaceAll("[=+%?&#]", "_"));
            arg.put("createNewFileWhenExists", String.valueOf(createNewFileWhenExists));
            try {
                if (item.getFileName() != null && item.getFileName().lastIndexOf(46) <= 0) {
                    throw new IscBizException(String.format(ResManager.loadKDString((String)"upload file %s failed. description: \u6587\u4ef6\u6269\u5c55\u540d\u4e0d\u80fd\u4e3a\u7a7a", (String)"SolutionFeedbackFormPlugin_5", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), item.getPath()));
                }
                Map result = HttpFileClient.sendFile((String)uploadUrl, (int)60000, (InputStream)item.getInputStream(), arg);
                item.close();
                if (result == null) {
                    throw new IscBizException("upload timeout within 60 seconds" + item.getPath());
                }
            }
            catch (Exception e) {
                throw new IscBizException("upload " + item.getPath() + " failed.", (Throwable)e);
            }
            finally {
                item.close();
            }
        }
        finally {
            if (inputStream != null) {
                DbUtil.close((InputStream)inputStream);
            }
        }
    }

    public void update(RateEvent evt) {
        Number rateScore = evt.getRateScore();
        Rate rate = (Rate)evt.getSource();
        this.getPageCache().put(rate.getKey(), rateScore.toString());
    }
}

