/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.formplugin.tools;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.ext.form.control.CustomControl;
import kd.bos.form.control.SplitContainer;
import kd.bos.form.control.SplitDirection;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.isc.iscb.formplugin.util.FormOpener;
import kd.isc.iscb.platform.core.debug.ScriptDebugCoordinator;
import kd.isc.iscb.platform.core.util.FileUtil;
import kd.isc.iscb.util.db.DbUtil;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.misc.NetUtil;
import kd.isc.iscb.util.script.Script;
import kd.isc.iscb.util.script.encoding.PseudoBase64;
import kd.isc.iscb.util.script.feature.tool.string.IsQname;

public abstract class AbstractScriptEditorFormPlugin
extends AbstractFormPlugin {
    protected void handleScript(String script) {
        FormOpener.showMessage(this, ResManager.loadKDString((String)"\u811a\u672c", (String)"AbstractScriptEditorFormPlugin_0", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), script);
    }

    public void beforeBindData(EventObject e) {
        SplitContainer splitContainer;
        super.beforeBindData(e);
        CustomControl c = (CustomControl)this.getControl("editor");
        if (c != null) {
            HashMap<String, Object> data = new HashMap<String, Object>();
            data.put("keywords", this.getKeywords());
            data.put("all_keys", AbstractScriptEditorFormPlugin.getAllKeywords());
            data.put("tips", this.getTips());
            data.put("editable", this.getEditable());
            data.put("height", this.getHeight());
            data.put("width", this.getWidth());
            data.put("script", this.getScript());
            c.setData(data);
        }
        Object env = this.getView().getFormShowParameter().getCustomParam("env");
        this.getView().getPageCache().put("env", D.s((Object)env));
        if (!this.getEditable() && (splitContainer = (SplitContainer)this.getControl("srcriptpane")) != null) {
            splitContainer.hidePanel(SplitDirection.right, true);
        }
    }

    private static Map<String, Object> getAllKeywords() {
        Map all = AbstractScriptEditorFormPlugin.readResource("iscb/script/global/all_keys.js", new HashMap(16));
        Map keys = AbstractScriptEditorFormPlugin.readResource("iscb/script/global/keys.js", new HashMap(16));
        for (String key : keys.keySet()) {
            all.put(key, "");
        }
        return all;
    }

    private Map<String, Object> getKeywords() {
        HashMap<String, String> def = new HashMap<String, String>(4);
        def.put("type", "def");
        def.put("style", "def");
        Map keys = AbstractScriptEditorFormPlugin.readResource("iscb/script/global/keys.js", new HashMap(16));
        for (String var : this.getContextVariables()) {
            if (!IsQname.valid((Object)var).booleanValue()) continue;
            keys.put(var, def);
        }
        return keys;
    }

    private Collection<String> getContextVariables() {
        Set<String> vars = (Set<String>)this.getView().getFormShowParameter().getCustomParam("context_variables");
        return vars != null ? vars : Collections.emptySet();
    }

    private List<Map<String, Object>> getTips() {
        ArrayList<Map<String, Object>> tips = new ArrayList<Map<String, Object>>(256);
        tips.addAll(this.readEnvTips());
        tips.addAll(this.getDynamicTips());
        tips.addAll(AbstractScriptEditorFormPlugin.readResource("iscb/script/isc/common.js", Collections.emptyList()));
        tips.addAll(AbstractScriptEditorFormPlugin.readResource("iscb/script/global/tips.js", Collections.emptyList()));
        return tips;
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        if ("get_script_data".equals(e.getOperateKey())) {
            HashMap<String, String> data = new HashMap<String, String>(2);
            data.put("cmd", "get_script_data");
            data.put("id", UUID.randomUUID().toString());
            ((CustomControl)this.getControl("editor")).setData(data);
        } else if ("get_script_data_dl".equals(e.getOperateKey())) {
            HashMap<String, String> data = new HashMap<String, String>(2);
            data.put("cmd", "get_script_data_dl");
            data.put("id", UUID.randomUUID().toString());
            ((CustomControl)this.getControl("editor")).setData(data);
        }
    }

    public void customEvent(CustomEventArgs e) {
        super.customEvent(e);
        String event = e.getEventName();
        if ("return_script_data".equals(event)) {
            String encoded = e.getEventArgs();
            String script = PseudoBase64.decode((String)encoded);
            this.handleScript(script);
        } else if ("return_editor_data".equals(event)) {
            String editorData = e.getEventArgs();
            this.handleScript(editorData);
        }
    }

    protected int getHeight() {
        return 520;
    }

    protected int getWidth() {
        return 1100;
    }

    private String getScript() {
        String script = D.s((Object)this.getView().getFormShowParameter().getCustomParam("script"));
        return script == null ? "" : script;
    }

    private boolean getEditable() {
        Map params = this.getView().getFormShowParameter().getCustomParams();
        if (params.get("view") != null && ((Boolean)params.get("view")).booleanValue()) {
            return false;
        }
        if ("VIEW".equals(D.s(params.get("billStatus")))) {
            return false;
        }
        Object editable = this.getView().getFormShowParameter().getCustomParam("editable");
        return editable == null ? true : D.x((Object)editable);
    }

    private List<Map<String, Object>> getDynamicTips() {
        List<Map<String, Object>> tips = (List<Map<String, Object>>)this.getView().getFormShowParameter().getCustomParam("dynamic_tips");
        return tips != null ? tips : Collections.emptyList();
    }

    private List<Map<String, Object>> readEnvTips() {
        String env = (String)this.getView().getFormShowParameter().getCustomParam("env");
        if (env == null) {
            env = "tool";
        }
        return AbstractScriptEditorFormPlugin.readResource("iscb/script/isc/context.js", Collections.emptyList(), env);
    }

    public static <T> T readResource(String path, T defaultRes) {
        return AbstractScriptEditorFormPlugin.readResource(path, defaultRes, "tool");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T readResource(String path, T defaultRes, String env) {
        FileUtil.checkFilePath((String)path);
        InputStream in = ScriptDebugCoordinator.class.getClassLoader().getResourceAsStream(path);
        try {
            if (in == null) {
                T t = defaultRes;
                return t;
            }
            HashMap<String, String> ctx = new HashMap<String, String>(1);
            ctx.put("env", env);
            String js = NetUtil.readText((InputStream)in);
            Object t = Script.compile((String)js).eval(ctx);
            Object object = t != null ? t : defaultRes;
            return (T)object;
        }
        finally {
            DbUtil.close((InputStream)in);
        }
    }
}

